/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteCredentialsHolder
implements MutableRemoteCredentials {
    private static final String SERVICE_NAME_PREFIX = "IntelliJ Platform Remote Credentials ";
    public static final String HOST = "HOST";
    public static final String PORT = "PORT";
    public static final String USERNAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";
    public static final String USE_KEY_PAIR = "USE_KEY_PAIR";
    public static final String USE_AUTH_AGENT = "USE_AUTH_AGENT";
    public static final String PRIVATE_KEY_FILE = "PRIVATE_KEY_FILE";
    public static final String PASSPHRASE = "PASSPHRASE";
    public static final String USE_OPENSSH_CONFIG = "USE_OPENSSH_CONFIG";
    public static final String SSH_PREFIX = "ssh://";
    private static final Map<AuthType, String> CREDENTIAL_ATTRIBUTES_QUALIFIERS = Map.of(AuthType.PASSWORD, "password", AuthType.KEY_PAIR, "passphrase", AuthType.OPEN_SSH, "empty");
    private String myHost;
    private int myPort;
    private String myLiteralPort;
    @Nullable
    private String myUserName;
    @Nullable
    private String myPassword;
    private String myPrivateKeyFile;
    @Nullable
    private String myPassphrase;
    private boolean myStorePassword;
    private boolean myStorePassphrase;
    private boolean myUseOpenSSHConfig;
    private AuthType myAuthType;
    @Nullable
    private SshConnectionConfigPatch myConnectionConfigPatch;

    public RemoteCredentialsHolder() {
        this.myHost = "";
        this.myLiteralPort = "";
        this.myPrivateKeyFile = "";
        this.myAuthType = AuthType.PASSWORD;
    }

    public RemoteCredentialsHolder(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(0);
        }
        this.myHost = "";
        this.myLiteralPort = "";
        this.myPrivateKeyFile = "";
        this.myAuthType = AuthType.PASSWORD;
        this.copyFrom(credentials);
    }

    @NlsSafe
    public static String getCredentialsString(@NotNull RemoteCredentials cred) {
        if (cred == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(1);
        }
        return SSH_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getLiteralPort();
    }

    @Override
    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void setHost(@Nullable @NlsSafe String host) {
        this.myHost = StringUtil.notNullize((String)host);
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    @Override
    public void setPort(int port) {
        this.myPort = port;
        this.myLiteralPort = Integer.toString(port);
    }

    @Override
    @NotNull
    public String getLiteralPort() {
        String string = this.myLiteralPort;
        if (string == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void setLiteralPort(@Nullable String portText) {
        this.myLiteralPort = StringUtil.notNullize((String)portText);
        this.myPort = StringUtil.parseInt((String)portText, (int)0);
    }

    @Override
    @Transient
    @Nullable
    public String getUserName() {
        return this.myUserName;
    }

    @Override
    public void setUserName(@Nullable String userName) {
        this.myUserName = StringUtil.notNullize((String)userName);
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    @Override
    public void setPassword(@Nullable String password) {
        this.myPassword = StringUtil.notNullize((String)password);
    }

    @Override
    public void setStorePassword(boolean storePassword) {
        this.myStorePassword = storePassword;
    }

    @Override
    public void setStorePassphrase(boolean storePassphrase) {
        this.myStorePassphrase = storePassphrase;
    }

    @Override
    public boolean isStorePassword() {
        return this.myStorePassword;
    }

    @Override
    public boolean isStorePassphrase() {
        return this.myStorePassphrase;
    }

    @Override
    public boolean isOpenSshConfigUsageForced() {
        return this.myUseOpenSSHConfig;
    }

    @Override
    public void setOpenSshConfigUsageForced(boolean useOpenSSHConfig) {
        this.myUseOpenSSHConfig = useOpenSSHConfig;
    }

    @Override
    @NotNull
    public String getPrivateKeyFile() {
        String string = this.myPrivateKeyFile;
        if (string == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void setPrivateKeyFile(@Nullable String privateKeyFile) {
        this.myPrivateKeyFile = StringUtil.notNullize((String)privateKeyFile);
    }

    @Override
    @Transient
    @Nullable
    public String getPassphrase() {
        return this.myPassphrase;
    }

    @Override
    public void setPassphrase(@Nullable String passphrase) {
        this.myPassphrase = StringUtil.notNullize((String)passphrase);
    }

    @Override
    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myAuthType;
        if (authType == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(5);
        }
        return authType;
    }

    @Override
    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(6);
        }
        this.myAuthType = authType;
    }

    @Override
    @Nullable
    public SshConnectionConfigPatch getConnectionConfigPatch() {
        return this.myConnectionConfigPatch;
    }

    @Override
    public void setConnectionConfigPatch(@Nullable SshConnectionConfigPatch patch) {
        this.myConnectionConfigPatch = patch;
    }

    private void setSerializedUserName(@Nullable String userName) {
        this.myUserName = StringUtil.isEmpty((String)userName) ? null : userName;
    }

    public void copyRemoteCredentialsTo(@NotNull MutableRemoteCredentials to) {
        if (to == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(7);
        }
        RemoteCredentialsHolder.copyRemoteCredentials(this, to);
    }

    public void copyFrom(@NotNull RemoteCredentials from) {
        if (from == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(8);
        }
        RemoteCredentialsHolder.copyRemoteCredentials(from, this);
    }

    public static void copyRemoteCredentials(@NotNull RemoteCredentials from, @NotNull MutableRemoteCredentials to) {
        if (from == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(9);
        }
        if (to == null) {
            RemoteCredentialsHolder.$$$reportNull$$$0(10);
        }
        to.setHost(from.getHost());
        to.setLiteralPort(from.getLiteralPort());
        to.setUserName(from.getUserName());
        to.setPassword(from.getPassword());
        to.setPassphrase(from.getPassphrase());
        to.setAuthType(from.getAuthType());
        to.setPrivateKeyFile(from.getPrivateKeyFile());
        to.setStorePassword(from.isStorePassword());
        to.setStorePassphrase(from.isStorePassphrase());
        to.setOpenSshConfigUsageForced(from.isOpenSshConfigUsageForced());
        to.setConnectionConfigPatch(from.getConnectionConfigPatch());
    }

    public void load(Element element) {
        this.setHost(element.getAttributeValue(HOST));
        this.setLiteralPort(element.getAttributeValue(PORT));
        this.setSerializedUserName(element.getAttributeValue(USERNAME));
        this.setPrivateKeyFile(StringUtil.nullize((String)element.getAttributeValue(PRIVATE_KEY_FILE)));
        this.setOpenSshConfigUsageForced(Boolean.parseBoolean(StringUtil.defaultIfEmpty((String)element.getAttributeValue(USE_OPENSSH_CONFIG), (String)String.valueOf(!PlatformUtils.isDataGrip()))));
        boolean useKeyPair = Boolean.parseBoolean(element.getAttributeValue(USE_KEY_PAIR));
        boolean useAuthAgent = Boolean.parseBoolean(element.getAttributeValue(USE_AUTH_AGENT));
        this.myAuthType = useKeyPair ? AuthType.KEY_PAIR : (useAuthAgent ? AuthType.OPEN_SSH : AuthType.PASSWORD);
        CredentialAttributes attributes = this.createAttributes(false);
        Credentials credentials = PasswordSafe.getInstance().get(attributes);
        if (credentials != null) {
            boolean memoryOnly = PasswordSafe.getInstance().isPasswordStoredOnlyInMemory(attributes, credentials);
            if (this.myAuthType == AuthType.KEY_PAIR) {
                this.setPassword(null);
                this.setStorePassword(false);
                this.setPassphrase(credentials.getPasswordAsString());
                this.setStorePassphrase(!memoryOnly);
            } else if (this.myAuthType == AuthType.PASSWORD) {
                this.setPassword(credentials.getPasswordAsString());
                this.setStorePassword(!memoryOnly);
                this.setPassphrase(null);
                this.setStorePassphrase(false);
            } else {
                this.setOpenSshConfigUsageForced(true);
                this.setPassword(null);
                this.setStorePassword(false);
                this.setPassphrase(null);
                this.setStorePassphrase(false);
            }
        }
    }

    public void save(Element rootElement) {
        rootElement.setAttribute(HOST, StringUtil.notNullize((String)this.getHost()));
        rootElement.setAttribute(PORT, StringUtil.notNullize((String)this.getLiteralPort()));
        rootElement.setAttribute(USERNAME, StringUtil.notNullize((String)this.myUserName));
        rootElement.setAttribute(PRIVATE_KEY_FILE, StringUtil.notNullize((String)this.getPrivateKeyFile()));
        rootElement.setAttribute(USE_KEY_PAIR, Boolean.toString(this.myAuthType == AuthType.KEY_PAIR));
        rootElement.setAttribute(USE_OPENSSH_CONFIG, Boolean.toString(this.isOpenSshConfigUsageForced()));
        rootElement.setAttribute(USE_AUTH_AGENT, Boolean.toString(this.myAuthType == AuthType.OPEN_SSH));
        boolean memoryOnly = this.myAuthType == AuthType.KEY_PAIR && !this.isStorePassphrase() || this.myAuthType == AuthType.PASSWORD && !this.isStorePassword() || this.myAuthType == AuthType.OPEN_SSH;
        String password = switch (this.myAuthType) {
            case AuthType.KEY_PAIR -> this.getPassphrase();
            case AuthType.PASSWORD -> this.getPassword();
            default -> null;
        };
        PasswordSafe.getInstance().set(this.createAttributes(memoryOnly), new Credentials(this.getUserName(), password));
    }

    private CredentialAttributes createAttributes(boolean memoryOnly) {
        String serviceName = SERVICE_NAME_PREFIX + RemoteCredentialsHolder.getCredentialsString(this) + "(" + CREDENTIAL_ATTRIBUTES_QUALIFIERS.get((Object)this.myAuthType) + ")";
        return new CredentialAttributes(serviceName, this.getUserName(), memoryOnly);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteCredentialsHolder holder = (RemoteCredentialsHolder)o;
        if (!this.myLiteralPort.equals(holder.myLiteralPort)) {
            return false;
        }
        if (this.myStorePassword != holder.myStorePassword) {
            return false;
        }
        if (this.myStorePassphrase != holder.myStorePassphrase) {
            return false;
        }
        if (!this.myHost.equals(holder.myHost)) {
            return false;
        }
        if (!Objects.equals(this.myUserName, holder.myUserName)) {
            return false;
        }
        if (!Objects.equals(this.myPassword, holder.myPassword)) {
            return false;
        }
        if (!this.myPrivateKeyFile.equals(holder.myPrivateKeyFile)) {
            return false;
        }
        if (!Objects.equals(this.myPassphrase, holder.myPassphrase)) {
            return false;
        }
        if (this.myUseOpenSSHConfig != holder.myUseOpenSSHConfig) {
            return false;
        }
        if (this.myAuthType != holder.myAuthType) {
            return false;
        }
        return Objects.equals(this.myConnectionConfigPatch, holder.myConnectionConfigPatch);
    }

    public int hashCode() {
        int result2 = this.myHost.hashCode();
        result2 = 31 * result2 + this.myLiteralPort.hashCode();
        result2 = 31 * result2 + (this.myUserName != null ? this.myUserName.hashCode() : 0);
        result2 = 31 * result2 + (this.myPassword != null ? this.myPassword.hashCode() : 0);
        result2 = 31 * result2 + this.myPrivateKeyFile.hashCode();
        result2 = 31 * result2 + (this.myPassphrase != null ? this.myPassphrase.hashCode() : 0);
        result2 = 31 * result2 + (this.myStorePassword ? 1 : 0);
        result2 = 31 * result2 + (this.myStorePassphrase ? 1 : 0);
        result2 = 31 * result2 + (this.myUseOpenSSHConfig ? 1 : 0);
        result2 = 31 * result2 + this.myAuthType.hashCode();
        result2 = 31 * result2 + (this.myConnectionConfigPatch != null ? this.myConnectionConfigPatch.hashCode() : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cred";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteCredentialsHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteCredentialsHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPort";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKeyFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialsString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyRemoteCredentialsTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyRemoteCredentials";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

