/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerImpl;
import com.intellij.remoteServer.impl.configuration.RemoteServerState;
import com.intellij.remoteServer.impl.configuration.RemoteServersManagerState;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RemoteServers", category=SettingsCategory.TOOLS, exportable=true, storages={@Storage(value="remote-servers.xml", roamingType=RoamingType.DISABLED)})
public final class RemoteServersManagerImpl
extends RemoteServersManager
implements PersistentStateComponent<RemoteServersManagerState> {
    private SkipDefaultValuesSerializationFilters myDefaultValuesFilter = new SkipDefaultValuesSerializationFilters();
    private final List<RemoteServer<?>> myServers = new CopyOnWriteArrayList();
    private final List<RemoteServerState> myUnknownServers = new ArrayList<RemoteServerState>();
    private final Map<RemoteServer<?>, UUID> myThirdPartyServerIds = CollectionFactory.createWeakIdentityMap((int)2, (float)0.75f);

    public RemoteServersManagerImpl() {
        ServerType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<ServerType<?>>(){

            public void extensionAdded(@NotNull ServerType addedType, @NotNull PluginDescriptor pluginDescriptor) {
                if (addedType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                List nowKnownStates = ContainerUtil.filter(RemoteServersManagerImpl.this.myUnknownServers, next -> addedType.getId().equals(next.myTypeId));
                nowKnownStates.forEach(nextState -> {
                    RemoteServersManagerImpl.this.myUnknownServers.remove(nextState);
                    RemoteServersManagerImpl.this.addServer(RemoteServersManagerImpl.createConfiguration(addedType, nextState));
                });
            }

            public void extensionRemoved(@NotNull ServerType removedType, @NotNull PluginDescriptor pluginDescriptor) {
                if (removedType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                List removedServers = RemoteServersManagerImpl.this.getServers(removedType);
                removedServers.forEach(nextServer -> {
                    RemoteServerState nextState = RemoteServersManagerImpl.this.createServerState((RemoteServer<?>)nextServer);
                    RemoteServersManagerImpl.this.removeServer((RemoteServer<?>)nextServer);
                    RemoteServersManagerImpl.this.myUnknownServers.add(nextState);
                });
                if (!removedServers.isEmpty()) {
                    RemoteServersManagerImpl.this.myDefaultValuesFilter = new SkipDefaultValuesSerializationFilters();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "addedType";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "removedType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/RemoteServersManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    @Override
    public List<RemoteServer<?>> getServers() {
        return Collections.unmodifiableList(this.myServers);
    }

    @Override
    public <C extends ServerConfiguration> List<RemoteServer<C>> getServers(@NotNull ServerType<C> type) {
        if (type == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList<RemoteServer<C>> servers = new ArrayList<RemoteServer<C>>();
        for (RemoteServer<?> server : this.myServers) {
            if (!server.getType().equals(type)) continue;
            servers.add(server);
        }
        return servers;
    }

    @Override
    @Nullable
    public <C extends ServerConfiguration> RemoteServer<C> findByName(@NotNull String name, @NotNull ServerType<C> type) {
        if (name == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(2);
        }
        for (RemoteServer<?> server : this.myServers) {
            if (!server.getType().equals(type) || !server.getName().equals(name)) continue;
            return server;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public UUID getId(RemoteServer<?> server) {
        if (server instanceof RemoteServerImpl) {
            RemoteServerImpl impl = (RemoteServerImpl)server;
            UUID uUID = impl.getUniqueId();
            if (uUID != null) return uUID;
            RemoteServersManagerImpl.$$$reportNull$$$0(3);
            return uUID;
        }
        Map<RemoteServer<?>, UUID> map = this.myThirdPartyServerIds;
        // MONITORENTER : map
        UUID uUID = this.myThirdPartyServerIds.computeIfAbsent(server, s -> UUID.randomUUID());
        // MONITOREXIT : map
        if (uUID != null) return uUID;
        RemoteServersManagerImpl.$$$reportNull$$$0(4);
        return uUID;
    }

    @Override
    @Nullable
    public <C extends ServerConfiguration> RemoteServer<C> findById(@NotNull UUID id) {
        if (id == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(5);
        }
        for (RemoteServer<?> server : this.myServers) {
            if (!id.equals(this.getId(server))) continue;
            return server;
        }
        return null;
    }

    @Override
    @NotNull
    public <C extends ServerConfiguration> RemoteServer<C> createServer(@NotNull ServerType<C> type, @NotNull String name) {
        if (type == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(6);
        }
        if (name == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(7);
        }
        return new RemoteServerImpl<C>(name, type, type.createDefaultConfiguration());
    }

    @Override
    @NotNull
    public <C extends ServerConfiguration> RemoteServer<C> createServer(@NotNull ServerType<C> type) {
        if (type == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(8);
        }
        String name = UniqueNameGenerator.generateUniqueName((String)type.getPresentableName(), s -> this.getServers(type).stream().map(RemoteServer::getName).noneMatch(s::equals));
        RemoteServer<C> remoteServer = this.createServer(type, name);
        if (remoteServer == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(9);
        }
        return remoteServer;
    }

    @Override
    public void addServer(RemoteServer<?> server) {
        this.myServers.add(server);
        ((RemoteServerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RemoteServerListener.TOPIC)).serverAdded(server);
    }

    @Override
    public void removeServer(RemoteServer<?> server) {
        this.myServers.remove(server);
        ((RemoteServerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RemoteServerListener.TOPIC)).serverRemoved(server);
    }

    @NotNull
    public RemoteServersManagerState getState() {
        RemoteServersManagerState state = new RemoteServersManagerState();
        for (RemoteServer<?> server : this.myServers) {
            state.myServers.add(this.createServerState(server));
        }
        state.myServers.addAll(this.myUnknownServers);
        RemoteServersManagerState remoteServersManagerState = state;
        if (remoteServersManagerState == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(10);
        }
        return remoteServersManagerState;
    }

    public void loadState(@NotNull RemoteServersManagerState state) {
        if (state == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(11);
        }
        this.myUnknownServers.clear();
        this.myServers.clear();
        LinkedList<CloudConfigurationBase> needsMigration = new LinkedList<CloudConfigurationBase>();
        for (RemoteServerState server : state.myServers) {
            ServerType<?> type = RemoteServersManagerImpl.findServerType(server.myTypeId);
            if (type == null) {
                this.myUnknownServers.add(server);
                continue;
            }
            RemoteServerImpl<?> nextServer = RemoteServersManagerImpl.createConfiguration(type, server);
            this.myServers.add(nextServer);
            Object nextConfig = nextServer.getConfiguration();
            if (!(nextConfig instanceof CloudConfigurationBase) || !((CloudConfigurationBase)nextConfig).shouldMigrateToPasswordSafe()) continue;
            needsMigration.add((CloudConfigurationBase)nextConfig);
        }
        if (!needsMigration.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                for (CloudConfigurationBase nextConfig : needsMigration) {
                    nextConfig.migrateToPasswordSafe();
                }
            });
        }
    }

    @NotNull
    private RemoteServerState createServerState(@NotNull RemoteServer<?> server) {
        if (server == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(12);
        }
        RemoteServerState serverState = new RemoteServerState();
        serverState.myName = server.getName();
        serverState.myTypeId = server.getType().getId();
        serverState.myConfiguration = XmlSerializer.serialize((Object)((ServerConfiguration)server.getConfiguration()).getSerializer().getState(), (SerializationFilter)this.myDefaultValuesFilter);
        RemoteServerState remoteServerState = serverState;
        if (remoteServerState == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(13);
        }
        return remoteServerState;
    }

    @NotNull
    private static <C extends ServerConfiguration> RemoteServerImpl<C> createConfiguration(ServerType<C> type, RemoteServerState server) {
        C configuration = type.createDefaultConfiguration();
        PersistentStateComponent<?> serializer2 = ((ServerConfiguration)configuration).getSerializer();
        ComponentSerializationUtil.loadComponentState(serializer2, (Element)server.myConfiguration);
        return new RemoteServerImpl<C>(server.myName, type, configuration);
    }

    @Nullable
    private static ServerType<?> findServerType(@NotNull String typeId) {
        if (typeId == null) {
            RemoteServersManagerImpl.$$$reportNull$$$0(14);
        }
        return (ServerType)ServerType.EP_NAME.findFirstSafe(next -> typeId.equals(next.getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/RemoteServersManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/RemoteServersManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createServer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createServerState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getServers";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createServer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createServerState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findServerType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9, 10, 13 -> new IllegalStateException(string);
        };
    }
}

