/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.CompileSdkReleaseModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileSdkReleaseModelImpl
implements CompileSdkReleaseModel {
    public static String MINOR_API_LEVEL = "minorApiLevel";
    public static String SDK_EXTENSION = "sdkExtension";
    private final GradleDslMethodCall myMethodCall;
    GradleDslClosure myClosure;

    public CompileSdkReleaseModelImpl(@NotNull GradleDslMethodCall methodCall) {
        if (methodCall == null) {
            CompileSdkReleaseModelImpl.$$$reportNull$$$0(0);
        }
        this.myMethodCall = methodCall;
        this.myClosure = methodCall.getClosureElement();
        if (this.myClosure == null) {
            this.myClosure = new GradleDslClosure(methodCall, null, GradleNameElement.empty());
        }
    }

    @Override
    @NotNull
    public ResolvedPropertyModel getMinorApiLevel() {
        ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myClosure, MINOR_API_LEVEL).buildResolved();
        if (resolvedPropertyModelImpl == null) {
            CompileSdkReleaseModelImpl.$$$reportNull$$$0(1);
        }
        return resolvedPropertyModelImpl;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel getSdkExtension() {
        ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myClosure, SDK_EXTENSION).buildResolved();
        if (resolvedPropertyModelImpl == null) {
            CompileSdkReleaseModelImpl.$$$reportNull$$$0(2);
        }
        return resolvedPropertyModelImpl;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel getVersion() {
        ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create(this.myMethodCall.getArguments().get(0)).buildResolved();
        if (resolvedPropertyModelImpl == null) {
            CompileSdkReleaseModelImpl.$$$reportNull$$$0(3);
        }
        return resolvedPropertyModelImpl;
    }

    @Override
    public void delete() {
        this.myMethodCall.delete();
    }

    @Override
    @Nullable
    public String toHash() {
        Integer sdkExtension;
        Integer apiLevel = this.getVersion().toInt();
        String compileSdkString = "android-" + apiLevel;
        Integer minorApiLevel = this.getMinorApiLevel().toInt();
        if (minorApiLevel != null) {
            compileSdkString = compileSdkString + "." + minorApiLevel;
        }
        if ((sdkExtension = this.getSdkExtension().toInt()) != null) {
            compileSdkString = compileSdkString + "-ext" + sdkExtension;
        }
        return compileSdkString;
    }

    @Override
    @Nullable
    public Integer toInt() {
        if (this.getMinorApiLevel().toInt() == null && this.getSdkExtension().toInt() == null) {
            return this.getVersion().toInt();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/android/CompileSdkReleaseModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/android/CompileSdkReleaseModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinorApiLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

