/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorMouseHoverPopupManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.codeFloatingToolbar.CodeFloatingToolbar;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XDebuggerTooltipPopup {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Point myPoint;
    private JBPopup myPopup;

    XDebuggerTooltipPopup(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            XDebuggerTooltipPopup.$$$reportNull$$$0(0);
        }
        if (point == null) {
            XDebuggerTooltipPopup.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myPoint = point;
    }

    @Nullable
    JBPopup show(JComponent component, @Nullable EditorMouseEvent editorMouseEvent) {
        BorderLayoutPanel content = JBUI.Panels.simplePanel();
        Color bgColor = HintUtil.getInformationColor();
        content.setBackground(bgColor);
        if (editorMouseEvent != null) {
            content.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)10, (int)6));
            component.setBorder((Border)JBUI.Borders.emptyRight((int)20));
            DefaultActionGroup actions = new DefaultActionGroup();
            ShowErrorsAction action = new ShowErrorsAction(editorMouseEvent);
            action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)content);
            actions.add((AnAction)action);
            ActionToolbarImpl toolbar = new ActionToolbarImpl("XDebuggerTooltip", (ActionGroup)actions, true);
            toolbar.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
            toolbar.setBackground(bgColor);
            toolbar.setReservePlaceAutoPopupIcon(false);
            toolbar.setTargetComponent(null);
            JSeparator separator = new JSeparator(1);
            separator.setBackground(bgColor);
            separator.setOpaque(true);
            content.addToRight((Component)JBUI.Panels.simplePanel((Component)toolbar).addToLeft((Component)separator));
        } else {
            content.setBorder(JBUI.Borders.empty((int)10));
        }
        content.addToCenter((Component)component);
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content, component).setRequestFocus(false).setFocusable(false).setModalContext(false).setCancelOnOtherWindowOpen(true).createPopup();
        if (this.myEditor.isDisposed()) {
            this.myPopup.cancel();
            return null;
        }
        this.myPopup.show(new RelativePoint((Component)this.myEditor.getContentComponent(), this.myPoint));
        XDebuggerTooltipPopup.hideAndDisableFloatingToolbar(this.myEditor, this.myPopup);
        return this.myPopup;
    }

    private static void hideAndDisableFloatingToolbar(@NotNull Editor editor, @NotNull JBPopup popup2) {
        CodeFloatingToolbar floatingToolbar;
        if (editor == null) {
            XDebuggerTooltipPopup.$$$reportNull$$$0(2);
        }
        if (popup2 == null) {
            XDebuggerTooltipPopup.$$$reportNull$$$0(3);
        }
        if ((floatingToolbar = CodeFloatingToolbar.getToolbar((Editor)editor)) == null) {
            return;
        }
        floatingToolbar.hideOnPopupConflict(popup2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTooltipPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hideAndDisableFloatingToolbar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ShowErrorsAction
    extends AnAction {
        @Nullable
        private final EditorMouseEvent myEditorMouseEvent;

        ShowErrorsAction(EditorMouseEvent editorMouseEvent) {
            super(XDebuggerBundle.message((String)"xdebugger.show.errors.action.title", (Object[])new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Ide.FatalErrorRead);
            this.setShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowErrorDescription"));
            this.myEditorMouseEvent = editorMouseEvent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowErrorsAction.$$$reportNull$$$0(0);
            }
            XDebuggerTooltipPopup.this.myPopup.cancel();
            EditorMouseHoverPopupManager.getInstance().showInfoTooltip(this.myEditorMouseEvent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/quick/common/XDebuggerTooltipPopup$ShowErrorsAction", "actionPerformed"));
        }
    }
}

