/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.CustomComponentEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.visualizedtext.EvaluationCallback;
import com.intellij.xdebugger.impl.ui.visualizedtext.RawTextVisualizer;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPanel;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtilKt;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J0\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\r0\u00160\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPopupUtil;", "", "<init>", "()V", "showValuePopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "Ljava/awt/event/MouseEvent;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "component", "Ljavax/swing/JComponent;", "cancelCallback", "Ljava/lang/Runnable;", "evaluateAndShowValuePopup", "", "evaluator", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "collectVisualizedTabs", "", "Lkotlin/Pair;", "Lcom/intellij/xdebugger/ui/VisualizedContentTab;", "fullValue", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "isVisualizable", "", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVisualizedTextPopupUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualizedTextPopupUtil.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPopupUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1642#2,10:306\n1915#2:316\n1916#2:318\n1652#2:319\n1#3:317\n*S KotlinDebug\n*F\n+ 1 VisualizedTextPopupUtil.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPopupUtil\n*L\n88#1:306,10\n88#1:316\n88#1:318\n88#1:319\n88#1:317\n*E\n"})
public final class VisualizedTextPopupUtil {
    @NotNull
    public static final VisualizedTextPopupUtil INSTANCE = new VisualizedTextPopupUtil();

    private VisualizedTextPopupUtil() {
    }

    @NotNull
    public final JBPopup showValuePopup(@NotNull MouseEvent event, @NotNull Project project, @Nullable Editor editor, @NotNull JComponent component, @Nullable Runnable cancelCallback) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Dimension size = DimensionService.getInstance().getSize("XDebugger.FullValuePopup", project);
        if (size == null) {
            JFrame jFrame = WindowManager.getInstance().getFrame(project);
            Intrinsics.checkNotNull((Object)jFrame);
            Dimension frameSize = jFrame.getSize();
            size = new Dimension(frameSize.width / 2, frameSize.height / 2);
        }
        component.setPreferredSize(size);
        JBPopup popup2 = DebuggerUIUtil.createValuePopup(project, component, cancelCallback);
        if (editor == null) {
            Rectangle bounds = new Rectangle(event.getLocationOnScreen(), size);
            ScreenUtil.fitToScreenVertical((Rectangle)bounds, (int)5, (int)5, (boolean)true);
            if (size.width != bounds.width || size.height != bounds.height) {
                size = bounds.getSize();
                component.setPreferredSize(size);
            }
            popup2.showInScreenCoordinates(event.getComponent(), bounds.getLocation());
        } else {
            popup2.showInBestPositionFor(editor);
        }
        Intrinsics.checkNotNull((Object)popup2);
        return popup2;
    }

    @JvmStatic
    public static final void evaluateAndShowValuePopup(@NotNull XFullValueEvaluator evaluator, @NotNull MouseEvent event, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (evaluator instanceof CustomComponentEvaluator) {
            ((CustomComponentEvaluator)evaluator).show(event, project, editor);
            return;
        }
        VisualizedTextPanel panel2 = new VisualizedTextPanel(project);
        EvaluationCallback callback2 = new EvaluationCallback(panel2);
        JBPopup popup2 = INSTANCE.showValuePopup(event, project, editor, panel2, callback2::setObsolete);
        Disposer.register((Disposable)((Disposable)popup2), (Disposable)((Disposable)panel2));
        evaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<VisualizedContentTab, JComponent>> collectVisualizedTabs(@NotNull Project project, @NotNull String fullValue, @NotNull Disposable parentDisposable) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fullValue, (String)"fullValue");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        List tabs = CollectionsKt.plus((Collection)VisualizedTextPopupUtilKt.access$calcNonTrivialVisualizedTabs(fullValue), (Iterable)RawTextVisualizer.INSTANCE.visualize(fullValue));
        Iterable $this$mapNotNull$iv = tabs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VisualizedContentTab tab = (VisualizedContentTab)element$iv$iv;
            boolean bl2 = false;
            if ((Pair)VisualizedTextPopupUtilKt.access$wrapUnsafeAction(fullValue, "create visualized component (" + tab.getId() + ")", () -> VisualizedTextPopupUtil.collectVisualizedTabs$lambda$0$0(tab, project, parentDisposable)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    public static final boolean isVisualizable(@NotNull String fullValue) {
        Intrinsics.checkNotNullParameter((Object)fullValue, (String)"fullValue");
        return StringUtil.containsLineBreak((CharSequence)fullValue) || !((Collection)VisualizedTextPopupUtilKt.access$calcNonTrivialVisualizedTabs(fullValue)).isEmpty();
    }

    private static final Pair collectVisualizedTabs$lambda$0$0(VisualizedContentTab $tab, Project $project, Disposable $parentDisposable) {
        return TuplesKt.to((Object)$tab, (Object)$tab.createComponent($project, $parentDisposable));
    }
}

