/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.psi.impl;

import com.intellij.debugger.streams.core.psi.DebuggerPositionResolver;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerPositionResolverImpl
implements DebuggerPositionResolver {
    private static final Logger logger = Logger.getInstance(DebuggerPositionResolverImpl.class);

    @Override
    @Nullable
    public PsiElement getNearestElementToBreakpoint(@NotNull XDebugSession session) {
        if (session == null) {
            DebuggerPositionResolverImpl.$$$reportNull$$$0(0);
        }
        XSourcePosition position = session.getCurrentPosition();
        logger.debug("Current position: ", new Object[]{position});
        if (position == null) {
            return null;
        }
        int offset = position.getOffset();
        VirtualFile file = position.getFile();
        if (file.isValid() && 0 <= offset && (long)offset < file.getLength()) {
            PsiElement element;
            @Nullable PsiFile psiFile = PsiManager.getInstance((Project)session.getProject()).findFile(file);
            if (logger.isDebugEnabled()) {
                logger.debug("Psi file: ", new Object[]{psiFile != null ? psiFile.getName() : null});
            }
            PsiElement psiElement = element = psiFile != null && psiFile.isValid() ? psiFile.findElementAt(offset) : null;
            if (logger.isDebugEnabled()) {
                logger.debug("Element: ", new Object[]{element != null ? element.getText() + "(" + String.valueOf(element.getTextRange()) + ")" : null});
            }
            return element;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Offset out of bounds. isValid: ", new Object[]{file.isValid(), ", offset: ", offset, ", length: ", file.getLength()});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/streams/core/psi/impl/DebuggerPositionResolverImpl", "getNearestElementToBreakpoint"));
    }
}

