/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.promo;

import com.intellij.java.promo.Framework;
import com.intellij.java.promo.FrameworkPluginSuggestion;
import com.intellij.java.promo.FrameworkSuggestionProviderKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/java/promo/FrameworkSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "<init>", "()V", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isApplicationConfig", "", "fileName", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.java.promo"})
public final class FrameworkSuggestionProvider
implements PluginSuggestionProvider {
    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!this.isApplicationConfig(string)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        Framework framework = FrameworkSuggestionProviderKt.access$detectFramework(module2);
        if (framework == null) {
            return null;
        }
        Framework framework2 = framework;
        if (FrameworkSuggestionProviderKt.isPluginSuggestionDismissed(framework2)) {
            return null;
        }
        return new FrameworkPluginSuggestion(project, framework2);
    }

    private final boolean isApplicationConfig(String fileName) {
        return Intrinsics.areEqual((Object)fileName, (Object)"application.properties") || Intrinsics.areEqual((Object)fileName, (Object)"application.yaml") || Intrinsics.areEqual((Object)fileName, (Object)"application.yml");
    }
}

