/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.task;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemTaskId
implements Serializable {
    @NotNull
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final long serialVersionUID = 1L;
    @NotNull
    private final ExternalSystemTaskType myType;
    @NotNull
    private final String myProjectId;
    @NotNull
    private final ProjectSystemId myProjectSystemId;
    private final long myId;

    private ExternalSystemTaskId(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull String projectId, long taskId) {
        if (projectSystemId == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(1);
        }
        if (projectId == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(2);
        }
        this.myType = type;
        this.myProjectId = projectId;
        this.myProjectSystemId = projectSystemId;
        this.myId = taskId;
    }

    @NotNull
    public String getIdeProjectId() {
        String string = this.myProjectId;
        if (string == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(4);
        }
        return projectSystemId;
    }

    @NotNull
    public static ExternalSystemTaskId create(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull Project project) {
        if (projectSystemId == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(5);
        }
        if (type == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(7);
        }
        return ExternalSystemTaskId.create(projectSystemId, type, ExternalSystemTaskId.getProjectId(project));
    }

    @NotNull
    public static ExternalSystemTaskId create(@NotNull ProjectSystemId projectSystemId, @NotNull ExternalSystemTaskType type, @NotNull String ideProjectId) {
        if (projectSystemId == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(8);
        }
        if (type == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(9);
        }
        if (ideProjectId == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(10);
        }
        return new ExternalSystemTaskId(projectSystemId, type, ideProjectId, COUNTER.getAndIncrement());
    }

    @NotNull
    public static String getProjectId(@NotNull Project project) {
        if (project == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(11);
        }
        Object object = project.isDisposed() ? project.getName() : project.getName() + ":" + project.getLocationHash();
        if (object == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(12);
        }
        return object;
    }

    @Nullable
    public Project findProject() {
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projectManager.getOpenProjects()) {
            if (!this.myProjectId.equals(ExternalSystemTaskId.getProjectId(project))) continue;
            return project;
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        ProgressManager.checkCanceled();
        Project project = this.findProject();
        if (project == null) {
            throw new AlreadyDisposedException(String.format("Project %s is closed", this.getIdeProjectId()));
        }
        Project project2 = project;
        if (project2 == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(13);
        }
        return project2;
    }

    @NotNull
    public ExternalSystemTaskType getType() {
        ExternalSystemTaskType externalSystemTaskType = this.myType;
        if (externalSystemTaskType == null) {
            ExternalSystemTaskId.$$$reportNull$$$0(14);
        }
        return externalSystemTaskType;
    }

    public long getId() {
        return this.myId;
    }

    public int hashCode() {
        return 31 * this.myType.hashCode() + Long.hashCode(this.myId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemTaskId that = (ExternalSystemTaskId)o;
        return this.myId == that.myId && this.myType == that.myType;
    }

    public String toString() {
        return String.valueOf((Object)this.myType) + ":" + this.myId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProjectId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeProjectId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSystemId";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

