/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpBackrefImpl
extends RegExpElementImpl
implements RegExpBackref {
    public RegExpBackrefImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public int getIndex() {
        return Integer.parseInt(this.getIndexNumberText());
    }

    @NotNull
    private String getIndexNumberText() {
        ASTNode node = this.getNode().findChildByType(RegExpTT.NUMBER);
        if (node != null) {
            String string = node.getText();
            if (string == null) {
                RegExpBackrefImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        String s = this.getUnescapedText();
        boolean pcreBackReference = s.charAt(1) == 'g';
        boolean pcreNumberedGroup = s.startsWith("(?");
        assert (s.charAt(0) == '\\' || pcreNumberedGroup);
        String string = pcreBackReference ? RegExpBackrefImpl.getPcreBackrefIndexNumberText(s.substring(2)) : (pcreNumberedGroup ? RegExpBackrefImpl.getPcreNumberedGroupIndexNumberText(s.substring(2)) : s.substring(1));
        if (string == null) {
            RegExpBackrefImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isRecursiveGroup() {
        return this.getUnescapedText().startsWith("(?");
    }

    @NotNull
    private static String getPcreNumberedGroupIndexNumberText(String s) {
        String string = StringUtil.trimEnd((String)s, (String)")");
        if (string == null) {
            RegExpBackrefImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getPcreBackrefIndexNumberText(String s) {
        String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)s, (String)"{"), (String)"}");
        if (string == null) {
            RegExpBackrefImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpBackref(this);
    }

    @Override
    public RegExpGroup resolve() {
        return RegExpBackrefImpl.resolve(this.getIndex(), this.getContainingFile());
    }

    static RegExpGroup resolve(int index, PsiFile file) {
        if (index < 0) {
            return RegExpBackrefImpl.resolveRelativeGroup(Math.abs(index), file);
        }
        return (RegExpGroup)SyntaxTraverser.psiTraverser((PsiElement)file).filter(RegExpGroup.class).filter(RegExpGroup::isCapturing).skip(index - 1).first();
    }

    @Nullable
    private static RegExpGroup resolveRelativeGroup(int index, PsiFile file) {
        List groups = SyntaxTraverser.psiTraverser((PsiElement)file).filter(RegExpGroup.class).filter(RegExpGroup::isCapturing).toList();
        return index <= groups.size() ? (RegExpGroup)groups.get(groups.size() - index) : null;
    }

    public PsiReference getReference() {
        return new PsiReference(){

            @NotNull
            public PsiElement getElement() {
                RegExpBackrefImpl regExpBackrefImpl = RegExpBackrefImpl.this;
                if (regExpBackrefImpl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return regExpBackrefImpl;
            }

            @NotNull
            public TextRange getRangeInElement() {
                TextRange textRange = TextRange.from((int)0, (int)this.getElement().getTextLength());
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            @NotNull
            public String getCanonicalText() {
                String string = this.getElement().getText();
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new IncorrectOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    1.$$$reportNull$$$0(4);
                }
                throw new IncorrectOperationException();
            }

            public boolean isReferenceTo(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(5);
                }
                return Comparing.equal((Object)element, (Object)this.resolve());
            }

            public boolean isSoft() {
                return false;
            }

            public PsiElement resolve() {
                return RegExpBackrefImpl.this.resolve();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 3, 4, 5 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "isReferenceTo";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 3, 4, 5 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/regexp/psi/impl/RegExpBackrefImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexNumberText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPcreNumberedGroupIndexNumberText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPcreBackrefIndexNumberText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

