/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.properties;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.EscapeUtilsKt;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.grazie.utils.Text;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.lang.properties.spellchecker.MnemonicsTokenizer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class PropertyTextExtractor
extends TextExtractor {
    private static final ExtensionPointName<MnemonicsTokenizer> MNEMONICS_EP_NAME = ExtensionPointName.create((String)"com.intellij.properties.spellcheckerMnemonicsTokenizer");
    private static final Pattern apostrophes = Pattern.compile("'(?=')");
    private static final Pattern continuationIndent = Pattern.compile("(?<=\n)[ \t]+");
    private static final Pattern trailingSlash = Pattern.compile("\\\\\n");

    PropertyTextExtractor() {
    }

    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement root, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (root == null) {
            PropertyTextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            PropertyTextExtractor.$$$reportNull$$$0(1);
        }
        if (root instanceof PsiComment && allowedDomains.contains(TextContent.TextDomain.COMMENTS)) {
            List roots = PsiUtilsKt.getNotSoDistantSimilarSiblings((PsiElement)root, e -> PropertiesTokenTypes.COMMENTS.contains(PsiUtilCore.getElementType((PsiElement)e)));
            List list = ContainerUtil.createMaybeSingletonList((Object)TextContent.joinWithWhitespace((char)'\n', (List)ContainerUtil.mapNotNull((Collection)roots, c -> TextContentBuilder.FromPsi.removingIndents(" \t#!").build(c, TextContent.TextDomain.COMMENTS))));
            if (list == null) {
                PropertyTextExtractor.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (root instanceof PropertyValueImpl) {
            PropertyValueImpl propertyValue = (PropertyValueImpl)root;
            if (allowedDomains.contains(TextContent.TextDomain.PLAIN_TEXT)) {
                String str;
                int start;
                TextContent content = TextContent.builder().build(root, TextContent.TextDomain.PLAIN_TEXT);
                if (content != null) {
                    content = content.excludeRanges(ContainerUtil.map((Collection)Text.allOccurrences((Pattern)apostrophes, (CharSequence)content), TextContent.Exclusion::exclude));
                    content = content.excludeRanges(ContainerUtil.map((Collection)Text.allOccurrences((Pattern)continuationIndent, (CharSequence)content), TextContent.Exclusion::exclude));
                    content = content.excludeRanges(ContainerUtil.map((Collection)Text.allOccurrences((Pattern)trailingSlash, (CharSequence)content), TextContent.Exclusion::exclude));
                    content = EscapeUtilsKt.replaceBackslashEscapedWhitespace((TextContent)content);
                    content = EscapeUtilsKt.replaceBackslashEscapedWhitespace((TextContent)content, (char)'r');
                    for (MnemonicsTokenizer tokenizer : MNEMONICS_EP_NAME.getExtensionList()) {
                        Set ignoredChars;
                        if (!tokenizer.hasMnemonics(content.toString()) || (ignoredChars = tokenizer.ignoredCharacters(propertyValue)).isEmpty()) continue;
                        Pattern ignoredCharactersPattern = Pattern.compile("[" + ignoredChars.stream().map(String::valueOf).collect(Collectors.joining()) + "]");
                        content = content.excludeRanges(ContainerUtil.map((Collection)Text.allOccurrences((Pattern)ignoredCharactersPattern, (CharSequence)content), TextContent.Exclusion::exclude));
                        break;
                    }
                }
                while (content != null && (start = (str = content.toString()).indexOf("{")) >= 0) {
                    int end;
                    int nesting = 1;
                    for (end = start + 1; end < str.length(); ++end) {
                        if (str.charAt(end) == '}' && --nesting == 0) {
                            ++end;
                            break;
                        }
                        if (str.charAt(end) != '{') continue;
                        ++nesting;
                    }
                    content = content.markUnknown(new TextRange(start, end));
                }
                List list = HtmlUtilsKt.excludeHtml((TextContent)content);
                if (list == null) {
                    PropertyTextExtractor.$$$reportNull$$$0(3);
                }
                return list;
            }
        }
        List<TextContent> list = List.of();
        if (list == null) {
            PropertyTextExtractor.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/ide/language/properties/PropertyTextExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/ide/language/properties/PropertyTextExtractor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContents";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

