/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.maddyhome.idea.copyright.CopyrightProfileKt;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.options.Options;
import com.maddyhome.idea.copyright.pattern.EntityUtil;
import com.maddyhome.idea.copyright.pattern.VelocityHelper;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.ui.TemplateCommentPanel;
import com.maddyhome.idea.copyright.ui.TemplateOptionsPanelListener;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u001c\u0010\u0007\u001a\u000f\u0012\u000b\b\u0001\u0012\u00070\t\u00a2\u0006\u0002\b\n0\b\"\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u00104\u001a\u00020\tH\u0016J\b\u00105\u001a\u00020\tH\u0016J\f\u00106\u001a\u0006\u0012\u0002\b\u000307H\u0016J\b\u00108\u001a\u00020\tH\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u0011H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020=H\u0016J\b\u0010?\u001a\u00020@H\u0002J\b\u0010A\u001a\u00020BH\u0002J\b\u0010C\u001a\u00020=H\u0002J\u0010\u0010D\u001a\u00020=2\u0006\u0010E\u001a\u00020\u0011H\u0002J\b\u0010F\u001a\u00020=H\u0002J\u0010\u0010G\u001a\u00020=2\u0006\u0010H\u001a\u00020@H\u0002J\u0010\u0010I\u001a\u00020=2\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020=H\u0002J\b\u0010M\u001a\u00020NH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006O"}, d2={"Lcom/maddyhome/idea/copyright/ui/TemplateCommentPanel;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "_fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "parentPanel", "project", "Lcom/intellij/openapi/project/Project;", "locations", "", "", "Lcom/intellij/openapi/util/NlsContexts$RadioButton;", "<init>", "(Lcom/intellij/openapi/fileTypes/FileType;Lcom/maddyhome/idea/copyright/ui/TemplateCommentPanel;Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)V", "fileType", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "allowBlock", "", "listeners", "Ljavax/swing/event/EventListenerList;", "fileLocations", "", "Ljavax/swing/JRadioButton;", "noCopyright", "Lcom/intellij/ui/components/JBRadioButton;", "useDefaultSettingsRadioButton", "useCustomFormattingOptionsRadioButton", "commentTypeGroup", "Lcom/intellij/ui/dsl/builder/Row;", "blockComment", "prefixLines", "Lcom/intellij/ui/components/JBCheckBox;", "lineComment", "relativeLocationGroup", "before", "after", "borderGroup", "separatorBefore", "lengthBefore", "Lcom/intellij/ui/components/JBTextField;", "separatorAfter", "lengthAfter", "filler", "box", "addBlankBefore", "addBlank", "preview", "Ljavax/swing/JTextArea;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "getDisplayName", "getHelpTopic", "getOriginalClass", "Ljava/lang/Class;", "getId", "createComponent", "Ljavax/swing/JComponent;", "isModified", "apply", "", "reset", "getOptions", "Lcom/maddyhome/idea/copyright/options/LanguageOptions;", "getOverrideChoice", "", "updateOverride", "enableFormattingOptions", "enable", "updateBox", "showPreview", "options", "addOptionChangeListener", "listener", "Lcom/maddyhome/idea/copyright/ui/TemplateOptionsPanelListener;", "fireChangeEvent", "getCopyrightOptions", "Lcom/maddyhome/idea/copyright/options/Options;", "intellij.copyright"})
public final class TemplateCommentPanel
implements SearchableConfigurable {
    @Nullable
    private final TemplateCommentPanel parentPanel;
    @NotNull
    private final Project project;
    @NotNull
    private final FileType fileType;
    private final boolean allowBlock;
    @NotNull
    private final EventListenerList listeners;
    @NotNull
    private final List<JRadioButton> fileLocations;
    private JBRadioButton noCopyright;
    private JBRadioButton useDefaultSettingsRadioButton;
    private JBRadioButton useCustomFormattingOptionsRadioButton;
    private Row commentTypeGroup;
    private JBRadioButton blockComment;
    private JBCheckBox prefixLines;
    private JBRadioButton lineComment;
    private Row relativeLocationGroup;
    private JBRadioButton before;
    private JBRadioButton after;
    private Row borderGroup;
    private JBCheckBox separatorBefore;
    private JBTextField lengthBefore;
    private JBCheckBox separatorAfter;
    private JBTextField lengthAfter;
    private JBTextField filler;
    private JBCheckBox box;
    private JBCheckBox addBlankBefore;
    private JBCheckBox addBlank;
    private JTextArea preview;
    @NotNull
    private final DialogPanel panel;

    public TemplateCommentPanel(@Nullable FileType _fileType, @Nullable TemplateCommentPanel parentPanel, @NotNull Project project, String ... locations) {
        FileType fileType;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        this.parentPanel = parentPanel;
        this.project = project;
        this.listeners = new EventListenerList();
        this.fileLocations = new ArrayList();
        this.panel = BuilderKt.panel(arg_0 -> TemplateCommentPanel.panel$lambda$0(locations, this, arg_0));
        if (_fileType == null) {
            JBRadioButton jBRadioButton = this.useDefaultSettingsRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useDefaultSettingsRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setVisible(false);
            JBRadioButton jBRadioButton2 = this.useCustomFormattingOptionsRadioButton;
            if (jBRadioButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomFormattingOptionsRadioButton");
                jBRadioButton2 = null;
            }
            jBRadioButton2.setVisible(false);
            JBRadioButton jBRadioButton3 = this.noCopyright;
            if (jBRadioButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"noCopyright");
                jBRadioButton3 = null;
            }
            jBRadioButton3.setVisible(false);
        }
        if ((fileType = _fileType) == null) {
            LanguageFileType languageFileType = StdFileTypes.JAVA;
            Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"JAVA");
            fileType = (FileType)languageFileType;
        }
        this.fileType = fileType;
        this.allowBlock = FileTypeUtil.hasBlockComment(this.fileType);
        TemplateCommentPanel templateCommentPanel = this.parentPanel;
        if (templateCommentPanel != null) {
            templateCommentPanel.addOptionChangeListener(() -> TemplateCommentPanel._init_$lambda$0(this));
        }
        this.addOptionChangeListener(() -> TemplateCommentPanel._init_$lambda$1(this));
    }

    @NotNull
    public final FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public String getDisplayName() {
        String string;
        if (this.fileType instanceof LanguageFileType) {
            String string2 = ((LanguageFileType)this.fileType).getLanguage().getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        } else {
            String string3 = this.fileType.getDisplayName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDisplayName(...)");
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        return "copyright.filetypes";
    }

    @NotNull
    public Class<?> getOriginalClass() {
        UpdateCopyrightsProvider provider = CopyrightUpdaters.INSTANCE.forFileType(this.fileType);
        Object object = provider;
        if (object == null || (object = object.getClass()) == null) {
            Class clazz = super.getOriginalClass();
            object = clazz;
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getOriginalClass(...)");
        }
        return object;
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic() + "." + this.fileType.getName();
    }

    @NotNull
    public JComponent createComponent() {
        return (JComponent)this.panel;
    }

    public boolean isModified() {
        if (this.parentPanel == null) {
            return !Intrinsics.areEqual((Object)this.getCopyrightOptions().getTemplateOptions(), (Object)this.getOptions());
        }
        return !Intrinsics.areEqual((Object)this.getCopyrightOptions().getOptions(this.fileType.getName()), (Object)this.getOptions());
    }

    public void apply() {
        Options options = this.getCopyrightOptions();
        if (this.parentPanel == null) {
            options.setTemplateOptions(this.getOptions());
        } else {
            options.setOptions(this.fileType.getName(), this.getOptions());
        }
    }

    public void reset() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        LanguageOptions options = this.parentPanel == null ? this.getCopyrightOptions().getTemplateOptions() : this.getCopyrightOptions().getOptions(this.fileType.getName());
        boolean isBlock = options.isBlock();
        if (isBlock) {
            JBRadioButton jBRadioButton = this.blockComment;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"blockComment");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
        } else {
            JBRadioButton jBRadioButton = this.lineComment;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lineComment");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
        }
        if ((jBCheckBox2 = this.prefixLines) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefixLines");
            jBCheckBox2 = null;
        }
        jBCheckBox2.setSelected(options.isPrefixLines());
        JBCheckBox jBCheckBox3 = this.separatorAfter;
        if (jBCheckBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorAfter");
            jBCheckBox3 = null;
        }
        jBCheckBox3.setSelected(options.isSeparateAfter());
        JBCheckBox jBCheckBox4 = this.separatorBefore;
        if (jBCheckBox4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorBefore");
            jBCheckBox4 = null;
        }
        jBCheckBox4.setSelected(options.isSeparateBefore());
        JBTextField jBTextField = this.lengthBefore;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lengthBefore");
            jBTextField = null;
        }
        jBTextField.setText(String.valueOf(options.getLenBefore()));
        JBTextField jBTextField2 = this.lengthAfter;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lengthAfter");
            jBTextField2 = null;
        }
        jBTextField2.setText(String.valueOf(options.getLenAfter()));
        JBTextField jBTextField3 = this.filler;
        if (jBTextField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filler");
            jBTextField3 = null;
        }
        jBTextField3.setText(options.getFiller() == " " ? "" : options.getFiller());
        JBCheckBox jBCheckBox5 = this.box;
        if (jBCheckBox5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"box");
            jBCheckBox5 = null;
        }
        jBCheckBox5.setSelected(options.isBox());
        int fileTypeOverride = options.getFileTypeOverride();
        JBRadioButton jBRadioButton = this.useDefaultSettingsRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useDefaultSettingsRadioButton");
            jBRadioButton = null;
        }
        jBRadioButton.setSelected(fileTypeOverride == 2);
        JBRadioButton jBRadioButton2 = this.useCustomFormattingOptionsRadioButton;
        if (jBRadioButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomFormattingOptionsRadioButton");
            jBRadioButton2 = null;
        }
        jBRadioButton2.setSelected(fileTypeOverride == 3);
        JBRadioButton jBRadioButton3 = this.noCopyright;
        if (jBRadioButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"noCopyright");
            jBRadioButton3 = null;
        }
        jBRadioButton3.setSelected(fileTypeOverride == 1);
        if (options.isRelativeBefore()) {
            JBRadioButton jBRadioButton4 = this.before;
            if (jBRadioButton4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"before");
                jBRadioButton4 = null;
            }
            jBRadioButton4.setSelected(true);
        } else {
            JBRadioButton jBRadioButton5 = this.after;
            if (jBRadioButton5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"after");
                jBRadioButton5 = null;
            }
            jBRadioButton5.setSelected(true);
        }
        if ((jBCheckBox = this.addBlank) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addBlank");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(options.isAddBlankAfter());
        JBCheckBox jBCheckBox6 = this.addBlankBefore;
        if (jBCheckBox6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addBlankBefore");
            jBCheckBox6 = null;
        }
        jBCheckBox6.setSelected(options.isAddBlankBefore());
        if (!((Collection)this.fileLocations).isEmpty()) {
            int choice = options.getFileLocation() - 1;
            choice = Math.max(0, Math.min(choice, this.fileLocations.size() - 1));
            this.fileLocations.get(choice).setSelected(true);
        }
        this.updateOverride();
    }

    private final LanguageOptions getOptions() {
        JBCheckBox jBCheckBox;
        LanguageOptions result = new LanguageOptions();
        JBRadioButton jBRadioButton = this.blockComment;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blockComment");
            jBRadioButton = null;
        }
        result.setBlock(jBRadioButton.isSelected());
        JBCheckBox jBCheckBox2 = this.prefixLines;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefixLines");
            jBCheckBox2 = null;
        }
        result.setPrefixLines(jBCheckBox2.isSelected());
        JBCheckBox jBCheckBox3 = this.separatorAfter;
        if (jBCheckBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorAfter");
            jBCheckBox3 = null;
        }
        result.setSeparateAfter(jBCheckBox3.isSelected());
        JBCheckBox jBCheckBox4 = this.separatorBefore;
        if (jBCheckBox4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorBefore");
            jBCheckBox4 = null;
        }
        result.setSeparateBefore(jBCheckBox4.isSelected());
        try {
            JBTextField jBTextField = this.lengthBefore;
            if (jBTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lengthBefore");
                jBTextField = null;
            }
            String string = jBTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            result.setLenBefore(Integer.parseInt(string));
            JBTextField jBTextField2 = this.lengthAfter;
            if (jBTextField2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lengthAfter");
                jBTextField2 = null;
            }
            String string2 = jBTextField2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string2;
            result.setLenAfter(Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ((jBCheckBox = this.box) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"box");
            jBCheckBox = null;
        }
        result.setBox(jBCheckBox.isSelected());
        JBTextField jBTextField = this.filler;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filler");
            jBTextField = null;
        }
        String filler = jBTextField.getText();
        Intrinsics.checkNotNull((Object)filler);
        if (((CharSequence)filler).length() > 0) {
            result.setFiller(filler);
        } else {
            result.setFiller(" ");
        }
        result.setFileTypeOverride(this.getOverrideChoice());
        JBRadioButton jBRadioButton2 = this.before;
        if (jBRadioButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"before");
            jBRadioButton2 = null;
        }
        result.setRelativeBefore(jBRadioButton2.isSelected());
        JBCheckBox jBCheckBox5 = this.addBlank;
        if (jBCheckBox5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addBlank");
            jBCheckBox5 = null;
        }
        result.setAddBlankAfter(jBCheckBox5.isSelected());
        JBCheckBox jBCheckBox6 = this.addBlankBefore;
        if (jBCheckBox6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addBlankBefore");
            jBCheckBox6 = null;
        }
        result.setAddBlankBefore(jBCheckBox6.isSelected());
        if (!((Collection)this.fileLocations).isEmpty()) {
            int n = ((Collection)this.fileLocations).size();
            for (int i = 0; i < n; ++i) {
                if (!this.fileLocations.get(i).isSelected()) continue;
                result.setFileLocation(i + 1);
            }
        }
        return result;
    }

    private final int getOverrideChoice() {
        int n;
        JBRadioButton jBRadioButton = this.useDefaultSettingsRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useDefaultSettingsRadioButton");
            jBRadioButton = null;
        }
        if (jBRadioButton.isSelected()) {
            n = 2;
        } else {
            JBRadioButton jBRadioButton2 = this.noCopyright;
            if (jBRadioButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"noCopyright");
                jBRadioButton2 = null;
            }
            n = jBRadioButton2.isSelected() ? 1 : 3;
        }
        return n;
    }

    private final void updateOverride() {
        int choice = this.getOverrideChoice();
        TemplateCommentPanel templateCommentPanel = this.parentPanel;
        LanguageOptions parentOpts = templateCommentPanel != null ? templateCommentPanel.getOptions() : null;
        switch (choice) {
            case 1: {
                this.enableFormattingOptions(false);
                this.showPreview(this.getOptions());
                Row row = this.relativeLocationGroup;
                if (row == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLocationGroup");
                    row = null;
                }
                row.enabled(false);
                JBRadioButton jBRadioButton = this.before;
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"before");
                    jBRadioButton = null;
                }
                jBRadioButton.setEnabled(false);
                JBRadioButton jBRadioButton2 = this.after;
                if (jBRadioButton2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"after");
                    jBRadioButton2 = null;
                }
                jBRadioButton2.setEnabled(false);
                JBCheckBox jBCheckBox = this.addBlank;
                if (jBCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"addBlank");
                    jBCheckBox = null;
                }
                jBCheckBox.setEnabled(false);
                JBCheckBox jBCheckBox2 = this.addBlankBefore;
                if (jBCheckBox2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"addBlankBefore");
                    jBCheckBox2 = null;
                }
                jBCheckBox2.setEnabled(false);
                if (!(!((Collection)this.fileLocations).isEmpty())) break;
                for (JRadioButton fileLocation : this.fileLocations) {
                    fileLocation.setEnabled(false);
                }
                break;
            }
            case 2: {
                boolean isTemplate = this.parentPanel == null;
                this.enableFormattingOptions(isTemplate);
                LanguageOptions languageOptions = parentOpts;
                if (languageOptions == null) {
                    languageOptions = this.getOptions();
                }
                this.showPreview(languageOptions);
                Row row = this.relativeLocationGroup;
                if (row == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLocationGroup");
                    row = null;
                }
                row.enabled(isTemplate);
                JBRadioButton jBRadioButton = this.before;
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"before");
                    jBRadioButton = null;
                }
                jBRadioButton.setEnabled(isTemplate);
                JBRadioButton jBRadioButton3 = this.after;
                if (jBRadioButton3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"after");
                    jBRadioButton3 = null;
                }
                jBRadioButton3.setEnabled(isTemplate);
                JBCheckBox jBCheckBox = this.addBlank;
                if (jBCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"addBlank");
                    jBCheckBox = null;
                }
                jBCheckBox.setEnabled(isTemplate);
                JBCheckBox jBCheckBox3 = this.addBlankBefore;
                if (jBCheckBox3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"addBlankBefore");
                    jBCheckBox3 = null;
                }
                jBCheckBox3.setEnabled(isTemplate);
                if (!(!((Collection)this.fileLocations).isEmpty())) break;
                for (JRadioButton fileLocation : this.fileLocations) {
                    fileLocation.setEnabled(true);
                }
                break;
            }
            case 3: {
                this.enableFormattingOptions(true);
                this.showPreview(this.getOptions());
                Row row = this.relativeLocationGroup;
                if (row == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"relativeLocationGroup");
                    row = null;
                }
                row.enabled(true);
                JBRadioButton jBRadioButton = this.before;
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"before");
                    jBRadioButton = null;
                }
                jBRadioButton.setEnabled(true);
                JBRadioButton jBRadioButton4 = this.after;
                if (jBRadioButton4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"after");
                    jBRadioButton4 = null;
                }
                jBRadioButton4.setEnabled(true);
                JBCheckBox jBCheckBox = this.addBlank;
                if (jBCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"addBlank");
                    jBCheckBox = null;
                }
                jBCheckBox.setEnabled(true);
                JBCheckBox jBCheckBox4 = this.addBlankBefore;
                if (jBCheckBox4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"addBlankBefore");
                    jBCheckBox4 = null;
                }
                jBCheckBox4.setEnabled(true);
                if (!(!((Collection)this.fileLocations).isEmpty())) break;
                for (JRadioButton fileLocation : this.fileLocations) {
                    fileLocation.setEnabled(true);
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void enableFormattingOptions(boolean enable) {
        block21: {
            block20: {
                if (!enable) break block20;
                v0 = this.commentTypeGroup;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commentTypeGroup");
                    v0 = null;
                }
                v0.enabled(true);
                v1 = this.borderGroup;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"borderGroup");
                    v1 = null;
                }
                v1.enabled(true);
                v2 = this.blockComment;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"blockComment");
                    v2 = null;
                }
                v2.setEnabled(true);
                v3 = this.lineComment;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lineComment");
                    v3 = null;
                }
                v3.setEnabled(true);
                v4 = this.prefixLines;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"prefixLines");
                    v4 = null;
                }
                if (!this.allowBlock) ** GOTO lbl-1000
                v5 = this.blockComment;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"blockComment");
                    v5 = null;
                }
                if (v5.isSelected()) {
                    v6 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v6 = false;
                }
                v4.setEnabled(v6);
                v7 = this.separatorBefore;
                if (v7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"separatorBefore");
                    v7 = null;
                }
                v7.setEnabled(true);
                v8 = this.separatorAfter;
                if (v8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"separatorAfter");
                    v8 = null;
                }
                v8.setEnabled(true);
                v9 = this.lengthBefore;
                if (v9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lengthBefore");
                    v9 = null;
                }
                if ((v10 = this.separatorBefore) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"separatorBefore");
                    v10 = null;
                }
                v9.setEnabled(v10.isSelected());
                v11 = this.lengthBefore;
                if (v11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lengthBefore");
                    v11 = null;
                }
                if ((v12 = this.separatorBefore) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"separatorBefore");
                    v12 = null;
                }
                v11.setEnabled(v12.isSelected());
                v13 = this.lengthAfter;
                if (v13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lengthAfter");
                    v13 = null;
                }
                if ((v14 = this.separatorAfter) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"separatorAfter");
                    v14 = null;
                }
                v13.setEnabled(v14.isSelected());
                v15 = this.lengthAfter;
                if (v15 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lengthAfter");
                    v15 = null;
                }
                if ((v16 = this.separatorAfter) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"separatorAfter");
                    v16 = null;
                }
                v15.setEnabled(v16.isSelected());
                this.updateBox();
                break block21;
            }
            v17 = this.commentTypeGroup;
            if (v17 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commentTypeGroup");
                v17 = null;
            }
            v17.enabled(false);
            v18 = this.borderGroup;
            if (v18 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"borderGroup");
                v18 = null;
            }
            v18.enabled(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateBox() {
        enable = true;
        v0 = this.separatorBefore;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorBefore");
            v0 = null;
        }
        if (!v0.isSelected()) ** GOTO lbl-1000
        v1 = this.separatorAfter;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorAfter");
            v1 = null;
        }
        if (!v1.isSelected()) lbl-1000:
        // 2 sources

        {
            enable = false;
        } else {
            v2 = this.lengthBefore;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lengthBefore");
                v2 = null;
            }
            v3 = v2.getText();
            v4 = this.lengthAfter;
            if (v4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lengthAfter");
                v4 = null;
            }
            if (!Intrinsics.areEqual((Object)v3, (Object)v4.getText())) {
                enable = false;
            }
        }
        if ((v5 = this.separatorBefore) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorBefore");
            v5 = null;
        }
        if (v5.isSelected()) ** GOTO lbl-1000
        v6 = this.separatorAfter;
        if (v6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorAfter");
            v6 = null;
        }
        if (v6.isSelected()) lbl-1000:
        // 2 sources

        {
            v7 = true;
        } else {
            v7 = either = false;
        }
        if ((v8 = this.box) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"box");
            v8 = null;
        }
        v8.setEnabled(enable);
        v9 = this.filler;
        if (v9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filler");
            v9 = null;
        }
        v9.setEnabled(either);
    }

    private final void showPreview(LanguageOptions options) {
        JBRadioButton jBRadioButton = this.noCopyright;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"noCopyright");
            jBRadioButton = null;
        }
        String defaultCopyrightText = jBRadioButton.isSelected() ? "" : FileTypeUtil.buildComment(this.fileType, VelocityHelper.evaluate(null, null, null, EntityUtil.decode(CopyrightProfileKt.DEFAULT_COPYRIGHT_NOTICE)), options);
        SwingUtilities.invokeLater(() -> TemplateCommentPanel.showPreview$lambda$0(this, defaultCopyrightText));
    }

    private final void addOptionChangeListener(TemplateOptionsPanelListener listener) {
        this.listeners.add(TemplateOptionsPanelListener.class, (EventListener)listener);
    }

    private final void fireChangeEvent() {
        Object[] fires = this.listeners.getListenerList();
        for (int i = fires.length - 2; i >= 0; i -= 2) {
            if (fires[i] != TemplateOptionsPanelListener.class) continue;
            Object object = fires[i + 1];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.maddyhome.idea.copyright.ui.TemplateOptionsPanelListener");
            ((TemplateOptionsPanelListener)object).optionChanged();
        }
    }

    private final Options getCopyrightOptions() {
        return CopyrightManager.Companion.getInstance(this.project).getOptions();
    }

    private static final Unit panel$lambda$0$3$0$0(ActionListener $updateOverrideListener, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($updateOverrideListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$3$1$0(ActionListener $updateOverrideListener, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($updateOverrideListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$3$2$0(ActionListener $updateOverrideListener, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($updateOverrideListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$3$0(TemplateCommentPanel this$0, ActionListener $updateOverrideListener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.no.copyright", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.noCopyright = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$3$0$0($updateOverrideListener, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$3$1(TemplateCommentPanel this$0, ActionListener $updateOverrideListener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.use.default.settings", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.useDefaultSettingsRadioButton = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$3$1$0($updateOverrideListener, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$3$2(TemplateCommentPanel this$0, ActionListener $updateOverrideListener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.use.custom.formatting.options", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.useCustomFormattingOptionsRadioButton = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$3$2$0($updateOverrideListener, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0$0$0$0(ActionListener $changeEventListener, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($changeEventListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0$0$1$0$0(ActionListener $changeEventListener, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($changeEventListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0$0$1$0(TemplateCommentPanel this$0, ActionListener $changeEventListener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.prefix.each.line", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0$0$1$0$0($changeEventListener, arg_0));
        JBRadioButton jBRadioButton = this$0.blockComment;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blockComment");
            jBRadioButton = null;
        }
        this$0.prefixLines = (JBCheckBox)cell.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBRadioButton))).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0$0$2$0(ActionListener $changeEventListener, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($changeEventListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0$0$0(TemplateCommentPanel this$0, ActionListener $changeEventListener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.use.block.comment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.blockComment = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0$0$0$0($changeEventListener, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0$0$1(TemplateCommentPanel this$0, ActionListener $changeEventListener, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0$0$1$0(this$0, $changeEventListener, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0$0$2(TemplateCommentPanel this$0, ActionListener $changeEventListener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.use.line.comment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.lineComment = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0$0$2$0($changeEventListener, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0$0(TemplateCommentPanel this$0, ActionListener $changeEventListener, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0$0$0(this$0, $changeEventListener, arg_0), (int)1, null);
        $this$buttonsGroup.indent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0$0$1(this$0, $changeEventListener, arg_0));
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0$0$2(this$0, $changeEventListener, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$1$0$0(TemplateCommentPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.before.other.comments", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.before = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$1$0$1(TemplateCommentPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.after.other.comments", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.after = (JBRadioButton)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$1$0(TemplateCommentPanel this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$1$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$1$0$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$0(TemplateCommentPanel this$0, ActionListener $changeEventListener, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.buttonsGroup$default((Panel)$this$group, null, (boolean)false, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0$0(this$0, $changeEventListener, arg_0), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0$1(TemplateCommentPanel this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.buttonsGroup$default((Panel)$this$group, null, (boolean)false, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$1$0(this$0, arg_0), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$0$0(ActionListener $updateBoxListener, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($updateBoxListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$0$1(panel.1.documentAdapter.1 $documentAdapter, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getDocument().addDocumentListener((DocumentListener)((Object)$documentAdapter));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$1$0(ActionListener $updateBoxListener, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($updateBoxListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$1$1(panel.1.documentAdapter.1 $documentAdapter, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getDocument().addDocumentListener((DocumentListener)((Object)$documentAdapter));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$2$0(panel.1.documentAdapter.1 $documentAdapter, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getDocument().addDocumentListener((DocumentListener)((Object)$documentAdapter));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$3$0(ActionListener $changeEventListener, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addActionListener($changeEventListener);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$0(TemplateCommentPanel this$0, ActionListener $updateBoxListener, panel.1.documentAdapter.1 $documentAdapter, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.separator.before", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.separatorBefore = (JBCheckBox)$this$row.checkBox(string).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$0$0($updateBoxListener, arg_0)).getComponent();
        Cell cell = Row.intTextField$default((Row)$this$row, null, null, (int)3, null);
        String string2 = CopyrightBundle.message("settings.copyright.formatting.length", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Cell cell2 = Cell.label$default((Cell)cell, (String)string2, null, (int)2, null).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$0$1($documentAdapter, arg_0));
        JBCheckBox jBCheckBox = this$0.separatorBefore;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorBefore");
            jBCheckBox = null;
        }
        this$0.lengthBefore = (JBTextField)cell2.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox))).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$1(TemplateCommentPanel this$0, ActionListener $updateBoxListener, panel.1.documentAdapter.1 $documentAdapter, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.separator.after", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.separatorAfter = (JBCheckBox)$this$row.checkBox(string).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$1$0($updateBoxListener, arg_0)).getComponent();
        Cell cell = Row.intTextField$default((Row)$this$row, null, null, (int)3, null);
        String string2 = CopyrightBundle.message("settings.copyright.formatting.length", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Cell cell2 = Cell.label$default((Cell)cell, (String)string2, null, (int)2, null).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$1$1($documentAdapter, arg_0));
        JBCheckBox jBCheckBox = this$0.separatorAfter;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"separatorAfter");
            jBCheckBox = null;
        }
        this$0.lengthAfter = (JBTextField)cell2.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox))).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$2(TemplateCommentPanel this$0, panel.1.documentAdapter.1 $documentAdapter, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = $this$row.textField();
        String string = CopyrightBundle.message("settings.copyright.formatting.separator", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.filler = (JBTextField)TextFieldKt.columns((Cell)Cell.label$default((Cell)cell, (String)string, null, (int)2, null).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$2$0($documentAdapter, arg_0)), (int)4).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$3(TemplateCommentPanel this$0, ActionListener $changeEventListener, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.box", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.box = (JBCheckBox)$this$row.checkBox(string).applyToComponent(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$3$0($changeEventListener, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$4(TemplateCommentPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.add.blank.line.before", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.addBlankBefore = (JBCheckBox)$this$row.checkBox(string).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0$5(TemplateCommentPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CopyrightBundle.message("settings.copyright.formatting.add.blank.line.after", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.addBlank = (JBCheckBox)$this$row.checkBox(string).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1$0(TemplateCommentPanel this$0, ActionListener $updateBoxListener, panel.1.documentAdapter.1 $documentAdapter, ActionListener $changeEventListener, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$0(this$0, $updateBoxListener, $documentAdapter, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$1(this$0, $updateBoxListener, $documentAdapter, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$2(this$0, $documentAdapter, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$3(this$0, $changeEventListener, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$4(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0$5(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$0(TemplateCommentPanel this$0, ActionListener $changeEventListener, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.commentTypeGroup = Panel.group$default((Panel)$this$panel, (String)CopyrightBundle.message("settings.copyright.formatting.comment.type", new Object[0]), (boolean)false, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$0(this$0, $changeEventListener, arg_0), (int)2, null);
        this$0.relativeLocationGroup = Panel.group$default((Panel)$this$panel, (String)CopyrightBundle.message("settings.copyright.formatting.relative.location", new Object[0]), (boolean)false, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0$1(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4$1(TemplateCommentPanel this$0, ActionListener $updateBoxListener, panel.1.documentAdapter.1 $documentAdapter, ActionListener $changeEventListener, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.borderGroup = Panel.group$default((Panel)$this$panel, (String)CopyrightBundle.message("settings.copyright.formatting.borders", new Object[0]), (boolean)false, arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1$0(this$0, $updateBoxListener, $documentAdapter, $changeEventListener, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$5$0$0(TemplateCommentPanel this$0, String $location, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ((Collection)this$0.fileLocations).add(Row.radioButton$default((Row)$this$row, (String)$location, null, (int)2, null).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$5$0(String[] $locations, TemplateCommentPanel this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        for (String location : $locations) {
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$5$0$0(this$0, location, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$6$0(JBTextArea $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setEditable(false);
        $this$applyToComponent.setFont(EditorFontType.getGlobalPlainFont());
        return Unit.INSTANCE;
    }

    private static final void panel$lambda$0$0(TemplateCommentPanel this$0, ActionEvent it) {
        this$0.updateOverride();
    }

    private static final void panel$lambda$0$1(TemplateCommentPanel this$0, ActionEvent it) {
        this$0.fireChangeEvent();
    }

    private static final void panel$lambda$0$2(TemplateCommentPanel this$0, ActionEvent it) {
        this$0.fireChangeEvent();
        this$0.updateBox();
    }

    private static final Unit panel$lambda$0$3(TemplateCommentPanel this$0, ActionListener $updateOverrideListener, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$3$0(this$0, $updateOverrideListener, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$3$1(this$0, $updateOverrideListener, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$3$2(this$0, $updateOverrideListener, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4(TemplateCommentPanel this$0, ActionListener $changeEventListener, ActionListener $updateBoxListener, panel.1.documentAdapter.1 $documentAdapter, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$0(this$0, $changeEventListener, arg_0)).resizableColumn().align((Align)AlignY.TOP.INSTANCE).gap(RightGap.COLUMNS);
        $this$row.panel(arg_0 -> TemplateCommentPanel.panel$lambda$0$4$1(this$0, $updateBoxListener, $documentAdapter, $changeEventListener, arg_0)).resizableColumn().align((Align)AlignY.TOP.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$5(String[] $locations, TemplateCommentPanel this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.buttonsGroup$default((Panel)$this$group, null, (boolean)false, arg_0 -> TemplateCommentPanel.panel$lambda$0$5$0($locations, this$0, arg_0), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$6(TemplateCommentPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.preview = (JTextArea)$this$row.textArea().align(Align.FILL).applyToComponent(TemplateCommentPanel::panel$lambda$0$6$0).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0(String[] $locations, TemplateCommentPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ActionListener updateOverrideListener = arg_0 -> TemplateCommentPanel.panel$lambda$0$0(this$0, arg_0);
        ActionListener changeEventListener = arg_0 -> TemplateCommentPanel.panel$lambda$0$1(this$0, arg_0);
        ActionListener updateBoxListener = arg_0 -> TemplateCommentPanel.panel$lambda$0$2(this$0, arg_0);
        DocumentAdapter documentAdapter2 = new DocumentAdapter(this$0){
            final /* synthetic */ TemplateCommentPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TemplateCommentPanel.access$fireChangeEvent(this.this$0);
                TemplateCommentPanel.access$updateBox(this.this$0);
            }
        };
        Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, arg_0 -> TemplateCommentPanel.panel$lambda$0$3(this$0, updateOverrideListener, arg_0), (int)3, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$4(this$0, changeEventListener, updateBoxListener, documentAdapter2, arg_0), (int)1, null);
        if (!($locations.length == 0)) {
            Panel.group$default((Panel)$this$panel, (String)CopyrightBundle.message("settings.copyright.formatting.location.in.file", new Object[0]), (boolean)false, arg_0 -> TemplateCommentPanel.panel$lambda$0$5($locations, this$0, arg_0), (int)2, null);
        }
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TemplateCommentPanel.panel$lambda$0$6(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0(TemplateCommentPanel this$0) {
        this$0.updateOverride();
    }

    private static final void _init_$lambda$1(TemplateCommentPanel this$0) {
        this$0.showPreview(this$0.getOptions());
    }

    private static final void showPreview$lambda$0(TemplateCommentPanel this$0, String $defaultCopyrightText) {
        JTextArea jTextArea = this$0.preview;
        if (jTextArea == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preview");
            jTextArea = null;
        }
        jTextArea.setText($defaultCopyrightText);
    }

    public static final /* synthetic */ void access$fireChangeEvent(TemplateCommentPanel $this) {
        $this.fireChangeEvent();
    }

    public static final /* synthetic */ void access$updateBox(TemplateCommentPanel $this) {
        $this.updateBox();
    }
}

