/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.test;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.siyeh.ig.psiutils.TestUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInspection/test/TestInProductSourceVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitClass", "", "node", "Lorg/jetbrains/uast/UClass;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "intellij.jvm.analysis.impl"})
final class TestInProductSourceVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public TestInProductSourceVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public boolean visitClass(@NotNull UClass node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiClass javaClass = node.getJavaPsi();
        if (TestUtils.isInTestSourceContent((PsiElement)((PsiElement)javaClass)) || !TestFrameworks.getInstance().isTestClass(javaClass)) {
            return true;
        }
        String message = JvmAnalysisBundle.message("jvm.inspections.test.case.in.product.source.problem.descriptor", new Object[0]);
        UDeclaration uDeclaration = (UDeclaration)node;
        Intrinsics.checkNotNull((Object)message);
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)uDeclaration, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        return true;
    }

    public boolean visitMethod(@NotNull UMethod node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiMethod method = node.getJavaPsi();
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return true;
        }
        PsiClass containingClass = psiClass;
        if (TestUtils.isInTestSourceContent((PsiElement)((PsiElement)containingClass)) || !TestFrameworks.getInstance().isTestMethod(method)) {
            return true;
        }
        String message = JvmAnalysisBundle.message("jvm.inspections.test.method.in.product.source.problem.descriptor", new Object[0]);
        UDeclaration uDeclaration = (UDeclaration)node;
        Intrinsics.checkNotNull((Object)message);
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UDeclaration)uDeclaration, (String)message, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        return true;
    }
}

