/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoPostFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlighterRecycler;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.InternalLayerSupplier;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextHighlightingUtil;
import com.intellij.codeInsight.multiverse.CodeInsightContextUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateHighlightersUtil {
    static final Logger LOG = Logger.getInstance(UpdateHighlightersUtil.class);
    static final Comparator<HighlightInfo> BY_ACTUAL_START_OFFSET_NO_DUPS = (o1, o2) -> {
        int d = o1.getActualStartOffset() - o2.getActualStartOffset();
        if (d != 0) {
            return d;
        }
        d = o1.getActualEndOffset() - o2.getActualEndOffset();
        if (d != 0) {
            return d;
        }
        d = Comparing.compare((Comparable)o1.getSeverity(), (Comparable)o2.getSeverity());
        if (d != 0) {
            return -d;
        }
        if (!Comparing.equal((Object)o1.type, (Object)o2.type)) {
            return String.valueOf(o1.type).compareTo(String.valueOf(o2.type));
        }
        if (!Comparing.equal((Object)o1.getGutterIconRenderer(), (Object)o2.getGutterIconRenderer())) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal((Object)o1.forcedTextAttributes, (Object)o2.forcedTextAttributes)) {
            return String.valueOf(o1.forcedTextAttributes).compareTo(String.valueOf(o2.forcedTextAttributes));
        }
        if (!Comparing.equal((Object)o1.forcedTextAttributesKey, (Object)o2.forcedTextAttributesKey)) {
            return String.valueOf(o1.forcedTextAttributesKey).compareTo(String.valueOf(o2.forcedTextAttributesKey));
        }
        d = Comparing.compare((Comparable)((Object)o1.getDescription()), (Comparable)((Object)o2.getDescription()));
        if (d != 0) {
            return d;
        }
        return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create((String)"TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static boolean isCoveredByOffsets(@NotNull HighlightInfo info, @NotNull HighlightInfo coveredBy) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(0);
        }
        if (coveredBy == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(1);
        }
        return coveredBy.startOffset <= info.startOffset && info.endOffset <= coveredBy.endOffset && info.getGutterIconRenderer() == null;
    }

    public static boolean isFileLevelOrGutterAnnotation(@NotNull HighlightInfo info) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(2);
        }
        return info.isFileLevelAnnotation() || info.getGutterIconRenderer() != null;
    }

    @Deprecated
    @RequiresEdt
    public static void setHighlightersToSingleEditor(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(4);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        Document document = editor.getDocument();
        MarkupModelEx markup = (MarkupModelEx)editor.getMarkupModel();
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, startOffset, endOffset, highlights, colorsScheme, group, markup);
    }

    @Deprecated
    @RequiresEdt
    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(6);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(7);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertEventDispatchThread();
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, startOffset, endOffset, highlights, colorsScheme, group, markup);
    }

    private static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> infos, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull MarkupModelEx markup) {
        PsiFile psiFile;
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(9);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(10);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(11);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(12);
        }
        TextRange range = new TextRange(startOffset, endOffset);
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-341181, IDEA-301732, EA-823296");){
            psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile instanceof PsiCompiledFile) {
                PsiCompiledFile compiled = (PsiCompiledFile)psiFile;
                psiFile = compiled.getDecompiledPsiFile();
            }
        }
        if (psiFile != null) {
            DaemonCodeAnalyzerEx.getInstanceEx(project).cleanFileLevelHighlights(group, psiFile);
            HighlightingSessionImpl.runInsideHighlightingSessionInEDT(psiFile, CodeInsightContextUtil.getCodeInsightContext((PsiFile)psiFile), colorsScheme, ProperTextRange.create((int)startOffset, (int)endOffset), false, session -> UpdateHighlightersUtil.setHighlightersInRange(document, range, new ArrayList(infos), markup, group, session));
        }
    }

    private static void setHighlightersInRange(@NotNull Document document, @NotNull TextRange range, @NotNull List<? extends HighlightInfo> infos, @NotNull MarkupModelEx markup, int group, @NotNull HighlightingSession session) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(13);
        }
        if (range == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(14);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(15);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(16);
        }
        if (session == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Project project = session.getProject();
        PsiFile psiFile = session.getPsiFile();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        boolean[] changed = new boolean[]{false};
        HighlighterRecycler.runWithRecycler(session, infosToRemove -> {
            DaemonCodeAnalyzerEx.processHighlights(markup, project, null, range.getStartOffset(), range.getEndOffset(), session.getCodeInsightContext(), (Processor<? super HighlightInfo>)((Processor)info -> {
                if (info.getGroup() == group) {
                    boolean willBeRemoved;
                    int hiEnd = info.getEndOffset();
                    boolean bl = willBeRemoved = range.contains((Segment)info) || hiEnd == document.getTextLength() && range.getEndOffset() == hiEnd;
                    if (willBeRemoved) {
                        infosToRemove.recycleHighlighter((HighlightInfo)info);
                    }
                }
                return true;
            }));
            List<HighlightInfo> filteredInfos = HighlightInfoPostFilters.applyPostFilter(project, infos);
            ContainerUtil.quickSort(filteredInfos, BY_ACTUAL_START_OFFSET_NO_DUPS);
            Long2ObjectOpenHashMap range2markerCache = new Long2ObjectOpenHashMap(10);
            DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
            SweepProcessor.Generator generator = processor -> ContainerUtil.process((List)filteredInfos, (Processor)processor);
            SweepProcessor.sweep(generator, (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersInRange$4(codeAnalyzer, group, psiFile, session, changed, range, severityRegistrar, document, markup, infosToRemove, (Long2ObjectMap)range2markerCache, arg_0, arg_1, arg_2, arg_3));
            changed[0] = changed[0] | !infosToRemove.isEmpty();
        });
        if (changed[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
    }

    static boolean isWarningCoveredByError(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar, @NotNull Collection<? extends HighlightInfo> overlappingIntervals) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(18);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(19);
        }
        if (overlappingIntervals == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(20);
        }
        if (!UpdateHighlightersUtil.isSevere(info, severityRegistrar)) {
            for (HighlightInfo highlightInfo : overlappingIntervals) {
                if (!UpdateHighlightersUtil.isCovered(info, severityRegistrar, highlightInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCovered(@NotNull HighlightInfo warning, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightInfo candidate) {
        if (warning == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(21);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(22);
        }
        if (candidate == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(23);
        }
        if (!UpdateHighlightersUtil.isCoveredByOffsets(warning, candidate)) {
            return false;
        }
        if (candidate.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY) {
            return false;
        }
        return UpdateHighlightersUtil.isSevere(candidate, severityRegistrar);
    }

    private static boolean isSevere(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(24);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(25);
        }
        return severityRegistrar.compare(HighlightSeverity.ERROR, severity = info.getSeverity()) <= 0 || severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
    }

    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, int group, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @Nullable HighlighterRecycler infosToRemove, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightingSession highlightingSession) {
        RangeHighlighterEx highlighter;
        long finalInfoRange;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(26);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(27);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(28);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(29);
        }
        if (range2markerCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(30);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(31);
        }
        if (highlightingSession == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(32);
        }
        if ((finalInfoRange = BackgroundUpdateHighlightersUtil.getRangeToCreateHighlighter(info, document)) == -1L) {
            return;
        }
        int infoStartOffset = TextRangeScalarUtil.startOffset((long)finalInfoRange);
        int infoEndOffset = TextRangeScalarUtil.endOffset((long)finalInfoRange);
        info.setGroup(group);
        int layer = UpdateHighlightersUtil.getLayer(info, severityRegistrar);
        TextAttributes infoAttributes = info.getTextAttributes((PsiElement)psiFile, colorsScheme);
        CodeInsightContext context = highlightingSession.getCodeInsightContext();
        Project project = highlightingSession.getProject();
        Consumer changeAttributes = finalHighlighter -> {
            Color attributesErrorStripeColor;
            TextAttributesKey textAttributesKey = info.forcedTextAttributesKey == null ? info.type.getAttributesKey() : info.forcedTextAttributesKey;
            finalHighlighter.setTextAttributesKey(textAttributesKey);
            if (infoAttributes != null) {
                finalHighlighter.setTextAttributes(infoAttributes);
            }
            finalHighlighter.setAfterEndOfLine(info.isAfterEndOfLine());
            Color infoErrorStripeColor = info.getErrorStripeMarkColor((PsiElement)psiFile, colorsScheme);
            TextAttributes attributes = finalHighlighter.getTextAttributes(colorsScheme);
            Color color = attributesErrorStripeColor = attributes != null ? attributes.getErrorStripeColor() : null;
            if (infoErrorStripeColor != null && !infoErrorStripeColor.equals(attributesErrorStripeColor)) {
                finalHighlighter.setErrorStripeMarkColor(infoErrorStripeColor);
            }
            BackgroundUpdateHighlightersUtil.associateInfoAndHighlighter(info, finalHighlighter);
            GutterMark renderer = info.getGutterIconRenderer();
            finalHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
            CodeInsightContextHighlightingUtil.installCodeInsightContext((RangeHighlighter)finalHighlighter, project, context);
            info.updateQuickFixFields(document, range2markerCache, finalInfoRange);
        };
        RangeHighlighterEx rangeHighlighterEx = highlighter = infosToRemove == null ? null : (RangeHighlighterEx)infosToRemove.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer, info.getDescription());
        if (highlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(null, infoStartOffset, infoEndOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, changeAttributes);
            if (HighlightInfoType.VISIBLE_IF_FOLDED.contains(info.type)) {
                highlighter.setVisibleIfFolded(true);
            }
        } else {
            markup.changeAttributesInBatch(highlighter, changeAttributes);
        }
        range2markerCache.put(finalInfoRange, (Object)highlighter);
        if (infoAttributes != null) {
            boolean attributesSet = Comparing.equal((Object)infoAttributes, (Object)highlighter.getTextAttributes(colorsScheme));
            assert (attributesSet) : "Info: " + String.valueOf(infoAttributes) + "; colorsScheme: " + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "; highlighter:" + String.valueOf(highlighter.getTextAttributes(colorsScheme));
        }
    }

    @ApiStatus.Internal
    public static int getLayer(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        int hardCodedLayer;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(33);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(34);
        }
        if ((hardCodedLayer = InternalLayerSuppliers.getLayerFromSuppliers(info)) > 0) {
            return hardCodedLayer;
        }
        HighlightSeverity severity = info.getSeverity();
        int layer = severityRegistrar.compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : (severityRegistrar.compare(severity, HighlightSeverity.WARNING) >= 0 ? 4000 : (severityRegistrar.compare(severity, HighlightSeverity.WEAK_WARNING) >= 0 || severity == HighlightSeverity.TEXT_ATTRIBUTES ? 3750 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || severity == HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY ? 1999 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SYNTAX_SEVERITY ? 1998 : (severity == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY ? 5500 : (severityRegistrar.getAllSeverities().contains(severity) && !SeverityRegistrar.isDefaultSeverity(severity) ? 4000 : 3000))))));
        return layer;
    }

    @ApiStatus.Internal
    public static boolean isWhitespaceOptimizationAllowed(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(35);
        }
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(36);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, (Object)Boolean.TRUE);
    }

    static void clearWhiteSpaceOptimizationFlag(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(37);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    @ApiStatus.Internal
    public static void updateHighlightersByTyping(@NotNull Project project, @NotNull DocumentEvent e) {
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(38);
        }
        if (e == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(39);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Document document = e.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        int start = e.getOffset() - 1;
        int end = start + e.getOldLength();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, start, end, (Processor<? super HighlightInfo>)((Processor)info -> {
            RangeHighlighterEx highlighter = info.getHighlighter();
            TextRange range = highlighter.getTextRange();
            int highlighterStart = range.getStartOffset();
            int highlighterEnd = range.getEndOffset();
            if (info.isAfterEndOfLine()) {
                if (highlighterStart < document.getTextLength()) {
                    ++highlighterStart;
                }
                if (highlighterEnd < document.getTextLength()) {
                    ++highlighterEnd;
                }
            }
            if (!highlighter.isValid() || start < highlighterEnd && highlighterStart <= end) {
                UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
                return false;
            }
            return true;
        }));
    }

    @RequiresEdt
    @ApiStatus.Internal
    public static void disposeWithFileLevelIgnoreErrorsInEDT(@NotNull RangeHighlighter highlighter, @NotNull Project project, @NotNull HighlightInfo info) {
        if (highlighter == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(40);
        }
        if (project == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(41);
        }
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(42);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (info.isFileLevelAnnotation()) {
            DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(highlighter.getDocument());
            if (psiFile != null) {
                codeAnalyzer.removeFileLevelHighlight(psiFile, info);
            }
        }
        try {
            highlighter.dispose();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    static void disposeWithFileLevelIgnoreErrors(@NotNull HighlightInfo info, @NotNull HighlightingSession session) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(43);
        }
        if (session == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(44);
        }
        if (info.isFileLevelAnnotation()) {
            ((HighlightingSessionImpl)session).removeFileLevelHighlight(info);
        }
        RangeHighlighterEx highlighter = info.getHighlighter();
        try {
            if (highlighter != null) {
                highlighter.dispose();
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            MarkupModel model = highlighter == null ? null : DocumentMarkupModel.forDocument((Document)highlighter.getDocument(), (Project)session.getProject(), (boolean)false);
            ArrayList<RangeHighlighterEx> dups = new ArrayList<RangeHighlighterEx>();
            if (model != null) {
                ((MarkupModelEx)model).processRangeHighlightersOverlappingWith(highlighter.getStartOffset(), highlighter.getEndOffset(), (Processor)new CommonProcessors.CollectProcessor(dups));
                dups.removeIf(arg_0 -> UpdateHighlightersUtil.lambda$disposeWithFileLevelIgnoreErrors$8((RangeHighlighter)highlighter, info, arg_0));
            }
            LOG.trace("disposeWithFileLevelIgnoreErrors: " + String.valueOf(info) + (highlighter == null ? " (highlighter is null)" : "") + (String)(dups.isEmpty() ? "" : "; same range highlighters remain: " + String.valueOf(dups)));
        }
    }

    private static /* synthetic */ boolean lambda$disposeWithFileLevelIgnoreErrors$8(RangeHighlighter highlighter, HighlightInfo info, RangeHighlighterEx h) {
        HighlightInfo hi;
        return !h.getTextRange().equals((Object)highlighter.getTextRange()) || h.getTextAttributesKey() != highlighter.getTextAttributesKey() || (hi = HighlightInfo.fromRangeHighlighter((RangeHighlighter)h)) == null || !Objects.equals(hi.getDescription(), info.getDescription()) || !Objects.equals(hi.getToolId(), info.getToolId());
    }

    private static /* synthetic */ boolean lambda$setHighlightersInRange$4(DaemonCodeAnalyzerEx codeAnalyzer, int group, PsiFile psiFile, HighlightingSession session, boolean[] changed, TextRange range, SeverityRegistrar severityRegistrar, Document document, MarkupModelEx markup, HighlighterRecycler infosToRemove, Long2ObjectMap range2markerCache, int __, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (!atStart) {
            return true;
        }
        if (info.isFileLevelAnnotation()) {
            codeAnalyzer.addFileLevelHighlight(group, info, psiFile, null, session.getCodeInsightContext());
            changed[0] = true;
            return true;
        }
        if (range.contains((Segment)info) && !UpdateHighlightersUtil.isWarningCoveredByError(info, severityRegistrar, overlappingIntervals)) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, session.getColorsScheme(), document, group, psiFile, markup, infosToRemove, (Long2ObjectMap<RangeMarker>)range2markerCache, severityRegistrar, session);
            changed[0] = true;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coveredBy";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 27: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 12: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 17: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlappingIntervals";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2markerCache";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSession";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCoveredByOffsets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileLevelOrGutterAnnotation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersToSingleEditor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersToEditor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlightersInRange";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "isWarningCoveredByError";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "isCovered";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "isSevere";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrReuseHighlighterFor";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "getLayer";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhitespaceOptimizationAllowed";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "disableWhiteSpaceOptimization";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "clearWhiteSpaceOptimizationFlag";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "updateHighlightersByTyping";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeWithFileLevelIgnoreErrorsInEDT";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeWithFileLevelIgnoreErrors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InternalLayerSuppliers {
        private static final ExtensionPointName<InternalLayerSupplier> EP_NAME = ExtensionPointName.create((String)"com.intellij.internalHighlightingLayerSupplier");

        private InternalLayerSuppliers() {
        }

        private static int getLayerFromSuppliers(@NotNull HighlightInfo info) {
            if (info == null) {
                InternalLayerSuppliers.$$$reportNull$$$0(0);
            }
            for (InternalLayerSupplier extension : EP_NAME.getExtensionList()) {
                int layer = extension.getLayer(info);
                if (layer <= 0) continue;
                return layer;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil$InternalLayerSuppliers", "getLayerFromSuppliers"));
        }
    }

    @ApiStatus.Internal
    public static final class HighlightInfoPostFilters {
        private static final ExtensionPointName<HighlightInfoPostFilter> EP_NAME = new ExtensionPointName("com.intellij.highlightInfoPostFilter");

        public static boolean accept(@NotNull Project project, @NotNull HighlightInfo info) {
            if (project == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(0);
            }
            if (info == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(1);
            }
            for (HighlightInfoPostFilter filter : EP_NAME.getExtensionList((AreaInstance)project)) {
                if (filter.accept(info)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        static List<HighlightInfo> applyPostFilter(@NotNull Project project, @NotNull List<? extends HighlightInfo> highlightInfos) {
            if (project == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(2);
            }
            if (highlightInfos == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(3);
            }
            ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(highlightInfos.size());
            for (HighlightInfo highlightInfo : highlightInfos) {
                if (!HighlightInfoPostFilters.accept(project, highlightInfo)) continue;
                result.add(highlightInfo);
            }
            ArrayList<HighlightInfo> arrayList = result;
            if (arrayList == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @NotNull
        static List<HighlightInfo> applyPostAndAdditionalFilter(@NotNull Project project, @NotNull List<? extends HighlightInfo> highlightInfos, @NotNull Predicate<? super HighlightInfo> additionalFilter) {
            if (project == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(5);
            }
            if (highlightInfos == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(6);
            }
            if (additionalFilter == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(7);
            }
            ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(highlightInfos.size());
            for (HighlightInfo highlightInfo : highlightInfos) {
                if (!HighlightInfoPostFilters.accept(project, highlightInfo) || !additionalFilter.test(highlightInfo)) continue;
                result.add(highlightInfo);
            }
            ArrayList<HighlightInfo> arrayList = result;
            if (arrayList == null) {
                HighlightInfoPostFilters.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightInfos";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil$HighlightInfoPostFilters";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil$HighlightInfoPostFilters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyPostFilter";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyPostAndAdditionalFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPostFilter";
                    break;
                }
                case 4: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPostAndAdditionalFilter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 8 -> new IllegalStateException(string);
            };
        }
    }
}

