/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.CollectionBreakpointInstrumentor;
import com.intellij.rt.debugger.agent.LogCaptureTransformer;
import com.intellij.rt.debugger.agent.SharedFlowTransformer;
import com.intellij.rt.debugger.agent.SpilledVariablesTransformer;
import com.intellij.rt.debugger.agent.StateFlowTransformer;
import com.intellij.rt.debugger.agent.SuspendHelper;
import com.intellij.rt.debugger.agent.TailCallContinuationTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class DebuggerAgent {
    private static final String KEEP_SUFFIX = "[keep]";

    public static void premain(String args, Instrumentation instrumentation) {
        if (DebuggerAgent.class.getClassLoader() != null) {
            System.err.println("Debugger agent: agent should be loaded by bootstrap classloader, check jar name and 'Boot-Class-Path' value in the manifest");
            return;
        }
        if (System.getProperty("intellij.debug.agent") != null) {
            System.err.println("Debugger agent: more than one agent is not allowed, skipping");
            return;
        }
        System.setProperty("intellij.debug.agent", "true");
        DebuggerAgent.readAndApplyProperties(args, instrumentation);
    }

    private static void initAll(Instrumentation instrumentation, Properties properties) {
        DebuggerAgent.initSharedFlowTransformer(instrumentation);
        CaptureAgent.init(properties, instrumentation);
        SuspendHelper.init(properties);
        CollectionBreakpointInstrumentor.init(instrumentation);
        SpilledVariablesTransformer.init(instrumentation);
        TailCallContinuationTransformer.init(instrumentation);
        LogCaptureTransformer.init(instrumentation);
    }

    private static void readAndApplyProperties(String args, Instrumentation instrumentation) {
        boolean keep;
        String path;
        Properties properties = new Properties();
        if (args == null || args.isEmpty()) {
            DebuggerAgent.initAll(instrumentation, properties);
            return;
        }
        boolean keepSettings = false;
        String argsTrimmed = args.trim();
        if (argsTrimmed.endsWith(KEEP_SUFFIX)) {
            path = argsTrimmed.substring(0, argsTrimmed.length() - KEEP_SUFFIX.length()).trim();
            keepSettings = true;
        } else {
            path = argsTrimmed;
        }
        Path filePath = null;
        try {
            try {
                filePath = Paths.get(new URI(path));
            }
            catch (URISyntaxException ignored) {
                filePath = Paths.get(path, new String[0]);
            }
            try (InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);){
                properties.load(stream);
            }
        }
        catch (Exception e) {
            System.out.println("Capture agent: unable to read settings");
            e.printStackTrace();
        }
        DebuggerAgent.initAll(instrumentation, properties);
        boolean bl = keep = keepSettings || !Boolean.parseBoolean(properties.getProperty("deleteSettings", "true"));
        if (!keep && filePath != null) {
            try {
                Files.deleteIfExists(filePath);
            }
            catch (IOException e) {
                System.out.println("Capture agent: could not delete settings file: " + filePath);
                e.printStackTrace();
            }
        }
    }

    private static void initSharedFlowTransformer(Instrumentation instrumentation) {
        if (Boolean.getBoolean("debugger.agent.enable.coroutines") && Boolean.getBoolean("kotlinx.coroutines.debug.enable.flows.stack.trace")) {
            instrumentation.addTransformer(new SharedFlowTransformer(), true);
            if (Boolean.getBoolean("kotlinx.coroutines.debug.enable.mutable.state.flows.stack.trace")) {
                instrumentation.addTransformer(new StateFlowTransformer(), true);
            }
        }
    }
}

