/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.jvm;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ)\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J1\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001eH\u0082\b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper;", "Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "<init>", "()V", "mapPlatformClass", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classDescriptor", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "mapJavaToKotlin", "functionTypeArity", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isMutable", "", "mutable", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isReadOnly", "readOnly", "convertMutableToReadOnly", "convertReadOnlyToMutable", "convertToOppositeMutability", "descriptor", "mutabilityKindName", "", "oppositeNameExtractor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "descriptors.jvm"})
@SourceDebugExtension(value={"SMAP\nJavaToKotlinClassMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinClassMapper.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper\n*L\n1#1,80:1\n75#1,3:81\n75#1,3:84\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinClassMapper.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMapper\n*L\n59#1:81,3\n65#1:84,3\n*E\n"})
public final class JavaToKotlinClassMapper
implements PlatformToKotlinClassMapper {
    @NotNull
    public static final JavaToKotlinClassMapper INSTANCE = new JavaToKotlinClassMapper();

    private JavaToKotlinClassMapper() {
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
        FqNameUnsafe className = fqNameUnsafe;
        return className.isSafe() ? this.mapPlatformClass(className.toSafe(), DescriptorUtilsKt.getBuiltIns(classDescriptor)) : (Collection<ClassDescriptor>)SetsKt.emptySet();
    }

    @NotNull
    public final Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(this, fqName2, builtIns, null, 4, null);
        if (classDescriptor == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor kotlinAnalog = classDescriptor;
        FqName fqName3 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (fqName3 == null) {
            return SetsKt.setOf((Object)kotlinAnalog);
        }
        FqName kotlinMutableAnalogFqName = fqName3;
        Object[] objectArray = new ClassDescriptor[2];
        objectArray[0] = kotlinAnalog;
        Intrinsics.checkNotNullExpressionValue((Object)builtIns.getBuiltInClassByFqName(kotlinMutableAnalogFqName), (String)"getBuiltInClassByFqName(...)");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns, @Nullable Integer functionTypeArity) {
        ClassId kotlinClassId;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassId classId = kotlinClassId = functionTypeArity != null && Intrinsics.areEqual((Object)fqName2, (Object)JavaToKotlinClassMap.INSTANCE.getFUNCTION_N_FQ_NAME()) ? StandardNames.getFunctionClassId(functionTypeArity) : JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        return classId != null ? builtIns.getBuiltInClassByFqName(classId.asSingleFqName()) : null;
    }

    public static /* synthetic */ ClassDescriptor mapJavaToKotlin$default(JavaToKotlinClassMapper javaToKotlinClassMapper, FqName fqName2, KotlinBuiltIns kotlinBuiltIns, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return javaToKotlinClassMapper.mapJavaToKotlin(fqName2, kotlinBuiltIns, n);
    }

    public final boolean isMutable(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkNotNullParameter((Object)mutable, (String)"mutable");
        return JavaToKotlinClassMap.INSTANCE.isMutable(DescriptorUtils.getFqName(mutable));
    }

    public final boolean isMutable(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isMutable(classDescriptor);
    }

    public final boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkNotNullParameter((Object)readOnly, (String)"readOnly");
        return JavaToKotlinClassMap.INSTANCE.isReadOnly(DescriptorUtils.getFqName(readOnly));
    }

    public final boolean isReadOnly(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isReadOnly(classDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        void descriptor$iv;
        Intrinsics.checkNotNullParameter((Object)mutable, (String)"mutable");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        ClassDescriptor classDescriptor = mutable;
        String mutabilityKindName$iv = "mutable";
        boolean $i$f$convertToOppositeMutability = false;
        FqNameUnsafe it = DescriptorUtils.getFqName((DeclarationDescriptor)descriptor$iv);
        boolean bl = false;
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.mutableToReadOnly(it);
        if (fqName2 == null) {
            throw new IllegalArgumentException("Given class " + descriptor$iv + " is not a " + mutabilityKindName$iv + " collection");
        }
        FqName oppositeClassFqName$iv = fqName2;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)descriptor$iv).getBuiltInClassByFqName(oppositeClassFqName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"getBuiltInClassByFqName(...)");
        return classDescriptor2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        void descriptor$iv;
        Intrinsics.checkNotNullParameter((Object)readOnly, (String)"readOnly");
        JavaToKotlinClassMapper javaToKotlinClassMapper = this;
        ClassDescriptor classDescriptor = readOnly;
        String mutabilityKindName$iv = "read-only";
        boolean $i$f$convertToOppositeMutability = false;
        FqNameUnsafe it = DescriptorUtils.getFqName((DeclarationDescriptor)descriptor$iv);
        boolean bl = false;
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(it);
        if (fqName2 == null) {
            throw new IllegalArgumentException("Given class " + descriptor$iv + " is not a " + mutabilityKindName$iv + " collection");
        }
        FqName oppositeClassFqName$iv = fqName2;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)descriptor$iv).getBuiltInClassByFqName(oppositeClassFqName$iv);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"getBuiltInClassByFqName(...)");
        return classDescriptor2;
    }

    private final ClassDescriptor convertToOppositeMutability(ClassDescriptor descriptor2, String mutabilityKindName, Function1<? super FqNameUnsafe, FqName> oppositeNameExtractor) {
        boolean $i$f$convertToOppositeMutability = false;
        FqName fqName2 = (FqName)oppositeNameExtractor.invoke((Object)DescriptorUtils.getFqName(descriptor2));
        if (fqName2 == null) {
            throw new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        FqName oppositeClassFqName = fqName2;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getBuiltInClassByFqName(...)");
        return classDescriptor;
    }
}

