/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromBaseDirectory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J3\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001dJ1\u0010\u001f\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H 0\"H\u0002\u00a2\u0006\u0002\u0010#R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil;", "", "<init>", "()V", "ourClassLoaderRef", "Ljava/lang/ref/SoftReference;", "Ljava/lang/ClassLoader;", "jdkToolsJar", "Ljava/io/File;", "getJdkToolsJar$jps_plugin", "()Ljava/io/File;", "getOrCreateClassLoader", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "paths", "", "getLibPath", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "invokeExecMethod", "compilerClassName", "", "arguments", "", "out", "Ljava/io/PrintStream;", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;Ljava/io/PrintStream;)Ljava/lang/Object;", "invokeClassesFqNames", "", "files", "withCompilerClassloader", "T", "fn", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nCompilerRunnerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerRunnerUtil.kt\norg/jetbrains/kotlin/compilerRunner/CompilerRunnerUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class CompilerRunnerUtil {
    @NotNull
    public static final CompilerRunnerUtil INSTANCE = new CompilerRunnerUtil();
    @NotNull
    private static SoftReference<ClassLoader> ourClassLoaderRef = new SoftReference<Object>(null);

    private CompilerRunnerUtil() {
    }

    @Nullable
    public final File getJdkToolsJar$jps_plugin() {
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath == null || ((CharSequence)javaHomePath).length() == 0) {
            return null;
        }
        Path javaHome = Paths.get(javaHomePath, new String[0]);
        Path toolsJar = javaHome.resolve("lib/tools.jar");
        if (Files.exists(toolsJar, new LinkOption[0])) {
            return toolsJar.toFile();
        }
        Path path = javaHome.getFileName();
        if (Intrinsics.areEqual((Object)(path != null ? ((Object)path).toString() : null), (Object)"jre") && Files.exists(toolsJar = javaHome.resolveSibling("lib/tools.jar"), new LinkOption[0])) {
            return toolsJar.toFile();
        }
        return null;
    }

    private final synchronized ClassLoader getOrCreateClassLoader(JpsCompilerEnvironment environment, List<? extends File> paths) {
        ClassLoader classLoader = ourClassLoaderRef.get();
        if (classLoader == null) {
            classLoader = ClassPreloadingUtils.preloadClasses((Collection<File>)paths, 4096, CompilerRunnerUtil.class.getClassLoader(), environment.getClassesToLoadByParent());
            ourClassLoaderRef = new SoftReference<ClassLoader>(classLoader);
        }
        ClassLoader classLoader2 = classLoader;
        Intrinsics.checkNotNull((Object)classLoader2);
        return classLoader2;
    }

    @Nullable
    public final File getLibPath(@NotNull KotlinPaths paths, @NotNull MessageCollector messageCollector2) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        File libs = paths.getLibPath();
        if (libs.exists() && !libs.isFile()) {
            return libs;
        }
        messageCollector2.report(CompilerMessageSeverity.ERROR, "Broken compiler at '" + libs.getAbsolutePath() + "'. Make sure plugin is properly installed", null);
        return null;
    }

    @Nullable
    public final Object invokeExecMethod(@NotNull String compilerClassName, @NotNull String[] arguments2, @NotNull JpsCompilerEnvironment environment, @NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return this.withCompilerClassloader(environment, arg_0 -> CompilerRunnerUtil.invokeExecMethod$lambda$0(compilerClassName, out, environment, arguments2, arg_0));
    }

    @NotNull
    public final Set<String> invokeClassesFqNames(@NotNull JpsCompilerEnvironment environment, @NotNull Set<? extends File> files2) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Set set = (Set)this.withCompilerClassloader(environment, arg_0 -> CompilerRunnerUtil.invokeClassesFqNames$lambda$0(files2, arg_0));
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final <T> T withCompilerClassloader(JpsCompilerEnvironment environment, Function1<? super ClassLoader, ? extends T> fn) {
        File file = this.getLibPath(environment.getKotlinPaths(), environment.getMessageCollector());
        if (file == null) {
            return null;
        }
        File libPath = file;
        KotlinPathsFromBaseDirectory kotlinPaths = new KotlinPathsFromBaseDirectory(libPath);
        List paths = CollectionsKt.toMutableList((Collection)kotlinPaths.classPath(KotlinPaths.ClassPaths.CompilerWithScripting, new KotlinPaths.Jar[0]));
        File file2 = this.getJdkToolsJar$jps_plugin();
        if (file2 != null) {
            File it = file2;
            boolean bl = false;
            paths.add(it);
        }
        ClassLoader classLoader = this.getOrCreateClassLoader(environment, paths);
        return (T)fn.invoke((Object)classLoader);
    }

    private static final Object invokeExecMethod$lambda$0(String $compilerClassName, PrintStream $out, JpsCompilerEnvironment $environment, String[] $arguments, ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Class<?> compiler = Class.forName($compilerClassName, true, classLoader);
        Object[] objectArray = new Class[]{PrintStream.class, Class.forName("org.jetbrains.kotlin.config.Services", true, classLoader), String[].class};
        Method exec = compiler.getMethod("execAndOutputXml", (Class<?>[])objectArray);
        objectArray = new Object[]{$out, $environment.getServices(), $arguments};
        return exec.invoke(compiler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), objectArray);
    }

    private static final Set invokeClassesFqNames$lambda$0(Set $files, ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Class<?> klass = Class.forName("org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt", true, classLoader);
        Object object = new Class[]{Set.class};
        Method method = klass.getMethod("classesFqNames", (Class<?>)object);
        Object[] objectArray = new Object[]{$files};
        object = method.invoke(klass, objectArray);
        return object instanceof Set ? (Set)object : null;
    }
}

