/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storages;

import com.intellij.openapi.util.io.FileUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0082\u0004J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u000fH\u0096\u0082\u0004J\n\u0010\u0010\u001a\u00020\u000bH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/storages/PathFunctionPair;", "", "path", "", "function", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getFunction", "compareTo", "", "other", "equals", "", "", "hashCode", "jps-plugin"})
public final class PathFunctionPair
implements Comparable<PathFunctionPair> {
    @NotNull
    private final String path;
    @NotNull
    private final String function;

    public PathFunctionPair(@NotNull String path, @NotNull String function) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.path = path;
        this.function = function;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getFunction() {
        return this.function;
    }

    @Override
    public int compareTo(@NotNull PathFunctionPair other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int pathComp = FileUtil.comparePaths((String)this.path, (String)other.path);
        if (pathComp != 0) {
            return pathComp;
        }
        return this.function.compareTo(other.function);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PathFunctionPair ? FileUtil.pathsEqual((String)this.path, (String)((PathFunctionPair)other).path) && Intrinsics.areEqual((Object)this.function, (Object)((PathFunctionPair)other).function) : false;
    }

    public int hashCode() {
        return 31 * FileUtil.pathHashCode((String)this.path) + this.function.hashCode();
    }
}

