/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListManagerRefreshHelper;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewCommitPanelSplitter;
import com.intellij.openapi.vcs.changes.ChangesViewController;
import com.intellij.openapi.vcs.changes.ChangesViewEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ChangesViewEx;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.impl.shared.changes.DiffPreviewUpdateProcessor;
import com.intellij.platform.vcs.impl.shared.changes.PreviewDiffSplitterComponent;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UiScopeKt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.changes.viewModel.ChangesViewProxy;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitTabTitleUpdater;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.FixedSizeScrollPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0007\"#$%&'(B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\nH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager;", "Lcom/intellij/openapi/vcs/changes/ChangesViewEx;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "value", "Lcom/intellij/vcs/changes/viewModel/ChangesViewProxy;", "changesView", "getChangesView$intellij_platform_vcs_impl", "()Lcom/intellij/vcs/changes/viewModel/ChangesViewProxy;", "getOrCreateCommitChangesView", "disposeCommitChangesView", "", "dispose", "scheduleRefresh", "selectFile", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectChanges", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "setGrouping", "groupingKey", "", "resetViewImmediatelyAndRefreshLater", "commitWorkflowHandler", "Lcom/intellij/vcs/commit/ChangesViewCommitWorkflowHandler;", "getCommitWorkflowHandler", "()Lcom/intellij/vcs/commit/ChangesViewCommitWorkflowHandler;", "ContentPreloader", "ContentPredicate", "ContentProvider", "MyContentDnDTarget", "ChangesViewToolWindowPanel", "DisplayNameSupplier", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nChangesViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewManager.kt\ncom/intellij/openapi/vcs/changes/ChangesViewManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,410:1\n1#2:411\n*E\n"})
public final class ChangesViewManager
implements ChangesViewEx,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @Nullable
    private ChangesViewProxy changesView;

    public ChangesViewManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
    }

    @Nullable
    public final ChangesViewProxy getChangesView$intellij_platform_vcs_impl() {
        return this.changesView;
    }

    @Override
    @RequiresEdt
    @ApiStatus.Internal
    @NotNull
    public ChangesViewProxy getOrCreateCommitChangesView() {
        ChangesViewProxy changesViewProxy = this.changesView;
        if (changesViewProxy == null) {
            ChangesViewProxy changesViewProxy2;
            ChangesViewProxy changesViewProxy3;
            ChangesViewManager $this$getOrCreateCommitChangesView_u24lambda_u240 = this;
            boolean bl = false;
            Activity activity = StartUpMeasurer.startActivity((String)"ChangesViewPanel initialization");
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(...)");
            Activity activity2 = activity;
            ChangesViewProxy it = changesViewProxy3 = ChangesViewProxy.Companion.create($this$getOrCreateCommitChangesView_u24lambda_u240.project, $this$getOrCreateCommitChangesView_u24lambda_u240.cs);
            boolean bl2 = false;
            Disposer.register((Disposable)this, (Disposable)it);
            ChangesViewProxy view = changesViewProxy3;
            activity2.end();
            ChangesViewProxy it2 = changesViewProxy2 = view;
            boolean bl3 = false;
            this.changesView = it2;
            changesViewProxy = changesViewProxy2;
        }
        return changesViewProxy;
    }

    private final void disposeCommitChangesView() {
        ChangesViewProxy changesViewProxy = this.changesView;
        if (changesViewProxy != null) {
            ChangesViewProxy it = changesViewProxy;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.changesView = null;
    }

    public void dispose() {
    }

    @Override
    public void scheduleRefresh() {
        block0: {
            ChangesViewProxy changesViewProxy = this.changesView;
            if (changesViewProxy == null) break block0;
            changesViewProxy.scheduleDelayedRefresh();
        }
    }

    @Override
    public void selectFile(@Nullable VirtualFile vFile) {
        block0: {
            ChangesViewProxy changesViewProxy = this.changesView;
            if (changesViewProxy == null) break block0;
            changesViewProxy.selectFile(vFile);
        }
    }

    @Override
    public void selectChanges(@NotNull List<? extends Change> changes) {
        block0: {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            ChangesViewProxy changesViewProxy = this.changesView;
            if (changesViewProxy == null) break block0;
            changesViewProxy.selectChanges(CollectionsKt.toList((Iterable)changes));
        }
    }

    @Override
    public void setGrouping(@NotNull String groupingKey) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
            ChangesViewProxy changesViewProxy = this.changesView;
            if (changesViewProxy == null) break block0;
            changesViewProxy.setGrouping(groupingKey);
        }
    }

    @Override
    public void resetViewImmediatelyAndRefreshLater() {
        block0: {
            ChangesViewProxy changesViewProxy = this.changesView;
            if (changesViewProxy == null) break block0;
            changesViewProxy.resetViewImmediatelyAndRefreshLater();
        }
    }

    @Override
    @Deprecated(message="Use ChangesViewWorkflowManager#getCommitWorkflowHandler")
    @ApiStatus.Internal
    @Nullable
    public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
        return ChangesViewWorkflowManager.Companion.getInstance(this.project).getCommitWorkflowHandler();
    }

    @JvmStatic
    @NotNull
    public static final ChangesViewI getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final ChangesViewEx getInstanceEx(@NotNull Project project) {
        return Companion.getInstanceEx(project);
    }

    @JvmStatic
    @NotNull
    public static final Factory<JComponent> createTextStatusFactory(@NlsContexts.Label @NotNull String text, boolean isError) {
        return Companion.createTextStatusFactory(text, isError);
    }

    @JvmStatic
    @Nls
    @NotNull
    public static final String getLocalChangesToolWindowName(@NotNull Project project) {
        return Companion.getLocalChangesToolWindowName(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u000212B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0002J\u0010\u0010#\u001a\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010\u0018J\b\u0010%\u001a\u00020\u001cH\u0002J\u0018\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010)\u001a\u00020\u001aH\u0016J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0016J\u001e\u0010-\u001a\u00020\u001c2\u0014\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001000/0'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0018\u00010\u0015R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/vcs/changes/ChangesViewController;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "changesView", "Lcom/intellij/vcs/changes/viewModel/ChangesViewProxy;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/changes/viewModel/ChangesViewProxy;)V", "vcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "mainPanelContent", "Lcom/intellij/ui/components/panels/Wrapper;", "contentPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "commitPanelSplitter", "Lcom/intellij/openapi/vcs/changes/ChangesViewCommitPanelSplitter;", "editorDiffPreview", "Lcom/intellij/openapi/vcs/changes/ChangesViewEditorDiffPreview;", "splitterDiffPreview", "Lcom/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ChangesViewSplitterDiffPreview;", "progressLabel", "commitPanel", "Lcom/intellij/vcs/commit/ChangesViewCommitPanel;", "isDisposed", "", "dispose", "", "updatePanelLayout", "isDiffPreviewAvailable", "()Z", "toggleDiffPreview", "state", "closeEditorPreviewIfNoChanges", "setCommitUi", "commitUi", "configureToolbars", "getActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "originalProvider", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "updateProgressComponent", "progress", "Ljava/util/function/Supplier;", "Ljavax/swing/JComponent;", "ChangesViewSplitterDiffPreview", "Companion", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nChangesViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewManager.kt\ncom/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,410:1\n1642#2,10:411\n1915#2:421\n1916#2:423\n1652#2:424\n1#3:422\n*S KotlinDebug\n*F\n+ 1 ChangesViewManager.kt\ncom/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel\n*L\n331#1:411,10\n331#1:421\n331#1:423\n331#1:424\n331#1:422\n*E\n"})
    private static final class ChangesViewToolWindowPanel
    extends SimpleToolWindowPanel
    implements ChangesViewController,
    Disposable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Project project;
        @NotNull
        private final ChangesViewProxy changesView;
        @NotNull
        private final VcsConfiguration vcsConfiguration;
        @NotNull
        private final Wrapper mainPanelContent;
        @NotNull
        private final BorderLayoutPanel contentPanel;
        @NotNull
        private final ChangesViewCommitPanelSplitter commitPanelSplitter;
        @NotNull
        private final ChangesViewEditorDiffPreview editorDiffPreview;
        @Nullable
        private ChangesViewSplitterDiffPreview splitterDiffPreview;
        @NotNull
        private final Wrapper progressLabel;
        @Nullable
        private ChangesViewCommitPanel commitPanel;
        private boolean isDisposed;

        public ChangesViewToolWindowPanel(@NotNull Project project, @NotNull ChangesViewProxy changesView) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)changesView, (String)"changesView");
            super(false, true);
            this.project = project;
            this.changesView = changesView;
            this.progressLabel = new Wrapper();
            this.changesView.initPanel();
            MessageBusConnection busConnection = this.project.getMessageBus().connect((Disposable)this);
            VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)vcsConfiguration, (String)"getInstance(...)");
            this.vcsConfiguration = vcsConfiguration;
            ChangesViewToolWindowPanel.Companion.registerShortcuts((JComponent)((Object)this));
            Topic topic = ChangeListListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            busConnection.subscribe(topic, (Object)new ChangeListListener(){

                public void changedFileStatusChanged() {
                    ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
                    List<Supplier<JComponent>> list = changeListManager.getAdditionalUpdateInfo();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getAdditionalUpdateInfo(...)");
                    this.updateProgressComponent(list);
                }
            });
            CommitModeManager.Companion.subscribeOnCommitModeChange((SimpleMessageBusConnection)busConnection, () -> ChangesViewToolWindowPanel._init_$lambda$0(this));
            this.configureToolbars();
            this.commitPanelSplitter = new ChangesViewCommitPanelSplitter(this.project);
            Disposer.register((Disposable)this, (Disposable)this.commitPanelSplitter);
            this.commitPanelSplitter.setFirstComponent(this.changesView.getPanel());
            this.contentPanel = new BorderLayoutPanel();
            this.contentPanel.addToCenter((Component)((Object)this.commitPanelSplitter));
            this.mainPanelContent = new Wrapper((JComponent)this.contentPanel);
            this.editorDiffPreview = new ChangesViewEditorDiffPreview(this.changesView, (JComponent)this.contentPanel);
            Disposer.register((Disposable)this, (Disposable)((Disposable)this.editorDiffPreview));
            BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)((Component)this.mainPanelContent)).addToBottom((Component)this.progressLabel);
            Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"addToBottom(...)");
            BorderLayoutPanel mainPanel2 = borderLayoutPanel;
            this.setContent((JComponent)mainPanel2);
            CoroutineScopeKt.cancelOnDispose((Job)UiScopeKt.launchOnShow$default((Component)((Component)mainPanel2), (String)"Changes refresh on changes show", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ChangesViewToolWindowPanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ChangeListManagerRefreshHelper.INSTANCE.requestRefresh(this.this$0.project);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null), (Disposable)this);
            ChangesViewContentManagerKt.subscribeOnVcsToolWindowLayoutChanges(busConnection, () -> ChangesViewToolWindowPanel._init_$lambda$1(this));
            this.updatePanelLayout();
        }

        public void dispose() {
            this.isDisposed = true;
            if (this.splitterDiffPreview != null) {
                ChangesViewSplitterDiffPreview changesViewSplitterDiffPreview = this.splitterDiffPreview;
                Intrinsics.checkNotNull((Object)changesViewSplitterDiffPreview);
                Disposer.dispose((Disposable)changesViewSplitterDiffPreview);
            }
            this.splitterDiffPreview = null;
        }

        private final void updatePanelLayout() {
            boolean needUpdatePreviews;
            if (this.isDisposed) {
                return;
            }
            boolean isVertical = ChangesViewContentManager.Companion.isToolWindowTabVertical(this.project, "Local Changes");
            boolean hasSplitterPreview = ChangesViewContentManager.Companion.shouldHaveSplitterDiffPreview(this.project, isVertical);
            boolean isPreviewPanelShown = hasSplitterPreview && this.vcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
            this.commitPanelSplitter.setOrientation(isPreviewPanelShown || isVertical);
            boolean bl = needUpdatePreviews = hasSplitterPreview != (this.splitterDiffPreview != null);
            if (!needUpdatePreviews) {
                return;
            }
            if (hasSplitterPreview) {
                ChangesViewSplitterDiffPreview changesViewSplitterDiffPreview = this.splitterDiffPreview = new ChangesViewSplitterDiffPreview(this.changesView.createDiffPreviewProcessor(false));
                Intrinsics.checkNotNull((Object)changesViewSplitterDiffPreview);
                DiffPreview.Companion.setPreviewVisible((DiffPreview)changesViewSplitterDiffPreview, this.vcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
            } else {
                ChangesViewSplitterDiffPreview changesViewSplitterDiffPreview = this.splitterDiffPreview;
                Intrinsics.checkNotNull((Object)changesViewSplitterDiffPreview);
                Disposer.dispose((Disposable)changesViewSplitterDiffPreview);
                this.splitterDiffPreview = null;
            }
        }

        @Override
        public boolean isDiffPreviewAvailable() {
            return this.splitterDiffPreview != null;
        }

        @Override
        public void toggleDiffPreview(boolean state) {
            Object object = this.splitterDiffPreview;
            if (object == null) {
                object = this.editorDiffPreview;
            }
            ChangesViewSplitterDiffPreview preview = object;
            DiffPreview.Companion.setPreviewVisible((DiffPreview)preview, state);
            this.updatePanelLayout();
        }

        private final void closeEditorPreviewIfNoChanges() {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            changeListManager2.invokeAfterUpdate(true, () -> ChangesViewToolWindowPanel.closeEditorPreviewIfNoChanges$lambda$0(changeListManager2, this));
        }

        public final void setCommitUi(@Nullable ChangesViewCommitPanel commitUi) {
            if (commitUi != null) {
                commitUi.registerRootComponent((JComponent)((Object)this));
                commitUi.setPostCommitCallback((Function0<Unit>)((Function0)() -> ChangesViewToolWindowPanel.setCommitUi$lambda$0(this)));
                this.commitPanel = commitUi;
                this.commitPanelSplitter.setSecondComponent(commitUi.getComponent());
            } else {
                this.commitPanelSplitter.setSecondComponent(null);
                ChangesViewCommitPanel changesViewCommitPanel = this.commitPanel;
                if (changesViewCommitPanel != null) {
                    changesViewCommitPanel.setPostCommitCallback(null);
                }
                this.commitPanel = null;
            }
            this.configureToolbars();
        }

        private final void configureToolbars() {
            boolean isToolbarHorizontal = CommitModeManager.Companion.isCommitToolWindowEnabled(this.project);
            this.changesView.setToolbarHorizontal(isToolbarHorizontal);
        }

        @NotNull
        public List<AnAction> getActions(boolean originalProvider) {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction("ChangesViewToolbar.Shared");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            DefaultActionGroup toolbarActionGroup = (DefaultActionGroup)anAction;
            AnAction[] anActionArray = toolbarActionGroup.getChildren(actionManager);
            Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
            return ArraysKt.toList((Object[])anActionArray);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            super.uiDataSnapshot(sink);
            DataKey dataKey = DiffDataKeys.EDITOR_TAB_DIFF_PREVIEW;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR_TAB_DIFF_PREVIEW");
            sink.set(dataKey, (Object)this.editorDiffPreview);
            sink.set(ChangesViewController.DATA_KEY, (Object)this);
            DataSink.Companion.uiDataSnapshot(sink, (DataProvider)this.commitPanel);
        }

        private final void updateProgressComponent(List<? extends Supplier<JComponent>> progress) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), arg_0 -> ChangesViewToolWindowPanel.updateProgressComponent$lambda$0(this, arg_0), () -> ChangesViewToolWindowPanel.updateProgressComponent$lambda$1(progress, this));
        }

        private static final void _init_$lambda$0(ChangesViewToolWindowPanel this$0) {
            this$0.configureToolbars();
        }

        private static final void _init_$lambda$1(ChangesViewToolWindowPanel this$0) {
            this$0.updatePanelLayout();
        }

        private static final void closeEditorPreviewIfNoChanges$lambda$0(ChangeListManager $changeListManager, ChangesViewToolWindowPanel this$0) {
            if ($changeListManager.getAllChanges().isEmpty()) {
                this$0.editorDiffPreview.closePreview();
            }
        }

        private static final Unit setCommitUi$lambda$0(ChangesViewToolWindowPanel this$0) {
            this$0.closeEditorPreviewIfNoChanges();
            return Unit.INSTANCE;
        }

        private static final boolean updateProgressComponent$lambda$0(ChangesViewToolWindowPanel this$0, Object it) {
            return this$0.isDisposed;
        }

        /*
         * WARNING - void declaration
         */
        private static final void updateProgressComponent$lambda$1(List $progress, ChangesViewToolWindowPanel this$0) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $progress;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JComponent it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Supplier it = (Supplier)element$iv$iv;
                boolean bl2 = false;
                if ((JComponent)it.get() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List components = (List)destination$iv$iv;
            if (!components.isEmpty()) {
                JComponent jComponent = DiffUtil.createStackedComponents((List)components, (JBValue)DiffUtil.TITLE_GAP);
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createStackedComponents(...)");
                JComponent component = jComponent;
                this$0.progressLabel.setContent((JComponent)((Object)new FixedSizeScrollPanel(component, (Dimension)new JBDimension(400, 100))));
            } else {
                this$0.progressLabel.setContent(null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ChangesViewSplitterDiffPreview;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "Lcom/intellij/openapi/Disposable;", "processor", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel;Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;)V", "splitterComponent", "Lcom/intellij/platform/vcs/impl/shared/changes/PreviewDiffSplitterComponent;", "dispose", "", "openPreview", "", "requestFocus", "closePreview", "intellij.platform.vcs.impl"})
        private final class ChangesViewSplitterDiffPreview
        implements DiffPreview,
        Disposable {
            @NotNull
            private final ChangeViewDiffRequestProcessor processor;
            @NotNull
            private final PreviewDiffSplitterComponent splitterComponent;

            public ChangesViewSplitterDiffPreview(ChangeViewDiffRequestProcessor processor2) {
                Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
                this.processor = processor2;
                this.splitterComponent = new PreviewDiffSplitterComponent((DiffPreviewUpdateProcessor)this.processor, "ChangesViewManager.DETAILS_SPLITTER_PROPORTION");
                this.splitterComponent.setFirstComponent((JComponent)ChangesViewToolWindowPanel.this.contentPanel);
                ChangesViewToolWindowPanel.this.mainPanelContent.setContent((JComponent)this.splitterComponent);
            }

            public void dispose() {
                Disposer.dispose((Disposable)((Disposable)this.processor));
                if (!ChangesViewToolWindowPanel.this.isDisposed) {
                    ChangesViewToolWindowPanel.this.mainPanelContent.setContent((JComponent)ChangesViewToolWindowPanel.this.contentPanel);
                }
            }

            public boolean openPreview(boolean requestFocus) {
                return this.splitterComponent.openPreview(requestFocus);
            }

            public void closePreview() {
                this.splitterComponent.closePreview();
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$Companion;", "", "<init>", "()V", "registerShortcuts", "", "component", "Ljavax/swing/JComponent;", "intellij.platform.vcs.impl"})
        public static final class Companion {
            private Companion() {
            }

            private final void registerShortcuts(JComponent component) {
                ActionUtil.wrap((String)"ChangesView.Refresh").registerCustomShortcutSet(CommonShortcuts.getRerun(), component);
                ActionUtil.wrap((String)"ChangesView.NewChangeList").registerCustomShortcutSet(CommonShortcuts.getNew(), component);
                ActionUtil.wrap((String)"ChangesView.RemoveChangeList").registerCustomShortcutSet(CommonShortcuts.getDelete(), component);
                ActionUtil.wrap((String)"ChangesView.Move").registerCustomShortcutSet(CommonShortcuts.getMove(), component);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J'\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\r\b\u0001\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0015\u0010\u0012\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/vcs/changes/ChangesViewI;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceEx", "Lcom/intellij/openapi/vcs/changes/ChangesViewEx;", "createTextStatusFactory", "Lcom/intellij/openapi/util/Factory;", "Ljavax/swing/JComponent;", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "isError", "", "getLocalChangesToolWindowName", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nChangesViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewManager.kt\ncom/intellij/openapi/vcs/changes/ChangesViewManager$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,410:1\n106#2:411\n78#2,22:412\n*S KotlinDebug\n*F\n+ 1 ChangesViewManager.kt\ncom/intellij/openapi/vcs/changes/ChangesViewManager$Companion\n*L\n376#1:411\n376#1:412,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ChangesViewI getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ChangesViewI.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ChangesViewI)object;
        }

        @JvmStatic
        @NotNull
        public final ChangesViewEx getInstanceEx(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ChangesViewI changesViewI = this.getInstance(project);
            Intrinsics.checkNotNull((Object)changesViewI, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ChangesViewEx");
            return (ChangesViewEx)changesViewI;
        }

        @JvmStatic
        @NotNull
        public final Factory<JComponent> createTextStatusFactory(@NlsContexts.Label @NotNull String text, boolean isError) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return () -> Companion.createTextStatusFactory$lambda$0(text, isError);
        }

        @JvmStatic
        @Nls
        @NotNull
        public final String getLocalChangesToolWindowName(@NotNull Project project) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (CommitModeManager.Companion.isCommitToolWindowEnabled(project)) {
                String string2 = VcsBundle.message((String)"tab.title.commit", (Object[])new Object[0]);
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            } else {
                String string3 = VcsBundle.message((String)"local.changes.tab", (Object[])new Object[0]);
                Intrinsics.checkNotNull((Object)string3);
                string = string3;
            }
            return string;
        }

        private static final JComponent createTextStatusFactory$lambda$0(String $text, boolean $isError) {
            JBLabel jBLabel;
            String $this$trim$iv = $text;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string = StringUtil.replace((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (String)"\n", (String)"<br/>");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            String text = string;
            JBLabel $this$createTextStatusFactory_u24lambda_u240_u241 = jBLabel = new JBLabel(text);
            boolean bl = false;
            $this$createTextStatusFactory_u24lambda_u240_u241.setCopyable(true);
            $this$createTextStatusFactory_u24lambda_u240_u241.setVerticalTextPosition(1);
            $this$createTextStatusFactory_u24lambda_u240_u241.setBorder(JBUI.Borders.empty((int)3));
            $this$createTextStatusFactory_u24lambda_u240_u241.setForeground($isError ? (Color)JBColor.RED : UIUtil.getLabelForeground());
            return (JComponent)jBLabel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$ContentPredicate;", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/project/Project;", "<init>", "()V", "test", "", "project", "intellij.platform.vcs.impl"})
    public static final class ContentPredicate
    implements Predicate<Project> {
        @Override
        public boolean test(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return ProjectLevelVcsManager.Companion.getInstance(project).hasActiveVcss() && !CommitModeManager.Companion.getInstance(project).getCurrentCommitMode().isLocalChangesTabHidden();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$ContentPreloader;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider$Preloader;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "preloadTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "intellij.platform.vcs.impl"})
    public static final class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @NotNull
        private final Project project;

        public ContentPreloader(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void preloadTabContent(@NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            new ChangesViewCommitTabTitleUpdater(this.project, "Local Changes").init((Disposable)content);
            content.putUserData(Content.TAB_DND_TARGET_KEY, (Object)new MyContentDnDTarget(this.project, content));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$ContentProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "intellij.platform.vcs.impl"})
    public static final class ContentProvider
    implements ChangesViewContentProvider {
        @NotNull
        private final Project project;

        public ContentProvider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void initTabContent(@NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Activity activity = StartUpMeasurer.startActivity((String)"ChangesViewToolWindowPanel initialization");
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(...)");
            Activity activity2 = activity;
            ChangesViewI changesViewI = Companion.getInstance(this.project);
            Intrinsics.checkNotNull((Object)changesViewI, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ChangesViewManager");
            ChangesViewManager viewManager = (ChangesViewManager)changesViewI;
            ChangesViewProxy changesView = viewManager.getOrCreateCommitChangesView();
            ChangesViewToolWindowPanel panel = new ChangesViewToolWindowPanel(this.project, changesView);
            ContentProvider.initTabContent$updateCommitWorkflow(this, panel);
            this.project.getMessageBus().connect((Disposable)panel).subscribe(ChangesViewWorkflowManager.TOPIC, () -> ContentProvider.initTabContent$lambda$0(this, panel));
            Disposer.register((Disposable)panel, () -> ContentProvider.initTabContent$lambda$1(viewManager));
            content.setHelpId("ideaInterface.changes");
            content.setComponent((JComponent)((Object)panel));
            content.setPreferredFocusableComponent(changesView.getPreferredFocusedComponent());
            activity2.end();
        }

        private static final void initTabContent$updateCommitWorkflow(ContentProvider this$0, ChangesViewToolWindowPanel panel) {
            ChangesViewCommitWorkflowHandler workflow;
            ChangesViewCommitWorkflowHandler changesViewCommitWorkflowHandler = workflow = ChangesViewWorkflowManager.Companion.getInstance(this$0.project).getCommitWorkflowHandler();
            panel.setCommitUi(changesViewCommitWorkflowHandler != null ? changesViewCommitWorkflowHandler.getUi() : null);
        }

        private static final void initTabContent$lambda$0(ContentProvider this$0, ChangesViewToolWindowPanel $panel) {
            ContentProvider.initTabContent$updateCommitWorkflow(this$0, $panel);
        }

        private static final void initTabContent$lambda$1(ChangesViewManager $viewManager) {
            $viewManager.disposeCommitChangesView();
        }
    }

    @Deprecated(message="Use ChangesViewManager.getLocalChangesToolWindowName")
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$DisplayNameSupplier;", "Ljava/util/function/Supplier;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "get", "intellij.platform.vcs.impl"})
    public static class DisplayNameSupplier
    implements Supplier<String> {
        @NotNull
        private final Project project;

        public DisplayNameSupplier(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        @NotNull
        public String get() {
            return Companion.getLocalChangesToolWindowName(this.project);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewManager$MyContentDnDTarget;", "Lcom/intellij/openapi/vcs/changes/VcsToolwindowDnDTarget;", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/content/Content;)V", "drop", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "isDropPossible", "", "intellij.platform.vcs.impl"})
    private static final class MyContentDnDTarget
    extends VcsToolwindowDnDTarget {
        public MyContentDnDTarget(@NotNull Project project, @NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            super(project, content);
        }

        @Override
        public void drop(@NotNull DnDEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attachedObject, null, !ChangesTreeDnDSupport.isCopyAction((DnDEvent)event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }
    }
}

