/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CompositeCommittedChangesProvider
implements CommittedChangesProvider<CommittedChangeList, CompositeChangeBrowserSettings> {
    private final Project myProject;
    private final List<AbstractVcs> myBaseVcss;

    public CompositeCommittedChangesProvider(@NotNull Project project, @NotNull Collection<AbstractVcs> vcses) {
        if (project == null) {
            CompositeCommittedChangesProvider.$$$reportNull$$$0(0);
        }
        if (vcses == null) {
            CompositeCommittedChangesProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myBaseVcss = new ArrayList<AbstractVcs>(vcses);
    }

    @NotNull
    public CompositeChangeBrowserSettings createDefaultSettings() {
        HashMap<AbstractVcs, ChangeBrowserSettings> map2 = new HashMap<AbstractVcs, ChangeBrowserSettings>();
        for (AbstractVcs vcs : this.myBaseVcss) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            assert (provider != null);
            map2.put(vcs, provider.createDefaultSettings());
        }
        return new CompositeChangeBrowserSettings(map2);
    }

    @NotNull
    public ChangesBrowserSettingsEditor<CompositeChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new CompositeChangesBrowserSettingsEditor();
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath root) {
        AbstractVcs vcs;
        if (root == null) {
            CompositeCommittedChangesProvider.$$$reportNull$$$0(2);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(root)) == null) {
            return null;
        }
        return CommittedChangesCache.getInstance(this.myProject).getLocationCache().getLocation(vcs, root, false);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<CommittedChangeList> getCommittedChanges(CompositeChangeBrowserSettings settings, RepositoryLocation location, int maxCount) {
        throw new UnsupportedOperationException();
    }

    public void loadCommittedChanges(CompositeChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, @NotNull AsynchConsumer<? super CommittedChangeList> consumer) {
        if (location == null) {
            CompositeCommittedChangesProvider.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            CompositeCommittedChangesProvider.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public ChangeListColumn<?> @NotNull [] getColumns() {
        LinkedHashSet<ChangeListColumn> columns = new LinkedHashSet<ChangeListColumn>();
        for (AbstractVcs vcs : this.myBaseVcss) {
            ChangeListColumn[] providerColumns;
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            assert (provider != null);
            for (ChangeListColumn col : providerColumns = provider.getColumns()) {
                if (col != ChangeListColumn.DATE && col != ChangeListColumn.DESCRIPTION && col != ChangeListColumn.NAME && !(col instanceof ChangeListColumn.ChangeListNumberColumn)) continue;
                columns.add(col);
            }
        }
        ChangeListColumn[] changeListColumnArray = columns.toArray(new ChangeListColumn[0]);
        if (changeListColumnArray == null) {
            CompositeCommittedChangesProvider.$$$reportNull$$$0(5);
        }
        return changeListColumnArray;
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(@NotNull DecoratorManager manager, @Nullable RepositoryLocation location) {
        if (manager == null) {
            CompositeCommittedChangesProvider.$$$reportNull$$$0(6);
        }
        JBTabbedPane tabbedPane = null;
        ArrayList actions = null;
        ArrayList toolbarActions = null;
        ArrayList<Runnable> calledOnDispose = new ArrayList<Runnable>();
        for (AbstractVcs baseVcs : this.myBaseVcss) {
            VcsCommittedViewAuxiliary auxiliary;
            CommittedChangesProvider provider = baseVcs.getCommittedChangesProvider();
            if (provider == null || (auxiliary = provider.createActions(manager, location)) == null) continue;
            if (tabbedPane == null) {
                tabbedPane = new JBTabbedPane();
                actions = new ArrayList();
                toolbarActions = new ArrayList();
            }
            actions.addAll(auxiliary.getPopupActions());
            toolbarActions.addAll(auxiliary.getToolbarActions());
            calledOnDispose.add(auxiliary.getCalledOnViewDispose());
        }
        if (tabbedPane != null) {
            JPanel panel = new JPanel();
            panel.add((Component)tabbedPane);
            return new VcsCommittedViewAuxiliary(actions, () -> {
                for (Runnable runnable : calledOnDispose) {
                    runnable.run();
                }
            }, toolbarActions);
        }
        return null;
    }

    public int getUnlimitedCountValue() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Pair<CommittedChangeList, FilePath> getOneList(VirtualFile file, VcsRevisionNumber number) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RepositoryLocation getForNonLocal(@NotNull VirtualFile file) {
        if (file == null) {
            CompositeCommittedChangesProvider.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CompositeCommittedChangesProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CompositeCommittedChangesProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadCommittedChanges";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getForNonLocal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static final class CompositeChangeBrowserSettings
    extends ChangeBrowserSettings {
        private final Map<AbstractVcs, ChangeBrowserSettings> myMap;
        private final Set<AbstractVcs> myEnabledVcs = new HashSet<AbstractVcs>();

        public CompositeChangeBrowserSettings(Map<AbstractVcs, ChangeBrowserSettings> map2) {
            this.myMap = map2;
            this.myEnabledVcs.addAll(map2.keySet());
        }

        public void put(AbstractVcs vcs, ChangeBrowserSettings settings) {
            this.myMap.put(vcs, settings);
        }

        public ChangeBrowserSettings get(AbstractVcs vcs) {
            return this.myMap.get(vcs);
        }

        public void setEnabledVcss(Collection<? extends AbstractVcs> vcss) {
            this.myEnabledVcs.clear();
            this.myEnabledVcs.addAll(vcss);
        }

        public Collection<AbstractVcs> getEnabledVcss() {
            return this.myEnabledVcs;
        }
    }

    private class CompositeChangesBrowserSettingsEditor
    implements ChangesBrowserSettingsEditor<CompositeChangeBrowserSettings> {
        @NotNull
        private final JPanel myCompositePanel;
        private final DateFilterComponent myDateFilter;
        private CompositeChangeBrowserSettings mySettings;
        private final Map<AbstractVcs, ChangesBrowserSettingsEditor<?>> myEditors = new HashMap();
        private final Map<AbstractVcs, JCheckBox> myEnabledCheckboxes = new HashMap<AbstractVcs, JCheckBox>();

        CompositeChangesBrowserSettingsEditor() {
            this.myCompositePanel = new JPanel();
            this.myCompositePanel.setLayout(new BoxLayout(this.myCompositePanel, 1));
            this.myDateFilter = new DateFilterComponent().withBorder(IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.changes.filter.date.filter", (Object[])new Object[0])));
            this.myCompositePanel.add(this.myDateFilter.getPanel());
            for (AbstractVcs vcs : CompositeCommittedChangesProvider.this.myBaseVcss) {
                CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
                assert (provider != null);
                final ChangesBrowserSettingsEditor editor = provider.createFilterUI(false);
                this.myEditors.put(vcs, editor);
                JPanel wrapperPane = new JPanel(new BorderLayout());
                wrapperPane.setBorder(IdeBorderFactory.createTitledBorder((String)vcs.getDisplayName()));
                final JCheckBox checkBox2 = new JCheckBox(VcsBundle.message((String)"composite.change.provider.include.vcs.checkbox", (Object[])new Object[]{vcs.getDisplayName()}), true);
                checkBox2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CompositeChangesBrowserSettingsEditor.updateVcsEnabled(checkBox2, editor);
                    }
                });
                wrapperPane.add((Component)checkBox2, "North");
                this.myEnabledCheckboxes.put(vcs, checkBox2);
                wrapperPane.add((Component)editor.getComponent(), "Center");
                this.myCompositePanel.add(wrapperPane);
            }
        }

        private static void updateVcsEnabled(@NotNull JCheckBox checkBox2, @NotNull ChangesBrowserSettingsEditor<?> editor) {
            if (checkBox2 == null) {
                CompositeChangesBrowserSettingsEditor.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                CompositeChangesBrowserSettingsEditor.$$$reportNull$$$0(1);
            }
            UIUtil.setEnabled((Component)editor.getComponent(), (boolean)checkBox2.isSelected(), (boolean)true);
            if (checkBox2.isSelected()) {
                editor.updateEnabledControls();
            }
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myCompositePanel;
            if (jPanel == null) {
                CompositeChangesBrowserSettingsEditor.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        @NotNull
        public CompositeChangeBrowserSettings getSettings() {
            HashSet<AbstractVcs> enabledVcss = new HashSet<AbstractVcs>();
            for (AbstractVcs vcs : this.myEditors.keySet()) {
                ChangeBrowserSettings settings = this.myEditors.get(vcs).getSettings();
                this.myDateFilter.saveValues(settings);
                this.mySettings.put(vcs, settings);
                if (!this.myEnabledCheckboxes.get(vcs).isSelected()) continue;
                enabledVcss.add(vcs);
            }
            this.mySettings.setEnabledVcss(enabledVcss);
            CompositeChangeBrowserSettings compositeChangeBrowserSettings = this.mySettings;
            if (compositeChangeBrowserSettings == null) {
                CompositeChangesBrowserSettingsEditor.$$$reportNull$$$0(3);
            }
            return compositeChangeBrowserSettings;
        }

        public void setSettings(@NotNull CompositeChangeBrowserSettings settings) {
            if (settings == null) {
                CompositeChangesBrowserSettingsEditor.$$$reportNull$$$0(4);
            }
            this.mySettings = settings;
            boolean dateFilterInitialized = false;
            for (AbstractVcs vcs : this.myEditors.keySet()) {
                ChangeBrowserSettings vcsSettings = this.mySettings.get(vcs);
                ChangesBrowserSettingsEditor<?> editor = this.myEditors.get(vcs);
                editor.setSettings(vcsSettings);
                if (!dateFilterInitialized) {
                    this.myDateFilter.initValues(vcsSettings);
                    dateFilterInitialized = true;
                }
                JCheckBox checkBox2 = this.myEnabledCheckboxes.get(vcs);
                checkBox2.setSelected(settings.getEnabledVcss().contains(vcs));
                CompositeChangesBrowserSettingsEditor.updateVcsEnabled(checkBox2, editor);
            }
        }

        @Nullable
        public String validateInput() {
            for (ChangesBrowserSettingsEditor<?> editor : this.myEditors.values()) {
                String result2 = editor.validateInput();
                if (result2 == null) continue;
                return result2;
            }
            return null;
        }

        public void updateEnabledControls() {
            for (ChangesBrowserSettingsEditor<?> editor : this.myEditors.values()) {
                editor.updateEnabledControls();
            }
        }

        @NotNull
        public String getDimensionServiceKey() {
            @NonNls StringBuilder result2 = new StringBuilder();
            result2.append("Composite");
            for (AbstractVcs vcs : CompositeCommittedChangesProvider.this.myBaseVcss) {
                result2.append(".").append(vcs.getDisplayName());
            }
            String string = result2.toString();
            if (string == null) {
                CompositeChangesBrowserSettingsEditor.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checkBox";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CompositeCommittedChangesProvider$CompositeChangesBrowserSettingsEditor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CompositeCommittedChangesProvider$CompositeChangesBrowserSettingsEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDimensionServiceKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateVcsEnabled";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSettings";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

