/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.instructions;

import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.data.instructions.JumpInstructions;
import com.intellij.rt.coverage.data.instructions.SwitchInstructions;
import java.util.ArrayList;
import java.util.List;

public class LineInstructions
implements CoverageData {
    private int myInstructions;
    private List<JumpInstructions> myJumps;
    private List<SwitchInstructions> mySwitches;

    /*
     * WARNING - void declaration
     */
    public void setInstructions(int instructions) {
        void var1_1;
        this.myInstructions = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addJump(JumpInstructions jump) {
        void var1_1;
        if (this.myJumps == null) {
            this.myJumps = new ArrayList<JumpInstructions>();
        }
        this.myJumps.add((JumpInstructions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addSwitch(SwitchInstructions aSwitch) {
        void var1_1;
        if (this.mySwitches == null) {
            this.mySwitches = new ArrayList<SwitchInstructions>();
        }
        this.mySwitches.add((SwitchInstructions)var1_1);
    }

    public int getInstructions() {
        return this.myInstructions;
    }

    public List<JumpInstructions> getJumps() {
        return this.myJumps;
    }

    public List<SwitchInstructions> getSwitches() {
        return this.mySwitches;
    }

    @Override
    public void merge(CoverageData coverageData) {
        int i;
        LineInstructions other = (LineInstructions)coverageData;
        this.myInstructions = Math.max(this.myInstructions, other.myInstructions);
        if (other.myJumps != null) {
            if (this.myJumps == null) {
                this.myJumps = new ArrayList<JumpInstructions>();
            }
            for (i = this.myJumps.size(); i < other.myJumps.size(); ++i) {
                this.myJumps.add(new JumpInstructions());
            }
            for (i = 0; i < other.myJumps.size(); ++i) {
                this.myJumps.get(i).merge(other.myJumps.get(i));
            }
        }
        if (other.mySwitches != null) {
            if (this.mySwitches == null) {
                this.mySwitches = new ArrayList<SwitchInstructions>();
            }
            for (i = this.mySwitches.size(); i < other.mySwitches.size(); ++i) {
                this.mySwitches.add(new SwitchInstructions(other.mySwitches.get(i).size()));
            }
            for (i = 0; i < other.mySwitches.size(); ++i) {
                this.mySwitches.get(i).merge(other.mySwitches.get(i));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public BranchData getInstructionsData(LineData line) {
        void var3_2;
        void var2_3;
        SwitchData[] switches;
        JumpData[] jumps;
        int covered = 0;
        int total = 0 + this.myInstructions;
        if (line.getHits() > 0) {
            covered = 0 + this.myInstructions;
        }
        if ((jumps = line.getJumps()) != null && this.myJumps != null) {
            for (int i = 0; i < Math.min(jumps.length, this.myJumps.size()); ++i) {
                JumpData jump = jumps[i];
                JumpInstructions jumpInstructions = this.myJumps.get(i);
                total += jumpInstructions.getInstructions(true) + jumpInstructions.getInstructions(false);
                if (jump.getTrueHits() > 0) {
                    covered += jumpInstructions.getInstructions(true);
                }
                if (jump.getFalseHits() <= 0) continue;
                covered += jumpInstructions.getInstructions(false);
            }
        }
        if ((switches = line.getSwitches()) != null && this.mySwitches != null) {
            for (int i = 0; i < Math.min(switches.length, this.mySwitches.size()); ++i) {
                SwitchData switchData = switches[i];
                SwitchInstructions switchInstructions = this.mySwitches.get(i);
                total += switchInstructions.getInstructions(-1);
                if (switchData.getDefaultHits() > 0) {
                    covered += switchInstructions.getInstructions(-1);
                }
                for (int key = 0; key < switchData.getKeys().length; ++key) {
                    total += switchInstructions.getInstructions(key);
                    if (switchData.getHits()[key] <= 0) continue;
                    covered += switchInstructions.getInstructions(key);
                }
            }
        }
        return new BranchData((int)var2_3, (int)var3_2);
    }
}

