/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

public class JSR45Util {
    private static final String FILE_SECTION = "*F\n";
    private static final String LINE_SECTION = "*L\n";
    private static final String SECTION_SEPARATOR = "*";
    private static final LineMapData[] EMPTY_LINE_MAP = new LineMapData[0];

    private static boolean isSmap(String debug) {
        return debug.startsWith("SMAP");
    }

    /*
     * WARNING - void declaration
     */
    public static FileMapData[] extractLineMapping(String debug, String className) {
        Object[] objectArray;
        if (!JSR45Util.isSmap(debug)) {
            return null;
        }
        TIntObjectHashMap<ArrayList<LineMapData>> linesMap = new TIntObjectHashMap<ArrayList<LineMapData>>();
        int fileSectionIdx = debug.indexOf(FILE_SECTION);
        int lineInfoIdx = debug.indexOf(LINE_SECTION);
        List<FileInfo> fileNames = JSR45Util.parseFileNames(debug, fileSectionIdx, lineInfoIdx, className);
        int lineInfoStart = lineInfoIdx + 3;
        int lineInfoEnd = debug.indexOf(SECTION_SEPARATOR, lineInfoStart);
        debug = debug.substring(lineInfoStart, lineInfoEnd);
        Object[] lines = debug.split("\n");
        int fileId = 1;
        for (String string : lines) {
            void var6_7;
            int startOutLine2;
            int repeat = 1;
            int outLineInc = 1;
            int idx = string.indexOf(58);
            String srcLine = string.substring(0, idx);
            String outLine = string.substring(idx + 1);
            int srcCommaIdx = srcLine.indexOf(44);
            int sharpIdx = srcLine.indexOf(35);
            if (sharpIdx >= 0) {
                int n = Integer.parseInt(srcLine.substring(0, sharpIdx));
                if (srcCommaIdx >= 0) {
                    repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                    fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1, srcCommaIdx));
                } else {
                    fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1));
                }
            } else if (srcCommaIdx >= 0) {
                repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                int n = Integer.parseInt(srcLine.substring(0, srcCommaIdx));
            } else {
                int n = Integer.parseInt(srcLine);
            }
            int outCommaIdx = outLine.indexOf(44);
            if (outCommaIdx >= 0) {
                outLineInc = Integer.parseInt(outLine.substring(outCommaIdx + 1));
                int startOutLine = Integer.parseInt(outLine.substring(0, outCommaIdx));
            } else {
                void startOutLine;
                startOutLine2 = Integer.parseInt((String)startOutLine);
            }
            ArrayList<LineMapData> currentFile = (ArrayList<LineMapData>)linesMap.get(fileId);
            if (currentFile == null) {
                currentFile = new ArrayList<LineMapData>();
                linesMap.put(fileId, currentFile);
            }
            currentFile.add(new LineMapData((int)var6_7, repeat, startOutLine2, outLineInc));
        }
        Object[] result = new FileMapData[fileNames.size()];
        for (int i = 0; i < result.length; ++i) {
            FileInfo fileInfo = fileNames.get(i);
            List list = (List)linesMap.get(fileInfo.myIndex);
            LineMapData[] lineMapDataArray = list == null ? EMPTY_LINE_MAP : list.toArray(EMPTY_LINE_MAP);
            result[i] = new FileMapData(fileInfo.myPath, fileInfo.myName, lineMapDataArray);
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] getFileSectionLines(String debug, int fileSectionIdx, int lineInfoIdx) {
        String string;
        void var2_2;
        void var1_1;
        String fileSection = (debug = debug.substring((int)(var1_1 + 3), (int)var2_2)).trim();
        if (fileSection.endsWith("\n")) {
            fileSection = fileSection.substring(0, fileSection.length() - 1);
        }
        return string.split("\n");
    }

    /*
     * WARNING - void declaration
     */
    private static List<FileInfo> parseFileNames(String debug, int fileSectionIdx, int lineInfoIdx, String className) {
        void var1_2;
        void var2_3;
        int i;
        String defaultPrefix = JSR45Util.getClassPackageName(className);
        String[] fileLines = JSR45Util.getFileSectionLines(debug, fileSectionIdx, lineInfoIdx);
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        boolean generatedPrefix = true;
        for (i = 0; i < fileLines.length; ++i) {
            String fileInfoLine;
            String idAndName = fileInfoLine = fileLines[i];
            String path = null;
            if (fileInfoLine.startsWith("+ ")) {
                idAndName = fileInfoLine.substring(2);
                path = fileLines[++i];
            }
            int idx = idAndName.indexOf(" ");
            int key = Integer.parseInt(idAndName.substring(0, idx));
            String fileName = idAndName.substring(idx + 1);
            path = path == null ? fileName : JSR45Util.processRelative(path);
            int lastDot = path.lastIndexOf(".");
            String pathWithDots = ClassNameUtil.convertToFQName(lastDot < 0 ? path : path.substring(0, lastDot) + "_" + path.substring(lastDot + 1));
            generatedPrefix &= !pathWithDots.startsWith(defaultPrefix);
            result.add(new FileInfo(fileName, pathWithDots, key));
        }
        if (var2_3 != false) {
            for (i = 0; i < result.size(); ++i) {
                FileInfo fileInfo = (FileInfo)result.get(i);
                result.set(i, new FileInfo(fileInfo.myName, defaultPrefix + fileInfo.myPath, fileInfo.myIndex));
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String processRelative(String fileName) {
        String string;
        int idx;
        while ((idx = fileName.indexOf("..")) >= 0) {
            void var2_4;
            void var0_1;
            void var1_2;
            String rest = fileName.substring(idx + 2);
            String start = fileName.substring(0, idx);
            if (!start.endsWith("/")) {
                return fileName;
            }
            int endIndex = (start = start.substring(0, start.length() - 1)).lastIndexOf(47);
            string = endIndex >= 0 ? var1_2.substring(0, (int)var0_1) + rest : (rest.startsWith("/") ? rest.substring(1) : var2_4);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String getClassPackageName(String className) {
        void var1_1;
        String generatePrefix = "";
        int fqnLastDotIdx = className.lastIndexOf(".");
        if (fqnLastDotIdx >= 0) {
            void var2_2;
            String string;
            generatePrefix = string.substring(0, (int)(var2_2 + true));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> parseSourcePaths(String debug) {
        void var1_1;
        if (!JSR45Util.isSmap(debug)) {
            return Collections.emptyList();
        }
        String string = debug;
        String[] fileNameIdx = JSR45Util.getFileSectionLines(string, string.indexOf(FILE_SECTION), debug.indexOf(LINE_SECTION));
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < fileNameIdx.length; ++i) {
            String fileName;
            String idAndName = fileName = fileNameIdx[i];
            String path = null;
            if (fileName.startsWith("+ ")) {
                idAndName = fileName.substring(2);
                path = fileNameIdx[++i];
            }
            int idx = idAndName.indexOf(" ");
            String currentClassName = idAndName.substring(idx + 1);
            if (path == null) {
                path = currentClassName;
            } else {
                int lastSlashIdx = (path = JSR45Util.processRelative(path)).lastIndexOf("/");
                if (lastSlashIdx > 0) {
                    void var3_3;
                    path = path.substring(0, ++lastSlashIdx) + (String)var3_3;
                }
            }
            paths.add(path);
        }
        return var1_1;
    }

    private static class FileInfo {
        private final String myName;
        private final String myPath;
        private final int myIndex;

        /*
         * WARNING - void declaration
         */
        public FileInfo(String name, String path, int index) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.myName = var1_1;
            this.myPath = var2_2;
            this.myIndex = var3_3;
        }
    }
}

