/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.FreezableArrayList;
import com.intellij.util.containers.FreezableHashMap;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntKeyWeakValueHashMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.Java11Shim;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftValueHashMap;
import com.intellij.util.containers.WeakHashSet;
import com.intellij.util.containers.WeakKeyIntValueHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

public final class ContainerUtil {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    @SafeVarargs
    @Contract(pure=true)
    public static <T> T @NotNull [] ar(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(1);
        }
        return elements;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(2);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(3);
        }
        HashMap<Object, Object> map2 = new HashMap<Object, Object>(entries.length + 1);
        map2.put(first.getFirst(), first.getSecond());
        for (Pair<? extends K, ? extends V> entry : entries) {
            map2.put(entry.getFirst(), entry.getSecond());
        }
        HashMap<Object, Object> hashMap = map2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> Map<K, V> newHashMap(@NotNull List<? extends K> keys2, @NotNull List<? extends V> values2) {
        if (keys2 == null) {
            ContainerUtil.$$$reportNull$$$0(5);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(6);
        }
        if (keys2.size() != values2.size()) {
            throw new IllegalArgumentException(keys2 + " must have same length as " + values2);
        }
        HashMap<K, V> map2 = new HashMap<K, V>(keys2.size());
        for (int i = 0; i < keys2.size(); ++i) {
            map2.put(keys2.get(i), values2.get(i));
        }
        HashMap<K, V> hashMap = map2;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(8);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(9);
        }
        LinkedHashMap<Object, Object> map2 = new LinkedHashMap<Object, Object>();
        map2.put(first.getFirst(), first.getSecond());
        for (Pair<? extends K, ? extends V> entry : entries) {
            map2.put(entry.getFirst(), entry.getSecond());
        }
        LinkedHashMap<Object, Object> linkedHashMap = map2;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(10);
        }
        return linkedHashMap;
    }

    @Deprecated
    @ApiStatus.Internal
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(11);
        }
        LinkedList list = new LinkedList();
        Collections.addAll(list, elements);
        LinkedList linkedList = list;
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(12);
        }
        return linkedList;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(13);
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Collection<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(14);
        }
        Logger.getInstance(ContainerUtil.class).error("Use `new ArrayList(Collection)` instead. " + iterable.getClass());
        return new ArrayList<E>(iterable);
    }

    @Contract(pure=true)
    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(15);
        }
        ArrayList<E> collection = new ArrayList<E>();
        for (E element : iterable) {
            collection.add(element);
        }
        ArrayList<E> arrayList = collection;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return new ArrayList(size);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> subArrayAsList(final T @NotNull [] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < 0 || index >= end - start) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + (end - start));
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return end - start;
            }
        };
    }

    @Deprecated
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> newUnmodifiableList(@NotNull List<? extends T> originalList) {
        int size;
        if (originalList == null) {
            ContainerUtil.$$$reportNull$$$0(18);
        }
        if ((size = originalList.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        if (size == 1) {
            List<T> list = Collections.singletonList(originalList.get(0));
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<? extends T> list = new FreezableArrayList<T>(originalList).freeze();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> unmodifiableOrEmptyList(@NotNull List<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(21);
        }
        if ((size = original.size()) == 0) {
            return ContainerUtil.emptyList();
        }
        List<? extends T> list = Collections.unmodifiableList(original);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> unmodifiableOrEmptySet(@NotNull Set<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        if ((size = original.size()) == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(24);
            }
            return set;
        }
        Set<? extends T> set = Collections.unmodifiableSet(original);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(25);
        }
        return set;
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> unmodifiableOrEmptyMap(@NotNull Map<? extends K, ? extends V> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(26);
        }
        if ((size = original.size()) == 0) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                ContainerUtil.$$$reportNull$$$0(27);
            }
            return map2;
        }
        Map<? extends K, ? extends V> map3 = Collections.unmodifiableMap(original);
        if (map3 == null) {
            ContainerUtil.$$$reportNull$$$0(28);
        }
        return map3;
    }

    @Deprecated
    @NotNull
    public static <T> List<T> newSmartList() {
        return new SmartList();
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(29);
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(30);
        }
        HashSet<T> set = new HashSet<T>();
        for (T t : iterable) {
            set.add(t);
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(31);
        }
        return hashSet;
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Collection<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(32);
        }
        Logger.getInstance(ContainerUtil.class).error("use HashSet#HashSet(Collection) instead");
        return new HashSet<T>(iterable);
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(33);
        }
        HashSet<T> set = new HashSet<T>();
        while (iterator2.hasNext()) {
            set.add(iterator2.next());
        }
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(34);
        }
        return hashSet;
    }

    @Deprecated
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean isEmpty;
        boolean bl = isEmpty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        if (isEmpty) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(35);
            }
            return set;
        }
        return ContainerUtil.newHashSet(iterable);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        LinkedHashSet<T> collection = new LinkedHashSet<T>();
        for (T element : elements) {
            collection.add(element);
        }
        LinkedHashSet<T> linkedHashSet = collection;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        return linkedHashSet;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Collection<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(38);
        }
        Logger.getInstance(ContainerUtil.class).error("use LinkedHashSet#LinkedHashSet(Collection) instead");
        return new LinkedHashSet<T>(iterable);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> newConcurrentSet() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        if (keySetView == null) {
            ContainerUtil.$$$reportNull$$$0(40);
        }
        return keySetView;
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        if (elements.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> union(@NotNull Map<? extends K, ? extends V> map2, @NotNull Map<? extends K, ? extends V> map22) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(42);
        }
        if (map22 == null) {
            ContainerUtil.$$$reportNull$$$0(43);
        }
        FreezableHashMap<K, V> result = new FreezableHashMap<K, V>(map2.size() + map22.size());
        result.putAll(map2);
        result.putAll(map22);
        return ContainerUtil.emptyOrFrozen(result);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> union(@NotNull Set<? extends T> set, @NotNull Set<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(44);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(45);
        }
        return ContainerUtil.union(set, set2);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(46);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(47);
        }
        HashSet<T> result = new HashSet<T>(set.size() + set2.size());
        result.addAll(set);
        result.addAll(set2);
        Set set3 = ContainerUtil.emptyOrUnmodifiableSet(result);
        if (set3 == null) {
            ContainerUtil.$$$reportNull$$$0(48);
        }
        return set3;
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(49);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(50);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(51);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(52);
        }
        return set;
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        return new ImmutableListBackedByArray(array);
    }

    @Deprecated
    @ApiStatus.Internal
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    public static <E> @Unmodifiable @NotNull List<E> immutableList() {
        return ContainerUtil.emptyList();
    }

    @Deprecated
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull List<E> immutableList(E element) {
        List<E> list = Collections.singletonList(element);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(54);
        }
        return list;
    }

    @Deprecated
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull ImmutableList<E> immutableList(@NotNull List<? extends E> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(55);
        }
        return list instanceof ImmutableList ? (ImmutableList)list : new ImmutableListBackedByList(list);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        return new ImmutableMapBuilder();
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> MultiMap<K, V> groupBy(@NotNull Iterable<? extends V> collection, @NotNull NullableFunction<? super V, ? extends K> grouper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(56);
        }
        if (grouper == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        MultiMap<K, V> result = MultiMap.createLinked();
        for (V data : collection) {
            K key = grouper.fun(data);
            if (key == null) continue;
            result.putValue(key, data);
        }
        if (!result.isEmpty() && result.keySet().iterator().next() instanceof Comparable) {
            return new KeyOrderedMultiMap(result);
        }
        MultiMap<K, V> multiMap = result;
        if (multiMap == null) {
            ContainerUtil.$$$reportNull$$$0(58);
        }
        return multiMap;
    }

    @Contract(pure=true)
    public static <T> T getOrElse(@NotNull List<? extends T> elements, int i, T defaultValue) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(59);
        }
        return elements.size() > i ? elements.get(i) : defaultValue;
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> intersection(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(60);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(61);
        }
        if (map1.isEmpty() || map2.isEmpty()) {
            Map map3 = Collections.emptyMap();
            if (map3 == null) {
                ContainerUtil.$$$reportNull$$$0(62);
            }
            return map3;
        }
        if (map2.size() < map1.size()) {
            Map<K, V> t = map1;
            map1 = map2;
            map2 = t;
        }
        FreezableHashMap<K, V> result = new FreezableHashMap<K, V>(map1);
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            V v2;
            K key = entry.getKey();
            V v1 = entry.getValue();
            if (Objects.equals(v1, v2 = map2.get(key))) continue;
            result.remove(key);
        }
        return ContainerUtil.emptyOrFrozen(result);
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, Couple<V>> diff(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(63);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(64);
        }
        Set<K> keys2 = ContainerUtil.union(map1.keySet(), map2.keySet());
        FreezableHashMap<K, Couple> result = new FreezableHashMap<K, Couple>();
        for (K k : keys2) {
            V v2;
            V v1 = map1.get(k);
            if (Objects.equals(v1, v2 = map2.get(k))) continue;
            result.put(k, Couple.of(v1, v2));
        }
        return ContainerUtil.emptyOrFrozen(result);
    }

    public static <T> void processSortedListsInOrder(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @NotNull PairConsumer<? super T, ? super MergeResult> processor) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(66);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T e;
            if (index1 >= list1.size()) {
                e = list2.get(index2);
                ContainerUtil.checkElementsAreSorted(list2, comparator, index2, e);
                processor.consume((MergeResult)((Object)e), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST2));
                ++index2;
                continue;
            }
            if (index2 >= list2.size()) {
                e = list1.get(index1);
                ContainerUtil.checkElementsAreSorted(list1, comparator, index1, e);
                processor.consume((MergeResult)((Object)e), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST1));
                ++index1;
                continue;
            }
            T element1 = list1.get(index1);
            T element2 = list2.get(index2);
            ContainerUtil.checkElementsAreSorted(list1, comparator, index1, element1);
            ContainerUtil.checkElementsAreSorted(list2, comparator, index2, element2);
            int c = comparator.compare(element1, element2);
            if (c == 0) {
                ++index1;
                ++index2;
                if (mergeEqualItems) {
                    e = element1;
                    processor.consume((MergeResult)((Object)e), (MergeResult)((MergeResult)MergeResult.MERGED_EQUAL_FROM_BOTH));
                    continue;
                }
                processor.consume((MergeResult)((Object)element1), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST1));
                e = element2;
                processor.consume((MergeResult)((Object)e), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST2));
                continue;
            }
            if (c < 0) {
                e = element1;
                ++index1;
                processor.consume((MergeResult)((Object)e), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST1));
                continue;
            }
            e = element2;
            ++index2;
            processor.consume((MergeResult)((Object)e), (MergeResult)((MergeResult)MergeResult.COPIED_FROM_LIST2));
        }
    }

    private static <T> void checkElementsAreSorted(@NotNull List<? extends T> list, @NotNull Comparator<? super T> comparator, int index, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(69);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(70);
        }
        if (index > 0 && comparator.compare(list.get(index - 1), element) > 0) {
            throw new IllegalArgumentException("List is not sorted according to the comparator: list[" + (index - 1) + "]=" + list.get(index - 1) + " > list[" + index + "]=" + element + "; all results are invalid. list=" + list);
        }
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> mergeSortedLists(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(71);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(72);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        FreezableArrayList result = new FreezableArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, (t, __) -> result.add(t));
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result.freeze();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(74);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> subList(@NotNull List<T> list, int from) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(75);
        }
        List<T> list2 = list.subList(from, list.size());
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(76);
        }
        return list2;
    }

    @Contract(mutates="param1")
    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(77);
        }
        if (appendix == null) {
            ContainerUtil.$$$reportNull$$$0(78);
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    @Contract(mutates="param1, param2")
    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            collection.add(o);
        }
    }

    @Contract(mutates="param1")
    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(81);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(82);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    @Contract(mutates="param1, param2")
    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(83);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(84);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <K, V> @Unmodifiable @NotNull Map<K, V> newMapFromKeys(@NotNull Iterator<? extends K> keys2, @NotNull Convertor<? super K, ? extends V> valueConvertor) {
        if (keys2 == null) {
            ContainerUtil.$$$reportNull$$$0(85);
        }
        if (valueConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(86);
        }
        FreezableHashMap<K, V> map2 = new FreezableHashMap<K, V>();
        while (keys2.hasNext()) {
            K key = keys2.next();
            map2.put(key, valueConvertor.convert(key));
        }
        return ContainerUtil.emptyOrFrozen(map2);
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <K, V> @Unmodifiable @NotNull Map<K, V> newMapFromValues(@NotNull Iterator<? extends V> values2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(87);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(88);
        }
        FreezableHashMap map2 = new FreezableHashMap();
        ContainerUtil.fillMapWithValues(map2, values2, keyConvertor);
        return ContainerUtil.emptyOrFrozen(map2);
    }

    @Contract(mutates="param1, param2")
    public static <K, V> void fillMapWithValues(@NotNull Map<? super K, ? super V> map2, @NotNull Iterator<? extends V> values2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(89);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(90);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(91);
        }
        while (values2.hasNext()) {
            V value = values2.next();
            map2.put(keyConvertor.convert(value), value);
        }
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <K, V> @Unmodifiable @NotNull Map<K, Set<V>> classify(@NotNull Iterator<? extends V> iterator2, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(92);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(93);
        }
        FreezableHashMap<Object, Set> map2 = new FreezableHashMap<Object, Set>();
        while (iterator2.hasNext()) {
            V value = iterator2.next();
            K key = keyConvertor.convert(value);
            Set set = map2.computeIfAbsent(key, __ -> new LinkedHashSet());
            set.add(value);
        }
        return ContainerUtil.emptyOrFrozen(map2);
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T find(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(94);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(95);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(96);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(97);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<? super T> processor) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(98);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(99);
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T @NotNull [] iterable, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(100);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(mutates="param1")
    public static <T> boolean process(@NotNull Iterator<? extends T> iterator2, @NotNull Processor<? super T> processor) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        while (iterator2.hasNext()) {
            if (processor.process(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull T equalTo) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(106);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(107);
        }
        return (T)ContainerUtil.find(iterable, object -> equalTo == object || equalTo.equals(object));
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    @Nullable
    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull T equalTo) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(108);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(109);
        }
        return (T)ContainerUtil.find(iterator2, (? super T object) -> equalTo == object || equalTo.equals(object));
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    @Nullable
    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull Condition<? super T> condition) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(110);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(111);
        }
        while (iterator2.hasNext()) {
            T value = iterator2.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static <T> T findLast(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        int index;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(112);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(113);
        }
        if ((index = ContainerUtil.lastIndexOf(list, condition)) < 0) {
            return null;
        }
        return list.get(index);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> @Unmodifiable Map<K, V> map2Map(T @NotNull [] collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(114);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(115);
        }
        FreezableHashMap<Object, Object> result = new FreezableHashMap<Object, Object>(collection.length);
        for (T t : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t);
            result.put(pair.first, pair.second);
        }
        return ContainerUtil.emptyOrFrozen(result);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> @Unmodifiable Map<K, V> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<? extends K, ? extends V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(116);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(117);
        }
        FreezableHashMap<Object, Object> result = new FreezableHashMap<Object, Object>(collection.size());
        for (T t : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t);
            result.put(pair.first, pair.second);
        }
        return ContainerUtil.emptyOrFrozen(result);
    }

    @Contract(pure=true)
    @NotNull
    public static <K, V> @Unmodifiable Map<K, V> map2Map(@NotNull Collection<? extends Pair<? extends K, ? extends V>> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(118);
        }
        FreezableHashMap<Object, Object> result = new FreezableHashMap<Object, Object>(collection.size());
        for (Pair<K, V> pair : collection) {
            result.put(pair.first, pair.second);
        }
        return ContainerUtil.emptyOrFrozen(result);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> @Unmodifiable Map<K, V> map2MapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends @Nullable Pair<? extends K, ? extends V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(119);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(120);
        }
        FreezableHashMap<Object, Object> result = new FreezableHashMap<Object, Object>(collection.size());
        for (T t : collection) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t);
            if (pair == null) continue;
            result.put(pair.first, pair.second);
        }
        return ContainerUtil.emptyOrFrozen(result);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, K, V> Map<K, V> map2MapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable Pair<? extends K, ? extends V>> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(121);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(122);
        }
        FreezableHashMap<Object, Object> result = new FreezableHashMap<Object, Object>(array.length);
        for (T t : array) {
            Pair<? extends K, ? extends V> pair = mapper.fun(t);
            if (pair == null) continue;
            result.put(pair.first, pair.second);
        }
        return ContainerUtil.emptyOrFrozen(result);
    }

    @Contract(pure=true)
    public static <T> Object @NotNull [] map2Array(T @NotNull [] array, @NotNull Function<? super T, Object> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(124);
        }
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @Contract(pure=true)
    public static <T> Object @NotNull [] map2Array(@NotNull Collection<? extends T> array, @NotNull Function<? super T, Object> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(125);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(126);
        }
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(T @NotNull [] array, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(127);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(128);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(129);
        }
        V[] result = ArrayUtil.newArray(aClass, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.fun(array[i]);
        }
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(130);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(131);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(132);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        V[] result = ArrayUtil.newArray(aClass, collection.size());
        int i = 0;
        for (T t : collection) {
            result[i++] = mapper.fun(t);
        }
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        return result;
    }

    @Contract(mutates="param2")
    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, V @NotNull [] to, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(135);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(136);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(137);
        }
        V[] VArray = ContainerUtil.map(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(138);
        }
        return VArray;
    }

    @Contract(mutates="param2")
    public static <T, V> V @NotNull [] map2Array(T @NotNull [] collection, V @NotNull [] to, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(141);
        }
        V[] VArray = ContainerUtil.map(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(142);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> filter(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(143);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(144);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(145);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(146);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> filter(@NotNull Map<? extends K, ? extends V> map2, @NotNull Condition<? super K> keyFilter) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(147);
        }
        if (keyFilter == null) {
            ContainerUtil.$$$reportNull$$$0(148);
        }
        FreezableHashMap<K, V> result = new FreezableHashMap<K, V>();
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return ContainerUtil.emptyOrFrozen(result);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> filterIsInstance(@NotNull Collection<?> collection, @NotNull Class<? extends T> aClass) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(149);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(150);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> filterIsInstance(Object @NotNull [] collection, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(151);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(152);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(153);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(154);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result.freeze();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(155);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(156);
        }
        return ContainerUtil.findAll(collection, Conditions.notNull());
    }

    @Contract(pure=true)
    public static <T, V extends T> @Unmodifiable @NotNull List<V> findAll(T @NotNull [] array, @NotNull Class<V> instanceOf) {
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(157);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(158);
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>();
        for (T t : array) {
            if (!instanceOf.isInstance(t)) continue;
            result.add(t);
        }
        List list = result.freeze();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V extends T> @Unmodifiable @NotNull List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            result.add(t);
        }
        List list = result.freeze();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> findAll(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(163);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(164);
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        List list = result.freeze();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(165);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V extends T> V @NotNull [] findAllAsArray(T @NotNull [] collection, @NotNull Class<V> instanceOf) {
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(166);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(167);
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        V[] array = ArrayUtil.newArray(instanceOf, list.size());
        V[] VArray = list.toArray(array);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(168);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T, V extends T> V @NotNull [] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(169);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(170);
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        V[] array = ArrayUtil.newArray(instanceOf, list.size());
        V[] VArray = list.toArray(array);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(171);
        }
        return VArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] findAllAsArray(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        List<T> list;
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(172);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(173);
        }
        if ((list = ContainerUtil.findAll(collection, condition)).size() == collection.length) {
            if (collection == null) {
                ContainerUtil.$$$reportNull$$$0(174);
            }
            return collection;
        }
        T[] array = ArrayUtil.newArray(ArrayUtil.getComponentType(collection), list.size());
        T[] TArray = list.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(175);
        }
        return TArray;
    }

    public static <T> boolean all(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        return ContainerUtil.and(array, condition);
    }

    public static <T> boolean all(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(179);
        }
        return ContainerUtil.and(collection, condition);
    }

    @Contract(mutates="param1")
    public static void removeDuplicates(@NotNull Collection<?> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(180);
        }
        HashSet collected = new HashSet();
        collection.removeIf(t -> !collected.add(t));
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> iterate(T @NotNull [] array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(181);
        }
        Iterator iterator2 = array.length == 0 ? Collections.emptyIterator() : Arrays.asList(array).iterator();
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        return iterator2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(183);
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(184);
        }
        Iterable iterable = () -> new Iterator<T>(){
            private final ListIterator<? extends T> it;
            {
                this.it = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasPrevious();
            }

            @Override
            public T next() {
                return this.it.previous();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(185);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, E> Iterable<Pair<T, E>> zip(final @NotNull Iterable<? extends T> iterable1, final @NotNull Iterable<? extends E> iterable2) {
        if (iterable1 == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        if (iterable2 == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        Iterable<Pair<T, E>> iterable = () -> new Iterator<Pair<T, E>>(){
            private final Iterator<? extends T> i1;
            private final Iterator<? extends E> i2;
            {
                this.i1 = iterable1.iterator();
                this.i2 = iterable2.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i1.hasNext() && this.i2.hasNext();
            }

            @Override
            public Pair<T, E> next() {
                return Pair.create(this.i1.next(), this.i2.next());
            }

            @Override
            public void remove() {
                this.i1.remove();
                this.i2.remove();
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(188);
        }
        return iterable;
    }

    @Contract(mutates="param1")
    public static void swapElements(@NotNull List<?> list, int index1, int index2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(189);
        }
        Object e1 = list.get(index1);
        Object e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <T> @Unmodifiable @NotNull List<T> collect(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(190);
        }
        if (!iterator2.hasNext()) {
            return ContainerUtil.emptyList();
        }
        FreezableArrayList list = new FreezableArrayList();
        ContainerUtil.addAll(list, iterator2);
        List list2 = list.freeze();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(191);
        }
        return list2;
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <T> @Unmodifiable @NotNull List<T> collect(@NotNull Iterator<?> iterator2, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(192);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(193);
        }
        return ContainerUtil.collect(iterator2, (? super T t) -> instanceOf.value(t));
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <T> @Unmodifiable @NotNull List<T> collect(@NotNull Iterator<? extends T> iterator2, @NotNull Predicate<? super T> predicate) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(194);
        }
        if (predicate == null) {
            ContainerUtil.$$$reportNull$$$0(195);
        }
        if (!iterator2.hasNext()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            if (!predicate.test(o)) continue;
            list.add(o);
        }
        return ContainerUtil.unmodifiableOrEmptyList(list);
    }

    @Contract(mutates="param1, param2")
    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(196);
        }
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(197);
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @SafeVarargs
    @Contract(mutates="param1")
    @NotNull
    public static <T, C extends Collection<? super T>> C addAll(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(198);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(199);
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(200);
        }
        return c;
    }

    @SafeVarargs
    @Contract(mutates="param1")
    @NotNull
    public static <T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(201);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(202);
        }
        for (T element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(203);
        }
        return c;
    }

    @SafeVarargs
    @Contract(mutates="param1")
    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(204);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(205);
        }
        boolean modified = false;
        for (T element : elements) {
            modified |= collection.remove(element);
        }
        return modified;
    }

    @Contract(mutates="param1")
    public static <T> boolean retainAll(@NotNull Collection<T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(206);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(207);
        }
        boolean modified = false;
        Iterator<T> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            T next = iterator2.next();
            if (condition.value(next)) continue;
            iterator2.remove();
            modified = true;
        }
        return modified;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(208);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(209);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator2, @NotNull Class<? extends U> aClass) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(210);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(211);
        }
        return (U)ContainerUtil.find(iterator2, FilteringIterator.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(T @NotNull [] array, @NotNull Class<? extends U> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(212);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        return (U)ContainerUtil.find(array, FilteringIterator.instanceOf(aClass));
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<T> concat(V @NotNull [] array, @NotNull Function<? super V, ? extends Collection<? extends T>> listGenerator) {
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        FreezableArrayList<? extends T> result = new FreezableArrayList<T>();
        for (V v : array) {
            result.addAll(listGenerator.fun(v));
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result.freeze();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> concat(@NotNull @Unmodifiable Iterable<? extends Collection<? extends T>> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        int totalSize = 0;
        for (Collection<T> ts : list) {
            totalSize += ts.size();
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>(totalSize);
        for (Collection<T> collection : list) {
            result.addAll(collection);
        }
        List list2 = result.isEmpty() ? Collections.emptyList() : result.freeze();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(218);
        }
        return list2;
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> append(final @NotNull List<? extends T> list, final T ... values2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(220);
        }
        if (values2.length == 0) {
            List<? extends T> list2 = list;
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(221);
            }
            return list2;
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return index < list.size() ? list.get(index) : values2[index - list.size()];
            }

            @Override
            public int size() {
                return list.size() + values2.length;
            }
        };
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> prepend(final @NotNull List<? extends T> list, final T ... values2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(222);
        }
        if (values2 == null) {
            ContainerUtil.$$$reportNull$$$0(223);
        }
        if (values2.length == 0) {
            List<? extends T> list2 = list;
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(224);
            }
            return list2;
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return index < values2.length ? values2[index] : list.get(index - values2.length);
            }

            @Override
            public int size() {
                return list.size() + values2.length;
            }
        };
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(225);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(226);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(227);
            }
            return list;
        }
        if (list1.isEmpty()) {
            List<T> list = list2;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(228);
            }
            return list;
        }
        if (list2.isEmpty()) {
            List<T> list = list1;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(229);
            }
            return list;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return index < size1 ? list1.get(index) : list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator2 = ContainerUtil.concat(list1, list2).iterator();
                if (iterator2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$8", "iterator"));
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(final @NotNull Iterable<? extends T> it1, final @NotNull Iterable<? extends T> it2) {
        if (it1 == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        if (it2 == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        return new Iterable<T>(){

            @Override
            public void forEach(Consumer<? super T> action) {
                it1.forEach(action);
                it2.forEach(action);
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> it;
                    boolean firstFinished;
                    {
                        this.it = it1.iterator();
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.firstFinished || this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Object value = this.it.next();
                        this.advance();
                        return value;
                    }

                    private void advance() {
                        if (!this.firstFinished && !this.it.hasNext()) {
                            this.it = it2.iterator();
                            this.firstFinished = true;
                        }
                    }
                };
            }
        };
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(232);
        }
        if (iterables.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(233);
            }
            return list;
        }
        if (iterables.length == 1) {
            Iterable<? extends T> iterable = iterables[0];
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(234);
            }
            return iterable;
        }
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[iterables.length];
            for (int i = 0; i < iterables.length; ++i) {
                Iterable iterable = iterables[i];
                iterators[i] = iterable.iterator();
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(235);
        }
        return iterable;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> concatIterators(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(236);
        }
        return new SequenceIterator<T>(iterators);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> concatIterators(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(237);
        }
        return new SequenceIterator(iterators);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> Iterable<T> concat(T[] ... arrays) {
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[arrays.length];
            for (int i = 0; i < arrays.length; ++i) {
                iterators[i] = ContainerUtil.iterate(arrays[i]);
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(238);
        }
        return iterable;
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> concat(List<? extends T> ... lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        if (lists.length == 1) {
            List<? extends T> list = lists[0];
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(240);
            }
            return list;
        }
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        int finalSize = size;
        return new SubList(lists, finalSize);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> concat(@NotNull List<List<? extends T>> lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(241);
        }
        return ContainerUtil.concat(lists.toArray(new List[0]));
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> concat(@NotNull Iterable<? extends T> list, @NotNull Function<? super T, ? extends Collection<? extends V>> listGenerator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(242);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(243);
        }
        FreezableArrayList<? extends V> result = new FreezableArrayList<V>();
        for (T v : list) {
            result.addAll(listGenerator.fun(v));
        }
        List<T> list2 = result.isEmpty() ? ContainerUtil.emptyList() : result.freeze();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(245);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(247);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(248);
        }
        if (collection1.isEmpty() || collection2.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result.add(t);
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(249);
        }
        return list;
    }

    @NotNull
    private static <K, V> Map<K, V> emptyOrFrozen(@NotNull FreezableHashMap<? extends K, ? extends V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(250);
        }
        Map<Object, Object> map2 = result.isEmpty() ? Collections.emptyMap() : (Options.RETURN_REALLY_UNMODIFIABLE_COLLECTION_FROM_METHODS_MARKED_UNMODIFIABLE ? result.freeze() : result);
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(251);
        }
        return map2;
    }

    @Contract(pure=true)
    @NotNull
    public static <E extends Enum<E>> EnumSet<E> intersection(@NotNull EnumSet<E> collection1, @NotNull EnumSet<E> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(252);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(253);
        }
        if (collection1.isEmpty()) {
            EnumSet<E> enumSet = collection1;
            if (enumSet == null) {
                ContainerUtil.$$$reportNull$$$0(254);
            }
            return enumSet;
        }
        if (collection2.isEmpty()) {
            EnumSet<E> enumSet = collection2;
            if (enumSet == null) {
                ContainerUtil.$$$reportNull$$$0(255);
            }
            return enumSet;
        }
        EnumSet<E> result = EnumSet.copyOf(collection1);
        result.retainAll(collection2);
        EnumSet<E> enumSet = result;
        if (enumSet == null) {
            ContainerUtil.$$$reportNull$$$0(256);
        }
        return enumSet;
    }

    @Contract(pure=true)
    public static <T> @UnknownNullability T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Contract(pure=true)
    public static <T> @UnknownNullability T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    public static <T> @UnknownNullability T getOnlyItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getOnlyItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.size() != 1 ? defaultResult : items.iterator().next();
    }

    @Contract(pure=true)
    @NotNull
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(257);
        }
        if (maxItems < 0) {
            throw new IllegalArgumentException("Expected non-negative maxItems; got: " + maxItems);
        }
        List<T> list = maxItems >= items.size() ? items : items.subList(0, maxItems);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<? extends T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        Iterator<T> itr = items.iterator();
        T res = null;
        while (itr.hasNext()) {
            res = itr.next();
        }
        return res;
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull List<? extends T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(260);
        }
        Logger.getInstance(ContainerUtil.class).error("use getLastItem(List) instead");
        return ContainerUtil.getLastItem(items);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Function<? super T, ? extends U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(262);
        }
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Condition<? super T> filter) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(263);
        }
        if (filter == null) {
            ContainerUtil.$$$reportNull$$$0(264);
        }
        return new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    if (!filter.value(t)) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (this.hasNext) {
                    Object result = this.next;
                    this.findNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    @Contract(pure=true)
    public static <T> T getLastItem(@Nullable List<? extends T> list, @Nullable T def) {
        return ContainerUtil.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    @Contract(pure=true)
    public static <T> @UnknownNullability T getLastItem(@Nullable List<? extends T> list) {
        return ContainerUtil.getLastItem(list, null);
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Collection<T> subtract(@NotNull Collection<? extends T> from, @NotNull Collection<? extends T> what) {
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(265);
        }
        if (what == null) {
            ContainerUtil.$$$reportNull$$$0(266);
        }
        HashSet<T> set = new HashSet<T>(from);
        set.removeAll(what);
        Collection<Object> collection = set.isEmpty() ? ContainerUtil.emptyList() : Collections.unmodifiableCollection(set);
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(267);
        }
        return collection;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c, @NotNull ArrayFactory<? extends T> factory) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(268);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(269);
        }
        T[] a = factory.create(c.size());
        T[] TArray = c.toArray(a);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(270);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        return TArray;
    }

    @Contract(mutates="param1")
    public static <T extends Comparable<? super T>> void sort(@NotNull List<T> list) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    @Contract(mutates="param1")
    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            list.sort(comparator);
        }
    }

    @Contract(mutates="param1")
    public static <T extends Comparable<? super T>> void sort(T @NotNull [] a) {
        int size;
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> sorted(@NotNull Collection<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(279);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>(list);
        ContainerUtil.sort(result, comparator);
        List<? extends T> list2 = result.emptyOrFrozen();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(281);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> sorted(@NotNull Iterable<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(283);
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>();
        for (T element : list) {
            result.add(element);
        }
        ContainerUtil.sort(result, comparator);
        List list2 = result.emptyOrFrozen();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T extends Comparable<? super T>> @Unmodifiable @NotNull List<T> sorted(@NotNull Collection<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        FreezableArrayList result = new FreezableArrayList(list);
        result.sort(null);
        List<? extends T> list2 = result.emptyOrFrozen();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        return list2;
    }

    @Contract(mutates="param1")
    public static <T> void sort(T @NotNull [] array, @NotNull Comparator<? super T> comparator) {
        int size;
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(287);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(288);
        }
        if ((size = array.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = array[0];
            T t1 = array[1];
            if (comparator.compare(t0, t1) > 0) {
                array[0] = t1;
                array[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = array[i];
                    T tj = array[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    array[i] = tj;
                    array[j] = ti;
                }
            }
        } else {
            Arrays.sort(array, comparator);
        }
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(290);
        }
        FreezableArrayList<V> result = new FreezableArrayList<V>();
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        return list;
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <T, V> @Unmodifiable @NotNull List<V> map(@NotNull Iterator<? extends T> iterator2, @NotNull Function<? super T, ? extends V> mapping) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(292);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(293);
        }
        FreezableArrayList<V> result = new FreezableArrayList<V>();
        while (iterator2.hasNext()) {
            result.add(mapping.fun(iterator2.next()));
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(294);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(295);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(296);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        FreezableArrayList<V> result = new FreezableArrayList<V>(collection.size());
        for (T t : collection) {
            result.add(mapping.fun(t));
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(297);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @Unmodifiable @NotNull List<@NotNull V> mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(298);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(299);
        }
        if (array.length == 0) {
            return ContainerUtil.emptyList();
        }
        FreezableArrayList<V> result = new FreezableArrayList<V>(array.length);
        for (T t : array) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(300);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull V @NotNull [] mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping, V @NotNull [] emptyArray) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(301);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        assert (emptyArray.length == 0) : "You must pass an empty array";
        ArrayList<V> result = new ArrayList<V>(array.length);
        for (T t : array) {
            V v = mapping.fun(t);
            if (v == null) continue;
            result.add(v);
        }
        if (result.isEmpty()) {
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(304);
            }
            return emptyArray;
        }
        V[] VArray = result.toArray(emptyArray);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(305);
        }
        return VArray;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @Unmodifiable @NotNull List<@NotNull V> mapNotNull(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(306);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(307);
        }
        FreezableArrayList<V> result = new FreezableArrayList<V>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @Unmodifiable @NotNull List<@NotNull V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(309);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(310);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        FreezableArrayList<V> result = new FreezableArrayList<V>(collection.size());
        for (T t : collection) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(311);
        }
        return list;
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T> @Unmodifiable @NotNull List<@NotNull T> packNullables(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(312);
        }
        FreezableArrayList result = new FreezableArrayList();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(result, element);
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(313);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapping) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(314);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(315);
        }
        FreezableArrayList<V> result = new FreezableArrayList<V>(array.length);
        for (T t : array) {
            result.add(mapping.fun(t));
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(316);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> V @NotNull [] map(T @NotNull [] arr, @NotNull Function<? super T, ? extends V> mapping, V @NotNull [] emptyArray) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(317);
        }
        if (arr == null) {
            ContainerUtil.$$$reportNull$$$0(318);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(319);
        }
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(320);
            }
            return emptyArray;
        }
        V[] result = emptyArray.length < arr.length ? Arrays.copyOf(emptyArray, arr.length) : emptyArray;
        for (int i = 0; i < arr.length; ++i) {
            result[i] = mapping.fun(arr[i]);
        }
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(321);
        }
        return result;
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> set() {
        Set set = Collections.emptySet();
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(322);
        }
        return set;
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> set(T t) {
        Set<T> set = Collections.singleton(t);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(323);
        }
        return set;
    }

    @Deprecated
    @SafeVarargs
    public static <T> @Unmodifiable @NotNull Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(324);
        }
        Set<T> set = ContainerUtil.emptyOrUnmodifiableSet(new HashSet<T>(Arrays.asList(items)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(325);
        }
        return set;
    }

    @Contract(mutates="param3")
    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull Map<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(326);
        }
        if (value != null) {
            result.put(key, value);
        }
    }

    @Contract(mutates="param3")
    public static <K, V> void putIfNotNull(K key, @Nullable Collection<? extends V> value, @NotNull MultiMap<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(327);
        }
        if (value != null) {
            result.putValues(key, value);
        }
    }

    @Contract(mutates="param3")
    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull MultiMap<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(328);
        }
        if (value != null) {
            result.putValue(key, value);
        }
    }

    @Contract(mutates="param2")
    public static <T> void add(T element, @NotNull Collection<? super T> result, @NotNull Disposable parentDisposable) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(329);
        }
        if (parentDisposable == null) {
            ContainerUtil.$$$reportNull$$$0(330);
        }
        if (result.add(element)) {
            Disposer.register(parentDisposable, () -> result.remove(element));
        }
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> createMaybeSingletonList(@Nullable T element) {
        List list = element == null ? Collections.emptyList() : Collections.singletonList(element);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(331);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> createMaybeSingletonSet(@Nullable T element) {
        Set set = element == null ? Collections.emptySet() : Collections.singleton(element);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(332);
        }
        return set;
    }

    @Deprecated
    @NotNull
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull V defaultValue) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(333);
        }
        if (defaultValue == null) {
            ContainerUtil.$$$reportNull$$$0(334);
        }
        Object object = result.computeIfAbsent(key, __ -> defaultValue);
        if (object == null) {
            ContainerUtil.$$$reportNull$$$0(335);
        }
        return (V)object;
    }

    @Deprecated
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull Factory<? extends V> factory) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(336);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(337);
        }
        return (V)result.computeIfAbsent(key, __ -> factory.create());
    }

    @Contract(pure=true)
    public static <T> boolean and(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(338);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(339);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(340);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(342);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(343);
        }
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(345);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean or(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(346);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(347);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(348);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(349);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> int count(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(350);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(351);
        }
        int count = 0;
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            ++count;
        }
        return count;
    }

    @SafeVarargs
    @Deprecated
    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> list(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(352);
        }
        List<T> list = Arrays.asList(items);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(353);
        }
        return list;
    }

    @Contract(mutates="param1")
    public static <T> void quickSort(@NotNull List<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(354);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    @Contract(mutates="param1")
    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(357);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecSwap(x, off, b - s, s);
        int n = off + len;
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(358);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(359);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    @Contract(mutates="param1")
    private static <T> void vecSwap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <E> @Unmodifiable @NotNull List<E> flatten(Collection<E> ... collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(360);
        }
        return ContainerUtil.flatten(Arrays.asList(collections));
    }

    @NotNull
    public static <T> @NotNull List<? extends @NotNull T> removeDuplicatesFromSorted(@NotNull @NotNull List<? extends @NotNull T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        Object prev = null;
        ArrayList<@NotNull T> result = null;
        for (int i = 0; i < list.size(); ++i) {
            int cmp;
            T t = list.get(i);
            if (t == null) {
                throw new IllegalArgumentException("get(" + i + ") = null");
            }
            int n = cmp = prev == null ? -1 : comparator.compare(prev, t);
            if (cmp < 0) {
                if (result != null) {
                    result.add(t);
                }
            } else if (cmp == 0) {
                if (result == null) {
                    result = new ArrayList<T>(list.size());
                    result.addAll(list.subList(0, i));
                }
            } else {
                throw new IllegalArgumentException("List must be sorted but get(" + (i - 1) + ")=" + list.get(i - 1) + " > get(" + i + ")=" + t);
            }
            prev = t;
        }
        List<T> list2 = result == null ? list : result;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> flatten(@NotNull @NotNull Iterable<? extends @NotNull Collection<? extends T>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        int totalSize = 0;
        for (Collection<T> list : collections) {
            totalSize += list.size();
        }
        if (totalSize == 0) {
            return ContainerUtil.emptyList();
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>(totalSize);
        for (Collection<T> collection : collections) {
            result.addAll(collection);
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(365);
        }
        return list;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> flatMap(@NotNull Iterable<? extends T> iterable, @NotNull @NotNull Function<? super T, ? extends @NotNull List<? extends V>> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(366);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(367);
        }
        List<V> result = null;
        boolean isOriginal = true;
        for (T each : iterable) {
            List<V> toAdd = mapping.fun(each);
            if (toAdd.isEmpty()) continue;
            if (result == null) {
                result = toAdd;
                continue;
            }
            if (isOriginal) {
                List<V> original = result;
                result = new ArrayList<V>(Math.max(10, result.size() + toAdd.size()));
                result.addAll(original);
                isOriginal = false;
            }
            result.addAll(toAdd);
        }
        List<T> list = result == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(result);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        return list;
    }

    @Contract(mutates="param2")
    public static <K, V> V @NotNull [] convert(K @NotNull [] from, V @NotNull [] to, @NotNull Function<? super K, ? extends V> fun) {
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(369);
        }
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(370);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        if (to.length < from.length) {
            to = ArrayUtil.newArray(ArrayUtil.getComponentType(to), from.length);
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = fun.fun(from[i]);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        return to;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<? extends T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(373);
        }
        for (T t : list) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<? extends T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(374);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean equalsIdentity(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(375);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(376);
        }
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i = 0; i < listSize; ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(377);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(T @NotNull [] list, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(379);
        }
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(380);
        }
        for (int i = 0; i < list.length; ++i) {
            T t = list[i];
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(381);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(382);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findLastInstance(@NotNull List<? extends T> list, @NotNull Class<? extends U> clazz) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(383);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(384);
        }
        int i = ContainerUtil.lastIndexOf(list, clazz::isInstance);
        return i < 0 ? null : (U)list.get(i);
    }

    @Contract(pure=true)
    @NotNull
    public static <A, B> Map<B, A> reverseMap(@NotNull Map<? extends A, ? extends B> map2) {
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(385);
        }
        HashMap<B, A> result = new HashMap<B, A>(map2.size());
        for (Map.Entry<A, B> entry : map2.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        HashMap<B, A> hashMap = result;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(386);
        }
        return hashMap;
    }

    @Contract(value="null -> null; !null -> !null", mutates="param1")
    public static <T> List<T> trimToSize(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(387);
        }
        return list;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return new CopyOnWriteArrayList<T>(ContainerUtil.emptyList());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(388);
        }
        return new LockFreeCopyOnWriteArrayList<T>(c);
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectMap concurrentIntObjectMap = Java11Shim.Companion.createConcurrentIntObjectMap();
        if (concurrentIntObjectMap == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        return concurrentIntObjectMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors());
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(392);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(393);
        }
        return concurrentMap;
    }

    @ApiStatus.Internal
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(394);
        }
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeyWeakValueMap(strategy);
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(395);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(396);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(397);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(398);
        }
        return concurrentMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(399);
        }
        return new LockFreeCopyOnWriteArrayList<T>(c);
    }

    @Contract(mutates="param1")
    public static <T> void addIfNotNull(@NotNull Collection<? super T> result, @Nullable T element) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(400);
        }
        if (element != null) {
            result.add(element);
        }
    }

    @Deprecated
    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(402);
        }
        return ContainerUtil.map(collection, mapper);
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull Set<V> map2Set(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(403);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(404);
        }
        if (array.length == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(405);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(array.length);
        for (T t : array) {
            set.add(mapper.fun(t));
        }
        Set set2 = ContainerUtil.emptyOrUnmodifiableSet(set);
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(406);
        }
        return set2;
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(407);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(408);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(409);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        Set set2 = ContainerUtil.emptyOrUnmodifiableSet(set);
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(410);
        }
        return set2;
    }

    private static <T> Set<T> emptyOrUnmodifiableSet(Set<T> set) {
        return set.isEmpty() ? Collections.emptySet() : (Options.RETURN_REALLY_UNMODIFIABLE_COLLECTION_FROM_METHODS_MARKED_UNMODIFIABLE ? Collections.unmodifiableSet(set) : set);
    }

    @Contract(pure=true)
    public static <T, V> @Unmodifiable @NotNull Set<V> map2LinkedSet(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(411);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(412);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(413);
            }
            return set;
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        Set set2 = ContainerUtil.emptyOrUnmodifiableSet(set);
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(414);
        }
        return set2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @Unmodifiable @NotNull Set<@NotNull V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends @Nullable V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(415);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(416);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(417);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            V value = mapper.fun(t);
            if (value == null) continue;
            set.add(value);
        }
        Set set2 = ContainerUtil.emptyOrUnmodifiableSet(set);
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        return set2;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(mutates="param2")
    public static <T> T @NotNull [] toArray(@NotNull List<T> collection, T @NotNull [] array) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(419);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(420);
        }
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(421);
        }
        return TArray;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(mutates="param2")
    public static <T> T @NotNull [] toArray(@NotNull Collection<? extends T> c, T @NotNull [] sample) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(422);
        }
        if (sample == null) {
            ContainerUtil.$$$reportNull$$$0(423);
        }
        T[] TArray = c.toArray(sample);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(424);
        }
        return TArray;
    }

    @CheckReturnValue
    @Contract(mutates="param1")
    public static <T> T @NotNull [] copyAndClear(@NotNull Collection<T> collection, @NotNull ArrayFactory<? extends T> factory, boolean clear) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(425);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(426);
        }
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(427);
        }
        return a;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> copyList(@NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(428);
        }
        if (list.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(429);
            }
            return list2;
        }
        if (list.size() == 1) {
            List<T> list3 = Collections.singletonList(list.get(0));
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(430);
            }
            return list3;
        }
        List<? extends T> list4 = Collections.unmodifiableList(new ArrayList<T>(list));
        if (list4 == null) {
            ContainerUtil.$$$reportNull$$$0(431);
        }
        return list4;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> toCollection(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(432);
        }
        return iterable instanceof Collection ? (ArrayList<? extends T>)iterable : ContainerUtil.newArrayList(iterable);
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    @NotNull
    public static <T> Collection<T> toCollection(@NotNull Collection<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(433);
        }
        Logger.getInstance(ContainerUtil.class).error("use the argument, Luke");
        Collection<? extends T> collection = iterable;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(434);
        }
        return collection;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> toList(@NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(435);
        }
        if (!enumeration.hasMoreElements()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(436);
            }
            return list;
        }
        FreezableArrayList<T> result = new FreezableArrayList<T>();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        List list = result.emptyOrFrozen();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        return list;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable Map<?, ?> map2) {
        return map2 == null || map2.isEmpty();
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull List<T> notNullize(@Nullable List<T> list) {
        List<T> list2 = list == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(list);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(438);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> @Unmodifiable @NotNull Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : ContainerUtil.emptyOrUnmodifiableSet(set);
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(439);
        }
        return set2;
    }

    @Contract(pure=true)
    public static <K, V> @Unmodifiable @NotNull Map<K, V> notNullize(@Nullable Map<K, V> map2) {
        Map map3 = map2 == null ? Collections.emptyMap() : Collections.unmodifiableMap(map2);
        if (map3 == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        return map3;
    }

    @Contract(pure=true)
    public static <T> boolean startsWith(@NotNull List<? extends T> list, @NotNull List<? extends T> prefix) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(441);
        }
        if (prefix == null) {
            ContainerUtil.$$$reportNull$$$0(442);
        }
        return list.size() >= prefix.size() && list.subList(0, prefix.size()).equals(prefix);
    }

    @Contract(pure=true)
    @Nullable
    public static <C extends Collection<?>> C nullize(@Nullable C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    @Contract(pure=true)
    public static <T extends Comparable<? super T>> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(443);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(444);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = Comparing.compare((Comparable)((Comparable)o1.get(i)), (Comparable)((Comparable)o2.get(i)));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(pure=true)
    public static <T> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2, @NotNull Comparator<? super T> comparator) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(445);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(446);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(447);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = comparator.compare(o1.get(i), o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeySoftValueMap() {
        Map map2 = CollectionFactory.createWeakKeySoftValueMap();
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(448);
        }
        return map2;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeyWeakValueMap() {
        Map map2 = CollectionFactory.createWeakKeyWeakValueMap();
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(449);
        }
        return map2;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftKeySoftValueMap() {
        Map map2 = CollectionFactory.createSoftKeySoftValueMap();
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(450);
        }
        return map2;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftValueMap() {
        return new SoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakValueMap() {
        return new WeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftMap() {
        Map map2 = CollectionFactory.createSoftMap();
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(451);
        }
        return map2;
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap() {
        return new WeakHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createWeakSet() {
        return new WeakHashSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> @NotNull IntObjectMap<@NotNull T> createIntKeyWeakValueMap() {
        return new IntKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> @NotNull ObjectIntMap<@NotNull T> createWeakKeyIntValueMap() {
        return new WeakKeyIntValueHashMap();
    }

    public static <T> T reduce(@NotNull List<? extends T> list, T identity, @NotNull BinaryOperator<T> accumulator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(452);
        }
        if (accumulator == null) {
            ContainerUtil.$$$reportNull$$$0(453);
        }
        Object result = identity;
        for (T t : list) {
            result = accumulator.apply(result, t);
        }
        return result;
    }

    public static <T> Stream<List<? extends T>> splitListToChunks(@NotNull List<? extends T> list, int chunkSize) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(454);
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("invalid chunkSize: " + chunkSize);
        }
        int listSize = list.size();
        if (listSize == 0) {
            return Stream.empty();
        }
        int numberOfChunks = listSize / chunkSize;
        return IntStream.range(0, numberOfChunks * chunkSize == listSize ? numberOfChunks : numberOfChunks + 1).mapToObj(i -> list.subList(i * chunkSize, Math.min(listSize, i * chunkSize + chunkSize)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 62: 
            case 74: 
            case 76: 
            case 130: 
            case 134: 
            case 138: 
            case 142: 
            case 155: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 171: 
            case 174: 
            case 175: 
            case 182: 
            case 185: 
            case 188: 
            case 191: 
            case 200: 
            case 203: 
            case 216: 
            case 218: 
            case 221: 
            case 224: 
            case 227: 
            case 228: 
            case 229: 
            case 233: 
            case 234: 
            case 235: 
            case 238: 
            case 240: 
            case 244: 
            case 249: 
            case 251: 
            case 254: 
            case 255: 
            case 256: 
            case 258: 
            case 267: 
            case 270: 
            case 274: 
            case 281: 
            case 284: 
            case 286: 
            case 291: 
            case 294: 
            case 297: 
            case 300: 
            case 304: 
            case 305: 
            case 308: 
            case 311: 
            case 313: 
            case 316: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 325: 
            case 331: 
            case 332: 
            case 335: 
            case 353: 
            case 363: 
            case 365: 
            case 368: 
            case 372: 
            case 386: 
            case 387: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 405: 
            case 406: 
            case 409: 
            case 410: 
            case 413: 
            case 414: 
            case 417: 
            case 418: 
            case 421: 
            case 424: 
            case 427: 
            case 429: 
            case 430: 
            case 431: 
            case 434: 
            case 436: 
            case 437: 
            case 438: 
            case 439: 
            case 440: 
            case 448: 
            case 449: 
            case 450: 
            case 451: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 62: 
            case 74: 
            case 76: 
            case 130: 
            case 134: 
            case 138: 
            case 142: 
            case 155: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 171: 
            case 174: 
            case 175: 
            case 182: 
            case 185: 
            case 188: 
            case 191: 
            case 200: 
            case 203: 
            case 216: 
            case 218: 
            case 221: 
            case 224: 
            case 227: 
            case 228: 
            case 229: 
            case 233: 
            case 234: 
            case 235: 
            case 238: 
            case 240: 
            case 244: 
            case 249: 
            case 251: 
            case 254: 
            case 255: 
            case 256: 
            case 258: 
            case 267: 
            case 270: 
            case 274: 
            case 281: 
            case 284: 
            case 286: 
            case 291: 
            case 294: 
            case 297: 
            case 300: 
            case 304: 
            case 305: 
            case 308: 
            case 311: 
            case 313: 
            case 316: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 325: 
            case 331: 
            case 332: 
            case 335: 
            case 353: 
            case 363: 
            case 365: 
            case 368: 
            case 372: 
            case 386: 
            case 387: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 405: 
            case 406: 
            case 409: 
            case 410: 
            case 413: 
            case 414: 
            case 417: 
            case 418: 
            case 421: 
            case 424: 
            case 427: 
            case 429: 
            case 430: 
            case 431: 
            case 434: 
            case 436: 
            case 437: 
            case 438: 
            case 439: 
            case 440: 
            case 448: 
            case 449: 
            case 450: 
            case 451: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 62: 
            case 74: 
            case 76: 
            case 130: 
            case 134: 
            case 138: 
            case 142: 
            case 155: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 171: 
            case 174: 
            case 175: 
            case 182: 
            case 185: 
            case 188: 
            case 191: 
            case 200: 
            case 203: 
            case 216: 
            case 218: 
            case 221: 
            case 224: 
            case 227: 
            case 228: 
            case 229: 
            case 233: 
            case 234: 
            case 235: 
            case 238: 
            case 240: 
            case 244: 
            case 249: 
            case 251: 
            case 254: 
            case 255: 
            case 256: 
            case 258: 
            case 267: 
            case 270: 
            case 274: 
            case 281: 
            case 284: 
            case 286: 
            case 291: 
            case 294: 
            case 297: 
            case 300: 
            case 304: 
            case 305: 
            case 308: 
            case 311: 
            case 313: 
            case 316: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 325: 
            case 331: 
            case 332: 
            case 335: 
            case 353: 
            case 363: 
            case 365: 
            case 368: 
            case 372: 
            case 386: 
            case 387: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 405: 
            case 406: 
            case 409: 
            case 410: 
            case 413: 
            case 414: 
            case 417: 
            case 418: 
            case 421: 
            case 424: 
            case 427: 
            case 429: 
            case 430: 
            case 431: 
            case 434: 
            case 436: 
            case 437: 
            case 438: 
            case 439: 
            case 440: 
            case 448: 
            case 449: 
            case 450: 
            case 451: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 5: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 6: 
            case 87: 
            case 90: 
            case 220: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 13: 
            case 53: 
            case 95: 
            case 122: 
            case 124: 
            case 125: 
            case 129: 
            case 158: 
            case 177: 
            case 181: 
            case 213: 
            case 215: 
            case 288: 
            case 299: 
            case 302: 
            case 315: 
            case 343: 
            case 404: 
            case 420: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 14: 
            case 15: 
            case 30: 
            case 32: 
            case 38: 
            case 96: 
            case 101: 
            case 104: 
            case 106: 
            case 208: 
            case 289: 
            case 306: 
            case 339: 
            case 340: 
            case 344: 
            case 347: 
            case 348: 
            case 350: 
            case 366: 
            case 432: 
            case 433: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalList";
                break;
            }
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 33: 
            case 80: 
            case 92: 
            case 102: 
            case 108: 
            case 110: 
            case 190: 
            case 192: 
            case 194: 
            case 210: 
            case 261: 
            case 263: 
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 42: 
            case 89: 
            case 147: 
            case 385: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 43: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 55: 
            case 69: 
            case 75: 
            case 98: 
            case 112: 
            case 184: 
            case 189: 
            case 217: 
            case 219: 
            case 222: 
            case 242: 
            case 275: 
            case 276: 
            case 279: 
            case 282: 
            case 285: 
            case 354: 
            case 361: 
            case 373: 
            case 374: 
            case 377: 
            case 380: 
            case 381: 
            case 383: 
            case 428: 
            case 441: 
            case 452: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 56: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 131: 
            case 135: 
            case 140: 
            case 144: 
            case 145: 
            case 149: 
            case 152: 
            case 153: 
            case 156: 
            case 160: 
            case 164: 
            case 167: 
            case 169: 
            case 173: 
            case 178: 
            case 180: 
            case 196: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 295: 
            case 309: 
            case 401: 
            case 407: 
            case 411: 
            case 415: 
            case 419: 
            case 425: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 65: 
            case 71: 
            case 225: 
            case 375: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 66: 
            case 72: 
            case 226: 
            case 376: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 67: 
            case 70: 
            case 73: 
            case 277: 
            case 280: 
            case 283: 
            case 287: 
            case 355: 
            case 357: 
            case 359: 
            case 362: 
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 68: 
            case 97: 
            case 99: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 88: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 94: 
            case 105: 
            case 111: 
            case 113: 
            case 143: 
            case 146: 
            case 154: 
            case 163: 
            case 172: 
            case 176: 
            case 179: 
            case 207: 
            case 338: 
            case 341: 
            case 342: 
            case 345: 
            case 346: 
            case 349: 
            case 351: 
            case 378: 
            case 379: 
            case 382: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 114: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 126: 
            case 128: 
            case 133: 
            case 136: 
            case 139: 
            case 262: 
            case 402: 
            case 403: 
            case 408: 
            case 412: 
            case 416: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 127: 
            case 132: 
            case 150: 
            case 151: 
            case 209: 
            case 211: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 137: 
            case 141: 
            case 371: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 157: 
            case 161: 
            case 166: 
            case 170: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 183: 
            case 197: 
            case 435: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 214: 
            case 243: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 236: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 239: 
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 245: 
            case 247: 
            case 252: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 246: 
            case 248: 
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 250: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 333: 
            case 336: 
            case 400: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 257: 
            case 259: 
            case 260: 
            case 324: 
            case 352: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 265: 
            case 370: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 266: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 268: 
            case 388: 
            case 399: 
            case 422: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 269: 
            case 273: 
            case 337: 
            case 426: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 271: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 290: 
            case 293: 
            case 296: 
            case 298: 
            case 301: 
            case 307: 
            case 310: 
            case 314: 
            case 317: 
            case 367: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 303: 
            case 319: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 318: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 330: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 334: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 356: 
            case 358: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 360: 
            case 364: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 369: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 384: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 394: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 423: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 443: 
            case 445: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 444: 
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 31: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableList";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 62: 
            case 249: 
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 130: 
            case 134: 
            case 138: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 155: 
            case 159: 
            case 162: 
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 168: 
            case 171: 
            case 174: 
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 203: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 216: 
            case 218: 
            case 227: 
            case 228: 
            case 229: 
            case 233: 
            case 234: 
            case 235: 
            case 238: 
            case 240: 
            case 244: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 221: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 251: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyOrFrozen";
                break;
            }
            case 258: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 267: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 270: 
            case 274: 
            case 421: 
            case 424: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 281: 
            case 284: 
            case 286: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 291: 
            case 294: 
            case 297: 
            case 316: 
            case 320: 
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 300: 
            case 304: 
            case 305: 
            case 308: 
            case 311: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 313: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 322: 
            case 323: 
            case 325: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 331: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 335: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 353: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 363: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 365: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 368: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 372: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 386: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 387: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 389: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectMap";
                break;
            }
            case 390: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 391: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 392: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 393: 
            case 395: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 396: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 397: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftMap";
                break;
            }
            case 398: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 405: 
            case 406: 
            case 409: 
            case 410: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 413: 
            case 414: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 417: 
            case 418: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 427: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 429: 
            case 430: 
            case 431: {
                objectArray = objectArray2;
                objectArray2[1] = "copyList";
                break;
            }
            case 434: {
                objectArray = objectArray2;
                objectArray2[1] = "toCollection";
                break;
            }
            case 436: 
            case 437: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 438: 
            case 439: 
            case 440: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 448: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeySoftValueMap";
                break;
            }
            case 449: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyWeakValueMap";
                break;
            }
            case 450: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftKeySoftValueMap";
                break;
            }
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 62: 
            case 74: 
            case 76: 
            case 130: 
            case 134: 
            case 138: 
            case 142: 
            case 155: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 171: 
            case 174: 
            case 175: 
            case 182: 
            case 185: 
            case 188: 
            case 191: 
            case 200: 
            case 203: 
            case 216: 
            case 218: 
            case 221: 
            case 224: 
            case 227: 
            case 228: 
            case 229: 
            case 233: 
            case 234: 
            case 235: 
            case 238: 
            case 240: 
            case 244: 
            case 249: 
            case 251: 
            case 254: 
            case 255: 
            case 256: 
            case 258: 
            case 267: 
            case 270: 
            case 274: 
            case 281: 
            case 284: 
            case 286: 
            case 291: 
            case 294: 
            case 297: 
            case 300: 
            case 304: 
            case 305: 
            case 308: 
            case 311: 
            case 313: 
            case 316: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 325: 
            case 331: 
            case 332: 
            case 335: 
            case 353: 
            case 363: 
            case 365: 
            case 368: 
            case 372: 
            case 386: 
            case 387: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 405: 
            case 406: 
            case 409: 
            case 410: 
            case 413: 
            case 414: 
            case 417: 
            case 418: 
            case 421: 
            case 424: 
            case 427: 
            case 429: 
            case 430: 
            case 431: 
            case 434: 
            case 436: 
            case 437: 
            case 438: 
            case 439: 
            case 440: 
            case 448: 
            case 449: 
            case 450: 
            case 451: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "subArrayAsList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newUnmodifiableList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 53: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 60: 
            case 61: 
            case 247: 
            case 248: 
            case 252: 
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "checkElementsAreSorted";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 94: 
            case 95: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "filterIsInstance";
                break;
            }
            case 153: 
            case 154: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 181: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 190: 
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 214: 
            case 215: 
            case 217: 
            case 225: 
            case 226: 
            case 230: 
            case 231: 
            case 232: 
            case 239: 
            case 241: 
            case 242: 
            case 243: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 219: 
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 250: {
                objectArray = objectArray;
                objectArray[2] = "emptyOrFrozen";
                break;
            }
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 261: 
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 263: 
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 265: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 268: 
            case 269: 
            case 271: 
            case 272: 
            case 273: 
            case 419: 
            case 420: 
            case 422: 
            case 423: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 287: 
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 279: 
            case 280: 
            case 282: 
            case 283: 
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 289: 
            case 290: 
            case 292: 
            case 293: 
            case 295: 
            case 296: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 298: 
            case 299: 
            case 301: 
            case 302: 
            case 303: 
            case 306: 
            case 307: 
            case 309: 
            case 310: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 326: 
            case 327: 
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 329: 
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 333: 
            case 334: 
            case 336: 
            case 337: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 338: 
            case 339: 
            case 340: 
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 342: 
            case 343: 
            case 344: 
            case 345: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 346: 
            case 347: 
            case 348: 
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 350: 
            case 351: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 352: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 354: 
            case 355: 
            case 356: 
            case 357: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 358: 
            case 359: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 360: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 361: 
            case 362: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 366: 
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 369: 
            case 370: 
            case 371: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 373: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 375: 
            case 376: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 377: 
            case 378: 
            case 379: 
            case 380: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 381: 
            case 382: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 383: 
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 385: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 388: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 400: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 401: 
            case 402: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 403: 
            case 404: 
            case 407: 
            case 408: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 411: 
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 415: 
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 425: 
            case 426: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 428: {
                objectArray = objectArray;
                objectArray[2] = "copyList";
                break;
            }
            case 432: 
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 435: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 441: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 443: 
            case 444: 
            case 445: 
            case 446: 
            case 447: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 452: 
            case 453: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "splitListToChunks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 58: 
            case 62: 
            case 74: 
            case 76: 
            case 130: 
            case 134: 
            case 138: 
            case 142: 
            case 155: 
            case 159: 
            case 162: 
            case 165: 
            case 168: 
            case 171: 
            case 174: 
            case 175: 
            case 182: 
            case 185: 
            case 188: 
            case 191: 
            case 200: 
            case 203: 
            case 216: 
            case 218: 
            case 221: 
            case 224: 
            case 227: 
            case 228: 
            case 229: 
            case 233: 
            case 234: 
            case 235: 
            case 238: 
            case 240: 
            case 244: 
            case 249: 
            case 251: 
            case 254: 
            case 255: 
            case 256: 
            case 258: 
            case 267: 
            case 270: 
            case 274: 
            case 281: 
            case 284: 
            case 286: 
            case 291: 
            case 294: 
            case 297: 
            case 300: 
            case 304: 
            case 305: 
            case 308: 
            case 311: 
            case 313: 
            case 316: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 325: 
            case 331: 
            case 332: 
            case 335: 
            case 353: 
            case 363: 
            case 365: 
            case 368: 
            case 372: 
            case 386: 
            case 387: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 405: 
            case 406: 
            case 409: 
            case 410: 
            case 413: 
            case 414: 
            case 417: 
            case 418: 
            case 421: 
            case 424: 
            case 427: 
            case 429: 
            case 430: 
            case 431: 
            case 434: 
            case 436: 
            case 437: 
            case 438: 
            case 439: 
            case 440: 
            case 448: 
            case 449: 
            case 450: 
            case 451: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Unmodifiable
    private static final class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(E @NotNull [] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index) {
            return this.myStore[index];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        @Override
        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            int size;
            if (a == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(1);
            }
            T[] result = a.length >= (size = this.size()) ? a : ArrayUtil.newArray(ArrayUtil.getComponentType(a), size);
            System.arraycopy(this.myStore, 0, result, 0, size);
            if (result.length > size) {
                result[size] = null;
            }
            if (result == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(2);
            }
            return result;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            int length = this.myStore.length;
            for (int i = 0; i < length; ++i) {
                action.accept(this.myStore[i]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Unmodifiable
    private static final class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<? extends E> myStore;

        private ImmutableListBackedByList(@NotNull List<? extends E> list) {
            if (list == null) {
                ImmutableListBackedByList.$$$reportNull$$$0(0);
            }
            this.myStore = list;
        }

        @Override
        public E get(int index) {
            return this.myStore.get(index);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.myStore.forEach(action);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByList", "<init>"));
        }
    }

    @Deprecated
    public static final class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new HashMap();

        @NotNull
        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            ImmutableMapBuilder immutableMapBuilder = this;
            if (immutableMapBuilder == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(0);
            }
            return immutableMapBuilder;
        }

        @NotNull
        public ImmutableMapBuilder<K, V> putAll(@NotNull Map<? extends K, ? extends V> fromMap) {
            if (fromMap == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(1);
            }
            this.myMap.putAll(fromMap);
            ImmutableMapBuilder immutableMapBuilder = this;
            if (immutableMapBuilder == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(2);
            }
            return immutableMapBuilder;
        }

        @Contract(pure=true)
        public @Unmodifiable @NotNull Map<K, V> build() {
            Map<K, V> map2 = Collections.unmodifiableMap(this.myMap);
            if (map2 == null) {
                ImmutableMapBuilder.$$$reportNull$$$0(3);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableMapBuilder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "put";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableMapBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "putAll";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "putAll";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class KeyOrderedMultiMap<K extends Comparable<? super K>, V>
    extends MultiMap<K, V> {
        public KeyOrderedMultiMap() {
            super(new TreeMap());
        }

        public KeyOrderedMultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
            if (toCopy == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(0);
            }
            super(new TreeMap());
            this.putAllValues(toCopy);
        }

        @NotNull
        public NavigableSet<K> navigableKeySet() {
            NavigableSet navigableSet = ((TreeMap)this.myMap).navigableKeySet();
            if (navigableSet == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(1);
            }
            return navigableSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toCopy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigableKeySet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum MergeResult {
        COPIED_FROM_LIST1,
        MERGED_EQUAL_FROM_BOTH,
        COPIED_FROM_LIST2;

    }

    private static class SubList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final int myFinalSize;
        @NotNull
        @NotNull @Unmodifiable List<? extends T> @NotNull [] lists;

        private SubList(@NotNull @NotNull @Unmodifiable List<? extends T> @NotNull [] lists, int totalSize) {
            if (lists == null) {
                SubList.$$$reportNull$$$0(0);
            }
            this.lists = lists;
            assert (lists.length > 1);
            this.myFinalSize = totalSize;
        }

        @Override
        public T get(int index) {
            if (index >= 0 && index < this.myFinalSize) {
                int from = 0;
                for (List<T> list : this.lists) {
                    if (from <= index && index < from + list.size()) {
                        return list.get(index - from);
                    }
                    from += list.size();
                }
                if (from != this.myFinalSize) {
                    throw new ConcurrentModificationException("The list has changed. Its size was " + this.myFinalSize + "; now it's " + from);
                }
            }
            throw new IndexOutOfBoundsException("index: " + index + "; size: " + this.size());
        }

        @Override
        public int size() {
            return this.myFinalSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/util/containers/ContainerUtil$SubList", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static final class Options {
        @ApiStatus.Internal
        public static boolean RETURN_REALLY_UNMODIFIABLE_COLLECTION_FROM_METHODS_MARKED_UNMODIFIABLE;
    }
}

