/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.wm.RegisterToolWindowTaskBuilder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.RemoteTransferUIManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import icons.MavenIcons;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.indices.IndexChangeProgressListener;
import org.jetbrains.idea.maven.indices.MavenSystemIndicesManager;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigatorState;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsNavigatorPanel;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.MavenIndexUpdateState;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenEelUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@State(name="MavenProjectNavigator", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")}, getStateRequiresEdt=true)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 92\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u00020\u0004:\u000289B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0011H\u0016J\b\u0010'\u001a\u00020\u0011H\u0007J\b\u0010(\u001a\u00020\u0011H\u0002J\b\u0010)\u001a\u00020\u0011H\u0016J\b\u0010*\u001a\u00020\u0011H\u0002J\u0006\u0010+\u001a\u00020\u0011J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\u0011H\u0002J\u0010\u00100\u001a\u00020\u00112\b\u0010\u0005\u001a\u0004\u0018\u000101J\u0010\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00112\u0006\u00103\u001a\u000204H\u0002J\b\u00106\u001a\u00020\u0011H\u0002J\b\u00107\u001a\u00020\u0011H\u0007R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R$\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R$\u0010 \u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R$\u0010#\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u0017\"\u0004\b%\u0010\u0019\u00a8\u0006:"}, d2={"Lorg/jetbrains/idea/maven/navigator/MavenProjectsNavigator;", "Lorg/jetbrains/idea/maven/utils/MavenSimpleProjectComponent;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/idea/maven/navigator/MavenProjectsNavigatorState;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myState", "myTree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "structureForTests", "Lorg/jetbrains/idea/maven/navigator/structure/MavenProjectsStructure;", "myStructure", "getState", "loadState", "", "state", "value", "", "groupModules", "getGroupModules", "()Z", "setGroupModules", "(Z)V", "showIgnored", "getShowIgnored", "setShowIgnored", "showBasicPhasesOnly", "getShowBasicPhasesOnly", "setShowBasicPhasesOnly", "alwaysShowArtifactId", "getAlwaysShowArtifactId", "setAlwaysShowArtifactId", "showVersions", "getShowVersions", "setShowVersions", "initializeComponent", "initForTests", "doInit", "dispose", "listenForProjectsChanges", "initToolWindow", "initializeToolWindow", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "initTree", "selectInTree", "Lorg/jetbrains/idea/maven/project/MavenProject;", "scheduleStructureRequest", "r", "Ljava/lang/Runnable;", "doScheduleStructureRequest", "initStructure", "scheduleStructureUpdate", "MyProjectsListener", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectsNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectsNavigator.kt\norg/jetbrains/idea/maven/navigator/MavenProjectsNavigator\n+ 2 ToolWindowManager.kt\ncom/intellij/openapi/wm/ToolWindowManager\n*L\n1#1,465:1\n99#2,3:466\n*S KotlinDebug\n*F\n+ 1 MavenProjectsNavigator.kt\norg/jetbrains/idea/maven/navigator/MavenProjectsNavigator\n*L\n249#1:466,3\n*E\n"})
public final class MavenProjectsNavigator
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenProjectsNavigatorState>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MavenProjectsNavigatorState myState;
    @Nullable
    private SimpleTree myTree;
    @Nullable
    private MavenProjectsStructure myStructure;
    @NotNull
    public static final String TOOL_WINDOW_ID = "Maven";
    @NotNull
    public static final String TOOL_WINDOW_PLACE_ID = "Maven tool window";

    public MavenProjectsNavigator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myState = new MavenProjectsNavigatorState();
        MessageBus messageBus = project.getMessageBus();
        MavenDisposable mavenDisposable = MavenDisposable.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenDisposable, (String)"getInstance(...)");
        MessageBusConnection messageBusConnection = messageBus.connect((Disposable)mavenDisposable);
        Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new MavenImportListener(){

            @Override
            public void importFinished(Collection<MavenProject> importedProjects, List<Module> newModules) {
                Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
                Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
                this.scheduleStructureUpdate();
            }
        });
    }

    @TestOnly
    @Nullable
    public final MavenProjectsStructure structureForTests() {
        return this.myStructure;
    }

    @NotNull
    public MavenProjectsNavigatorState getState() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myStructure != null) {
            try {
                this.myState.treeState = new Element("root");
                SimpleTree simpleTree = this.myTree;
                Intrinsics.checkNotNull((Object)simpleTree);
                TreeState.createOn((JTree)((JTree)simpleTree)).writeExternal(this.myState.treeState);
            }
            catch (WriteExternalException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return this.myState;
    }

    public void loadState(@NotNull MavenProjectsNavigatorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.myState = state;
        this.scheduleStructureUpdate();
    }

    public final boolean getGroupModules() {
        return this.myState.groupStructurally;
    }

    public final void setGroupModules(boolean value) {
        if (this.myState.groupStructurally != value) {
            this.myState.groupStructurally = value;
            this.scheduleStructureUpdate();
        }
    }

    public final boolean getShowIgnored() {
        return this.myState.showIgnored;
    }

    public final void setShowIgnored(boolean value) {
        if (this.myState.showIgnored != value) {
            this.myState.showIgnored = value;
            this.scheduleStructureUpdate();
        }
    }

    public final boolean getShowBasicPhasesOnly() {
        return this.myState.showBasicPhasesOnly;
    }

    public final void setShowBasicPhasesOnly(boolean value) {
        if (this.myState.showBasicPhasesOnly != value) {
            this.myState.showBasicPhasesOnly = value;
            this.scheduleStructureUpdate();
        }
    }

    public final boolean getAlwaysShowArtifactId() {
        return this.myState.alwaysShowArtifactId;
    }

    public final void setAlwaysShowArtifactId(boolean value) {
        if (this.myState.alwaysShowArtifactId != value) {
            this.myState.alwaysShowArtifactId = value;
            this.scheduleStructureUpdate();
        }
    }

    public final boolean getShowVersions() {
        return this.myState.showVersions;
    }

    public final void setShowVersions(boolean value) {
        if (this.myState.showVersions != value) {
            this.myState.showVersions = value;
            this.scheduleStructureUpdate();
        }
    }

    public void initializeComponent() {
        if (this.isNormalProject()) {
            this.doInit();
        }
    }

    @TestOnly
    public final void initForTests() {
        this.doInit();
        this.initTree();
        this.initStructure();
    }

    private final void doInit() {
        MavenProjectsManager.getInstance(this.myProject).addManagerListener(new MavenProjectsManager.Listener(this){
            final /* synthetic */ MavenProjectsNavigator this$0;
            {
                this.this$0 = $receiver;
            }

            public void activated() {
                Project project = MavenProjectsNavigator.access$getMyProject$p$s-1408889646(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getMyProject$p$s-1408889646(...)");
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> doInit.1.activated$lambda$0(this.this$0));
                MavenProjectsNavigator.access$listenForProjectsChanges(this.this$0);
                this.this$0.scheduleStructureUpdate();
            }

            private static final void activated$lambda$0(MavenProjectsNavigator this$0) {
                this$0.initToolWindow();
            }
        });
    }

    public void dispose() {
    }

    private final void listenForProjectsChanges() {
        MavenProjectsManager.getInstance(this.myProject).addProjectsTreeListener(new MyProjectsListener(), this);
        MavenShortcutsManager.getInstance(this.myProject).addListener(() -> MavenProjectsNavigator.listenForProjectsChanges$lambda$0(this), this);
        MavenTasksManager.getInstance(this.myProject).addListener(new MavenTasksManager.Listener(this){
            final /* synthetic */ MavenProjectsNavigator this$0;
            {
                this.this$0 = $receiver;
            }

            public void compileTasksChanged() {
                MavenProjectsNavigator.access$scheduleStructureRequest(this.this$0, () -> listenForProjectsChanges.2.compileTasksChanged$lambda$0(this.this$0));
            }

            private static final void compileTasksChanged$lambda$0(MavenProjectsNavigator this$0) {
                MavenProjectsStructure mavenProjectsStructure = MavenProjectsNavigator.access$getMyStructure$p(this$0);
                Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
                mavenProjectsStructure.updateGoals();
            }
        }, this);
        MavenRunner.getInstance(this.myProject).getSettings().addListener(new MavenRunnerSettings.Listener(this){
            final /* synthetic */ MavenProjectsNavigator this$0;
            {
                this.this$0 = $receiver;
            }

            public void skipTestsChanged() {
                MavenProjectsNavigator.access$scheduleStructureRequest(this.this$0, () -> listenForProjectsChanges.3.skipTestsChanged$lambda$0(this.this$0));
            }

            private static final void skipTestsChanged$lambda$0(MavenProjectsNavigator this$0) {
                MavenProjectsStructure mavenProjectsStructure = MavenProjectsNavigator.access$getMyStructure$p(this$0);
                Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
                mavenProjectsStructure.updateGoals();
            }
        }, this);
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect();
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new RunManagerListener(this){
            final /* synthetic */ MavenProjectsNavigator this$0;
            {
                this.this$0 = $receiver;
            }

            public final void changed() {
                MavenProjectsNavigator.access$scheduleStructureRequest(this.this$0, () -> listenForProjectsChanges.4.changed$lambda$0(this.this$0));
            }

            public void runConfigurationAdded(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.changed();
            }

            public void runConfigurationRemoved(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.changed();
            }

            public void runConfigurationChanged(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                this.changed();
            }

            public void beforeRunTasksChanged() {
                MavenProjectsNavigator.access$scheduleStructureRequest(this.this$0, () -> listenForProjectsChanges.4.beforeRunTasksChanged$lambda$1(this.this$0));
            }

            private static final void changed$lambda$0(MavenProjectsNavigator this$0) {
                MavenProjectsStructure mavenProjectsStructure = MavenProjectsNavigator.access$getMyStructure$p(this$0);
                Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
                mavenProjectsStructure.updateRunConfigurations();
            }

            private static final void beforeRunTasksChanged$lambda$1(MavenProjectsNavigator this$0) {
                MavenProjectsStructure mavenProjectsStructure = MavenProjectsNavigator.access$getMyStructure$p(this$0);
                Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
                mavenProjectsStructure.updateGoals();
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(MavenSystemIndicesManager.TOPIC, (Object)new IndexChangeProgressListener(this){
            final /* synthetic */ MavenProjectsNavigator this$0;
            {
                this.this$0 = $receiver;
            }

            public void indexStatusChanged(MavenIndexUpdateState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                MavenProjectsNavigator.access$doScheduleStructureRequest(this.this$0, () -> listenForProjectsChanges.5.indexStatusChanged$lambda$0(this.this$0, state));
            }

            private static final void indexStatusChanged$lambda$0(MavenProjectsNavigator this$0, MavenIndexUpdateState $state) {
                MavenProjectsStructure mavenProjectsStructure = MavenProjectsNavigator.access$getMyStructure$p(this$0);
                Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
                mavenProjectsStructure.updateRepositoryStatus($state);
            }
        });
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).addProjectJdkListener(() -> MavenProjectsNavigator.listenForProjectsChanges$lambda$1(this));
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> MavenProjectsNavigator.listenForProjectsChanges$lambda$2(this));
    }

    public final void initToolWindow() {
        this.initTree();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        toolWindowManager.invokeLater(() -> MavenProjectsNavigator.initToolWindow$lambda$0(this, toolWindowManager));
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeToolWindow(ToolWindowManager toolWindowManager) {
        void this_$iv;
        RegisterToolWindowTaskBuilder b$iv;
        JPanel panel = (JPanel)((Object)new MavenProjectsNavigatorPanel(this.myProject, this.myTree));
        ActionUtil.wrap((String)"Maven.RemoveRunConfiguration").registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)this.myTree, (Disposable)this);
        ActionUtil.wrap((String)"Maven.EditRunConfiguration").registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)this.myTree, (Disposable)this);
        ToolWindowManager toolWindowManager2 = toolWindowManager;
        String id$iv = TOOL_WINDOW_ID;
        boolean $i$f$registerToolWindow = false;
        RegisterToolWindowTaskBuilder $this$initializeToolWindow_u24lambda_u240 = b$iv = new RegisterToolWindowTaskBuilder(id$iv);
        boolean bl = false;
        $this$initializeToolWindow_u24lambda_u240.icon = MavenIcons.ToolWindowMaven;
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.RIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"RIGHT");
        $this$initializeToolWindow_u24lambda_u240.anchor = toolWindowAnchor;
        $this$initializeToolWindow_u24lambda_u240.canCloseContent = false;
        $this$initializeToolWindow_u24lambda_u240.contentFactory = new ToolWindowFactory(){

            public void createToolWindowContent(Project project, ToolWindow toolWindow2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
            }
        };
        ToolWindow toolWindow2 = this_$iv.registerToolWindow(b$iv.build());
        ContentManager contentManager = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Disposer.register((Disposable)this, () -> MavenProjectsNavigator.initializeToolWindow$lambda$1(this, contentManager2, toolWindow2));
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content content = contentFactory.createContent((JComponent)panel, "", false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        contentManager2.addContent(content2);
        contentManager2.setSelectedContent(content2, false);
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)content2);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(toolWindow2, this){
            private boolean wasVisible;
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ MavenProjectsNavigator this$0;
            {
                this.$toolWindow = $toolWindow;
                this.this$0 = $receiver;
            }

            public final boolean getWasVisible() {
                return this.wasVisible;
            }

            public final void setWasVisible(boolean bl) {
                this.wasVisible = bl;
            }

            public void stateChanged(ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                if (this.$toolWindow.isDisposed()) {
                    return;
                }
                boolean visible = ((ToolWindowManagerEx)toolWindowManager).shouldUpdateToolWindowContent(this.$toolWindow);
                if (!visible || this.wasVisible) {
                    return;
                }
                this.this$0.scheduleStructureUpdate();
                this.wasVisible = true;
            }
        });
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(actionManager.getAction("Maven.GroupProjects"));
        group.add(actionManager.getAction("Maven.ShowIgnored"));
        group.add(actionManager.getAction("Maven.ShowBasicPhasesOnly"));
        group.add(actionManager.getAction("Maven.AlwaysShowArtifactId"));
        group.add(actionManager.getAction("Maven.ShowVersions"));
        toolWindow2.setAdditionalGearActions((ActionGroup)group);
        RemoteTransferUIManager.forceDirectTransfer((JComponent)panel);
    }

    private final void initTree() {
        MavenProjectsManager mavenProjectManager = MavenProjectsManager.getInstance(this.myProject);
        SimpleTree simpleTree = this.myTree = (SimpleTree)new SimpleTree(mavenProjectManager){
            private final JTextPane myPane;
            final /* synthetic */ MavenProjectsManager $mavenProjectManager;
            {
                this.$mavenProjectManager = $mavenProjectManager;
                this.myPane = new JTextPane();
                this.myPane.setOpaque(false);
                String addIconText = "'+'";
                String refreshIconText = "'Reimport'";
                Object[] objectArray = new Object[]{addIconText, refreshIconText};
                String string = MavenProjectBundle.message("maven.navigator.nothing.to.display", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                int firstEol = StringsKt.indexOf$default((CharSequence)message, (String)"\n", (int)0, (boolean)false, (int)6, null);
                int addIconMarkerIndex = StringsKt.indexOf$default((CharSequence)message, (String)addIconText, (int)0, (boolean)false, (int)6, null);
                this.myPane.replaceSelection(StringsKt.take((String)message, (int)addIconMarkerIndex));
                this.myPane.insertIcon(AllIcons.General.Add);
                int refreshIconMarkerIndex = StringsKt.indexOf$default((CharSequence)message, (String)refreshIconText, (int)0, (boolean)false, (int)6, null);
                String string2 = message.substring(addIconMarkerIndex + addIconText.length(), refreshIconMarkerIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                this.myPane.replaceSelection(string2);
                this.myPane.insertIcon(AllIcons.Actions.Refresh);
                String string3 = message.substring(refreshIconMarkerIndex + refreshIconText.length());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                this.myPane.replaceSelection(string3);
                StyledDocument document = this.myPane.getStyledDocument();
                SimpleAttributeSet centerAlignment = new SimpleAttributeSet();
                StyleConstants.setAlignment(centerAlignment, 1);
                SimpleAttributeSet justifiedAlignment = new SimpleAttributeSet();
                StyleConstants.setAlignment(justifiedAlignment, 3);
                document.setParagraphAttributes(0, firstEol, centerAlignment, false);
                document.setParagraphAttributes(firstEol + 2, document.getLength(), justifiedAlignment, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                if (this.$mavenProjectManager.hasProjects()) {
                    return;
                }
                this.myPane.setFont(this.getFont());
                this.myPane.setBackground(this.getBackground());
                this.myPane.setForeground(this.getForeground());
                Rectangle bounds = this.getBounds();
                this.myPane.setBounds(0, 0, bounds.width - 10, bounds.height);
                Graphics g2 = g.create(bounds.x + 10, bounds.y + 20, bounds.width, bounds.height);
                try {
                    this.myPane.paint(g2);
                }
                finally {
                    g2.dispose();
                }
            }
        };
        Intrinsics.checkNotNull((Object)simpleTree);
        simpleTree.getEmptyText().clear();
        SimpleTree simpleTree2 = this.myTree;
        Intrinsics.checkNotNull((Object)simpleTree2);
        simpleTree2.getSelectionModel().setSelectionMode(4);
    }

    public final void selectInTree(@Nullable MavenProject project) {
        this.scheduleStructureRequest(() -> MavenProjectsNavigator.selectInTree$lambda$0(this, project));
    }

    private final void scheduleStructureRequest(Runnable r) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myStructure != null) {
                r.run();
            }
        } else {
            this.doScheduleStructureRequest(r);
        }
    }

    private final void doScheduleStructureRequest(Runnable r) {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ToolWindow toolWindow2 = ToolWindowManager.Companion.getInstance(project).getToolWindow(TOOL_WINDOW_ID);
        if (toolWindow2 == null) {
            return;
        }
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        MavenUtil.invokeLater(project2, () -> MavenProjectsNavigator.doScheduleStructureRequest$lambda$0(this, toolWindow2, r));
    }

    private final void initStructure() {
        this.myStructure = new MavenProjectsStructure(this.myProject, MavenProjectsStructure.MavenStructureDisplayMode.SHOW_ALL, MavenProjectsManager.getInstance(this.myProject), MavenTasksManager.getInstance(this.myProject), MavenShortcutsManager.getInstance(this.myProject), this, this.myTree);
    }

    @ApiStatus.Internal
    public final void scheduleStructureUpdate() {
        this.scheduleStructureRequest(() -> MavenProjectsNavigator.scheduleStructureUpdate$lambda$0(this));
    }

    private static final void listenForProjectsChanges$lambda$0$0(MavenProjectsNavigator this$0) {
        MavenProjectsStructure mavenProjectsStructure = this$0.myStructure;
        Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
        mavenProjectsStructure.updateGoals();
    }

    private static final void listenForProjectsChanges$lambda$2$0(MavenProjectsNavigator this$0) {
        Project project = this$0.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        MavenEelUtil.checkJdkAndShowNotification(project);
    }

    private static final void listenForProjectsChanges$lambda$0(MavenProjectsNavigator this$0) {
        this$0.scheduleStructureRequest(() -> MavenProjectsNavigator.listenForProjectsChanges$lambda$0$0(this$0));
    }

    private static final void listenForProjectsChanges$lambda$1(MavenProjectsNavigator this$0) {
        Project project = this$0.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        MavenEelUtil.checkJdkAndShowNotification(project);
        Project project2 = this$0.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        MavenEelUtil.restartMavenConnectorsIfJdkIncorrect(project2);
    }

    private static final void listenForProjectsChanges$lambda$2(MavenProjectsNavigator this$0) {
        Project project = this$0.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        DumbService.Companion.getInstance(project).runWhenSmart(() -> MavenProjectsNavigator.listenForProjectsChanges$lambda$2$0(this$0));
    }

    private static final void initToolWindow$lambda$0(MavenProjectsNavigator this$0, ToolWindowManager $toolWindowManager) {
        this$0.initializeToolWindow($toolWindowManager);
    }

    private static final void initializeToolWindow$lambda$1(MavenProjectsNavigator this$0, ContentManager $contentManager, ToolWindow $toolWindow) {
        if (!this$0.myProject.isDisposed()) {
            $contentManager.removeAllContents(true);
        }
        Disposer.dispose((Disposable)((Disposable)$contentManager));
        if (!this$0.myProject.isDisposed()) {
            $toolWindow.remove();
        }
    }

    private static final void selectInTree$lambda$0(MavenProjectsNavigator this$0, MavenProject $project) {
        MavenProjectsStructure mavenProjectsStructure = this$0.myStructure;
        Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
        mavenProjectsStructure.select($project);
    }

    private static final void doScheduleStructureRequest$lambda$0(MavenProjectsNavigator this$0, ToolWindow $toolWindow, Runnable $r) {
        boolean shouldCreate;
        boolean hasMavenProjects;
        List<String> files2 = MavenProjectsManager.getInstance((Project)this$0.myProject).getState().originalFiles;
        boolean bl = hasMavenProjects = files2 != null && !files2.isEmpty();
        if ($toolWindow.isAvailable() != hasMavenProjects) {
            MavenLog.LOG.info("Set MavenToolWindow availability: " + hasMavenProjects);
            $toolWindow.setAvailable(hasMavenProjects);
            if (hasMavenProjects && this$0.myProject.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == null) {
                $toolWindow.activate(null);
            }
        }
        boolean bl2 = shouldCreate = this$0.myStructure == null;
        if (shouldCreate) {
            this$0.initStructure();
        }
        $r.run();
        if (shouldCreate) {
            TreeState treeState = TreeState.createFrom((Element)this$0.myState.treeState);
            SimpleTree simpleTree = this$0.myTree;
            Intrinsics.checkNotNull((Object)simpleTree);
            treeState.applyTo((JTree)simpleTree);
        }
    }

    private static final void scheduleStructureUpdate$lambda$0(MavenProjectsNavigator this$0) {
        MavenProjectsStructure mavenProjectsStructure = this$0.myStructure;
        Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
        mavenProjectsStructure.update();
    }

    @JvmStatic
    @NotNull
    public static final MavenProjectsNavigator getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getMyProject$p$s-1408889646(MavenProjectsNavigator $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ void access$listenForProjectsChanges(MavenProjectsNavigator $this) {
        $this.listenForProjectsChanges();
    }

    public static final /* synthetic */ void access$doScheduleStructureRequest(MavenProjectsNavigator $this, Runnable r) {
        $this.doScheduleStructureRequest(r);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/navigator/MavenProjectsNavigator$Companion;", "", "<init>", "()V", "TOOL_WINDOW_ID", "", "TOOL_WINDOW_PLACE_ID", "getInstance", "Lorg/jetbrains/idea/maven/navigator/MavenProjectsNavigator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MavenProjectsNavigator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(MavenProjectsNavigator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (MavenProjectsNavigator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J0\u0010\r\u001a\u00020\u00052\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u001c\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\bH\u0016J\"\u0010\u0016\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/navigator/MavenProjectsNavigator$MyProjectsListener;", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree$Listener;", "<init>", "(Lorg/jetbrains/idea/maven/navigator/MavenProjectsNavigator;)V", "projectsIgnoredStateChanged", "", "ignored", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "unignored", "fromImport", "", "profilesChanged", "projectsUpdated", "updated", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "deleted", "projectResolved", "projectWithChanges", "pluginsResolved", "project", "scheduleUpdateProjects", "projects", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenProjectsNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectsNavigator.kt\norg/jetbrains/idea/maven/navigator/MavenProjectsNavigator$MyProjectsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,465:1\n1586#2:466\n1661#2,3:467\n*S KotlinDebug\n*F\n+ 1 MavenProjectsNavigator.kt\norg/jetbrains/idea/maven/navigator/MavenProjectsNavigator$MyProjectsListener\n*L\n439#1:466\n439#1:467,3\n*E\n"})
    private final class MyProjectsListener
    implements MavenProjectsTree.Listener {
        @Override
        public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
            Intrinsics.checkNotNullParameter(ignored, (String)"ignored");
            Intrinsics.checkNotNullParameter(unignored, (String)"unignored");
            MavenProjectsNavigator.this.scheduleStructureRequest(() -> MyProjectsListener.projectsIgnoredStateChanged$lambda$0(MavenProjectsNavigator.this, ignored, unignored));
        }

        @Override
        public void profilesChanged() {
            MavenProjectsNavigator.this.scheduleStructureRequest(() -> MyProjectsListener.profilesChanged$lambda$0(MavenProjectsNavigator.this));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void projectsUpdated(@NotNull List<? extends Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(updated, (String)"updated");
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            Iterable iterable = updated;
            MyProjectsListener myProjectsListener = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((MavenProject)it.first);
            }
            myProjectsListener.scheduleUpdateProjects((List)destination$iv$iv, new ArrayList(deleted));
        }

        @Override
        public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
            Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
            this.scheduleUpdateProjects(CollectionsKt.listOf((Object)projectWithChanges.first), CollectionsKt.emptyList());
        }

        @Override
        public void pluginsResolved(@NotNull MavenProject project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.scheduleUpdateProjects(CollectionsKt.listOf((Object)project), CollectionsKt.emptyList());
        }

        public final void scheduleUpdateProjects(@NotNull List<MavenProject> projects2, @NotNull List<MavenProject> deleted) {
            Intrinsics.checkNotNullParameter(projects2, (String)"projects");
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            MavenProjectsNavigator.this.scheduleStructureRequest(() -> MyProjectsListener.scheduleUpdateProjects$lambda$0(MavenProjectsNavigator.this, projects2, deleted));
        }

        private static final void projectsIgnoredStateChanged$lambda$0(MavenProjectsNavigator this$0, List $ignored, List $unignored) {
            MavenProjectsStructure mavenProjectsStructure = this$0.myStructure;
            Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
            mavenProjectsStructure.updateIgnored(ContainerUtil.concat((List)$ignored, (List)$unignored));
        }

        private static final void profilesChanged$lambda$0(MavenProjectsNavigator this$0) {
            MavenProjectsStructure mavenProjectsStructure = this$0.myStructure;
            Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
            mavenProjectsStructure.updateProfiles();
        }

        private static final void scheduleUpdateProjects$lambda$0(MavenProjectsNavigator this$0, List $projects, List $deleted) {
            MavenProjectsStructure mavenProjectsStructure = this$0.myStructure;
            Intrinsics.checkNotNull((Object)((Object)mavenProjectsStructure));
            mavenProjectsStructure.updateProjects($projects, $deleted);
        }
    }
}

