/*
 * Decompiled with CFR 0.152.
 */
package git4idea.inMemory.rebase.log;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.inMemory.GitObjectRepository;
import git4idea.inMemory.GitObjectRepositoryExtensionsKt;
import git4idea.inMemory.objects.GitObject;
import git4idea.inMemory.objects.Oid;
import git4idea.inMemory.objects.OidKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000 32\u00020\u0001:\u000223B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000bH\u00a4@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0082@\u00a2\u0006\u0002\u0010*J\u0010\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0002J\u0012\u00100\u001a\u00020&2\b\b\u0002\u00101\u001a\u00020#H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u000eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010+\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0011\u00a8\u00064"}, d2={"Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation;", "", "objectRepo", "Lgit4idea/inMemory/GitObjectRepository;", "baseCommitMetadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "<init>", "(Lgit4idea/inMemory/GitObjectRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;)V", "getObjectRepo", "()Lgit4idea/inMemory/GitObjectRepository;", "editCommits", "Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation$CommitEditingResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "getOperationName", "()Ljava/lang/String;", "failureTitle", "Lorg/jetbrains/annotations/NonNls;", "getFailureTitle", "initialHeadPosition", "getInitialHeadPosition", "setInitialHeadPosition", "(Ljava/lang/String;)V", "baseToHeadCommitsRange", "", "Lgit4idea/inMemory/objects/GitObject$Commit;", "getBaseToHeadCommitsRange", "()Ljava/util/List;", "baseToHeadCommitsRange$delegate", "Lkotlin/Lazy;", "execute", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "showFailureNotification", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateRefToNewHead", "", "newHead", "Lgit4idea/inMemory/objects/Oid;", "resetToNewHead", "(Lgit4idea/inMemory/objects/Oid;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fullReflogMessage", "getFullReflogMessage", "notifyOperationFailed", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "assertCurrentRevMatchesInitialHead", "performUpdate", "CommitEditingResult", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitInMemoryCommitEditingOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitInMemoryCommitEditingOperation.kt\ngit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n13#2:133\n*S KotlinDebug\n*F\n+ 1 GitInMemoryCommitEditingOperation.kt\ngit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation\n*L\n130#1:133\n*E\n"})
public abstract class GitInMemoryCommitEditingOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitObjectRepository objectRepo;
    @NotNull
    private final VcsCommitMetadata baseCommitMetadata;
    protected String initialHeadPosition;
    @NotNull
    private final Lazy baseToHeadCommitsRange$delegate;
    @NonNls
    @NotNull
    private static final String REFLOG_MESSAGE_SUFFIX = "by " + ApplicationNamesInfo.getInstance().getFullProductName() + " Git plugin";
    @NotNull
    private static final Logger LOG;

    public GitInMemoryCommitEditingOperation(@NotNull GitObjectRepository objectRepo, @NotNull VcsCommitMetadata baseCommitMetadata) {
        Intrinsics.checkNotNullParameter((Object)objectRepo, (String)"objectRepo");
        Intrinsics.checkNotNullParameter((Object)baseCommitMetadata, (String)"baseCommitMetadata");
        this.objectRepo = objectRepo;
        this.baseCommitMetadata = baseCommitMetadata;
        this.baseToHeadCommitsRange$delegate = LazyKt.lazy(() -> GitInMemoryCommitEditingOperation.baseToHeadCommitsRange_delegate$lambda$0(this));
    }

    @NotNull
    protected final GitObjectRepository getObjectRepo() {
        return this.objectRepo;
    }

    @Nullable
    protected abstract Object editCommits(@NotNull Continuation<? super CommitEditingResult> var1);

    @NotNull
    protected abstract String getOperationName();

    @NotNull
    protected abstract String getFailureTitle();

    @NotNull
    protected final String getInitialHeadPosition() {
        String string = this.initialHeadPosition;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"initialHeadPosition");
        return null;
    }

    protected final void setInitialHeadPosition(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.initialHeadPosition = string;
    }

    @NotNull
    protected final List<GitObject.Commit> getBaseToHeadCommitsRange() {
        Lazy lazy = this.baseToHeadCommitsRange$delegate;
        return (List)lazy.getValue();
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object execute(boolean showFailureNotification, @NotNull Continuation<? super GitCommitEditingOperationResult> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 6[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static /* synthetic */ Object execute$default(GitInMemoryCommitEditingOperation gitInMemoryCommitEditingOperation, boolean bl, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: execute");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return gitInMemoryCommitEditingOperation.execute(bl, (Continuation<? super GitCommitEditingOperationResult>)continuation);
    }

    private final void updateRefToNewHead(Oid newHead) {
        GitUtil.updateHeadReference(this.objectRepo.getRepository(), OidKt.toHash(newHead), this.getFullReflogMessage());
    }

    private final Object resetToNewHead(Oid newHead, Continuation<? super Unit> $completion) {
        String string = this.objectRepo.getRepository().getCurrentBranchName();
        if (string == null) {
            string = newHead.hex();
        }
        String destinationName = string;
        return GitPreservingProcess.Companion.runWithPreservedLocalChanges(this.objectRepo.getRepository(), this.getOperationName(), destinationName, () -> GitInMemoryCommitEditingOperation.resetToNewHead$lambda$0(this, newHead), $completion);
    }

    private final String getFullReflogMessage() {
        return this.getOperationName() + " " + REFLOG_MESSAGE_SUFFIX;
    }

    private final void notifyOperationFailed(VcsException exception) {
        VcsNotifier.getInstance((Project)this.objectRepo.getRepository().getProject()).notifyError("git.in.memory.operation.failed", this.getFailureTitle(), exception.getMessage());
    }

    protected final void assertCurrentRevMatchesInitialHead(boolean performUpdate) {
        if (performUpdate) {
            this.objectRepo.getRepository().update();
        }
        String string = this.objectRepo.getRepository().getCurrentRevision();
        Intrinsics.checkNotNull((Object)string);
        if (!Intrinsics.areEqual((Object)string, (Object)this.getInitialHeadPosition())) {
            throw new VcsException(GitBundle.message("in.memory.rebase.fail.head.move", new Object[0]));
        }
    }

    public static /* synthetic */ void assertCurrentRevMatchesInitialHead$default(GitInMemoryCommitEditingOperation gitInMemoryCommitEditingOperation, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertCurrentRevMatchesInitialHead");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        gitInMemoryCommitEditingOperation.assertCurrentRevMatchesInitialHead(bl);
    }

    private static final List baseToHeadCommitsRange_delegate$lambda$0(GitInMemoryCommitEditingOperation this$0) {
        GitObjectRepository gitObjectRepository = this$0.objectRepo;
        String string = ((Hash)this$0.baseCommitMetadata.getId()).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return GitObjectRepositoryExtensionsKt.findCommitsRange(gitObjectRepository, string, this$0.getInitialHeadPosition());
    }

    private static final Unit resetToNewHead$lambda$0(GitInMemoryCommitEditingOperation this$0, Oid $newHead) {
        Git.getInstance().reset(this$0.objectRepo.getRepository(), GitResetMode.KEEP, $newHead.hex(), this$0.getFullReflogMessage(), new GitLineHandlerListener[0]).throwOnError(new int[0]);
        GitUtil.refreshChangedVfs(this$0.objectRepo.getRepository(), HashImpl.build((String)this$0.getInitialHeadPosition()));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$resetToNewHead(GitInMemoryCommitEditingOperation $this, Oid newHead, Continuation $completion) {
        return $this.resetToNewHead(newHead, (Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitInMemoryCommitEditingOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J5\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation$CommitEditingResult;", "", "newHead", "Lgit4idea/inMemory/objects/Oid;", "requiresWorkingTreeUpdate", "", "commitToFocus", "commitToFocusOnUndo", "<init>", "(Lgit4idea/inMemory/objects/Oid;ZLgit4idea/inMemory/objects/Oid;Lgit4idea/inMemory/objects/Oid;)V", "getNewHead", "()Lgit4idea/inMemory/objects/Oid;", "getRequiresWorkingTreeUpdate", "()Z", "getCommitToFocus", "getCommitToFocusOnUndo", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    protected static final class CommitEditingResult {
        @NotNull
        private final Oid newHead;
        private final boolean requiresWorkingTreeUpdate;
        @Nullable
        private final Oid commitToFocus;
        @Nullable
        private final Oid commitToFocusOnUndo;

        public CommitEditingResult(@NotNull Oid newHead, boolean requiresWorkingTreeUpdate, @Nullable Oid commitToFocus, @Nullable Oid commitToFocusOnUndo) {
            Intrinsics.checkNotNullParameter((Object)newHead, (String)"newHead");
            this.newHead = newHead;
            this.requiresWorkingTreeUpdate = requiresWorkingTreeUpdate;
            this.commitToFocus = commitToFocus;
            this.commitToFocusOnUndo = commitToFocusOnUndo;
        }

        public /* synthetic */ CommitEditingResult(Oid oid, boolean bl, Oid oid2, Oid oid3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                oid2 = null;
            }
            if ((n & 8) != 0) {
                oid3 = null;
            }
            this(oid, bl, oid2, oid3);
        }

        @NotNull
        public final Oid getNewHead() {
            return this.newHead;
        }

        public final boolean getRequiresWorkingTreeUpdate() {
            return this.requiresWorkingTreeUpdate;
        }

        @Nullable
        public final Oid getCommitToFocus() {
            return this.commitToFocus;
        }

        @Nullable
        public final Oid getCommitToFocusOnUndo() {
            return this.commitToFocusOnUndo;
        }

        @NotNull
        public final Oid component1() {
            return this.newHead;
        }

        public final boolean component2() {
            return this.requiresWorkingTreeUpdate;
        }

        @Nullable
        public final Oid component3() {
            return this.commitToFocus;
        }

        @Nullable
        public final Oid component4() {
            return this.commitToFocusOnUndo;
        }

        @NotNull
        public final CommitEditingResult copy(@NotNull Oid newHead, boolean requiresWorkingTreeUpdate, @Nullable Oid commitToFocus, @Nullable Oid commitToFocusOnUndo) {
            Intrinsics.checkNotNullParameter((Object)newHead, (String)"newHead");
            return new CommitEditingResult(newHead, requiresWorkingTreeUpdate, commitToFocus, commitToFocusOnUndo);
        }

        public static /* synthetic */ CommitEditingResult copy$default(CommitEditingResult commitEditingResult, Oid oid, boolean bl, Oid oid2, Oid oid3, int n, Object object) {
            if ((n & 1) != 0) {
                oid = commitEditingResult.newHead;
            }
            if ((n & 2) != 0) {
                bl = commitEditingResult.requiresWorkingTreeUpdate;
            }
            if ((n & 4) != 0) {
                oid2 = commitEditingResult.commitToFocus;
            }
            if ((n & 8) != 0) {
                oid3 = commitEditingResult.commitToFocusOnUndo;
            }
            return commitEditingResult.copy(oid, bl, oid2, oid3);
        }

        @NotNull
        public String toString() {
            return "CommitEditingResult(newHead=" + this.newHead + ", requiresWorkingTreeUpdate=" + this.requiresWorkingTreeUpdate + ", commitToFocus=" + this.commitToFocus + ", commitToFocusOnUndo=" + this.commitToFocusOnUndo + ")";
        }

        public int hashCode() {
            int result2 = this.newHead.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.requiresWorkingTreeUpdate);
            result2 = result2 * 31 + (this.commitToFocus == null ? 0 : this.commitToFocus.hashCode());
            result2 = result2 * 31 + (this.commitToFocusOnUndo == null ? 0 : this.commitToFocusOnUndo.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitEditingResult)) {
                return false;
            }
            CommitEditingResult commitEditingResult = (CommitEditingResult)other;
            if (!Intrinsics.areEqual((Object)this.newHead, (Object)commitEditingResult.newHead)) {
                return false;
            }
            if (this.requiresWorkingTreeUpdate != commitEditingResult.requiresWorkingTreeUpdate) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.commitToFocus, (Object)commitEditingResult.commitToFocus)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.commitToFocusOnUndo, (Object)commitEditingResult.commitToFocusOnUndo);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation$Companion;", "", "<init>", "()V", "REFLOG_MESSAGE_SUFFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

