/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import git4idea.repo.GitConfigHelperKt;
import git4idea.repo.GitSubmoduleInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/repo/GitModulesFileReader;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MODULE_SECTION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "read", "", "Lgit4idea/repo/GitSubmoduleInfo;", "file", "Ljava/nio/file/Path;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitModulesFileReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitModulesFileReader.kt\ngit4idea/repo/GitModulesFileReader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,58:1\n13#2:59\n*S KotlinDebug\n*F\n+ 1 GitModulesFileReader.kt\ngit4idea/repo/GitModulesFileReader\n*L\n26#1:59\n*E\n"})
public final class GitModulesFileReader {
    @NotNull
    private final Logger LOG;
    private final Pattern MODULE_SECTION;

    public GitModulesFileReader() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitModulesFileReader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.MODULE_SECTION = Pattern.compile("submodule \"(.*)\"", 2);
    }

    @NotNull
    public final Collection<GitSubmoduleInfo> read(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Ini ini = null;
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                return CollectionsKt.emptyList();
            }
            ini = GitConfigHelperKt.loadIniFile(file);
        }
        catch (IOException e) {
            return CollectionsKt.emptyList();
        }
        Set modules = new LinkedHashSet();
        for (Map.Entry entry : ((Map)ini).entrySet()) {
            String sectionName = (String)entry.getKey();
            Profile.Section section = (Profile.Section)entry.getValue();
            Matcher matcher = this.MODULE_SECTION.matcher(sectionName);
            if (!matcher.matches() || matcher.groupCount() != 1) continue;
            String path = (String)section.get((Object)"path");
            String url = (String)section.get((Object)"url");
            if (path == null || url == null) {
                this.LOG.warn("Partially defined submodule: " + section);
                continue;
            }
            GitSubmoduleInfo module = new GitSubmoduleInfo(path, url);
            this.LOG.debug("Found submodule " + module);
            modules.add(module);
        }
        return modules;
    }
}

