/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.proxy;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/proxy/InetAddresses;", "", "<init>", "()V", "loopback", "", "Ljava/net/InetAddress;", "getLoopback", "()Ljava/util/List;", "remote", "getRemote", "analyzeNetworkInterfaces", "", "analyzeNetworkInterface", "networkInterface", "Ljava/net/NetworkInterface;", "Companion", "intellij.gradle.toolingProxy"})
public final class InetAddresses {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<InetAddress> loopback = new ArrayList();
    @NotNull
    private final List<InetAddress> remote = new ArrayList();
    private static final Logger logger = LoggerFactory.getLogger(InetAddresses.class);
    private static final int REACHABLE_TIMEOUT_MS = 50;

    public InetAddresses() {
        this.analyzeNetworkInterfaces();
    }

    @NotNull
    public final List<InetAddress> getLoopback() {
        return this.loopback;
    }

    @NotNull
    public final List<InetAddress> getRemote() {
        return this.remote;
    }

    private final void analyzeNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Intrinsics.checkNotNull((Object)networkInterface, (String)"null cannot be cast to non-null type java.net.NetworkInterface");
                this.analyzeNetworkInterface(networkInterface);
            }
        }
    }

    private final void analyzeNetworkInterface(NetworkInterface networkInterface) {
        logger.debug("Adding IP addresses for network interface {}", (Object)networkInterface.getDisplayName());
        try {
            boolean isLoopbackInterface = networkInterface.isLoopback();
            logger.debug("Is this a loopback interface? {}", (Object)isLoopbackInterface);
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getInetAddresses(...)");
            Enumeration<InetAddress> candidates = enumeration;
            while (candidates.hasMoreElements()) {
                InetAddress candidate;
                Intrinsics.checkNotNull((Object)candidates.nextElement(), (String)"null cannot be cast to non-null type java.net.InetAddress");
                if (isLoopbackInterface) {
                    if (candidate.isLoopbackAddress()) {
                        if (candidate.isReachable(50)) {
                            logger.debug("Adding loopback address {}", (Object)candidate);
                            this.loopback.add(candidate);
                            continue;
                        }
                        logger.debug("Ignoring unreachable local address on loopback interface {}", (Object)candidate);
                        continue;
                    }
                    logger.debug("Ignoring remote address on loopback interface {}", (Object)candidate);
                    continue;
                }
                if (candidate.isLoopbackAddress()) {
                    logger.debug("Ignoring loopback address on remote interface {}", (Object)candidate);
                    continue;
                }
                logger.debug("Adding remote address {}", (Object)candidate);
                this.remote.add(candidate);
            }
        }
        catch (SocketException e) {
            logger.debug("Error while querying interface {} for IP addresses", (Object)networkInterface, (Object)e);
        }
        catch (Throwable t) {
            String string = "Could not determine the IP addresses for network interface %s";
            Object[] objectArray = new Object[]{networkInterface.getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new RuntimeException(string2, t);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/proxy/InetAddresses$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "REACHABLE_TIMEOUT_MS", "", "intellij.gradle.toolingProxy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

