/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util.cmd.node;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineParser;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineTokenizer;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineNode;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOptions;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTasks;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine;", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineNode;", "tasks", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTasks;", "options", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOptions;", "<init>", "(Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTasks;Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOptions;)V", "", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTask;", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption;", "(Ljava/util/List;Ljava/util/List;)V", "getTasks", "()Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineTasks;", "getOptions", "()Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOptions;", "tokens", "", "getTokens", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.gradle"})
@ApiStatus.Experimental
public final class GradleCommandLine
implements GradleCommandLineNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleCommandLineTasks tasks;
    @NotNull
    private final GradleCommandLineOptions options;
    @NotNull
    private final List<String> tokens;

    public GradleCommandLine(@NotNull GradleCommandLineTasks tasks2, @NotNull GradleCommandLineOptions options) {
        Intrinsics.checkNotNullParameter((Object)tasks2, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.tasks = tasks2;
        this.options = options;
        this.tokens = CollectionsKt.plus((Collection)this.tasks.getTokens(), (Iterable)this.options.getTokens());
    }

    @NotNull
    public final GradleCommandLineTasks getTasks() {
        return this.tasks;
    }

    @NotNull
    public final GradleCommandLineOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public List<String> getTokens() {
        return this.tokens;
    }

    public GradleCommandLine(@NotNull List<GradleCommandLineTask> tasks2, @NotNull List<? extends GradleCommandLineOption> options) {
        Intrinsics.checkNotNullParameter(tasks2, (String)"tasks");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this(new GradleCommandLineTasks(tasks2), new GradleCommandLineOptions(options));
    }

    @NotNull
    public final GradleCommandLineTasks component1() {
        return this.tasks;
    }

    @NotNull
    public final GradleCommandLineOptions component2() {
        return this.options;
    }

    @NotNull
    public final GradleCommandLine copy(@NotNull GradleCommandLineTasks tasks2, @NotNull GradleCommandLineOptions options) {
        Intrinsics.checkNotNullParameter((Object)tasks2, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return new GradleCommandLine(tasks2, options);
    }

    public static /* synthetic */ GradleCommandLine copy$default(GradleCommandLine gradleCommandLine, GradleCommandLineTasks gradleCommandLineTasks, GradleCommandLineOptions gradleCommandLineOptions, int n, Object object) {
        if ((n & 1) != 0) {
            gradleCommandLineTasks = gradleCommandLine.tasks;
        }
        if ((n & 2) != 0) {
            gradleCommandLineOptions = gradleCommandLine.options;
        }
        return gradleCommandLine.copy(gradleCommandLineTasks, gradleCommandLineOptions);
    }

    @NotNull
    public String toString() {
        return "GradleCommandLine(tasks=" + this.tasks + ", options=" + this.options + ")";
    }

    public int hashCode() {
        int result = this.tasks.hashCode();
        result = result * 31 + this.options.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GradleCommandLine)) {
            return false;
        }
        GradleCommandLine gradleCommandLine = (GradleCommandLine)other;
        if (!Intrinsics.areEqual((Object)this.tasks, (Object)gradleCommandLine.tasks)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.options, (Object)gradleCommandLine.options);
    }

    @JvmStatic
    @NotNull
    public static final GradleCommandLine parse(@NotNull String commandLine) {
        return Companion.parse(commandLine);
    }

    @JvmStatic
    @NotNull
    public static final GradleCommandLine parse(@NotNull List<String> commandLine) {
        return Companion.parse(commandLine);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine$Companion;", "", "<init>", "()V", "parse", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLine;", "commandLine", "", "", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleCommandLine parse(@NotNull String commandLine) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            return new GradleCommandLineParser(new GradleCommandLineTokenizer(commandLine)).parse();
        }

        @JvmStatic
        @NotNull
        public final GradleCommandLine parse(@NotNull List<String> commandLine) {
            Intrinsics.checkNotNullParameter(commandLine, (String)"commandLine");
            return new GradleCommandLineParser(new GradleCommandLineTokenizer(commandLine)).parse();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

