/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck.suggestion;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grazie/spellcheck/suggestion/SpellcheckingNameSuggestionProvider;", "Lcom/intellij/refactoring/rename/NameSuggestionProvider;", "<init>", "()V", "minimalWordLength", "", "getSuggestedNames", "Lcom/intellij/psi/codeStyle/SuggestedNameInfo;", "element", "Lcom/intellij/psi/PsiElement;", "context", "result", "", "", "getName", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nSpellcheckingNameSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellcheckingNameSuggestionProvider.kt\ncom/intellij/grazie/spellcheck/suggestion/SpellcheckingNameSuggestionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n777#2:36\n873#2,2:37\n*S KotlinDebug\n*F\n+ 1 SpellcheckingNameSuggestionProvider.kt\ncom/intellij/grazie/spellcheck/suggestion/SpellcheckingNameSuggestionProvider\n*L\n26#1:36\n26#1:37,2\n*E\n"})
public final class SpellcheckingNameSuggestionProvider
implements NameSuggestionProvider {
    private final int minimalWordLength;

    public SpellcheckingNameSuggestionProvider() {
        this.minimalWordLength = 4;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SuggestedNameInfo getSuggestedNames(@NotNull PsiElement element, @Nullable PsiElement context, @NotNull Set<String> result) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (!Registry.Companion.is("spellchecker.suggestion.provider.enabled")) {
            return null;
        }
        String string = this.getName(element);
        if (string == null) {
            return null;
        }
        String name = string;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"IntellijIdeaRulezzz", (boolean)false, (int)2, null) || name.length() < this.minimalWordLength) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SpellCheckerManager manager = SpellCheckerManager.Companion.getInstance(project);
        if (!manager.hasProblem(name)) {
            return null;
        }
        Iterable iterable = manager.getSuggestions(name);
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!RenameUtil.isValidName((Project)element.getProject(), (PsiElement)element, (String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suggestions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (suggestions.isEmpty()) {
            return null;
        }
        result.addAll(suggestions);
        return SuggestedNameInfo.NULL_INFO;
    }

    private final String getName(PsiElement element) {
        return element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
    }
}

