/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.injection.Injectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.references.LanguageInjectionUtil;
import org.intellij.plugins.intelliLang.references.LanguageSymbol;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/intelliLang/references/LanguageReferenceContributor;", "Lcom/intellij/model/psi/PsiSymbolReferenceProvider;", "<init>", "()V", "getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "hints", "Lcom/intellij/model/psi/PsiSymbolReferenceHints;", "getSearchRequests", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/model/Symbol;", "intellij.platform.langInjection.backend"})
@SourceDebugExtension(value={"SMAP\nLanguageReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageReferenceContributor.kt\norg/intellij/plugins/intelliLang/references/LanguageReferenceContributor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n18#2:69\n18#2:70\n1#3:71\n*S KotlinDebug\n*F\n+ 1 LanguageReferenceContributor.kt\norg/intellij/plugins/intelliLang/references/LanguageReferenceContributor\n*L\n25#1:69\n43#1:70\n*E\n"})
public final class LanguageReferenceContributor
implements PsiSymbolReferenceProvider {
    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        PsiExternalReferenceHost $this$asSafely$iv = element;
        boolean $i$f$asSafely = false;
        PsiExternalReferenceHost psiExternalReferenceHost = $this$asSafely$iv;
        if (!(psiExternalReferenceHost instanceof PsiComment)) {
            psiExternalReferenceHost = null;
        }
        PsiComment psiComment = (PsiComment)psiExternalReferenceHost;
        if (psiComment == null) {
            return CollectionsKt.emptyList();
        }
        PsiComment psiComment2 = psiComment;
        TextRange textRange = LanguageInjectionUtil.INSTANCE.languageRange(psiComment2);
        if (textRange == null) {
            return CollectionsKt.emptyList();
        }
        TextRange languageRange = textRange;
        return CollectionsKt.listOf((Object)new PsiCompletableReference(element, languageRange){
            final /* synthetic */ PsiExternalReferenceHost $element;
            final /* synthetic */ TextRange $languageRange;
            {
                this.$element = $element;
                this.$languageRange = $languageRange;
            }

            /*
             * WARNING - void declaration
             */
            public Collection<LookupElement> getCompletionVariants() {
                void $this$mapTo$iv$iv;
                List<Injectable> list = InjectLanguageAction.getAllInjectables();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAllInjectables(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Injectable injectable = (Injectable)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    collection.add(LookupElementBuilder.create((String)string2).withIcon(it.getIcon()).withTailText("(" + it.getDisplayName() + ")", true));
                }
                return (List)destination$iv$iv;
            }

            public PsiElement getElement() {
                return (PsiElement)this.$element;
            }

            public TextRange getRangeInElement() {
                return this.$languageRange;
            }

            public Collection<Symbol> resolveReference() {
                String string = this.getRangeInElement().substring(this.getElement().getText());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return CollectionsKt.listOf((Object)new LanguageSymbol(string));
            }
        });
    }

    @NotNull
    public Collection<SearchRequest> getSearchRequests(@NotNull Project project, @NotNull Symbol target) {
        SearchRequest searchRequest;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Symbol $this$asSafely$iv = target;
        boolean $i$f$asSafely = false;
        Symbol symbol = $this$asSafely$iv;
        if (!(symbol instanceof LanguageSymbol)) {
            symbol = null;
        }
        LanguageSymbol languageSymbol = (LanguageSymbol)symbol;
        if (languageSymbol != null) {
            LanguageSymbol it = languageSymbol;
            boolean bl = false;
            searchRequest = SearchRequest.of((String)it.getName());
        } else {
            searchRequest = null;
        }
        return CollectionsKt.listOfNotNull(searchRequest);
    }
}

