/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReferenceBase;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\t0\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrUnaryOperatorReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCallReferenceBase;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrUnaryExpression;", "element", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrUnaryExpression;)V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "receiverArgument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "getReceiverArgument", "()Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getArguments", "()Ljava/util/List;", "Companion", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGrUnaryOperatorReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrUnaryOperatorReference.kt\norg/jetbrains/plugins/groovy/lang/resolve/references/GrUnaryOperatorReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class GrUnaryOperatorReference
extends GroovyMethodCallReferenceBase<GrUnaryExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<IElementType, String> unaryOperatorMethodNames;

    public GrUnaryOperatorReference(@NotNull GrUnaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((GrUnaryExpression)this.getElement()).getOperationToken().getTextRangeInParent();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
        return textRange;
    }

    @Override
    @Nullable
    public Argument getReceiverArgument() {
        ExpressionArgument expressionArgument;
        GrExpression grExpression = ((GrUnaryExpression)this.getElement()).getOperand();
        if (grExpression != null) {
            GrExpression p0 = grExpression;
            boolean bl = false;
            expressionArgument = new ExpressionArgument(p0);
        } else {
            expressionArgument = null;
        }
        return expressionArgument;
    }

    @Override
    @NotNull
    public String getMethodName() {
        IElementType iElementType = ((GrUnaryExpression)this.getElement()).getOperationTokenType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationTokenType(...)");
        IElementType tokenType = iElementType;
        String string = unaryOperatorMethodNames.get(tokenType);
        if (string == null) {
            throw new IllegalStateException(("unexpected token type: " + tokenType).toString());
        }
        return string;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return CollectionsKt.emptyList();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)GroovyElementTypes.T_NOT, (Object)"asBoolean"), TuplesKt.to((Object)GroovyElementTypes.T_PLUS, (Object)"positive"), TuplesKt.to((Object)GroovyElementTypes.T_MINUS, (Object)"negative"), TuplesKt.to((Object)GroovyElementTypes.T_DEC, (Object)"previous"), TuplesKt.to((Object)GroovyElementTypes.T_INC, (Object)"next"), TuplesKt.to((Object)GroovyElementTypes.T_BNOT, (Object)"bitwiseNegate")};
        unaryOperatorMethodNames = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\u0016\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrUnaryOperatorReference$Companion;", "", "<init>", "()V", "unaryOperatorMethodNames", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

