/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.BuildDataProvider;
import org.jetbrains.jps.incremental.storage.ExperimentalOneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.PathTypeAwareRelativizer;
import org.jetbrains.jps.incremental.storage.PerTargetMapManager;
import org.jetbrains.jps.incremental.storage.RelativePathType;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.incremental.storage.StorageManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u00020\u000b2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0018\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020!2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0014\u0010\"\u001a\u00020\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\b\u0010#\u001a\u00020\u0013H\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalBuildDataManager;", "Lorg/jetbrains/jps/incremental/storage/BuildDataProvider;", "storageManager", "Lorg/jetbrains/jps/incremental/storage/StorageManager;", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "<init>", "(Lorg/jetbrains/jps/incremental/storage/StorageManager;Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;)V", "targetToMapManager", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/jps/builders/BuildTarget;", "Lorg/jetbrains/jps/incremental/storage/PerTargetMapManager;", "typeAwareRelativizer", "Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;", "Lorg/jetbrains/annotations/Nullable;", "outputToTargetMapping", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;", "clearCache", "", "removeStaleTarget", "targetId", "", "targetTypeId", "getPerTargetMapManager", "target", "getFileStampStorage", "Lorg/jetbrains/jps/incremental/storage/StampsStorage;", "getSourceToOutputMapping", "Lorg/jetbrains/jps/builders/storage/SourceToOutputMapping;", "getOutputToTargetMapping", "Lorg/jetbrains/jps/incremental/storage/OutputToTargetMapping;", "getSourceToForm", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOneToManyPathMapping;", "closeTargetMaps", "removeAllMaps", "commit", "close", "intellij.platform.jps.build"})
public final class ExperimentalBuildDataManager
implements BuildDataProvider {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final PathRelativizerService relativizer;
    @NotNull
    private final ConcurrentHashMap<BuildTarget<?>, PerTargetMapManager> targetToMapManager;
    @NotNull
    private final PathTypeAwareRelativizer typeAwareRelativizer;
    @NotNull
    private final SynchronizedClearableLazy<ExperimentalOutputToTargetMapping> outputToTargetMapping;

    public ExperimentalBuildDataManager(@NotNull StorageManager storageManager, @NotNull PathRelativizerService relativizer) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
        this.storageManager = storageManager;
        this.relativizer = relativizer;
        this.targetToMapManager = new ConcurrentHashMap();
        PathTypeAwareRelativizer pathTypeAwareRelativizer = this.relativizer.getTypeAwareRelativizer();
        if (pathTypeAwareRelativizer == null) {
            pathTypeAwareRelativizer = new PathTypeAwareRelativizer(this){
                final /* synthetic */ ExperimentalBuildDataManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public String toRelative(String path, RelativePathType type) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                    String string = ExperimentalBuildDataManager.access$getRelativizer$p(this.this$0).toRelative(path);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
                    return string;
                }

                public String toRelative(Path path, RelativePathType type) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                    String string = ExperimentalBuildDataManager.access$getRelativizer$p(this.this$0).toRelative(path);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toRelative(...)");
                    return string;
                }

                public String toAbsolute(String path, RelativePathType type) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                    String string = ExperimentalBuildDataManager.access$getRelativizer$p(this.this$0).toFull(path);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toFull(...)");
                    return string;
                }

                public Path toAbsoluteFile(String path, RelativePathType type) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                    Path path2 = Path.of(ExperimentalBuildDataManager.access$getRelativizer$p(this.this$0).toFull(path), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                    return path2;
                }
            };
        }
        this.typeAwareRelativizer = pathTypeAwareRelativizer;
        this.outputToTargetMapping = new SynchronizedClearableLazy(() -> ExperimentalBuildDataManager.outputToTargetMapping$lambda$0(this));
    }

    @Override
    public void clearCache() {
        this.storageManager.clearCache();
    }

    @Override
    public void removeStaleTarget(@NotNull String targetId, @NotNull String targetTypeId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
        this.storageManager.removeMaps(targetId, targetTypeId);
        ((ExperimentalOutputToTargetMapping)this.outputToTargetMapping.getValue()).removeTarget(targetId, targetTypeId);
    }

    private final PerTargetMapManager getPerTargetMapManager(BuildTarget<?> target) {
        PerTargetMapManager perTargetMapManager = this.targetToMapManager.computeIfAbsent(target, arg_0 -> ExperimentalBuildDataManager.getPerTargetMapManager$lambda$1(arg_0 -> ExperimentalBuildDataManager.getPerTargetMapManager$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)perTargetMapManager, (String)"computeIfAbsent(...)");
        return perTargetMapManager;
    }

    @Override
    @NotNull
    public StampsStorage<?> getFileStampStorage(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.getPerTargetMapManager(target).stamp;
    }

    @Override
    @NotNull
    public SourceToOutputMapping getSourceToOutputMapping(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.getPerTargetMapManager(target).getSourceToOutputMapping();
    }

    @Override
    @NotNull
    public OutputToTargetMapping getOutputToTargetMapping() {
        return (OutputToTargetMapping)this.outputToTargetMapping.getValue();
    }

    @Override
    @NotNull
    public ExperimentalOneToManyPathMapping getSourceToForm(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.getPerTargetMapManager(target).getSourceToForm();
    }

    @Override
    public void closeTargetMaps(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        this.targetToMapManager.remove(target);
    }

    @Override
    public void removeAllMaps() {
        this.outputToTargetMapping.drop();
        this.targetToMapManager.clear();
        this.storageManager.clean();
    }

    @Override
    public void commit() {
        this.storageManager.commit();
    }

    @Override
    public void close() {
        this.outputToTargetMapping.drop();
        this.targetToMapManager.clear();
        this.storageManager.close();
    }

    private static final ExperimentalOutputToTargetMapping outputToTargetMapping$lambda$0(ExperimentalBuildDataManager this$0) {
        return new ExperimentalOutputToTargetMapping(this$0.storageManager);
    }

    private static final PerTargetMapManager getPerTargetMapManager$lambda$0(ExperimentalBuildDataManager this$0, BuildTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new PerTargetMapManager(this$0.storageManager, this$0.typeAwareRelativizer, it, (Supplier)this$0.outputToTargetMapping);
    }

    private static final PerTargetMapManager getPerTargetMapManager$lambda$1(Function1 $tmp0, Object p0) {
        return (PerTargetMapManager)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ PathRelativizerService access$getRelativizer$p(ExperimentalBuildDataManager $this) {
        return $this.relativizer;
    }
}

