/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage.graph;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.StorageLockContext;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.dependency.BaseMaplet;
import org.jetbrains.jps.dependency.ComparableTypeExternalizer;
import org.jetbrains.jps.dependency.Enumerator;
import org.jetbrains.jps.dependency.Externalizer;
import org.jetbrains.jps.dependency.Maplet;
import org.jetbrains.jps.dependency.MapletFactory;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.impl.CachingMaplet;
import org.jetbrains.jps.dependency.impl.CachingMultiMaplet;
import org.jetbrains.jps.dependency.impl.GraphDataInputImpl;
import org.jetbrains.jps.dependency.impl.GraphDataOutputImpl;
import org.jetbrains.jps.incremental.storage.graph.PersistentMaplet;
import org.jetbrains.jps.incremental.storage.graph.PersistentMultiMaplet;
import org.jetbrains.jps.util.Iterators;

public final class PersistentMapletFactory
implements MapletFactory,
Closeable {
    private static final int BASE_CACHE_SIZE = 512 * (SystemProperties.getBooleanProperty((String)"compile.parallel", (boolean)false) ? 2 : 1);
    private final String myRootDirPath;
    private final PersistentStringEnumerator myStringTable;
    private final List<BaseMaplet<?>> myMaps = new ArrayList();
    private final Enumerator myEnumerator;
    private final Function<Object, Object> myDataInterner;
    private final LoadingCache<Object, Object> myInternerCache;
    private final LowMemoryWatcher myMemWatcher;
    private final int myCacheSize;

    public PersistentMapletFactory(String rootDirPath) throws IOException {
        this.myRootDirPath = rootDirPath;
        this.myStringTable = new PersistentStringEnumerator(this.getMapFile("string-table"), 4096, true, new StorageLockContext());
        this.myEnumerator = new Enumerator(){

            @Override
            public String toString(int num) throws IOException {
                return PersistentMapletFactory.this.myStringTable.valueOf(num);
            }

            @Override
            public int toNumber(String str) throws IOException {
                return PersistentMapletFactory.this.myStringTable.enumerate(str);
            }
        };
        int maxGb = (int)(Runtime.getRuntime().maxMemory() / 0x40000000L);
        this.myCacheSize = BASE_CACHE_SIZE * Math.min(Math.max(1, maxGb), 5);
        this.myInternerCache = Caffeine.newBuilder().maximumSize((long)this.myCacheSize).build(key -> key);
        this.myDataInterner = elem -> elem instanceof Usage ? this.myInternerCache.get(elem) : elem;
        this.myMemWatcher = LowMemoryWatcher.register(() -> {
            this.myInternerCache.invalidateAll();
            this.myStringTable.force();
            for (BaseMaplet<?> map : this.myMaps) {
                try {
                    map.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public <K, V> MultiMaplet<K, V> createSetMultiMaplet(String storageName, ComparableTypeExternalizer<K> keyExternalizer, ComparableTypeExternalizer<V> valueExternalizer) {
        PersistentMultiMaplet<K, V, Set> maplet = new PersistentMultiMaplet<K, V, Set>(this.getMapFile(storageName), new GraphKeyDescriptor<K>(keyExternalizer, this.myEnumerator, null), new GraphDataExternalizer<V>(valueExternalizer, this.myEnumerator, this.myDataInterner), HashSet::new);
        CachingMultiMaplet container = new CachingMultiMaplet(maplet, this.myCacheSize);
        this.myMaps.add(container);
        return container;
    }

    @Override
    public <K, V> Maplet<K, V> createMaplet(String storageName, ComparableTypeExternalizer<K> keyExternalizer, ComparableTypeExternalizer<V> valueExternalizer) {
        CachingMaplet<K, V> container = new CachingMaplet<K, V>(new PersistentMaplet<K, V>(this.getMapFile(storageName), new GraphKeyDescriptor<K>(keyExternalizer, this.myEnumerator, null), new GraphDataExternalizer<V>(valueExternalizer, this.myEnumerator, this.myDataInterner)), this.myCacheSize);
        this.myMaps.add(container);
        return container;
    }

    @Override
    public void close() {
        this.myMemWatcher.stop();
        Throwable ex = null;
        for (Closeable container : Iterators.flat(this.myMaps, (Iterable)Iterators.asIterable((Object)this.myStringTable))) {
            try {
                container.close();
            }
            catch (Throwable e) {
                if (ex != null) continue;
                ex = e;
            }
        }
        this.myMaps.clear();
        this.myInternerCache.invalidateAll();
        if (ex instanceof IOException) {
            throw new BuildDataCorruptedException((IOException)ex);
        }
        if (ex != null) {
            throw new RuntimeException(ex);
        }
    }

    private Path getMapFile(String name) {
        File file = new File(this.myRootDirPath, name);
        FileUtil.createIfDoesntExist((File)file);
        return file.toPath();
    }

    private static final class GraphKeyDescriptor<T>
    extends GraphDataExternalizer<T>
    implements KeyDescriptor<T> {
        GraphKeyDescriptor(Externalizer<T> externalizer, @Nullable Enumerator enumerator, @Nullable Function<Object, Object> objectInterner) {
            super(externalizer, enumerator, objectInterner);
        }

        public boolean isEqual(T val1, T val2) {
            return val1.equals(val2);
        }

        public int getHashCode(T value) {
            return value.hashCode();
        }
    }

    private static class GraphDataExternalizer<T>
    implements DataExternalizer<T> {
        private final Externalizer<T> myExternalizer;
        @Nullable
        private final Enumerator myEnumerator;
        @Nullable
        private final Function<Object, Object> myObjectInterner;

        GraphDataExternalizer(Externalizer<T> externalizer, @Nullable Enumerator enumerator, @Nullable Function<Object, Object> objectInterner) {
            this.myExternalizer = externalizer;
            this.myEnumerator = enumerator;
            this.myObjectInterner = objectInterner;
        }

        public void save(@NotNull DataOutput out, T value) throws IOException {
            if (out == null) {
                GraphDataExternalizer.$$$reportNull$$$0(0);
            }
            this.myExternalizer.save(GraphDataOutputImpl.wrap(out, this.myEnumerator), value);
        }

        public T read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                GraphDataExternalizer.$$$reportNull$$$0(1);
            }
            return this.myExternalizer.load(GraphDataInputImpl.wrap(in, this.myEnumerator, this.myObjectInterner));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/graph/PersistentMapletFactory$GraphDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

