/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000f\b\u0002\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\fJ7\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u000f\b\u0002\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/HighlightingFactory;", "", "<init>", "()V", "highlightName", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "element", "Lcom/intellij/psi/PsiElement;", "highlightInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "message", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "project", "Lcom/intellij/openapi/project/Project;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.kotlin.highlighting.minimal"})
public final class HighlightingFactory {
    @NotNull
    public static final HighlightingFactory INSTANCE = new HighlightingFactory();

    private HighlightingFactory() {
    }

    @Nullable
    public final HighlightInfo.Builder highlightName(@NotNull PsiElement element, @NotNull HighlightInfoType highlightInfoType, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)highlightInfoType, (String)"highlightInfoType");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!element.getTextRange().isEmpty()) {
            TextRange textRange = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            return this.highlightName(project2, element, textRange, highlightInfoType, message);
        }
        return null;
    }

    public static /* synthetic */ HighlightInfo.Builder highlightName$default(HighlightingFactory highlightingFactory, PsiElement psiElement, HighlightInfoType highlightInfoType, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return highlightingFactory.highlightName(psiElement, highlightInfoType, string);
    }

    @NotNull
    public final HighlightInfo.Builder highlightName(@NotNull Project project, @NotNull PsiElement element, @NotNull TextRange textRange, @NotNull HighlightInfoType highlightInfoType, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)highlightInfoType, (String)"highlightInfoType");
        TextRange elementTextRange = element.getTextRange();
        boolean bl = elementTextRange.contains(textRange);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-HighlightingFactory$highlightName$22 = false;
            String $i$a$-assert-HighlightingFactory$highlightName$22 = "Invalid textRange passed: " + textRange + ". It must be within the " + element + " text range (" + elementTextRange + ")";
            throw new AssertionError((Object)$i$a$-assert-HighlightingFactory$highlightName$22);
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newHighlightInfo(...)");
        HighlightInfo.Builder builder2 = builder;
        if (message != null) {
            builder2.descriptionAndTooltip(message);
        }
        int innerStart = textRange.getStartOffset() - elementTextRange.getStartOffset();
        TextRange textRange2 = TextRange.from((int)innerStart, (int)textRange.getLength());
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"from(...)");
        TextRange innerRange = textRange2;
        HighlightInfo.Builder builder3 = builder2.range(element, innerRange);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"range(...)");
        HighlightInfo.Builder annotation = builder3;
        return annotation;
    }

    public static /* synthetic */ HighlightInfo.Builder highlightName$default(HighlightingFactory highlightingFactory, Project project, PsiElement psiElement, TextRange textRange, HighlightInfoType highlightInfoType, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        return highlightingFactory.highlightName(project, psiElement, textRange, highlightInfoType, string);
    }
}

