/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInsight.multiverse.EditorContextManager;
import com.intellij.codeInsight.multiverse.EditorSelectedContexts;
import com.intellij.codeInsight.multiverse.SingleEditorContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.FileNavigator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class OpenFileDescriptor
implements FileEditorNavigatable,
Comparable<OpenFileDescriptor> {
    public static final DataKey<Editor> NAVIGATE_IN_EDITOR = DataKey.create((String)"NAVIGATE_IN_EDITOR");
    private final Project myProject;
    private final VirtualFile myFile;
    private final int myLogicalLine;
    private final int myLogicalColumn;
    private final int myOffset;
    private final RangeMarker myRangeMarker;
    @NotNull
    private final CodeInsightContext myContext;
    private boolean myUseCurrentWindow;
    private boolean myUsePreviewTab;
    private ScrollType myScrollType;

    @ApiStatus.Experimental
    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, @NotNull CodeInsightContext context, int offset) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OpenFileDescriptor.$$$reportNull$$$0(2);
        }
        this(project, file, context, -1, -1, offset, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(3);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(4);
        }
        this(project, file, CodeInsightContexts.anyContext(), -1, -1, offset, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(5);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(6);
        }
        this(project, file, CodeInsightContexts.anyContext(), logicalLine, logicalColumn, -1, false);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int logicalLine, int logicalColumn, boolean persistent) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(8);
        }
        this(project, file, CodeInsightContexts.anyContext(), logicalLine, logicalColumn, -1, persistent);
    }

    public OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(9);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(10);
        }
        this(project, file, CodeInsightContexts.anyContext(), -1, -1, -1, false);
    }

    private OpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, @NotNull CodeInsightContext context, int logicalLine, int logicalColumn, int offset, boolean persistent) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(11);
        }
        if (file == null) {
            OpenFileDescriptor.$$$reportNull$$$0(12);
        }
        if (context == null) {
            OpenFileDescriptor.$$$reportNull$$$0(13);
        }
        this.myScrollType = ScrollType.CENTER;
        this.myProject = project;
        this.myFile = file;
        this.myContext = context;
        this.myLogicalLine = logicalLine;
        this.myLogicalColumn = logicalColumn;
        this.myOffset = offset;
        this.myRangeMarker = offset >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, offset) : (logicalLine >= 0 ? LazyRangeMarkerFactory.getInstance(project).createRangeMarker(file, logicalLine, Math.max(0, logicalColumn), persistent) : null);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            OpenFileDescriptor.$$$reportNull$$$0(14);
        }
        return virtualFile;
    }

    @ApiStatus.Internal
    @NotNull
    public CodeInsightContext getContext() {
        CodeInsightContext codeInsightContext = this.myContext;
        if (codeInsightContext == null) {
            OpenFileDescriptor.$$$reportNull$$$0(15);
        }
        return codeInsightContext;
    }

    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    public int getOffset() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid() ? this.myRangeMarker.getStartOffset() : this.myOffset;
    }

    public int getLine() {
        return this.myLogicalLine;
    }

    public int getColumn() {
        return this.myLogicalColumn;
    }

    public void navigate(boolean requestFocus) {
        FileNavigator.getInstance().navigate(this, requestFocus);
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(16);
        }
        return FileNavigator.getInstance().navigateInEditor(this, requestFocus);
    }

    public void navigateIn(@NotNull Editor e) {
        if (e == null) {
            OpenFileDescriptor.$$$reportNull$$$0(17);
        }
        OpenFileDescriptor.navigateInEditor(this, e);
    }

    @ApiStatus.Internal
    public static void navigateInEditor(@NotNull OpenFileDescriptor descriptor, @NotNull Editor e) {
        CodeInsightContext context;
        if (descriptor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(18);
        }
        if (e == null) {
            OpenFileDescriptor.$$$reportNull$$$0(19);
        }
        int offset = descriptor.getOffset();
        CaretModel caretModel = e.getCaretModel();
        boolean caretMoved = false;
        if (descriptor.getLine() >= 0) {
            LogicalPosition pos = new LogicalPosition(descriptor.getLine(), Math.max(descriptor.getColumn(), 0));
            if (offset < 0 || offset == e.logicalPositionToOffset(pos)) {
                caretModel.removeSecondaryCarets();
                caretModel.moveToLogicalPosition(pos);
                caretMoved = true;
            }
        }
        if (!caretMoved && offset >= 0) {
            caretModel.removeSecondaryCarets();
            caretModel.moveToOffset(Math.min(offset, e.getDocument().getTextLength()));
            caretMoved = true;
        }
        if (caretMoved) {
            e.getSelectionModel().removeSelection();
            FileEditorManager.getInstance(descriptor.getProject()).runWhenLoaded(e, () -> {
                descriptor.scrollToCaret(e);
                OpenFileDescriptor.unfoldCurrentLine(e);
            });
        }
        if (CodeInsightContexts.isSharedSourceSupportEnabled((Project)descriptor.getProject()) && (context = descriptor.getContext()) != CodeInsightContexts.anyContext()) {
            EditorContextManager.getInstance((Project)descriptor.getProject()).setEditorContext(e, (EditorSelectedContexts)new SingleEditorContext(context));
        }
    }

    @ApiStatus.Internal
    public static void unfoldCurrentLine(@NotNull Editor editor) {
        if (editor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(20);
        }
        FoldRegion[] allRegions = editor.getFoldingModel().getAllFoldRegions();
        TextRange range = OpenFileDescriptor.getRangeToUnfoldOnNavigation(editor);
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            for (FoldRegion region : allRegions) {
                if (region.isExpanded() || !range.intersects((Segment)region)) continue;
                region.setExpanded(true);
            }
        });
    }

    @NotNull
    public static TextRange getRangeToUnfoldOnNavigation(@NotNull Editor editor) {
        if (editor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(21);
        }
        int offset = editor.getCaretModel().getOffset();
        int line = editor.getDocument().getLineNumber(offset);
        int start = editor.getDocument().getLineStartOffset(line);
        int end = editor.getDocument().getLineEndOffset(line);
        return new TextRange(start, end);
    }

    private void scrollToCaret(@NotNull Editor e) {
        if (e == null) {
            OpenFileDescriptor.$$$reportNull$$$0(22);
        }
        e.getScrollingModel().scrollToCaret(this.myScrollType);
    }

    public boolean canNavigate() {
        return FileNavigator.getInstance().canNavigate(this);
    }

    public boolean canNavigateToSource() {
        return FileNavigator.getInstance().canNavigateToSource(this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            OpenFileDescriptor.$$$reportNull$$$0(23);
        }
        return project;
    }

    @NotNull
    public OpenFileDescriptor setUseCurrentWindow(boolean search) {
        this.myUseCurrentWindow = search;
        OpenFileDescriptor openFileDescriptor = this;
        if (openFileDescriptor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(24);
        }
        return openFileDescriptor;
    }

    public boolean isUseCurrentWindow() {
        return this.myUseCurrentWindow;
    }

    @NotNull
    public OpenFileDescriptor setUsePreviewTab(boolean usePreviewTab) {
        this.myUsePreviewTab = usePreviewTab;
        OpenFileDescriptor openFileDescriptor = this;
        if (openFileDescriptor == null) {
            OpenFileDescriptor.$$$reportNull$$$0(25);
        }
        return openFileDescriptor;
    }

    public boolean isUsePreviewTab() {
        return this.myUsePreviewTab;
    }

    public void setScrollType(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            OpenFileDescriptor.$$$reportNull$$$0(26);
        }
        this.myScrollType = scrollType;
    }

    public void dispose() {
        if (this.myRangeMarker != null) {
            this.myRangeMarker.dispose();
        }
    }

    @Override
    public int compareTo(@NotNull OpenFileDescriptor o) {
        int i;
        if (o == null) {
            OpenFileDescriptor.$$$reportNull$$$0(27);
        }
        if ((i = this.myProject.getName().compareTo(o.myProject.getName())) != 0) {
            return i;
        }
        i = this.myFile.getName().compareTo(o.myFile.getName());
        if (i != 0) {
            return i;
        }
        if (this.myRangeMarker != null) {
            if (o.myRangeMarker == null) {
                return 1;
            }
            i = this.myRangeMarker.getStartOffset() - o.myRangeMarker.getStartOffset();
            if (i != 0) {
                return i;
            }
            return this.myRangeMarker.getEndOffset() - o.myRangeMarker.getEndOffset();
        }
        return o.myRangeMarker == null ? 0 : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/OpenFileDescriptor";
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/OpenFileDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "setUseCurrentWindow";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setUsePreviewTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "navigateInEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "navigateIn";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unfoldCurrentLine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToUnfoldOnNavigation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCaret";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setScrollType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

