/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsContributor;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.util.ArrayList;
import java.util.List;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
final class LanguageCodeStyleSettingsProviderService
implements Disposable {
    private volatile List<LanguageCodeStyleSettingsProvider> allProviders;
    private final Object lock;

    static LanguageCodeStyleSettingsProviderService getInstance() {
        return (LanguageCodeStyleSettingsProviderService)ApplicationManager.getApplication().getService(LanguageCodeStyleSettingsProviderService.class);
    }

    LanguageCodeStyleSettingsProviderService(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(0);
        }
        this.lock = new Object();
        LanguageCodeStyleSettingsProvider.EP_NAME.addChangeListener(coroutineScope, () -> {
            this.allProviders = null;
            LanguageCodeStyleSettingsProvider.cleanSettingsPagesProvidersCache();
        });
        LanguageCodeStyleSettingsContributor.EP_NAME.addChangeListener(coroutineScope, () -> {
            this.allProviders = null;
        });
    }

    @TestOnly
    LanguageCodeStyleSettingsProviderService(boolean testOnly) {
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<LanguageCodeStyleSettingsProvider> getAllProviders() {
        List<LanguageCodeStyleSettingsProvider> providers = this.allProviders;
        if (providers != null) {
            List<LanguageCodeStyleSettingsProvider> list = providers;
            if (list == null) {
                LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(1);
            }
            return list;
        }
        Object object = this.lock;
        synchronized (object) {
            providers = this.allProviders;
            if (providers != null) {
                List<LanguageCodeStyleSettingsProvider> list = providers;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                if (list == null) {
                    LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(2);
                }
                return list;
            }
            this.allProviders = providers = LanguageCodeStyleSettingsProviderService.computeAllProviders();
        }
        List<LanguageCodeStyleSettingsProvider> list = providers;
        if (list == null) {
            LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<LanguageCodeStyleSettingsProvider> computeAllProviders() {
        List extensions = LanguageCodeStyleSettingsProvider.EP_NAME.getExtensionList();
        List contributors = LanguageCodeStyleSettingsContributor.EP_NAME.getExtensionList();
        if (contributors.isEmpty()) {
            List list = extensions;
            if (list == null) {
                LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<LanguageCodeStyleSettingsProvider> allExtensions = new ArrayList<LanguageCodeStyleSettingsProvider>(extensions);
        for (LanguageCodeStyleSettingsContributor contributor : contributors) {
            allExtensions.addAll(contributor.getProviders());
        }
        ArrayList<LanguageCodeStyleSettingsProvider> arrayList = allExtensions;
        if (arrayList == null) {
            LanguageCodeStyleSettingsProviderService.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProviderService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProviderService";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProviders";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

