/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.OverrideOnly
public abstract class IndexableSetContributor {
    public static final ExtensionPointName<IndexableSetContributor> EP_NAME = new ExtensionPointName("com.intellij.indexedRootsProvider");
    private static final Logger LOG = Logger.getInstance(IndexableSetContributor.class);

    @NotNull
    public static @Unmodifiable Set<VirtualFile> getProjectRootsToIndex(@NotNull IndexableSetContributor contributor, @NotNull Project project) {
        if (contributor == null) {
            IndexableSetContributor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            IndexableSetContributor.$$$reportNull$$$0(1);
        }
        Set<VirtualFile> roots = contributor.getAdditionalProjectRootsToIndex(project);
        return IndexableSetContributor.filterOutNulls(contributor, "getAdditionalProjectRootsToIndex(Project)", roots);
    }

    @NotNull
    public static @Unmodifiable Set<VirtualFile> getRootsToIndex(@NotNull IndexableSetContributor contributor) {
        if (contributor == null) {
            IndexableSetContributor.$$$reportNull$$$0(2);
        }
        Set<VirtualFile> roots = contributor.getAdditionalRootsToIndex();
        return IndexableSetContributor.filterOutNulls(contributor, "getAdditionalRootsToIndex()", roots);
    }

    @ApiStatus.Experimental
    public boolean acceptFile(@NotNull VirtualFile file, @NotNull VirtualFile root, @Nullable Project project) {
        if (file == null) {
            IndexableSetContributor.$$$reportNull$$$0(3);
        }
        if (root == null) {
            IndexableSetContributor.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    public @Unmodifiable Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        if (project == null) {
            IndexableSetContributor.$$$reportNull$$$0(5);
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            IndexableSetContributor.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public abstract @Unmodifiable Set<VirtualFile> getAdditionalRootsToIndex();

    @NonNls
    @NotNull
    public String getDebugName() {
        String string = this.toString();
        if (string == null) {
            IndexableSetContributor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static @Unmodifiable Set<VirtualFile> filterOutNulls(@NotNull IndexableSetContributor contributor, @NotNull String methodInfo, @NotNull Set<VirtualFile> roots) {
        if (contributor == null) {
            IndexableSetContributor.$$$reportNull$$$0(8);
        }
        if (methodInfo == null) {
            IndexableSetContributor.$$$reportNull$$$0(9);
        }
        if (roots == null) {
            IndexableSetContributor.$$$reportNull$$$0(10);
        }
        for (VirtualFile root : roots) {
            if (root != null && root.isValid()) continue;
            LOG.error((Throwable)PluginException.createByClass((String)("Please fix " + contributor.getClass().getName() + "#" + methodInfo + ".\n" + (root == null ? "The returned set is not expected to contain nulls, but it is " + String.valueOf(roots) : "Invalid file returned: " + String.valueOf(root))), null, contributor.getClass()));
            return new LinkedHashSet<VirtualFile>(ContainerUtil.filter(roots, virtualFile -> virtualFile != null && virtualFile.isValid()));
        }
        Set<VirtualFile> set = roots;
        if (set == null) {
            IndexableSetContributor.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexableSetContributor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexableSetContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectRootsToIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutNulls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRootsToIndex";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToIndex";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectRootsToIndex";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterOutNulls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 11 -> new IllegalStateException(string);
        };
    }
}

