/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentInfo;
import org.intellij.plugins.markdown.editor.lists.ListItemInfo;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\nJ4\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\nH\u0002J\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013\u00a2\u0006\u0002\u0010\u0014JH\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\nH\u0002J2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c*\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001d\u0010 \u001a\n \"*\u0004\u0018\u00010!0!*\u00020#2\u0006\u0010$\u001a\u00020#H\u0082\u0002\u00a8\u0006%"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListRenumberUtils;", "", "<init>", "()V", "renumberInBulk", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "document", "Lcom/intellij/openapi/editor/Document;", "recursive", "", "restart", "inWriteAction", "sequentially", "collectReplacements", "Lkotlin/sequences/Sequence;", "Lorg/intellij/plugins/markdown/editor/lists/Replacement;", "obtainMarkerNumber", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;)Ljava/lang/Integer;", "renumberingReplacements", "list", "listIndentInfo", "Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentInfo;", "file", "Lcom/intellij/psi/PsiFile;", "changeContentLinesIndent", "", "lines", "Lkotlin/ranges/IntRange;", "newIndent", "plus", "Ljava/lang/StringBuilder;", "kotlin.jvm.PlatformType", "", "other", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nListRenumberUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListRenumberUtils.kt\norg/intellij/plugins/markdown/editor/lists/ListRenumberUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1642#2,10:111\n1915#2:121\n1916#2:123\n1652#2:124\n1#3:122\n*S KotlinDebug\n*F\n+ 1 ListRenumberUtils.kt\norg/intellij/plugins/markdown/editor/lists/ListRenumberUtils\n*L\n103#1:111,10\n103#1:121\n103#1:123\n103#1:124\n103#1:122\n*E\n"})
public final class ListRenumberUtils {
    @NotNull
    public static final ListRenumberUtils INSTANCE = new ListRenumberUtils();

    private ListRenumberUtils() {
    }

    public final void renumberInBulk(@NotNull MarkdownList $this$renumberInBulk, @NotNull Document document, boolean recursive, boolean restart, boolean inWriteAction, boolean sequentially) {
        Intrinsics.checkNotNullParameter((Object)$this$renumberInBulk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        List replacementList = SequencesKt.toList(this.collectReplacements($this$renumberInBulk, document, recursive, restart, sequentially));
        if (inWriteAction) {
            ActionsKt.runWriteAction(() -> ListRenumberUtils.renumberInBulk$lambda$0(replacementList, document));
        } else {
            Replacement.Companion.replaceAllInBulk$intellij_markdown(replacementList, document);
        }
    }

    public static /* synthetic */ void renumberInBulk$default(ListRenumberUtils listRenumberUtils, MarkdownList markdownList, Document document, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            bl4 = true;
        }
        listRenumberUtils.renumberInBulk(markdownList, document, bl, bl2, bl3, bl4);
    }

    private final Sequence<Replacement> collectReplacements(MarkdownList $this$collectReplacements, Document document, boolean recursive, boolean restart, boolean sequentially) {
        int line = document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)$this$collectReplacements)));
        Integer n = ListUtils.INSTANCE.getLineIndentInnerSpacesLength(document, line, $this$collectReplacements.getContainingFile());
        Intrinsics.checkNotNull((Object)n);
        int firstIndent = n;
        ListItemIndentInfo listItemIndentInfo = new ListItemIndentInfo(firstIndent, 0);
        PsiFile psiFile = $this$collectReplacements.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return this.renumberingReplacements($this$collectReplacements, listItemIndentInfo, document, psiFile, recursive, restart, sequentially);
    }

    static /* synthetic */ Sequence collectReplacements$default(ListRenumberUtils listRenumberUtils, MarkdownList markdownList, Document document, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return listRenumberUtils.collectReplacements(markdownList, document, bl, bl2, bl3);
    }

    @Nullable
    public final Integer obtainMarkerNumber(@NotNull MarkdownListItem $this$obtainMarkerNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$obtainMarkerNumber, (String)"<this>");
        PsiElement psiElement = $this$obtainMarkerNumber.getMarkerElement();
        MarkdownListNumber markdownListNumber = psiElement instanceof MarkdownListNumber ? (MarkdownListNumber)psiElement : null;
        return markdownListNumber != null ? markdownListNumber.getNumber() : null;
    }

    private final Sequence<Replacement> renumberingReplacements(MarkdownList list2, ListItemIndentInfo listIndentInfo, Document document, PsiFile file, boolean recursive, boolean restart, boolean sequentially) {
        Integer n;
        MarkdownListItem firstItem = (MarkdownListItem)CollectionsKt.first(ListUtils.INSTANCE.getItems(list2));
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)list2)), (Object)MarkdownElementTypes.ORDERED_LIST)) {
            n = null;
        } else if (restart) {
            n = 1;
        } else {
            Integer n2 = this.obtainMarkerNumber(firstItem);
            if (n2 == null) {
                throw new IllegalStateException("Failed to obtain first item number".toString());
            }
            n = (int)n2;
        }
        Integer start = n;
        char markerFlavor = StringsKt.last((CharSequence)((Object)StringsKt.trim((CharSequence)ListUtils.INSTANCE.getNormalizedMarker(firstItem))).toString());
        Sequence sequence = SequencesKt.emptySequence();
        Iterator iterator = ((Iterable)ListUtils.INSTANCE.getItems(list2)).iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Replacement indentReplacement;
            int i = n3++;
            MarkdownListItem item = (MarkdownListItem)iterator.next();
            ListItemInfo oldInfo = new ListItemInfo(item, document);
            String marker = start == null ? markerFlavor + " " : "" + (sequentially ? start + i : 1) + markerFlavor + " ";
            ListItemIndentInfo newIndentInfo = listIndentInfo.subItem(marker.length());
            Intrinsics.checkNotNull((Object)oldInfo.getIndentInfo().changeLineIndent(oldInfo.getLines().getFirst(), newIndentInfo.getIndent(), document, file));
            TextRange textRange = indentReplacement.getRange();
            PsiElement psiElement = item.getMarkerElement();
            Intrinsics.checkNotNull((Object)psiElement);
            TextRange textRange2 = textRange.union(psiElement.getTextRange());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"union(...)");
            StringBuilder stringBuilder = this.plus(indentReplacement.getStr(), marker);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"plus(...)");
            Replacement indentWithMarkerReplacement = new Replacement(textRange2, stringBuilder);
            sequence = SequencesKt.plus((Sequence)sequence, (Object)indentWithMarkerReplacement);
            int prevLine = oldInfo.getLines().getFirst();
            if (recursive) {
                for (MarkdownList sublist : ListUtils.INSTANCE.getSublists(item)) {
                    int sublistFirstLine = document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)sublist)));
                    int sublistLastLine = document.getLineNumber(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)sublist)));
                    IntRange preContentLines = RangesKt.until((int)(prevLine + 1), (int)sublistFirstLine);
                    sequence = SequencesKt.plus((Sequence)sequence, (Iterable)this.changeContentLinesIndent(oldInfo.getIndentInfo(), preContentLines, newIndentInfo.subItemIndent(), document, file));
                    sequence = SequencesKt.plus((Sequence)sequence, (Sequence)ListRenumberUtils.renumberingReplacements$default(this, sublist, newIndentInfo, document, file, true, true, false, 64, null));
                    prevLine = sublistLastLine;
                }
            }
            IntRange postContentLines = new IntRange(prevLine + 1, oldInfo.getLines().getLast());
            sequence = SequencesKt.plus((Sequence)sequence, (Iterable)this.changeContentLinesIndent(oldInfo.getIndentInfo(), postContentLines, newIndentInfo.subItemIndent(), document, file));
        }
        return sequence;
    }

    static /* synthetic */ Sequence renumberingReplacements$default(ListRenumberUtils listRenumberUtils, MarkdownList markdownList, ListItemIndentInfo listItemIndentInfo, Document document, PsiFile psiFile, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl3 = true;
        }
        return listRenumberUtils.renumberingReplacements(markdownList, listItemIndentInfo, document, psiFile, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Replacement> changeContentLinesIndent(ListItemIndentInfo $this$changeContentLinesIndent, IntRange lines, int newIndent, Document document, PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)lines;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Replacement it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int line = element$iv$iv;
            boolean bl2 = false;
            if ($this$changeContentLinesIndent.subItem(0).changeLineIndent(line, newIndent, document, file) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final StringBuilder plus(CharSequence $this$plus, CharSequence other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        return new StringBuilder($this$plus.length() + other.length()).append($this$plus).append(other);
    }

    private static final Unit renumberInBulk$lambda$0(List $replacementList, Document $document) {
        Replacement.Companion.replaceAllInBulk$intellij_markdown($replacementList, $document);
        return Unit.INSTANCE;
    }
}

