/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.terminal.TerminalFontSizeProvider;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalFontSettingsListener;
import org.jetbrains.plugins.terminal.TerminalFontSettingsService;
import org.jetbrains.plugins.terminal.TerminalFontSize;
import org.jetbrains.plugins.terminal.TerminalUtil;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\r\u0010\u0013\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0014J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl;", "Lcom/intellij/terminal/TerminalFontSizeProvider;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/terminal/TerminalFontSizeProvider$Listener;", "fontSize", "Lorg/jetbrains/plugins/terminal/TerminalFontSize;", "getFontSize", "", "setFontSize", "", "newSize", "resetFontSize", "setFontSizeImpl", "showZoomIndicator", "", "getDefaultScaledFontSize", "getDefaultScaledFontSize$intellij_terminal", "addListener", "parentDisposable", "listener", "dispose", "Companion", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalFontSizeProviderImpl
implements TerminalFontSizeProvider,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CopyOnWriteArrayList<TerminalFontSizeProvider.Listener> listeners = new CopyOnWriteArrayList();
    @Nullable
    private TerminalFontSize fontSize;

    public TerminalFontSizeProviderImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> TerminalFontSizeProviderImpl._init_$lambda$0(this, arg_0));
        TerminalFontSettingsService.Companion.getInstance().addListener(new TerminalFontSettingsListener(){

            @Override
            public void fontSettingsChanged() {
                this.resetFontSize();
            }
        }, this);
    }

    public float getFontSize() {
        TerminalFontSize size = this.fontSize;
        if (size == null) {
            this.fontSize = size = this.getDefaultScaledFontSize$intellij_terminal();
        }
        return size.getFloatValue();
    }

    public void setFontSize(float newSize) {
        this.setFontSizeImpl(newSize, true);
    }

    public void resetFontSize() {
        this.setFontSizeImpl(this.getDefaultScaledFontSize$intellij_terminal().getFloatValue(), false);
    }

    private final void setFontSizeImpl(float newSize, boolean showZoomIndicator) {
        TerminalFontSize oldSize = this.fontSize;
        if (!Intrinsics.areEqual((Object)oldSize, (Object)TerminalFontSize.Companion.ofFloat(newSize))) {
            this.fontSize = TerminalFontSize.Companion.ofFloat(newSize);
            Iterator<TerminalFontSizeProvider.Listener> iterator = this.listeners.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<TerminalFontSizeProvider.Listener> iterator2 = iterator;
            while (iterator2.hasNext()) {
                TerminalFontSizeProvider.Listener listener2 = iterator2.next();
                listener2.fontChanged(showZoomIndicator);
            }
        }
    }

    @NotNull
    public final TerminalFontSize getDefaultScaledFontSize$intellij_terminal() {
        return TerminalFontSettingsService.Companion.getInstance().getSettings().getFontSize().scale();
    }

    public void addListener(@NotNull Disposable parentDisposable, @NotNull TerminalFontSizeProvider.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        TerminalUtil.addItem((List)this.listeners, listener2, parentDisposable);
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(TerminalFontSizeProviderImpl this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.resetFontSize();
    }

    @JvmStatic
    @NotNull
    public static final TerminalFontSizeProviderImpl getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalFontSizeProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalFontSizeProviderImpl.kt\norg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,74:1\n42#2,3:75\n*S KotlinDebug\n*F\n+ 1 TerminalFontSizeProviderImpl.kt\norg/jetbrains/plugins/terminal/TerminalFontSizeProviderImpl$Companion\n*L\n72#1:75,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalFontSizeProviderImpl getInstance() {
            boolean $i$f$service = false;
            Class<TerminalFontSizeProviderImpl> serviceClass$iv = TerminalFontSizeProviderImpl.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalFontSizeProviderImpl)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

