/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FeatureRestriction;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.GermanDateChecker;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GermanValences;
import ai.grazie.rules.de.ReflexivePronouns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TreeSupport;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum Case {
    NOM("Nominativ"),
    GEN("Genitiv"),
    DAT("Dativ"),
    AKK("Akkusativ");

    static final NodePattern bisZu;
    static final NodePattern anstelleVon;
    static final NodePattern vor;
    static final NodePattern um;
    static final NodePattern accPreposition;
    private static final NodePattern entsprechendOutsideNP;
    static final NodePattern genDatPreposition;
    private static final NodePattern prepDativeOnly;
    static final NodePattern datPreposition;
    static final NodePattern accDatPreposition;
    static final NodePattern genPreposition;
    static final NodePattern notSubstantivatedVerb;
    static final NodePattern preferTransitiveInterpretation;
    static final NodePattern verbsWithAccUeberObject;
    static final NodePattern verbsWithAccAufObject;
    static final NodePattern verbsWithAccPrepObject;
    static final NodePattern verbsWithDatPrepObject;
    static final NodePattern definitelyTransitive;
    private static final NodePattern definitelyIntransitive;
    private static final NodePattern looksLikePassive;
    private static final NodePattern datArgumentFitsContext;
    private static final NodePattern mayHaveDativeArgument;
    private static final NodePattern definitelyDatObj;
    private static final NodePattern definitelyGenObj;
    private static final NodePattern accNomAmbiguity;
    static final NodePattern possiblyMisshapedSubject;
    static final NodePattern possiblyMisshapedCopulaSubject;
    static final NodePattern misparsedFlatHead;
    static final NodePattern hasMisparsedFlatHeadDependent;
    static final NodePattern possibleSubjectObjectAmbiguity;
    private static final NodePattern definitelyAccObj;
    private static final NodePattern esGibtPredicate;
    private static final NodePattern esGibtArg;
    static final NodePattern esGehtArg;
    private static final NodePattern dateWithCopula;
    private static final NodePattern predicativeWithDativeArg;
    private static final NodePattern singular;
    private static final NodePattern copulaWithDativeArg;
    private static final NodePattern betreffendArg;
    private static final NodePattern finiteInAnotherConjunct;
    private static final NodePattern wartenAufAkkObj;
    private static final FeatureRestriction<Case> allCases;
    private static final NodePattern willen;
    final String presentable;
    private static final NodePattern looksLikeAccUeberVerb;
    private static final NodePattern withEllipsis;
    private static final NodePattern trueNMod;
    static final NodePattern XXerJahre;
    private static final NodePattern inXXerJahre;
    private static final NodePattern inZeitDative;
    private static final NodePattern zurueckgehen;
    private static final NodePattern animateArgumentMod;
    private static final NodePattern alsX;
    private static final NodePattern mehrAlsX;
    private static final NodePattern looksLikeAccObj;
    private static final NodePattern looksLikeDatObj;
    private static final NodePattern hasMisparsedHead;
    private static final NodePattern finiteXcomp;

    static NodePattern mayHaveArg(String arg) {
        return NodePattern.custom(node -> GermanValences.get(node).stream().anyMatch(as -> as.has(arg)));
    }

    static NodePattern mayMissArgInContext(String arg) {
        return NodePattern.custom(node -> GermanValences.get(node).stream().anyMatch(as -> as.has(arg) && as.hasAllObligatoryArguments((Node)node)));
    }

    private Case(String presentable) {
        this.presentable = presentable;
    }

    static FeatureRestriction<Case> calcPrepositionCases(Node prep, Node node) {
        if (withEllipsis.matches(node)) {
            return allCases;
        }
        if (mehrAlsX.matches(node) && esGibtPredicate.matches(node.head().head())) {
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{AKK});
        }
        if (alsX.matches(node)) {
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{NOM, AKK});
        }
        if (um.matches(prep) && NodePattern.N.withPhraseEnd(NodePattern.or(willen, NodePattern.N.directlyBefore(willen))).matches(node)) {
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{GEN});
        }
        if (NodePattern.N.form("bez\u00fcglich").matches(prep)) {
            return NodePattern.N.onlyPos(".*PLU.*").noDependents("det(:poss)?|amod").matches(node) ? FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{GEN, DAT}) : FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{GEN});
        }
        if (SemanticRules.timeUnit.matches(node) && vor.matches(prep)) {
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{DAT});
        }
        if (genDatPreposition.matches(prep)) {
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{GEN, DAT});
        }
        if (datPreposition.matches(prep)) {
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{DAT});
        }
        if (accDatPreposition.matches(prep)) {
            Node predicate = node.head();
            String normalized = GermanValences.normalizePreposition(prep);
            TreeSupport support = node.tree().treeSupport();
            if (!node.hasDependent("cop") && predicate != null && predicate.allDependents().stream().noneMatch(d -> d != node && d.allDependents().stream().anyMatch(d1 -> d1.hasHeadRelation("case") && d1.lowForm().equals(prep.lowForm())))) {
                List<Valence> valences;
                if (predicate.allDependents().stream().noneMatch(d -> d != node && d.allDependents().stream().anyMatch(d1 -> d1.hasHeadRelation("case") && accDatPreposition.matches((Node)d1))) && (verbsWithAccPrepObject.matches(predicate) || predicate.hasForm("stolz") && prep.hasForm("auf"))) {
                    return FeatureRestriction.restricted((String)support.quote(predicate.lowForm() + " " + normalized), (Enum[])new Case[]{AKK});
                }
                if (prep.hasForm("auf") && (verbsWithAccAufObject.matches(predicate) && !looksLikeAccUeberVerb.matches(predicate) || predicate.hasLemma("warten") && wartenAufAkkObj.matches(node))) {
                    return FeatureRestriction.restricted((String)support.quote(predicate.lowForm() + " auf"), (Enum[])new Case[]{AKK});
                }
                if (prep.lowForm().equals("in") && predicate.hasLemma("fallen") && GermanTreePatterns.uncountableNoun.matches(node)) {
                    return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{AKK});
                }
                if (verbsWithAccUeberObject.matches(predicate) && prep.hasForm("(ue|\u00fc)ber")) {
                    return FeatureRestriction.restricted((String)support.quote(predicate.lowForm() + " \u00fcber"), (Enum[])new Case[]{AKK});
                }
                if (notSubstantivatedVerb.matches(predicate) && !hasMisparsedFlatHeadDependent.matches(node) && !(valences = GermanValences.get(predicate)).isEmpty()) {
                    boolean ambigSentence;
                    boolean hasDat = valences.stream().anyMatch(as -> as.has(normalized + "D") || as.has(normalized + "D:Anim") && SemanticRules.animate.matches(node) || as.has(normalized + "D:Inanim") && SemanticRules.inanimate.matches(node));
                    boolean hasAcc = valences.stream().anyMatch(as -> as.has(normalized + "A") || as.has(normalized + "A:Anim") && SemanticRules.animate.matches(node) || as.has(normalized + "A:Inanim") && SemanticRules.inanimate.matches(node));
                    boolean bl = ambigSentence = predicate.findDependents("obl").stream().filter(d -> d.hasDependent("case") && valences.stream().anyMatch(as -> as.recognizesArgument((Node)d))).toList().size() > 1;
                    if (hasDat != hasAcc && !ambigSentence) {
                        return FeatureRestriction.restricted((String)support.quote(predicate.lowForm() + " " + normalized), (Enum[])new Case[]{hasDat ? DAT : AKK});
                    }
                }
            }
            if ((verbsWithDatPrepObject.matches(predicate) || predicate != null && GermanValences.get(predicate).stream().anyMatch(as -> as.has(normalized + "D") && as.hasAllArguments(predicate))) && !prep.hasForm("(ue|\u00fc)ber")) {
                return FeatureRestriction.restricted((String)support.quote(predicate.lowForm() + " " + normalized), (Enum[])new Case[]{DAT});
            }
            if ((AgreementSet.copulaHead.matches(node) || AgreementSet.copulaHead.matches(predicate) && !trueNMod.matches(node)) && prep.lowForm().matches("[ai]n")) {
                return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{DAT});
            }
            if (prep.lowForm().equals("in") && (animateArgumentMod.matches(node) || inZeitDative.matches(node) || esGibtPredicate.matches(predicate) || NodePattern.N.withHead("nmod", AgreementSet.copulaHead).withPhraseEnd(CommonPatterns.comma).matches(node) || inXXerJahre.matches(node) && !zurueckgehen.matches(predicate) || !NodePattern.N.directlyAfter(NodePattern.N.form("bis")).matches(prep) && SemanticRules.timeUnit.withDependent("nummod").matches(node))) {
                return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{DAT});
            }
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{AKK, DAT});
        }
        if (genPreposition.matches(prep)) {
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{GEN});
        }
        if (accPreposition.matches(prep)) {
            return FeatureRestriction.restricted((Node)prep, (Enum[])new Case[]{AKK});
        }
        return allCases;
    }

    static FeatureRestriction<Case> calcDirectArgumentCases(Node node) {
        Node head = node.head();
        if (esGibtArg.matches(node)) {
            return FeatureRestriction.restricted((String)node.tree().treeSupport().quote("es gibt"), (Enum[])new Case[]{AKK});
        }
        if (esGehtArg.matches(node)) {
            return FeatureRestriction.restricted((String)node.tree().treeSupport().quote("es geht"), (Enum[])new Case[]{DAT});
        }
        boolean copulaDate = dateWithCopula.matches(node);
        if (node.headRelation().startsWith("nsubj") && !finiteXcomp.matches(head) && !AgreementSet.possiblyIncorrectSubj.matches(node) || copulaDate) {
            Node predicate = copulaDate ? node : Objects.requireNonNull(head);
            Node finite = Objects.requireNonNullElse(Case.findFiniteVerb(predicate), predicate);
            if (copulaWithDativeArg.matches(head)) {
                return FeatureRestriction.restricted((Node)finite, (Enum[])new Case[]{NOM, DAT});
            }
            return FeatureRestriction.restricted((Node)finite, (Enum[])new Case[]{NOM});
        }
        if (head == null || hasMisparsedHead.matches(node)) {
            return allCases;
        }
        if (possiblyMisshapedSubject.matches(node) || possiblyMisshapedCopulaSubject.matches(node)) {
            return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{NOM});
        }
        if (definitelyAccObj.matches(node)) {
            return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{AKK});
        }
        if (betreffendArg.matches(node)) {
            return FeatureRestriction.restricted((String)"betreffend", (Enum[])new Case[]{AKK});
        }
        if (definitelyDatObj.matches(node)) {
            return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{DAT});
        }
        if (definitelyGenObj.matches(node)) {
            return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{GEN});
        }
        if (looksLikeAccObj.matches(node)) {
            return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{AKK});
        }
        if (looksLikeDatObj.matches(node)) {
            return FeatureRestriction.restricted((Node)head, (Enum[])new Case[]{DAT});
        }
        return allCases;
    }

    @Nullable
    static Node findFiniteVerb(@NotNull Node predicate) {
        List<Node> auxVerbs = predicate.findDependents("cop|aux.*");
        if (auxVerbs.isEmpty()) {
            return NodePattern.or(GermanTreePatterns.finiteVerb, GermanTreePatterns.misspelledFiniteVerb).matches(predicate) && !finiteInAnotherConjunct.matches(predicate) ? predicate : null;
        }
        List finite = ((StreamEx)StreamEx.of(auxVerbs).filter(GermanTreePatterns.finiteVerb::matches)).toList();
        if (finite.size() == 1) {
            return (Node)finite.getFirst();
        }
        if (auxVerbs.size() == 1) {
            return null;
        }
        List nonInf = ((StreamEx)StreamEx.of((Collection)finite).filter(n -> !GermanTreePatterns.infinitive.matches((Node)n))).toList();
        if (nonInf.size() == 1) {
            return (Node)nonInf.getFirst();
        }
        List nonPass = ((StreamEx)StreamEx.of((Collection)finite).filter(n -> !NodePattern.N.withHeadRelation("aux:pass").matches((Node)n))).toList();
        if (nonPass.size() == 1) {
            return (Node)nonPass.getFirst();
        }
        return null;
    }

    static {
        bisZu = NodePattern.N.form("bis").directlyBefore(CommonPatterns.skipForward(NodePattern.N.form("hin"), NodePattern.N.form("zu")));
        anstelleVon = NodePattern.N.inFormSequence(0, "anstelle", "von");
        vor = NodePattern.N.form("vor");
        um = NodePattern.N.form("um");
        accPreposition = NodePattern.or(NodePattern.N.form("bis|durch|f(ue|\u00fc)r|gegen|ohne|wider").andNot(bisZu), um, AdjDeclination.accFusedPreposition);
        entsprechendOutsideNP = GermanTreePatterns.entsprechend.andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("amod")));
        genDatPreposition = NodePattern.or(AdjDeclination.recognizableGenOrDatPreposition.withHead("case", NodePattern.N.pos("SUB.*DAT.*").andNot(AdjDeclination.recognizableGenitive)), AdjDeclination.wegen.andOr(NodePattern.N.withHead("case", NodePattern.or(NodePattern.N.form("dem|denen|derer|anderem|manchem|Vergangenem"), NodePattern.N.pos("PRO:PER:.*"), NodePattern.N.inFormSequence(2, "ein", "paar", ".*"), NodePattern.N.withDependent("nmod", NodePattern.N.pos(".*GEN.*").beforeHead()))), NodePattern.N.directlyAfter(NodePattern.N.pos("SUB:GEN.*"))), NodePattern.N.form("entlang|innerhalb").withHead(NodePattern.N.pos(".*:PLU:.*").noDependents("det(:poss)?")).beforeHead(), AdjDeclination.anStatt.withHead("case", NodePattern.N.pos("PRO.*")), entsprechendOutsideNP, NodePattern.N.form("laut|trotz|dank"), AdjDeclination.waehrend);
        prepDativeOnly = NodePattern.N.form("mit|nach|aus|zu|von|bei|seit|au(ss|\u00df)er|gegen(ue|\u00fc)ber|gem(ae|\u00e4)\u00df|nahe|ab");
        datPreposition = NodePattern.or(prepDativeOnly, NodePattern.N.form("statt").withHead("case", NodePattern.N.withHead("nmod", NodePattern.N.withDependent("case", prepDativeOnly))), entsprechendOutsideNP, NodePattern.or(NodePattern.N.form("in").withHead("case", NodePattern.N.markAs("Noun").withHead("obl", NodePattern.N.markAs("Predicate").lemma("haben|wohnen|leben"))), NodePattern.N.form("an").withHead(NodePattern.N.markAs("Noun").withHead("obl", NodePattern.N.markAs("Predicate").lemma("lesen")))).andOr(NodePattern.markedNodeMatches("Noun", NodePattern.not(CommonPatterns.insideQuotes)), NodePattern.markedNodeMatches("Predicate", CommonPatterns.insideQuotes)), AdjDeclination.datFusedPreposition, NodePattern.N.pos(".*DAT\\+AKK").withHead("case", SpellingRules.noun.withHead("obl", NodePattern.N.lemma("treffen").withDependent("obj", NodePattern.N.pos("PRO:REF.*")))), anstelleVon);
        accDatPreposition = NodePattern.or(NodePattern.N.form("an|auf|hinter|in|neben|\u00fcber|ueber|unter|zwischen"), NodePattern.N.form("entlang").afterHead(), vor, bisZu);
        genPreposition = NodePattern.or(NodePattern.N.form("abz(ue|\u00fc)glich|abseits|angesichts|anhand|anl(ae|\u00e4)sslich|anstelle|aufgrund|au(ss|\u00df)erhalb|bez(ue|\u00fc)glich|halber|infolge|mithilfe|oberhalb|unterhalb|unweit|wegen|zugunsten").andNot(anstelleVon), NodePattern.N.form("inkl(usive)?").withHead("case", NodePattern.or(NodePattern.N.withDependent("det(:poss)?|amod"), NodePattern.N.withDependent("conj", NodePattern.N.withDependent("det(:poss)?|amod")))), NodePattern.N.form("innerhalb").andOr(NodePattern.N.withHead(NodePattern.N.onlyPos(".*:SIN:.*")), NodePattern.N.withHead(NodePattern.N.pos(".*PLU.*").withDependent("det(:poss)?"))).beforeHead(), NodePattern.N.form("entlang").withHead(NodePattern.N.pos(".*:SIN:.*")).beforeHead(), AdjDeclination.anStatt.andNot(NodePattern.N.withHead(NodePattern.N.withHead(NodePattern.N.pos("SUB.*").withHeadRelation("obl")))).andNot(NodePattern.N.withHead(NodePattern.N.markAs("stattObj").withHead("obl", NodePattern.N.withDependent("obj", NodePattern.N).andOr(NodePattern.N.before("stattObj"), NodePattern.N.withHeadRelation("ccomp|advcl"))))));
        notSubstantivatedVerb = NodePattern.or(NodePattern.N.noPos("SUB:.*"), NodePattern.N.withDependent("nsubj"));
        preferTransitiveInterpretation = NodePattern.N.lemma("machen");
        verbsWithAccUeberObject = NodePattern.or(Case.mayMissArgInContext("\u00fcberA"), NodePattern.N.form("dankbar").withDependent("cop", NodePattern.N.lemma("sein"))).noDependents("compound:prt").and(notSubstantivatedVerb);
        verbsWithAccAufObject = NodePattern.N.lemma("machen").withDependent("obj", NodePattern.N.form("[ms]ich|uns|euch")).noDependents("xcomp");
        verbsWithAccPrepObject = NodePattern.or(NodePattern.N.lemma("legen").noDependents("aux:pass").andNot(NodePattern.N.withDependent("obl").noDependents("obj")), NodePattern.N.lemma("einteilen")).andNot(CommonPatterns.severalDependents("obl")).noHeadRelation("xcomp").noDependents("compound:prt").and(notSubstantivatedVerb);
        verbsWithDatPrepObject = NodePattern.or(NodePattern.N.lemma("sein").withDependent("obl", NodePattern.N.label("GEO_POLITICAL_ENTITY").withDependent("case", NodePattern.N.form("in"))), NodePattern.N.lemma("sitzen|bleiben").andNot(NodePattern.N.withDependent("obl", NodePattern.N.inFormSequence(2, "bis", "auf", ".+es").pos("ADJ.*"))), NodePattern.N.lemma("stehen").noDependents("obl", NodePattern.N.form("Verf(\u00fc|ue)gung").noDependents("case", NodePattern.N.form("zu"))), NodePattern.N.lemma("liegen").noDependents("advmod", NodePattern.N.form("weit")).noDependents("obj")).noHeadRelation("xcomp").noDependents("xcomp|compound:prt").and(notSubstantivatedVerb);
        definitelyTransitive = NodePattern.custom(node -> {
            List<Valence> valences = GermanValences.get(node);
            if (valences.isEmpty()) {
                return false;
            }
            List<Valence> relevantStructures = valences.stream().filter(as -> !as.has("N") && as.hasAllObligatoryArguments((Node)node) && !as.arguments.isEmpty()).toList();
            return !relevantStructures.isEmpty() && relevantStructures.stream().allMatch(as -> as.hasAnyArgument(Set.of("A", "A:Inanim", "A:Anim")));
        });
        definitelyIntransitive = NodePattern.custom(node -> {
            List<Valence> valences = GermanValences.get(node);
            return !valences.isEmpty() && valences.stream().noneMatch(as -> as.has("A"));
        }).and(notSubstantivatedVerb);
        looksLikePassive = NodePattern.N.pos("PA2:PRD.*").noPos("VER:INF.*").andNot(NodePattern.N.withDependent("aux").noDependents("cop"));
        datArgumentFitsContext = NodePattern.custom((node, match) -> GermanValences.get(node).stream().anyMatch(as -> {
            Node thisDat = match.getMarkedNode("DatObj");
            boolean isDativeStructure = as.any(a -> a.presentable.equals("D") || a.presentable.equals("DRefl"));
            boolean everyArgInPlace = as.all(a -> {
                boolean isDat = a.presentable.equals("D") || a.presentable.equals("DRefl");
                Node found = a.findOn(node);
                return isDat || found != null && found != thisDat;
            });
            return isDativeStructure && everyArgInPlace;
        }) ? match : null);
        mayHaveDativeArgument = NodePattern.custom(node -> {
            List<Valence> valences = GermanValences.get(node);
            return valences.stream().anyMatch(as -> as.hasAnyArgument(Set.of("D", "DRefl"))) && valences.stream().allMatch(as -> as.hasAnyArgument(Set.of("D", "DRefl")) || !as.hasAllObligatoryArguments((Node)node));
        });
        definitelyDatObj = NodePattern.N.markAs("DatObj").andOr(NodePattern.N.withHead("expl:pv|iobj", datArgumentFitsContext.noDependents("xcomp|dep").noDependents("obj", NodePattern.N.onlyPos(".*DAT.*"))).andNot(NodePattern.N.withHead(NodePattern.N.lemma("sagen|erz\u00e4hlen").withDependent("nsubj", NodePattern.N.noPos("PRO.*").markAs("NSubj"))).before("NSubj")), NodePattern.not(NodePattern.N.onlyPos("PRO:PER:NOM.*")).withHead("i?obj", NodePattern.or(mayHaveDativeArgument.noDependents("obj", NodePattern.N.form("sich")).noDependents("expl:pv").noDependents("iobj", NodePattern.not(NodePattern.N.alreadyMarkedAs("DatObj"))), NodePattern.not(CommonPatterns.severalDependents("i?obj")).lemma("gratulieren|(ver|miss)trauen|folgen"), NodePattern.N.lemma("geben").noDependents("compound:prt").withDependent("advmod|obj", NodePattern.N.form("recht")), NodePattern.N.lemma("geh\u00f6ren|gefallen").andOr(NodePattern.N.noDependents("aux").withDependent("nsubj"), NodePattern.not(NodePattern.N.form("gef\u00e4llt|geh\u00f6rt"))).noDependents("obl", NodePattern.not(NodePattern.N.alreadyMarkedAs("DatObj"))), NodePattern.N.lemma("verdanken|zeichnen|schenken").withDependent("obj", NodePattern.not(NodePattern.N.alreadyMarkedAs("DatObj")))).noDependents("nsubj:pass").andNot(CommonPatterns.severalDependents("obj")).andNot(CommonPatterns.severalDependents("iobj")).noHeadRelation("xcomp")), ReflexivePronouns.anyReflexivePronoun.withHead("expl:pv|i?obj", NodePattern.or(NodePattern.N.lemma("geben|sagen|(weiter)?helfen|mitteilen|erlauben|w\u00fcnschen"), NodePattern.N.lemma("machen").withDependent("obj", NodePattern.N.form("sorgen|gedanken|vorw\u00fcrfe"))).noHeadRelation("xcomp")));
        definitelyGenObj = NodePattern.N.markAs("genObj").withHead("i?obj", NodePattern.custom(node -> {
            List<Valence> valences = GermanValences.get(node);
            return valences.stream().anyMatch(as -> as.hasAnyArgument(Set.of("G"))) && valences.stream().allMatch(as -> as.has("G") || !as.hasAllObligatoryArguments((Node)node));
        }));
        accNomAmbiguity = NodePattern.or(NodePattern.N.pos(".*AKK.*").pos(".*NOM.*").noPos("PRO:PER.*"), NodePattern.N.noPos());
        possiblyMisshapedSubject = NodePattern.or(NodePattern.N.pos("PRO:.*").beforeHead().withHead("iobj", definitelyTransitive.noDependents("obj").andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("nsubj")))).withNextSibling(NodePattern.or(accNomAmbiguity, NodePattern.N.noPos()).withHeadRelation("nsubj")), GermanTreePatterns.firstInPhraseAfterCommasOrConj.directlyBeforeHead().withHead(GermanTreePatterns.clause.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").noDependents("nsubj(:pass)?|expl").withDependent("ob[lj]|iobj|(adv|n)mod")).andOr(NodePattern.N.withHeadRelation("dep"), NodePattern.N.withHeadRelation("iobj").onlyPos(".*(AKK|NOM).*")));
        possiblyMisshapedCopulaSubject = NodePattern.N.beforeHead().withHead("i?obj", NodePattern.N.pos("VER:AUX.*").lemma("sein").withDependent("nsubj", NodePattern.N.markAs("CopulaSubj")).noDependents("xcomp|obl")).noDependents("acl").before("CopulaSubj");
        misparsedFlatHead = NodePattern.N.pos("SUB.*").markAs("Flat").andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("flat"))).withHead("flat|appos", NodePattern.or(CommonPatterns.letterWord.withDependent("nummod", NodePattern.N.directlyBeforeHead().noLemma("ein")), NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceAfter(), NodePattern.N.alreadyMarkedAs("Flat"))).andNot(CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("nmod"))), NodePattern.N.formCaseSensitive("\\p{Lu}+s?").label("ORGANIZATION|EVENT"), GermanTreePatterns.englishWord.form(".+ing").pos("SUB.*").noLabel(".*"), NodePattern.or(CommonPatterns.capitalizedMiddle.andOr(NodePattern.N.label(".*"), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.onlyPos(".*NEU.*")).noPos(".*NEU.*"), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.onlyPos(".*FEM.*")).noPos(".*FEM.*"), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.onlyPos(".*MAS.*")).noPos(".*MAS.*"), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.onlyPos(".*PLU.*")).noPos(".*PLU.*"), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.onlyPos(".*SIN.*")).noPos(".*SIN.*")).withDependent("flat|appos", NodePattern.N.noLabel(".*").withDependent("nmod")), CommonPatterns.upperCase.andNot(NodePattern.N.noLabel(".*").withDependent("flat|appos", NodePattern.N.label(".*")))).noLabel("ORGANIZATION").andOr(NodePattern.N.directlyBefore("Flat"), NodePattern.N.directlyBefore(CommonPatterns.skipForward(CommonPatterns.HYPHEN_LIKE_NODE.noSpaceAfter(), NodePattern.N.alreadyMarkedAs("Flat"))))).directlyBefore(CommonPatterns.skipForward(NodePattern.or(NodePattern.PUNCT, NodePattern.N.withHeadRelation("amod")), NodePattern.N.alreadyMarkedAs("Flat")))).unmark("Flat");
        hasMisparsedFlatHeadDependent = NodePattern.N.withDependent("flat|appos", misparsedFlatHead);
        possibleSubjectObjectAmbiguity = NodePattern.N.withHead("nsubj.*", NodePattern.or(NodePattern.N.pos(".*PA2.*"), NodePattern.N.pos(".*(INF|NEB).*"), NodePattern.N.pos("VER:3.*").withDependent("obj", hasMisparsedFlatHeadDependent)).noDependents("cop|aux(:pass)?").andNot(definitelyIntransitive)).andOr(accNomAmbiguity.withHead("nsubj", NodePattern.or(NodePattern.N.noDependents("obj|xcomp"), NodePattern.N.withDependent("obj", NodePattern.or(NodePattern.N.formCaseSensitive("Sie"), GermanTreePatterns.whPhrase, hasMisparsedFlatHeadDependent.withDependent("flat", NodePattern.N.onlyPos(".*NOM.*"))))).noDependents("mark").andNot(NodePattern.N.lemma("sein"))), NodePattern.N.withHead("nsubj:pass", NodePattern.N.noDependents("aux.*")));
        definitelyAccObj = NodePattern.N.markAs("accObj").andOr(ReflexivePronouns.anyReflexivePronoun.noForm("sich").withHead("expl:pv", NodePattern.N.noDependents("obj")), NodePattern.N.withHeadRelation("obj"), NodePattern.N.withHead("iobj", NodePattern.not(looksLikePassive).noDependents("obj").andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("obj"))).andNot(Case.mayHaveArg("D").noLemma("sehen").withDependent("iobj", NodePattern.N.pos("PRO:PER.*"))).noDependents("expl:pv", ReflexivePronouns.accReflexivPronomen)), NodePattern.N.withHead("conj", definitelyTransitive).withOnlyDependents(NodePattern.N.withHeadRelation("det.*|cc"))).andNot(definitelyDatObj.onlyPos(".*DAT.*")).andNot(NodePattern.or(NodePattern.N.onlyPos(".*NOM.*"), hasMisparsedFlatHeadDependent.withDependent("flat", NodePattern.N.onlyPos(".*NOM.*"))).withHead(NodePattern.N.withDependent("nsubj(:pass)?", possibleSubjectObjectAmbiguity))).andNot(NodePattern.N.onlyPos("PRO.*DAT.*").withHead("iobj", NodePattern.N.withDependent("ob[lj]", NodePattern.not(SemanticRules.durableNoun)))).andNot(NodePattern.N.onlyPos(".*DAT.*").withHead("obj", NodePattern.N.lemma("sehen").withDependent("obl", NodePattern.N.inFormSequence(1, "ins", "auge")))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("dep"))).andOr(NodePattern.N.withHead(definitelyTransitive.noDependents("nsubj:pass").noDependents("expl(:pv)?", NodePattern.not(ReflexivePronouns.anyReflexivePronoun.noForm("sich"))).noDependents("iobj", NodePattern.N.onlyPos("SUB.*(AKK|NOM).*")).and(notSubstantivatedVerb).andNot(CommonPatterns.severalDependents("obj")).andNot(looksLikePassive.andOr(CommonPatterns.skipConjUp(NodePattern.N.noDependents("nsubj(:pass)?")), NodePattern.N.withDependent("cop|aux(:pass)?"))).noDependents("acl", NodePattern.N.afterHead().withDependent(".*", GermanTreePatterns.firstInPhraseAfterCommasOrConj.lemma("wer"))).markAs("Head").noDependents(".*", NodePattern.N.withDependent("punct", NodePattern.or(CommonPatterns.HYPHEN_NODE, CommonPatterns.DASH_NODE))).andNot(NodePattern.N.pos(".*EIZ.*").withHeadRelation("acl")).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()).withDependent("aux", NodePattern.N.lemma("sein"))).andNot(NodePattern.N.lemma("f\u00fchren").withDependent("obl", NodePattern.N.form("augen").withDependent("case", NodePattern.N.form("vor")))).andNot(NodePattern.N.lemma("fahren").withDependent("advmod", NodePattern.N.form("dazwischen"))).andNot(NodePattern.N.lemma("sehen").withDependent("advmod", NodePattern.N.form("\u00e4hnlich")))).andNot(NodePattern.N.withHead("obj", NodePattern.N.withDependent("iobj", NodePattern.N.noPos(".*").noDependents()))).andNot(NodePattern.N.withHead("iobj", NodePattern.N.withDependent("obj"))).andNot(NodePattern.or(NodePattern.N.withNextSibling(NodePattern.N.form(",").beforeHead()).beforeHead(), NodePattern.N.withPrevSibling(NodePattern.N.form(",").afterHead()).afterHead())).andNot(NodePattern.N.pos(".*:DAT:.*").andNot(CommonPatterns.insideQuotes).withHead(NodePattern.not(preferTransitiveInterpretation).withHead("conj", NodePattern.N.withDependent("obj")).and(Case.mayMissArgInContext("D")))), ReflexivePronouns.anyReflexivePronoun.withHead("expl(:pv)?|i?obj", NodePattern.N.lemma("bedanken|vertun|freuen")), NodePattern.N.form("es|das|geschichten?|unsinn|l(\u00fc|ue)gen?|information|ger(\u00fc|ue)chte?|k(\u00e4|ae)se").withHead("obj", NodePattern.N.lemma("glauben").noDependents("i?obj", NodePattern.not(NodePattern.N.alreadyMarkedAs("accObj"))).markAs("Head")));
        esGibtPredicate = NodePattern.N.lemma("geben").withDependent("expl|nsubj", NodePattern.N.form("[e'`\u00b4\u2019]s"));
        esGibtArg = NodePattern.N.withHead("nsubj|obj", esGibtPredicate);
        esGehtArg = NodePattern.N.withHead("i?obj|dep|advmod|nsubj", NodePattern.or(NodePattern.N.lemma("gehen").withDependent("expl|nsubj", NodePattern.N.form("[e'`\u00b4\u2019]s")), NodePattern.N.form("gehe?ts|gings")).noDependents("compound:prt").withDependent("xcomp|advmod")).andOr(NodePattern.N.noHeadRelation("nsubj"), NodePattern.N.pos("PRO:PER.*").noPos(".*NEU.*").withHead("nsubj", NodePattern.N.noDependents("iobj", NodePattern.N.pos("PRO:PER.*")))).andOr(NodePattern.N.noHeadRelation("obj"), NodePattern.N.withHead("obj", NodePattern.N.noDependents("iobj")));
        dateWithCopula = SemanticRules.dayOfWeek.withDependent("cop").withDependent("appos", NodePattern.or(GermanDateChecker.dottedDateNode, GermanDateChecker.numDotMonth));
        predicativeWithDativeArg = NodePattern.N.pos("ADJ:PRD.*").noLemma("unterschiedlich|rot|sch\u00f6n|kurz");
        singular = NodePattern.N.pos(".*SIN.*");
        copulaWithDativeArg = NodePattern.N.lemma("werden").withDependent("xcomp", predicativeWithDativeArg).andOr(singular, NodePattern.N.withDependent("cop|aux.*", singular));
        betreffendArg = NodePattern.N.withHeadRelation("nmod|obl|obj").noDependents("case").withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.form("betreffend")));
        finiteInAnotherConjunct = NodePattern.or(NodePattern.N.markAs("Conj").withHead("conj", CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("cop|aux.*", NodePattern.N.after("Conj")))), NodePattern.N.pos("(VER:INF|PA2).*").withDependent("conj", NodePattern.N.withDependent("cop|aux.*")));
        wartenAufAkkObj = NodePattern.N.lemma("Ankunft|Antwort|Anruf|Besuch|Lieferung|Moment|Nachricht|Reaktion|R\u00fcckkehr|(R\u00fcck)meldung|Treffen");
        allCases = new FeatureRestriction<Case>("Der Kontext", EnumSet.allOf(Case.class));
        willen = NodePattern.N.form("willen");
        looksLikeAccUeberVerb = verbsWithAccUeberObject.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("\u00fcber")));
        withEllipsis = NodePattern.N.withDependent("punct", CommonPatterns.ellipsis);
        trueNMod = NodePattern.or(CommonPatterns.closestDepToHead, NodePattern.N.withPrevSibling(CommonPatterns.closestDepToHead.withHeadRelation("nmod"))).withHeadRelation("nmod");
        XXerJahre = NodePattern.N.lemma("Jahr").withDependent("amod", NodePattern.N.form("\\d{2}(\\d{2})?er"));
        inXXerJahre = XXerJahre.withDependent("case", NodePattern.N.form("in")).andNot(CommonPatterns.severalDependents("case"));
        inZeitDative = NodePattern.N.lemma("zeit").andNot(CommonPatterns.severalDependents("case")).withHead("obl", NodePattern.N.noLemma("datieren"));
        zurueckgehen = NodePattern.N.lemma("(zur\u00fcck)?gehen");
        animateArgumentMod = NodePattern.N.withHead("nmod", SemanticRules.animate.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound"));
        alsX = NodePattern.not(CommonPatterns.severalDependents("case")).withPhraseStart(NodePattern.N.withHeadRelation("case").form("als")).withHead("obl", GermanTreePatterns.clause.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").andNot(CommonPatterns.severalDependents("obl").noDependents("cop")).noDependents("iobj").andNot(NodePattern.N.withDependent("cop").withDependent("obj"))).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("advmod").withDependent("case", NodePattern.N.form("vor"))));
        mehrAlsX = NodePattern.N.withHead("nmod", NodePattern.N.withHeadRelation("advmod|nsubj|obj").inFormSequence(0, "mehr", "als"));
        looksLikeAccObj = NodePattern.or(NodePattern.N.withHead("nsubj", NodePattern.N.withHead("xcomp", definitelyTransitive.noDependents("nsubj:pass|i?obj|obl")).noDependents("aux(:pass)?|i?obj")), NodePattern.N.withHead("obj", NodePattern.N.withDependent("iobj", ReflexivePronouns.datReflexivPronomen)), NodePattern.not(SemanticRules.animate).pos("SUB.*").markAs("AccObj").withHead("obj", NodePattern.N.withDependent("iobj", NodePattern.or(SemanticRules.animate, NodePattern.N.pos("PRO:PER.*")).andOr(NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("AccObj")), NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("AccObj"))))), NodePattern.N.withHead("iobj", Case.mayHaveArg("A").andNot(Case.mayHaveArg("D")).andNot(Case.mayHaveArg("G")).noDependents("obj|conj|xcomp|ccomp|acl|(aux|nsubj):pass|cop|dep").noHeadRelation("conj")), SemanticRules.timeUnit.withHead("ob[lj]|iobj", NodePattern.N.withDependent("cop")).withPhraseStart(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.noHeadRelation("case"))));
        looksLikeDatObj = NodePattern.or(NodePattern.N.withHead("iobj", Case.mayHaveArg("D").andOr(NodePattern.N.withDependent("obj", NodePattern.N.noPos(".*DAT.*")), NodePattern.N.withDependent("nsubj:pass"))), SemanticRules.animate.withHead("i?obj", Case.mayHaveArg("D:Anim")), NodePattern.or(SemanticRules.animate, NodePattern.N.pos("PRO:PER.*")).noPos(".*GEN.*").markAs("DatObj").withHead("iobj", NodePattern.not(Case.mayHaveArg("refl")).andNot(Case.mayHaveArg("A:Inanim")).withDependent("obj", NodePattern.not(SemanticRules.animate).pos("SUB.*").noPos(".*DAT.*").andOr(NodePattern.N.withPrevSibling(NodePattern.N.alreadyMarkedAs("DatObj")), NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("DatObj"))))));
        hasMisparsedHead = NodePattern.or(NodePattern.N.noHeadRelation("dep").withHead(NodePattern.N.withDependent("dep", NodePattern.N.onlyPos("VER.*"))), NodePattern.N.withHead("i?obj", NodePattern.N.withDependent("cop").noDependents("mark", NodePattern.N.form("zu"))));
        finiteXcomp = NodePattern.N.withHeadRelation("xcomp").noDependents("aux", NodePattern.N.beforeHead());
    }
}

