/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.groovy;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.groovy.GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyIncorrectDependencyNotationArgumentInspectionVisitor;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitMethodCall", "", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "intellij.gradle.java"})
public final class GroovyIncorrectDependencyNotationArgumentInspectionVisitor
extends GroovyElementVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public GroovyIncorrectDependencyNotationArgumentInspectionVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @NotNull
    public final ProblemsHolder getHolder() {
        return this.holder;
    }

    public void visitMethodCall(@NotNull GrMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        PsiMethod psiMethod = call.resolveMethod();
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        if (!(method instanceof OriginInfoAwareElement) || !Intrinsics.areEqual((Object)((OriginInfoAwareElement)method).getOriginInfo(), (Object)"by Gradle, configuration method")) {
            return;
        }
        GrExpression[] grExpressionArray = call.getArgumentList().getExpressionArguments();
        Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"getExpressionArguments(...)");
        GrExpression[] arguments = grExpressionArray;
        Object[] objectArray = call.getNamedArguments();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getNamedArguments(...)");
        Object[] namedArguments = objectArray;
        if (arguments.length == 0 && namedArguments.length == 0) {
            this.holder.registerProblem((PsiElement)call.getArgumentList(), GradleInspectionBundle.message("inspection.display.name.dependency.notation.required", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            return;
        }
        if (!(namedArguments.length == 0)) {
            List list = ArraysKt.asList((Object[])namedArguments);
            GrArgumentList grArgumentList = call.getArgumentList();
            Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"getArgumentList(...)");
            GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.access$checkNamedArguments(list, (PsiElement)grArgumentList, this.holder);
        }
        if (!(arguments.length == 0)) {
            List argumentsToCheck = GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.access$getObservableArguments(call, arguments);
            for (GrExpression argument : argumentsToCheck) {
                PsiType type = argument.getType();
                PsiType providerComponentType = GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.access$extractComponentType((PsiElement)argument, type, "org.gradle.api.provider.Provider");
                PsiType providerConvertibleType = GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.access$extractComponentType((PsiElement)argument, providerComponentType, "org.gradle.api.provider.ProviderConvertible");
                PsiType iterableComponentType = GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.access$extractComponentType((PsiElement)argument, providerConvertibleType, "java.lang.Iterable");
                GroovyIncorrectDependencyNotationArgumentInspectionVisitorKt.access$checkArgument(argument, iterableComponentType, this.holder);
            }
        }
    }
}

