/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.lang.Language;
import com.intellij.model.Symbol;
import com.intellij.model.search.LeafOccurrence;
import com.intellij.model.search.LeafOccurrenceMapper;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectReference;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectReferenceProviderKt;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol;
import org.jetbrains.plugins.gradle.service.resolve.ProjectReferenceSearchKt;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"searchGradleProjectReferences", "Lcom/intellij/util/Query;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectReference;", "project", "Lcom/intellij/openapi/project/Project;", "projectSymbol", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectSymbol;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "gradleProjectReferences", "", "occurrence", "Lcom/intellij/model/search/LeafOccurrence;", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nprojectReferenceSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 projectReferenceSearch.kt\norg/jetbrains/plugins/gradle/service/resolve/ProjectReferenceSearchKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1#2:46\n777#3:47\n873#3,2:48\n777#3:50\n873#3,2:51\n*S KotlinDebug\n*F\n+ 1 projectReferenceSearch.kt\norg/jetbrains/plugins/gradle/service/resolve/ProjectReferenceSearchKt\n*L\n35#1:47\n35#1:48,2\n38#1:50\n38#1:51,2\n*E\n"})
public final class ProjectReferenceSearchKt {
    @NotNull
    public static final Query<? extends GradleProjectReference> searchGradleProjectReferences(@NotNull Project project, @NotNull GradleProjectSymbol projectSymbol, @NotNull SearchScope searchScope) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectSymbol, (String)"projectSymbol");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        String p0 = string = projectSymbol.getProjectName();
        boolean bl = false;
        String string2 = ((CharSequence)p0).length() > 0 ? string : null;
        if (string2 == null) {
            Query query = EmptyQuery.getEmptyQuery();
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"getEmptyQuery(...)");
            return query;
        }
        String projectName = string2;
        SearchWordQueryBuilder searchWordQueryBuilder = SearchService.Companion.getInstance().searchWord(project, projectName).inScope(searchScope).inFilesWithLanguage((Language)GroovyLanguage.INSTANCE);
        SearchContext searchContext = SearchContext.inStrings();
        Intrinsics.checkNotNullExpressionValue((Object)searchContext, (String)"inStrings(...)");
        return searchWordQueryBuilder.inContexts(searchContext, new SearchContext[0]).buildQuery(LeafOccurrenceMapper.Companion.withPointer(projectSymbol.createPointer(), (LeafOccurrenceMapper.Parameterized)searchGradleProjectReferences.1.INSTANCE));
    }

    private static final Collection<GradleProjectReference> gradleProjectReferences(GradleProjectSymbol projectSymbol, LeafOccurrence occurrence) {
        PsiElement scope = occurrence.component1();
        PsiElement start = occurrence.component2();
        int offsetInStart = occurrence.component3();
        Iterator iterator = PsiTreeUtilKt.walkUp((PsiElement)start, (int)offsetInStart, (PsiElement)scope);
        while (iterator.hasNext()) {
            GradleProjectReference it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Pair pair = (Pair)iterator.next();
            PsiElement element = (PsiElement)pair.component1();
            int offsetInElement = ((Number)pair.component2()).intValue();
            if (!(element instanceof GrLiteral)) continue;
            Iterable iterable = GradleProjectReferenceProviderKt.getReferences((GrLiteral)element);
            boolean $i$f$filter = false;
            void var11_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GradleProjectReference)((Object)element$iv$iv);
                boolean bl = false;
                if (!it.getRangeInElement().containsOffset(offsetInElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GradleProjectReference)((Object)element$iv$iv);
                boolean bl = false;
                if (!it.resolvesTo((Symbol)projectSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    public static final /* synthetic */ Collection access$gradleProjectReferences(GradleProjectSymbol projectSymbol, LeafOccurrence occurrence) {
        return ProjectReferenceSearchKt.gradleProjectReferences(projectSymbol, occurrence);
    }
}

