/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.lang.LangCoreBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum ShortenCommandLine {
    NONE("shorten.command.line.method.none", "java [options] className [args]"),
    MANIFEST("shorten.command.line.method.jar.manifest", "java -cp classpath.jar className [args]"),
    CLASSPATH_FILE("shorten.command.line.method.classpath.file", "java WrapperClass classpathFile className [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot == null || !JdkUtil.isModularRuntime(jreRoot);
        }
    }
    ,
    ARGS_FILE("shorten.command.line.method.argfile", "java @argfile className [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot == null || JdkUtil.isModularRuntime(jreRoot);
        }
    };

    @PropertyKey(resourceBundle="messages.LangCoreBundle")
    private final @PropertyKey(resourceBundle="messages.LangCoreBundle") String myNameKey;
    @NlsSafe
    private final String myDescription;

    private ShortenCommandLine(String nameKey, String description) {
        this.myNameKey = nameKey;
        this.myDescription = description;
    }

    public boolean isApplicable(String jreRoot) {
        return true;
    }

    @NlsContexts.Label
    public String getDescription() {
        return this.myDescription;
    }

    @NlsContexts.Label
    public String getPresentableName() {
        return LangCoreBundle.message(this.myNameKey, new Object[0]);
    }

    @NotNull
    public static ShortenCommandLine getDefaultMethod(@Nullable Project project, String rootPath) {
        if (!JdkUtil.useDynamicClasspath(project)) {
            ShortenCommandLine shortenCommandLine = NONE;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(0);
            }
            return shortenCommandLine;
        }
        return ShortenCommandLine.getDefaultMethodForJdkLevel(rootPath);
    }

    @NotNull
    public static ShortenCommandLine getDefaultMethodForJdkLevel(@Nullable String rootPath) {
        if (rootPath != null && JdkUtil.isModularRuntime(rootPath)) {
            ShortenCommandLine shortenCommandLine = ARGS_FILE;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(1);
            }
            return shortenCommandLine;
        }
        if (JdkUtil.useClasspathJar()) {
            ShortenCommandLine shortenCommandLine = MANIFEST;
            if (shortenCommandLine == null) {
                ShortenCommandLine.$$$reportNull$$$0(2);
            }
            return shortenCommandLine;
        }
        ShortenCommandLine shortenCommandLine = CLASSPATH_FILE;
        if (shortenCommandLine == null) {
            ShortenCommandLine.$$$reportNull$$$0(3);
        }
        return shortenCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/ShortenCommandLine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMethodForJdkLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

