/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListenerBackgroundable;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileChangedNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance(FileChangedNotificationProvider.class);

    public FileChangedNotificationProvider() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(this){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    return;
                }
                for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                    if (project2.isDisposed()) continue;
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)project2);
                    for (VirtualFile file2 : FileEditorManager.getInstance((Project)project2).getSelectedFiles()) {
                        notifications.updateNotifications(file2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/ide/FileChangedNotificationProvider$1", "applicationActivated"));
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES_BG, (Object)new BulkFileListenerBackgroundable(this){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
                    return;
                }
                for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                    if (project2.isDisposed()) continue;
                    List openFilePaths = ContainerUtil.map((Object[])FileEditorManager.getInstance((Project)project2).getSelectedFiles(), f -> f.getPath());
                    EditorNotifications notifications = EditorNotifications.getInstance((Project)project2);
                    for (VFileEvent vFileEvent : events) {
                        VirtualFile file2;
                        String path = vFileEvent.getPath();
                        if (!openFilePaths.contains(path) || (file2 = vFileEvent.getFile()) == null) continue;
                        notifications.updateNotifications(file2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/FileChangedNotificationProvider$2", "after"));
            }
        });
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(1);
        }
        if (project2.isDisposed() || GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            return null;
        }
        VirtualFileSystem fs = file2.getFileSystem();
        if (!(fs instanceof LocalFileSystem)) {
            return null;
        }
        FileAttributes attributes = ((LocalFileSystem)fs).getAttributes(file2);
        if (attributes != null && file2.getTimeStamp() == attributes.lastModified && file2.getLength() == attributes.length) {
            return null;
        }
        return fileEditor -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("%s: (%s,%s) -> %s", file2, file2.getTimeStamp(), file2.getLength(), attributes));
            }
            return FileChangedNotificationProvider.createPanel(file2, fileEditor, project2);
        };
    }

    @NotNull
    private static EditorNotificationPanel createPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project2) {
        if (file2 == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(4);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
        panel2.setText(IdeBundle.message((String)"file.changed.externally.message", (Object[])new Object[0]));
        panel2.createActionLabel(IdeBundle.message((String)"file.changed.externally.reload", (Object[])new Object[0]), () -> {
            if (!project2.isDisposed()) {
                file2.refresh(false, false);
                EditorNotifications.getInstance((Project)project2).updateNotifications(file2);
            }
        });
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            FileChangedNotificationProvider.$$$reportNull$$$0(5);
        }
        return editorNotificationPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/FileChangedNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/FileChangedNotificationProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

