/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.LoggingSettingsChangesListener;
import com.intellij.ide.actions.ShowSettingsChangesLogFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/actions/ShowSettingsChangesLogFile;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ShowSettingsChangesLogFile
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ShowSettingsChangesLogFile() {
        super("Show Settings Changes Log File");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        File file2 = FileUtilRt.createTempFile((String)"settings-changes", (String)".txt", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        File file3 = file2;
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file3);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile tempFile = virtualFile2;
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project3).openFile(tempFile, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        FileEditor[] editor2 = fileEditorArray;
        boolean isLoggingEnabled = Boolean.parseBoolean(System.getProperty("ide.settings.log.persistent.changes", "false"));
        String initialText = isLoggingEnabled ? "// 1. Call 'Save All' action first\n// 2. Remove the file content\n// 3. Change the setting you want to observe\n// 4. Call 'Save All' action again\n\n" : "The persistent settings saving logging seems to be disabled.\nTo enable it, please add a JVM property '-Dide.settings.log.persistent.changes=true' and restart the IDE.\n";
        ApplicationManager.getApplication().invokeLater(() -> ShowSettingsChangesLogFile.actionPerformed$lambda$0(tempFile, initialText));
        if (isLoggingEnabled) {
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            FileEditor fileEditor = editor2[0];
            Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"get(...)");
            messageBus.connect((Disposable)fileEditor).subscribe(LoggingSettingsChangesListener.Companion.getTOPIC(), (Object)new LoggingSettingsChangesListener(tempFile){
                final /* synthetic */ VirtualFile $tempFile;
                {
                    this.$tempFile = $tempFile;
                }

                public void performed(LoggingSettingsChangesListener.Event event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    com.intellij.ide.actions.ShowSettingsChangesLogFile$Companion.access$getLOG(ShowSettingsChangesLogFile.Companion).debug(event.getChange());
                    ApplicationManager.getApplication().invokeLater(() -> actionPerformed.2.performed$lambda$0(this.$tempFile, event));
                }

                private static final void performed$lambda$0$0(VirtualFile $tempFile, LoggingSettingsChangesListener.Event $event) {
                    String string = VfsUtil.loadText((VirtualFile)$tempFile);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
                    String currentText = string;
                    VirtualFileUtil.writeText((VirtualFile)$tempFile, (String)(currentText + $event.getChange() + "\n"));
                }

                private static final void performed$lambda$0(VirtualFile $tempFile, LoggingSettingsChangesListener.Event $event) {
                    WriteAction.run(() -> actionPerformed.2.performed$lambda$0$0($tempFile, $event));
                }
            });
        }
        Disposer.register((Disposable)((Disposable)editor2[0]), () -> ShowSettingsChangesLogFile.actionPerformed$lambda$1(tempFile, this));
    }

    private static final void actionPerformed$lambda$0$0(VirtualFile $tempFile, String $initialText) {
        VirtualFileUtil.writeText((VirtualFile)$tempFile, (String)$initialText);
    }

    private static final void actionPerformed$lambda$1$0$0(VirtualFile $tempFile, ShowSettingsChangesLogFile this$0) {
        $tempFile.delete((Object)this$0);
    }

    private static final void actionPerformed$lambda$1$0(VirtualFile $tempFile, ShowSettingsChangesLogFile this$0) {
        WriteAction.run(() -> ShowSettingsChangesLogFile.actionPerformed$lambda$1$0$0($tempFile, this$0));
    }

    private static final void actionPerformed$lambda$0(VirtualFile $tempFile, String $initialText) {
        WriteAction.run(() -> ShowSettingsChangesLogFile.actionPerformed$lambda$0$0($tempFile, $initialText));
    }

    private static final void actionPerformed$lambda$1(VirtualFile $tempFile, ShowSettingsChangesLogFile this$0) {
        ApplicationManager.getApplication().invokeLater(() -> ShowSettingsChangesLogFile.actionPerformed$lambda$1$0($tempFile, this$0));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/actions/ShowSettingsChangesLogFile$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLOG() {
            Logger logger2 = Logger.getInstance(ShowSettingsChangesLogFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            return logger2;
        }

        public static final /* synthetic */ Logger access$getLOG(Companion $this) {
            return $this.getLOG();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

