/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.SettingsEntryPointAction;
import com.intellij.ide.ui.InProductNotificationAction;
import com.intellij.ide.ui.InProductNotificationDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.LicensingFacade;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000f\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/ui/InProductNotificationActionProvider;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$ActionProvider;", "Lcom/intellij/ide/actions/SettingsEntryPointAction$IconCustomizer;", "<init>", "()V", "getUpdateActions", "", "Lcom/intellij/ide/actions/SettingsEntryPointAction$UpdateAction;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getExpiresInDays", "", "getLastActions", "Lcom/intellij/ide/actions/SettingsEntryPointAction$LastAction;", "getCustomIcon", "Ljavax/swing/Icon;", "supplier", "Lcom/intellij/ui/BadgeIconSupplier;", "getTooltip", "", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class InProductNotificationActionProvider
implements SettingsEntryPointAction.ActionProvider,
SettingsEntryPointAction.IconCustomizer {
    @Override
    @NotNull
    public Collection<SettingsEntryPointAction.UpdateAction> getUpdateActions(@NotNull DataContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return CollectionsKt.emptyList();
    }

    private final int getExpiresInDays() {
        if (!InProductNotificationDialog.Companion.enabled()) {
            return -1;
        }
        Object object = LicensingFacade.getInstance();
        if (object == null || (object = ((LicensingFacade)object).metadata) == null) {
            return -1;
        }
        Object metadata = object;
        if (((String)metadata).length() > 10 && ((String)metadata).charAt(10) == 'E') {
            Object object2 = LicensingFacade.getInstance();
            if (object2 == null || (object2 = ((LicensingFacade)object2).expirationDate) == null) {
                return -1;
            }
            Object date = object2;
            int days = (int)ChronoUnit.DAYS.between(Instant.now(), ((Date)date).toInstant());
            return days;
        }
        return -1;
    }

    @Override
    @NotNull
    public Collection<SettingsEntryPointAction.LastAction> getLastActions(@NotNull DataContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        int days = this.getExpiresInDays();
        if (0 <= days && days < 15) {
            return CollectionsKt.listOf((Object)((Object)new InProductNotificationAction(days)));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public Icon getCustomIcon(@NotNull BadgeIconSupplier supplier) {
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
        int days = this.getExpiresInDays();
        if (0 <= days && days < 15) {
            return supplier.getInfoIcon();
        }
        return null;
    }

    @Override
    @Nullable
    public String getTooltip() {
        int days = this.getExpiresInDays();
        if (0 <= days && days < 15) {
            Object[] objectArray = new Object[]{ApplicationInfo.getInstance().getFullApplicationName(), days};
            return IdeBundle.message((String)"in.product.notification.action.tooltip", (Object[])objectArray);
        }
        return null;
    }
}

