/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.wm.impl.AbstractToolbarCombo;
import com.intellij.openapi.wm.impl.TextCutStrategy;
import com.intellij.ui.JBColor;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.BadLocationException;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0004J(\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J.\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0015H\u0004J\u0014\u0010\u001c\u001a\u00020\u0006*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J \u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\bH\u0005J\u001e\u0010$\u001a\u00020\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010%\u001a\u00020\u001eH\u0004J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020 H\u0016\u00a8\u0006("}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/AbstractToolbarComboUI;", "Ljavax/swing/plaf/ComponentUI;", "Ljava/beans/PropertyChangeListener;", "<init>", "()V", "setUIDefaults", "", "c", "Lcom/intellij/openapi/wm/impl/AbstractToolbarCombo;", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "tryUpdateHtmlRenderer", "widget", "text", "", "drawText", "fullText", "g", "Ljava/awt/Graphics2D;", "textRect", "Ljava/awt/Rectangle;", "paintIcons", "icons", "", "Ljavax/swing/Icon;", "combo", "rect", "cutLeft", "delta", "", "getBaseline", "Ljavax/swing/JComponent;", "width", "height", "getText", "calcIconsWidth", "gapBetweenIcons", "getMinimumSize", "Ljava/awt/Dimension;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class AbstractToolbarComboUI
extends ComponentUI
implements PropertyChangeListener {
    protected void setUIDefaults(@NotNull AbstractToolbarCombo c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        c.setForeground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.foreground", (Color)JBColor.foreground()));
        c.setBackground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.background", (Color)JBColor.background()));
        JBColor jBColor = JBColor.namedColor((String)"MainToolbar.Dropdown.hoverBackground", (Color)JBColor.background());
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        JBColor hoverBG = jBColor;
        c.setHoverBackground((Color)hoverBG);
        c.setTransparentHoverBackground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.transparentHoverBackground", (Color)((Color)hoverBG)));
        int maxWidth = UIManager.getInt("MainToolbar.Dropdown.maxWidth");
        if (maxWidth > 0) {
            UiSizeUtilKt.setMaximumWidth(c, maxWidth);
        }
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"text") || Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"font")) {
            Object object = evt.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.AbstractToolbarCombo");
            AbstractToolbarCombo widget2 = (AbstractToolbarCombo)object;
            this.tryUpdateHtmlRenderer(widget2, widget2.getText());
        }
    }

    protected final void tryUpdateHtmlRenderer(@NotNull AbstractToolbarCombo widget2, @Nullable String text2) {
        Intrinsics.checkNotNullParameter((Object)widget2, (String)"widget");
        if (widget2.getFont() == null && BasicHTML.isHTMLString(text2)) {
            return;
        }
        BasicHTML.updateRenderer(widget2, text2);
    }

    protected final void drawText(@NotNull AbstractToolbarCombo c, @NotNull String fullText, @NotNull Graphics2D g, @NotNull Rectangle textRect) {
        View v;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)fullText, (String)"fullText");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)textRect, (String)"textRect");
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        g.setColor(c.isEnabled() ? c.getForeground() : UIUtil.getLabelDisabledForeground());
        int baseline = c.getBaseline(c.getWidth(), c.getHeight());
        TextCutStrategy textCutStrategy = c.getTextCutStrategy();
        Intrinsics.checkNotNull((Object)metrics);
        String text2 = textCutStrategy.calcShownText(fullText, metrics, textRect.width, c);
        Rectangle strBounds = metrics.getStringBounds(text2, g).getBounds();
        strBounds.setLocation(RangesKt.coerceAtLeast((int)((int)(textRect.getCenterX() - strBounds.getCenterX())), (int)textRect.x), baseline);
        Object object = c.getClientProperty("html");
        View view2 = v = object instanceof View ? (View)object : null;
        if (v != null) {
            strBounds.y -= metrics.getAscent();
            v.paint(g, strBounds);
        } else {
            SwingUtilities2.drawString((JComponent)c, (Graphics)g, text2, strBounds.x, strBounds.y);
        }
    }

    @NotNull
    protected final Rectangle paintIcons(@NotNull List<? extends Icon> icons, @NotNull AbstractToolbarCombo combo2, @NotNull Graphics2D g, @NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(icons, (String)"icons");
        Intrinsics.checkNotNullParameter((Object)combo2, (String)"combo");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (icons.isEmpty()) {
            return new Rectangle();
        }
        Rectangle bounds = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        int maxHeight = 0;
        int minY = Integer.MAX_VALUE;
        int width = 0;
        for (Icon icon2 : icons) {
            if (width != 0) {
                width += combo2.getBetweenIconsGap();
            }
            int x = bounds.x + width;
            int y = bounds.y + bounds.height / 2 - icon2.getIconHeight() / 2;
            icon2.paintIcon(combo2, g, x, y);
            width += icon2.getIconWidth();
            maxHeight = Math.max(maxHeight, icon2.getIconHeight());
            minY = Math.min(minY, y);
        }
        return new Rectangle(rect.x, minY, width, maxHeight);
    }

    protected final void cutLeft(@NotNull Rectangle $this$cutLeft, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$cutLeft, (String)"<this>");
        $this$cutLeft.x += delta;
        $this$cutLeft.width -= delta;
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        super.getBaseline(c, width, height);
        AbstractToolbarCombo widget2 = (AbstractToolbarCombo)c;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(c, c.getFontMetrics(c.getFont()), this.getText(widget2), null, 0, 0, 0, 0, new Rectangle(width, height), iconRect, textRect, 0);
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return textRect.y + fm.getAscent();
    }

    @Nls
    @Nullable
    protected final String getText(@NotNull AbstractToolbarCombo widget2) {
        View v;
        Intrinsics.checkNotNullParameter((Object)widget2, (String)"widget");
        Object object = widget2.getClientProperty("html");
        View view2 = v = object instanceof View ? (View)object : null;
        if (v != null) {
            try {
                String string = v.getDocument().getText(0, v.getDocument().getLength());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                return text2;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return widget2.getText();
    }

    protected final int calcIconsWidth(@NotNull List<? extends Icon> icons, int gapBetweenIcons) {
        Intrinsics.checkNotNullParameter(icons, (String)"icons");
        int res = 0;
        for (Icon icon2 : icons) {
            if (res > 0) {
                res += gapBetweenIcons;
            }
            res += icon2.getIconWidth();
        }
        return res;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!(c instanceof AbstractToolbarCombo)) {
            return new Dimension();
        }
        Dimension preferredSize = ((AbstractToolbarCombo)c).getPreferredSize();
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        String string = ((AbstractToolbarCombo)c).getText();
        if (string == null) {
            string = "";
        }
        int currentTextWidth = UIUtil.computeStringWidth((JComponent)c, (String)string);
        TextCutStrategy textCutStrategy = ((AbstractToolbarCombo)c).getTextCutStrategy();
        String string2 = ((AbstractToolbarCombo)c).getText();
        if (string2 == null) {
            string2 = "";
        }
        Intrinsics.checkNotNull((Object)metrics);
        int minTextWidth = textCutStrategy.calcMinTextWidth(string2, metrics, c);
        return new Dimension(preferredSize.width - currentTextWidth + minTextWidth, preferredSize.height);
    }
}

