/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.NotificationAnnouncingMode;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.impl.NotificationsAnnouncerKt;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.ui.DoNotAskConfigurableUi;
import com.intellij.notification.impl.ui.NotificationSettingsUi;
import com.intellij.notification.impl.ui.NotificationSettingsWrapper;
import com.intellij.notification.impl.ui.NotificationsConfigurablePanel;
import com.intellij.notification.impl.ui.NotificationsConfigurableUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\r\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020 H\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u001bH\u0017J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010&\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020\u001eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/notification/impl/ui/NotificationsConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/notification/impl/NotificationsConfigurationImpl;", "Lcom/intellij/openapi/Disposable;", "settings", "<init>", "(Lcom/intellij/notification/impl/NotificationsConfigurationImpl;)V", "ui", "Lcom/intellij/openapi/ui/DialogPanel;", "notificationList", "Lcom/intellij/ui/components/JBList;", "Lcom/intellij/notification/impl/ui/NotificationSettingsWrapper;", "speedSearch", "com/intellij/notification/impl/ui/NotificationsConfigurableUi$speedSearch$1", "Lcom/intellij/notification/impl/ui/NotificationsConfigurableUi$speedSearch$1;", "useBalloonNotifications", "Ljavax/swing/JCheckBox;", "useSystemNotifications", "notificationSettings", "Lcom/intellij/notification/impl/ui/NotificationSettingsUi;", "myDoNotAskConfigurableUi", "Lcom/intellij/notification/impl/ui/DoNotAskConfigurableUi;", "screenReaderEnabledProperty", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "notificationModeToUserString", "", "Lcom/intellij/notification/NotificationAnnouncingMode;", "", "createNotificationList", "reset", "", "isModified", "", "isNotificationsModified", "enableSearch", "Ljava/lang/Runnable;", "option", "apply", "getComponent", "dispose", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nNotificationsConfigurableUi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsConfigurableUi.kt\ncom/intellij/notification/impl/ui/NotificationsConfigurableUi\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,177:1\n37#2,2:178\n*S KotlinDebug\n*F\n+ 1 NotificationsConfigurableUi.kt\ncom/intellij/notification/impl/ui/NotificationsConfigurableUi\n*L\n114#1:178,2\n*E\n"})
public final class NotificationsConfigurableUi
implements ConfigurableUi<NotificationsConfigurationImpl>,
Disposable {
    @NotNull
    private final DialogPanel ui;
    @NotNull
    private final JBList<NotificationSettingsWrapper> notificationList;
    @NotNull
    private final speedSearch.1 speedSearch;
    private JCheckBox useBalloonNotifications;
    private JCheckBox useSystemNotifications;
    private NotificationSettingsUi notificationSettings;
    @NotNull
    private final DoNotAskConfigurableUi myDoNotAskConfigurableUi;
    @NotNull
    private final AtomicBooleanProperty screenReaderEnabledProperty;
    @NotNull
    private final Map<NotificationAnnouncingMode, String> notificationModeToUserString;

    public NotificationsConfigurableUi(@NotNull NotificationsConfigurationImpl settings) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.notificationList = this.createNotificationList();
        Pair[] pairArray = this.notificationList;
        this.speedSearch = new ListSpeedSearch<NotificationSettingsWrapper>(pairArray){

            protected boolean isMatchingElement(Object element, String pattern) {
                if (super.isMatchingElement(element, pattern)) {
                    return true;
                }
                if (element != null && pattern != null) {
                    return super.isMatchingElement(element, NotificationGroup.Companion.getGroupTitle(pattern));
                }
                return false;
            }
        };
        this.myDoNotAskConfigurableUi = new DoNotAskConfigurableUi();
        this.screenReaderEnabledProperty = new AtomicBooleanProperty(GeneralSettings.Companion.getInstance().isSupportScreenReaders());
        if (SystemInfo.isMac) {
            pairArray = new Pair[]{TuplesKt.to((Object)NotificationAnnouncingMode.NONE, (Object)IdeBundle.message((String)"notifications.configurable.announcing.value.off", (Object[])new Object[0])), TuplesKt.to((Object)NotificationAnnouncingMode.MEDIUM, (Object)IdeBundle.message((String)"notifications.configurable.announcing.value.medium", (Object[])new Object[0])), TuplesKt.to((Object)NotificationAnnouncingMode.HIGH, (Object)IdeBundle.message((String)"notifications.configurable.announcing.value.high", (Object[])new Object[0]))};
            map2 = MapsKt.mapOf((Pair[])pairArray);
        } else {
            pairArray = new Pair[]{TuplesKt.to((Object)NotificationAnnouncingMode.NONE, (Object)IdeBundle.message((String)"notifications.configurable.announcing.value.off", (Object[])new Object[0])), TuplesKt.to((Object)NotificationAnnouncingMode.MEDIUM, (Object)IdeBundle.message((String)"notifications.configurable.announcing.value.not.interrupting", (Object[])new Object[0])), TuplesKt.to((Object)NotificationAnnouncingMode.HIGH, (Object)IdeBundle.message((String)"notifications.configurable.announcing.value.interrupting", (Object[])new Object[0]))};
            map2 = MapsKt.mapOf((Pair[])pairArray);
        }
        this.notificationModeToUserString = map2;
        this.speedSearch.setupListeners();
        this.ui = com.intellij.ui.dsl.builder.BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> NotificationsConfigurableUi._init_$lambda$0(this, settings, arg_0)));
        ScrollingUtil.ensureSelectionExists((JList)((JList)this.notificationList));
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> NotificationsConfigurableUi._init_$lambda$1(this, arg_0));
    }

    private final JBList<NotificationSettingsWrapper> createNotificationList() {
        List<NotificationSettingsWrapper> list2 = new NotificationsConfigurablePanel.NotificationsTreeTableModel().getAllSettings();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllSettings(...)");
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith((Iterable)list2, NotificationsConfigurableUi::createNotificationList$lambda$0);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JBList jBList = thisCollection$iv.toArray(new NotificationSettingsWrapper[0]);
        JBList $this$createNotificationList_u24lambda_u241 = jBList = new JBList((Object[])Arrays.copyOf(jBList, ((NotificationSettingsWrapper[])jBList).length));
        boolean bl = false;
        $this$createNotificationList_u24lambda_u241.setCellRenderer(BuilderKt.textListCellRenderer(NotificationsConfigurableUi::createNotificationList$lambda$1$0));
        $this$createNotificationList_u24lambda_u241.getSelectionModel().addListSelectionListener(arg_0 -> NotificationsConfigurableUi.createNotificationList$lambda$1$1($this$createNotificationList_u24lambda_u241, this, arg_0));
        $this$createNotificationList_u24lambda_u241.setSelectionMode(0);
        $this$createNotificationList_u24lambda_u241.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"notifications.configurable.notifications.list.accessible.name", (Object[])new Object[0]));
        return jBList;
    }

    public void reset(@NotNull NotificationsConfigurationImpl settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.ui.reset();
        int selectedIndex = this.notificationList.getSelectedIndex();
        this.notificationList.setModel(this.createNotificationList().getModel());
        this.notificationList.setSelectedIndex(selectedIndex);
        NotificationSettingsUi notificationSettingsUi = this.notificationSettings;
        if (notificationSettingsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationSettings");
            notificationSettingsUi = null;
        }
        Object object = this.notificationList.getSelectedValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSelectedValue(...)");
        notificationSettingsUi.updateUi((NotificationSettingsWrapper)object);
        this.myDoNotAskConfigurableUi.reset();
    }

    public boolean isModified(@NotNull NotificationsConfigurationImpl settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        return this.ui.isModified() || this.isNotificationsModified() || this.myDoNotAskConfigurableUi.isModified();
    }

    private final boolean isNotificationsModified() {
        int n = this.notificationList.getModel().getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!((NotificationSettingsWrapper)this.notificationList.getModel().getElementAt(i2)).hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Runnable enableSearch(@Nullable String option2) {
        if (option2 == null) {
            return null;
        }
        return () -> NotificationsConfigurableUi.enableSearch$lambda$0(this, option2);
    }

    public void apply(@NotNull NotificationsConfigurationImpl settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.ui.apply();
        int n = this.notificationList.getModel().getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            NotificationSettingsWrapper settingsWrapper = (NotificationSettingsWrapper)this.notificationList.getModel().getElementAt(i2);
            if (!settingsWrapper.hasChanged()) continue;
            settingsWrapper.apply();
        }
        this.myDoNotAskConfigurableUi.apply();
    }

    @NotNull
    public DialogPanel getComponent() {
        return this.ui;
    }

    public void dispose() {
    }

    private static final String lambda$0$2$0(NotificationsConfigurableUi this$0, NotificationAnnouncingMode it) {
        return this$0.notificationModeToUserString.get(it);
    }

    private static final Unit lambda$0$2$1(NotificationsConfigurationImpl $settings, NotificationAnnouncingMode it) {
        NotificationAnnouncingMode notificationAnnouncingMode = it;
        Intrinsics.checkNotNull((Object)notificationAnnouncingMode);
        $settings.setNotificationAnnouncingMode(notificationAnnouncingMode);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(NotificationsConfigurableUi this$0, NotificationsConfigurationImpl $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"notifications.configurable.display.balloon.notifications", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.useBalloonNotifications = (JCheckBox)ButtonKt.bindSelected($this$row.checkBox(string), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$settings){

            public Object get() {
                return ((NotificationsConfigurationImpl)((Object)this.receiver)).SHOW_BALLOONS;
            }

            public void set(Object value) {
                ((NotificationsConfigurationImpl)((Object)this.receiver)).SHOW_BALLOONS = (Boolean)value;
            }
        })).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(NotificationsConfigurableUi this$0, NotificationsConfigurationImpl $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"notifications.configurable.enable.system.notifications", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.useSystemNotifications = (JCheckBox)ButtonKt.bindSelected($this$row.checkBox(string), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$settings){

            public Object get() {
                return ((NotificationsConfigurationImpl)((Object)this.receiver)).SYSTEM_NOTIFICATIONS;
            }

            public void set(Object value) {
                ((NotificationsConfigurationImpl)((Object)this.receiver)).SYSTEM_NOTIFICATIONS = (Boolean)value;
            }
        })).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2(NotificationsConfigurationImpl $settings, NotificationsConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new NotificationAnnouncingMode[]{NotificationAnnouncingMode.NONE, NotificationAnnouncingMode.MEDIUM, NotificationAnnouncingMode.HIGH};
        List options2 = CollectionsKt.listOf((Object[])objectArray);
        Cell combo2 = ComboBoxKt.bindItem($this$row.comboBox(options2, BuilderKt.textListCellRenderer(arg_0 -> NotificationsConfigurableUi.lambda$0$2$0(this$0, arg_0))), (Function0)new Function0<NotificationAnnouncingMode>((Object)$settings){

            public final NotificationAnnouncingMode invoke() {
                return ((NotificationsConfigurationImpl)((Object)this.receiver)).getNotificationAnnouncingMode();
            }
        }, arg_0 -> NotificationsConfigurableUi.lambda$0$2$1($settings, arg_0));
        if (SystemInfo.isMac) {
            Cell.comment$default(combo2, IdeBundle.message((String)"notifications.configurable.announcing.comment", (Object[])new Object[0]), 0, null, 6, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$3(NotificationsConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object e = this$0.notificationList.getModel().getElementAt(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"getElementAt(...)");
        NotificationSettingsWrapper notificationSettingsWrapper = (NotificationSettingsWrapper)e;
        JCheckBox jCheckBox = this$0.useBalloonNotifications;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useBalloonNotifications");
            jCheckBox = null;
        }
        this$0.notificationSettings = new NotificationSettingsUi(notificationSettingsWrapper, ComponentPredicateKt.getSelected((AbstractButton)jCheckBox));
        $this$row.scrollCell((JComponent)this$0.notificationList);
        NotificationSettingsUi notificationSettingsUi = this$0.notificationSettings;
        if (notificationSettingsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationSettings");
            notificationSettingsUi = null;
        }
        $this$row.cell((JComponent)notificationSettingsUi.getUi()).align(AlignY.TOP.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$4(NotificationsConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell<JComponent> cell = $this$row.cell(this$0.myDoNotAskConfigurableUi.createComponent());
        String string = IdeBundle.message((String)"notifications.configurable.do.not.ask.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        cell.label(string, LabelPosition.TOP).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(NotificationsConfigurableUi this$0, NotificationsConfigurationImpl $settings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> NotificationsConfigurableUi.lambda$0$0(this$0, $settings, arg_0), 1, null);
        Panel.row$default($this$panel, null, arg_0 -> NotificationsConfigurableUi.lambda$0$1(this$0, $settings, arg_0), 1, null);
        if (NotificationsAnnouncerKt.isNotificationAnnouncerFeatureAvailable()) {
            String string = IdeBundle.message((String)"notifications.configurable.announcing.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> NotificationsConfigurableUi.lambda$0$2($settings, this$0, arg_0))).visibleIf((ObservableProperty<Boolean>)((ObservableProperty)this$0.screenReaderEnabledProperty));
        }
        Panel.row$default($this$panel, null, arg_0 -> NotificationsConfigurableUi.lambda$0$3(this$0, arg_0), 1, null);
        Panel.row$default($this$panel, null, arg_0 -> NotificationsConfigurableUi.lambda$0$4(this$0, arg_0), 1, null).topGap(TopGap.SMALL).resizableRow();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(NotificationsConfigurableUi this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.screenReaderEnabledProperty.set(GeneralSettings.Companion.getInstance().isSupportScreenReaders());
    }

    private static final String createNotificationList$lambda$1$0(NotificationSettingsWrapper it) {
        return it.toString();
    }

    private static final void createNotificationList$lambda$1$1(JBList $this_apply, NotificationsConfigurableUi this$0, ListSelectionEvent it) {
        block2: {
            NotificationSettingsWrapper notificationSettingsWrapper = (NotificationSettingsWrapper)$this_apply.getSelectedValue();
            if (notificationSettingsWrapper == null) break block2;
            NotificationSettingsWrapper it2 = notificationSettingsWrapper;
            boolean bl = false;
            NotificationSettingsUi notificationSettingsUi = this$0.notificationSettings;
            if (notificationSettingsUi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationSettings");
                notificationSettingsUi = null;
            }
            notificationSettingsUi.updateUi(it2);
            if (SystemInfo.isMac) {
                $this_apply.getAccessibleContext().firePropertyChange("AccessibleSelection", false, true);
            }
        }
    }

    private static final int createNotificationList$lambda$0(NotificationSettingsWrapper nsw1, NotificationSettingsWrapper nsw2) {
        return NaturalComparator.INSTANCE.compare(nsw1.toString(), nsw2.toString());
    }

    private static final void enableSearch$lambda$0(NotificationsConfigurableUi this$0, String $option) {
        this$0.speedSearch.findAndSelectElement($option);
    }
}

