/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CommandMergerFlushReason;
import com.intellij.openapi.command.impl.LocalUndoRedoSnapshot;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.PerClientLocalUndoRedoSnapshot;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.command.impl.StableEditorProvider;
import com.intellij.openapi.command.impl.UndoCapabilities;
import com.intellij.openapi.command.impl.UndoClientState;
import com.intellij.openapi.command.impl.UndoDocumentUtil;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.impl.UndoRedoListener;
import com.intellij.openapi.command.impl.UndoSharedState;
import com.intellij.openapi.command.impl.cmd.CmdEvent;
import com.intellij.openapi.command.impl.cmd.CmdIdService;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.ClientFileEditorManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeActionUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public class UndoManagerImpl
extends UndoManager {
    private static final Logger LOG = Logger.getInstance(UndoManagerImpl.class);
    @TestOnly
    public static boolean ourNeverAskUser = false;
    @Nullable
    private final Project myProject;
    @NotNull
    private final UndoSharedState myUndoSharedState;
    @Nullable
    private CurrentEditorProvider myOverriddenEditorProvider;

    public static boolean isRefresh() {
        return ExternalChangeActionUtil.isExternalChangeInProgress();
    }

    public static int getGlobalUndoLimit() {
        return Registry.intValue((String)"undo.globalUndoLimit");
    }

    public static int getDocumentUndoLimit() {
        return Registry.intValue((String)"undo.documentUndoLimit");
    }

    private UndoManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(0);
        }
        this((ComponentManager)project2);
    }

    private UndoManagerImpl() {
        this((ComponentManager)null);
    }

    @NonInjectable
    @ApiStatus.Internal
    protected UndoManagerImpl(@Nullable ComponentManager componentManager) {
        Project project2;
        this.myProject = componentManager instanceof Project ? (project2 = (Project)componentManager) : null;
        this.myUndoSharedState = new UndoSharedState(this.getUndoCapabilities());
    }

    public boolean isUndoAvailable(@Nullable FileEditor editor2) {
        return this.isUndoRedoAvailable(editor2, true);
    }

    public boolean isRedoAvailable(@Nullable FileEditor editor2) {
        return this.isUndoRedoAvailable(editor2, false);
    }

    @NotNull
    public Pair<String, String> getUndoActionNameAndDescription(FileEditor editor2) {
        return this.getUndoOrRedoActionNameAndDescription(editor2, true);
    }

    @NotNull
    public Pair<String, String> getRedoActionNameAndDescription(FileEditor editor2) {
        return this.getUndoOrRedoActionNameAndDescription(editor2, false);
    }

    public void undo(@Nullable FileEditor editor2) {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.isUndoAvailable(editor2));
        this.undoOrRedo(editor2, true);
    }

    public void redo(@Nullable FileEditor editor2) {
        ThreadingAssertions.assertEventDispatchThread();
        LOG.assertTrue(this.isRedoAvailable(editor2));
        this.undoOrRedo(editor2, false);
    }

    public boolean isUndoInProgress() {
        UndoClientState state2 = this.getClientState();
        return state2 != null && state2.isUndoInProgress();
    }

    public boolean isRedoInProgress() {
        UndoClientState state2 = this.getClientState();
        return state2 != null && state2.isRedoInProgress();
    }

    public void nonundoableActionPerformed(@NotNull DocumentReference ref2, boolean isGlobal) {
        if (ref2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        this.undoableActionPerformed(new NonUndoableAction(ref2, isGlobal));
    }

    public void undoableActionPerformed(@NotNull UndoableAction action2) {
        if (action2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        UndoClientState state2 = this.getClientState();
        if (state2 != null) {
            state2.addUndoableAction(this.getEditorProvider(), action2);
        }
    }

    public long getNextUndoNanoTime(@NotNull FileEditor editor2) {
        UndoClientState state2;
        if (editor2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(3);
        }
        return (state2 = this.getClientState(editor2)) == null ? -1L : state2.getNextNanoTime(editor2, true);
    }

    public long getNextRedoNanoTime(@NotNull FileEditor editor2) {
        UndoClientState state2;
        if (editor2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(4);
        }
        return (state2 = this.getClientState(editor2)) == null ? -1L : state2.getNextNanoTime(editor2, false);
    }

    public boolean isNextUndoAskConfirmation(@NotNull FileEditor editor2) {
        UndoClientState state2;
        if (editor2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(5);
        }
        return (state2 = this.getClientState(editor2)) != null && state2.isNextAskConfirmation(editor2, true);
    }

    public boolean isNextRedoAskConfirmation(@NotNull FileEditor editor2) {
        UndoClientState state2;
        if (editor2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(6);
        }
        return (state2 = this.getClientState(editor2)) != null && state2.isNextAskConfirmation(editor2, false);
    }

    public boolean isActive() {
        UndoClientState state2 = this.getClientState();
        return state2 != null && state2.isActiveForCurrentProject();
    }

    public void addDocumentAsAffected(@NotNull Document document2) {
        UndoClientState state2;
        if (document2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(7);
        }
        if ((state2 = this.getClientState()) != null) {
            state2.addDocumentAsAffected(DocumentReferenceManager.getInstance().create(document2));
        }
    }

    public void markCurrentCommandAsGlobal() {
        UndoClientState state2 = this.getClientState();
        if (state2 != null) {
            state2.markCurrentCommandAsGlobal();
        }
    }

    public void addAffectedFiles(VirtualFile ... files2) {
        UndoClientState state2;
        if (files2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(8);
        }
        if ((state2 = this.getClientState()) != null) {
            state2.addAffectedFiles(files2);
        }
    }

    public void invalidateActionsFor(@NotNull DocumentReference ref2) {
        if (ref2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        for (UndoClientState state2 : this.getAllClientStates()) {
            state2.invalidateActions(ref2);
        }
    }

    @NotNull
    public CurrentEditorProvider getEditorProvider() {
        CurrentEditorProvider overriddenProvider = this.myOverriddenEditorProvider;
        CurrentEditorProvider editorProvider = overriddenProvider != null ? overriddenProvider : (CurrentEditorProvider)ProgressManager.getInstance().computeInNonCancelableSection(CurrentEditorProvider::getInstance);
        return new StableEditorProvider(editorProvider);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @ApiStatus.Internal
    public boolean isInsideCommand() {
        UndoClientState state2 = this.getClientState();
        return state2 != null && state2.isInsideCommand();
    }

    @ApiStatus.Internal
    @Nullable
    public ResetUndoHistoryToken createResetUndoHistoryToken(@NotNull FileEditor editor2) {
        Collection<DocumentReference> references;
        if (editor2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(10);
        }
        if ((references = UndoDocumentUtil.getDocumentReferences(editor2)).size() != 1) {
            return null;
        }
        DocumentReference reference = references.iterator().next();
        LocalUndoRedoSnapshot snapshot2 = this.getUndoRedoSnapshotForDocument(reference);
        if (snapshot2 == null) {
            return null;
        }
        return new ResetUndoHistoryToken(this, reference, snapshot2);
    }

    @ApiStatus.Internal
    @NotNull
    public String dumpState(@Nullable FileEditor editor2, @NotNull String title2) {
        if (title2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(11);
        }
        String editorString = "dump for " + (editor2 == null ? "GLOBAL" : editor2.toString());
        String undoAvailable = String.valueOf(this.isUndoAvailable(editor2)).toUpperCase(Locale.ROOT);
        String redoAvailable = String.valueOf(this.isRedoAvailable(editor2)).toUpperCase(Locale.ROOT);
        Pair<String, String> undoDescription = this.getUndoActionNameAndDescription(editor2);
        Pair<String, String> redoDescription = this.getRedoActionNameAndDescription(editor2);
        String undoStatus = "undo: %s, %s, %s".formatted(undoAvailable, undoDescription.getFirst(), undoDescription.getSecond());
        String redoStatus = "redo: %s, %s, %s".formatted(redoAvailable, redoDescription.getFirst(), redoDescription.getSecond());
        String commandHistory = CmdIdService.getInstance().historyDump();
        UndoClientState state2 = this.getClientState(editor2);
        String stacks = state2 == null ? "no state" : state2.dump(editor2);
        String string = "\n_____________________________________________________________________________________________________________________\n%s\n%s\n%s\n%s\n%s\n%s\n_____________________________________________________________________________________________________________________\n".formatted(title2, editorString, undoStatus, redoStatus, commandHistory, stacks);
        if (string == null) {
            UndoManagerImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @ApiStatus.Internal
    public void clearDocumentReferences(@NotNull Document document2) {
        if (document2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertEventDispatchThread();
        for (UndoClientState state2 : this.getAllClientStates()) {
            state2.clearDocumentReferences(document2);
        }
        this.myUndoSharedState.clearDocumentReferences(document2);
    }

    @ApiStatus.Internal
    public void clearStacks(@Nullable FileEditor editor2) {
        for (UndoClientState state2 : this.getAllClientStates()) {
            state2.clearStacks(editor2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected void undoOrRedo(@Nullable FileEditor editor2, boolean isUndo) {
        UndoClientState state2 = this.getClientState(editor2);
        if (state2 != null) {
            String commandName = (String)this.getUndoOrRedoActionNameAndDescription(editor2, isUndo).getSecond();
            Disposable disposable = Disposer.newDisposable();
            Runnable beforeUndoRedoStarted = () -> this.notifyUndoRedoStarted(editor2, disposable, isUndo);
            try {
                state2.undoOrRedo(editor2, commandName, beforeUndoRedoStarted, isUndo);
            }
            finally {
                Disposer.dispose((Disposable)disposable);
            }
        }
    }

    @ApiStatus.Internal
    protected void notifyUndoRedoStarted(@Nullable FileEditor editor2, @NotNull Disposable disposable, boolean isUndo) {
        if (disposable == null) {
            UndoManagerImpl.$$$reportNull$$$0(14);
        }
        ((UndoRedoListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(UndoRedoListener.Companion.getTOPIC())).undoRedoStarted(this.myProject, this, editor2, isUndo, disposable);
    }

    @ApiStatus.Internal
    public UndoCapabilities getUndoCapabilities() {
        return UndoCapabilities.Default.INSTANCE;
    }

    @ApiStatus.Internal
    public final int getStackSize(@Nullable DocumentReference docRef, boolean isUndo) {
        UndoClientState state2 = Objects.requireNonNull(this.getClientState(), "undo/redo is not available");
        return state2.getStackSize(docRef, isUndo);
    }

    void onCommandStarted(@NotNull CmdEvent cmdStartEvent) {
        if (cmdStartEvent == null) {
            UndoManagerImpl.$$$reportNull$$$0(15);
        }
        for (UndoProvider undoProvider : this.getUndoProviders()) {
            undoProvider.commandStarted(cmdStartEvent.project());
        }
        UndoClientState state2 = this.getClientState();
        if (state2 != null) {
            state2.commandStarted(cmdStartEvent, this.getEditorProvider());
        }
    }

    void onCommandFinished(@NotNull CmdEvent cmdFinishEvent) {
        UndoClientState state2;
        if (cmdFinishEvent == null) {
            UndoManagerImpl.$$$reportNull$$$0(16);
        }
        if ((state2 = this.getClientState()) != null) {
            state2.commandFinished(cmdFinishEvent);
        }
        for (UndoProvider undoProvider : this.getUndoProviders()) {
            undoProvider.commandFinished(cmdFinishEvent.project());
        }
    }

    void onCommandFakeFinished(@NotNull CmdEvent cmdFakeFinishEvent) {
        UndoClientState state2;
        if (cmdFakeFinishEvent == null) {
            UndoManagerImpl.$$$reportNull$$$0(17);
        }
        if ((state2 = this.getClientState()) != null) {
            state2.commandFakeFinished(cmdFakeFinishEvent);
        }
    }

    void addAffectedDocuments(Document ... docs) {
        UndoClientState state2;
        if (docs == null) {
            UndoManagerImpl.$$$reportNull$$$0(18);
        }
        if ((state2 = this.getClientState()) != null) {
            state2.addAffectedDocuments(docs);
        }
    }

    @Nullable
    LocalUndoRedoSnapshot getUndoRedoSnapshotForDocument(@NotNull DocumentReference reference) {
        if (reference == null) {
            UndoManagerImpl.$$$reportNull$$$0(19);
        }
        HashMap<ClientId, PerClientLocalUndoRedoSnapshot> perClient = new HashMap<ClientId, PerClientLocalUndoRedoSnapshot>();
        for (UndoClientState state2 : this.getAllClientStates()) {
            PerClientLocalUndoRedoSnapshot perClientSnapshot = state2.getUndoRedoSnapshotForDocument(reference);
            if (perClientSnapshot == null) {
                return null;
            }
            perClient.put(state2.getClientId(), perClientSnapshot);
        }
        return new LocalUndoRedoSnapshot(Collections.unmodifiableMap(perClient), this.myUndoSharedState.getSharedUndoRedoSnapshot(reference));
    }

    boolean resetLocalHistory(@NotNull DocumentReference reference, @NotNull LocalUndoRedoSnapshot snapshot2) {
        if (reference == null) {
            UndoManagerImpl.$$$reportNull$$$0(20);
        }
        if (snapshot2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(21);
        }
        for (UndoClientState state2 : this.getAllClientStates()) {
            boolean success2;
            PerClientLocalUndoRedoSnapshot perClientSnapshot = snapshot2.getClientSnapshots().get(state2.getClientId());
            if (perClientSnapshot == null) {
                perClientSnapshot = PerClientLocalUndoRedoSnapshot.empty();
            }
            if (success2 = state2.resetLocalHistory(reference, perClientSnapshot)) continue;
            return false;
        }
        this.myUndoSharedState.resetLocalHistory(reference, snapshot2.getSharedSnapshot());
        return true;
    }

    boolean isUndoRedoAvailable(@NotNull DocumentReference docRef, boolean undo) {
        UndoClientState state2;
        if (docRef == null) {
            UndoManagerImpl.$$$reportNull$$$0(22);
        }
        return (state2 = this.getClientState()) != null && state2.isUndoRedoAvailable(Collections.singleton(docRef), undo);
    }

    @NotNull
    UndoSharedState getUndoSharedState() {
        UndoSharedState undoSharedState = this.myUndoSharedState;
        if (undoSharedState == null) {
            UndoManagerImpl.$$$reportNull$$$0(23);
        }
        return undoSharedState;
    }

    @TestOnly
    public void setOverriddenEditorProvider(@Nullable CurrentEditorProvider p) {
        this.myOverriddenEditorProvider = p;
    }

    @TestOnly
    public void dropHistoryInTests() {
        UndoClientState state2 = this.getClientState();
        if (state2 != null) {
            this.flushMergers();
            state2.dropHistoryInTests();
        }
    }

    @TestOnly
    public void flushCurrentCommandMerger() {
        UndoClientState state2 = this.getClientState();
        if (state2 != null) {
            state2.flushCommandMerger(CommandMergerFlushReason.MANAGER_FORCE);
        }
    }

    @TestOnly
    public void clearUndoRedoQueueInTests(@NotNull VirtualFile file2) {
        UndoClientState state2;
        if (file2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(24);
        }
        if ((state2 = this.getClientState()) != null) {
            DocumentReference docRef = DocumentReferenceManager.getInstance().create(file2);
            state2.clearUndoRedoQueue(docRef);
            this.myUndoSharedState.trimSharedStacks(docRef);
        }
    }

    @TestOnly
    public void clearUndoRedoQueueInTests(@NotNull Document document2) {
        UndoClientState state2;
        if (document2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(25);
        }
        if ((state2 = this.getClientState()) != null) {
            DocumentReference docRef = DocumentReferenceManager.getInstance().create(document2);
            state2.clearUndoRedoQueue(docRef);
            this.myUndoSharedState.trimSharedStacks(docRef);
        }
    }

    private @NotNull Pair<@NlsActions.ActionText String, @NlsActions.ActionDescription String> getUndoOrRedoActionNameAndDescription(@Nullable FileEditor editor2, boolean undo) {
        UndoClientState state2 = this.getClientState(editor2);
        String desc = null;
        if (state2 != null && state2.isUndoRedoAvailable(editor2, undo)) {
            desc = state2.getLastCommandName(editor2, undo);
        }
        if (desc == null) {
            desc = "";
        }
        String shortActionName = StringUtil.first((String)desc, (int)30, (boolean)true);
        if (desc.isEmpty()) {
            desc = undo ? ActionsBundle.message((String)"action.undo.description.empty", (Object[])new Object[0]) : ActionsBundle.message((String)"action.redo.description.empty", (Object[])new Object[0]);
        }
        String name2 = undo ? ActionsBundle.message((String)"action.undo.text", (Object[])new Object[]{shortActionName}) : ActionsBundle.message((String)"action.redo.text", (Object[])new Object[]{shortActionName});
        String description = undo ? ActionsBundle.message((String)"action.undo.description", (Object[])new Object[]{desc}) : ActionsBundle.message((String)"action.redo.description", (Object[])new Object[]{desc});
        Pair pair = Pair.create((Object)name2.trim(), (Object)description.trim());
        if (pair == null) {
            UndoManagerImpl.$$$reportNull$$$0(26);
        }
        return pair;
    }

    private boolean isUndoRedoAvailable(@Nullable FileEditor editor2, boolean undo) {
        ThreadingAssertions.assertEventDispatchThread();
        return this.isUndoRedoAvailableUnsafe(editor2, undo);
    }

    @ApiStatus.Internal
    protected boolean isUndoRedoAvailableUnsafe(@Nullable FileEditor editor2, boolean undo) {
        UndoClientState state2 = this.getClientState(editor2);
        return state2 != null && state2.isUndoRedoAvailable(editor2, undo);
    }

    @Nullable
    private UndoClientState getClientState() {
        try {
            return (UndoClientState)ProgressManager.getInstance().computeInNonCancelableSection(this::getClientStateUnsafe);
        }
        catch (Throwable ex) {
            LOG.error("Failed to get client state, the error may lead to undo inconsistency", ex);
            return null;
        }
    }

    @Nullable
    private UndoClientState getClientStateUnsafe() {
        ClientAppSession appSession;
        ClientId clientId = ClientId.getCurrentOrNull();
        if (clientId != null && (appSession = ClientSessionsManager.getAppSession((ClientId)clientId)) != null && appSession.isController()) {
            try (AccessToken ignored = ClientId.withExplicitClientId((ClientId)ClientId.getLocalId());){
                UndoClientState undoClientState = UndoClientState.getInstance(this.myProject);
                return undoClientState;
            }
        }
        return UndoClientState.getInstance(this.myProject);
    }

    @Nullable
    private UndoClientState getClientState(@Nullable FileEditor editor2) {
        UndoClientState state2 = this.getClientState();
        if (this.myProject == null || editor2 == null) {
            return state2;
        }
        try (AccessToken ignored = ClientId.withExplicitClientId((ClientId)ClientFileEditorManager.getClientId(editor2));){
            UndoClientState editorState = this.getClientState();
            LOG.assertTrue(state2 == editorState, (Object)("Using editor belonging to '" + (editorState != null ? editorState.getClientId().getValue() : "null") + "' under '" + (state2 != null ? state2.getClientId().getValue() : "null") + "'"));
        }
        return state2;
    }

    private @Unmodifiable @NotNull List<UndoClientState> getAllClientStates() {
        List<UndoClientState> list2 = UndoClientState.getAllInstances(this.myProject);
        if (list2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(27);
        }
        return list2;
    }

    @NotNull
    private List<UndoProvider> getUndoProviders() {
        List list2 = (List)ProgressManager.getInstance().computeInNonCancelableSection(() -> this.myProject == null ? UndoProvider.EP_NAME.getExtensionList() : UndoProvider.PROJECT_EP_NAME.getExtensionList((AreaInstance)this.myProject));
        if (list2 == null) {
            UndoManagerImpl.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @TestOnly
    private void flushMergers() {
        assert (this.myProject == null || !this.myProject.isDisposed()) : this.myProject;
        CommandProcessor.getInstance().executeCommand(this.myProject, EmptyRunnable.getInstance(), "Dummy", null);
    }

    public String toString() {
        return "UndoManager for " + String.valueOf(ObjectUtils.notNull((Object)this.myProject, (Object)"application"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 23, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoManagerImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdStartEvent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdFinishEvent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdFakeFinishEvent";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoManagerImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoSharedState";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoOrRedoActionNameAndDescription";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClientStates";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "nonundoableActionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "undoableActionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNextUndoNanoTime";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNextRedoNanoTime";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNextUndoAskConfirmation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNextRedoAskConfirmation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentAsAffected";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createResetUndoHistoryToken";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dumpState";
                break;
            }
            case 12: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyUndoRedoStarted";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onCommandStarted";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onCommandFinished";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onCommandFakeFinished";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addAffectedDocuments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getUndoRedoSnapshotForDocument";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resetLocalHistory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isUndoRedoAvailable";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "clearUndoRedoQueueInTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 23, 26, 27, 28 -> new IllegalStateException(string);
        };
    }
}

