/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actions.CaretStop;
import com.intellij.openapi.editor.actions.CaretStopPolicy;
import com.intellij.openapi.editor.actions.LanguageWordBoundaryFilter;
import com.intellij.openapi.editor.actions.WordBoundaryFilter;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.DocumentUtil;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorActionUtil {
    public static final Object EDIT_COMMAND_GROUP = Key.create((String)"EditGroup");
    public static final Object DELETE_COMMAND_GROUP = Key.create((String)"DeleteGroup");
    private static final Key<VisualPosition> PREV_POS = Key.create((String)"PREV_POS");

    private EditorActionUtil() {
    }

    public static void scrollRelatively(@NotNull Editor editor2, int lineShift, int columnShift, boolean moveCaret) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(0);
        }
        if (lineShift != 0) {
            editor2.getScrollingModel().scrollVertically(editor2.getScrollingModel().getVerticalScrollOffset() + lineShift * editor2.getLineHeight());
        }
        if (columnShift != 0) {
            editor2.getScrollingModel().scrollHorizontally(editor2.getScrollingModel().getHorizontalScrollOffset() + columnShift * EditorUtil.getSpaceWidth(0, editor2));
        }
        if (!moveCaret) {
            return;
        }
        Rectangle viewRectangle = EditorActionUtil.getVisibleArea(editor2);
        int lineNumber = editor2.getCaretModel().getVisualPosition().line;
        VisualPosition startPos = editor2.xyToVisualPosition(new Point(0, viewRectangle.y));
        int start2 = startPos.line + 1;
        VisualPosition endPos = editor2.xyToVisualPosition(new Point(0, viewRectangle.y + viewRectangle.height));
        int end = endPos.line - 2;
        if (lineNumber < start2) {
            editor2.getCaretModel().moveCaretRelatively(0, start2 - lineNumber, false, false, true);
        } else if (lineNumber > end) {
            editor2.getCaretModel().moveCaretRelatively(0, end - lineNumber, false, false, true);
        }
    }

    public static void moveCaretRelativelyAndScroll(@NotNull Editor editor2, int columnShift, int lineShift, boolean withSelection) {
        boolean scrollToCaret;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(1);
        }
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor2);
        VisualPosition pos = editor2.getCaretModel().getVisualPosition();
        Point caretLocation = editor2.visualPositionToXY(pos);
        int caretVShift = caretLocation.y - visibleArea.y;
        editor2.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, false);
        VisualPosition caretPos = editor2.getCaretModel().getVisualPosition();
        Point caretLocation2 = editor2.visualPositionToXY(caretPos);
        boolean bl = scrollToCaret = !(editor2 instanceof EditorImpl) || ((EditorImpl)editor2).isScrollToCaret();
        if (scrollToCaret) {
            editor2.getScrollingModel().scrollVertically(caretLocation2.y - caretVShift);
        }
    }

    public static void indentLine(Project project2, @NotNull Editor editor2, int lineNumber, int indent) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(2);
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        int newCaretOffset = EditorActionUtil.indentLine(project2, editor2, lineNumber, indent, caretOffset);
        editor2.getCaretModel().moveToOffset(newCaretOffset);
    }

    public static int indentLine(Project project2, @NotNull Editor editor2, int lineNumber, int indent, int caretOffset) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(3);
        }
        return EditorCoreUtil.indentLine((Project)project2, (Editor)editor2, (int)lineNumber, (int)indent, (int)caretOffset, (boolean)EditorActionUtil.shouldUseSmartTabs(project2, editor2));
    }

    public static boolean shouldUseSmartTabs(Project project2, @NotNull Editor editor2) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(4);
        }
        if (!(editor2 instanceof EditorEx)) {
            return false;
        }
        return CodeStyle.getIndentOptions((Project)project2, (Document)editor2.getDocument()).SMART_TABS;
    }

    public static void selectEntireLines(@NotNull Caret caret) {
        if (caret == null) {
            EditorActionUtil.$$$reportNull$$$0(5);
        }
        EditorActionUtil.selectEntireLines(caret, false);
    }

    public static void selectEntireLines(@NotNull Caret caret, boolean resetToSingleLineAtCaret) {
        Editor editor2;
        Document document2;
        int lineNumber;
        if (caret == null) {
            EditorActionUtil.$$$reportNull$$$0(6);
        }
        if ((lineNumber = caret.getLogicalPosition().line) >= (document2 = (editor2 = caret.getEditor()).getDocument()).getLineCount()) {
            return;
        }
        TextRange range = EditorUtil.calcSurroundingTextRange(editor2, resetToSingleLineAtCaret ? caret.getVisualPosition() : caret.getSelectionStartPosition(), resetToSingleLineAtCaret ? caret.getVisualPosition() : caret.getSelectionEndPosition());
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        caret.setSelection(range.getStartOffset(), range.getEndOffset());
    }

    @NotNull
    public static TextRange getRangeToWordEnd(@NotNull Editor editor2, boolean isCamel, boolean handleQuoted) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(7);
        }
        int startOffset = editor2.getCaretModel().getOffset();
        int endOffset = EditorActionUtil.getNextCaretStopOffset(editor2, CaretStopPolicy.BOTH, isCamel, handleQuoted);
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            EditorActionUtil.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getRangeToWordStart(@NotNull Editor editor2, boolean isCamel, boolean handleQuoted) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(9);
        }
        int endOffset = editor2.getCaretModel().getOffset();
        int startOffset = EditorActionUtil.getPreviousCaretStopOffset(editor2, CaretStopPolicy.WORD_START, isCamel, handleQuoted);
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            EditorActionUtil.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    @ApiStatus.Internal
    public static int getNextCaretStopOffset(@NotNull Editor editor2, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(11);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(12);
        }
        return EditorActionUtil.getNextCaretStopOffset(editor2, caretStopPolicy, isCamel, false);
    }

    @ApiStatus.Internal
    public static int getPreviousCaretStopOffset(@NotNull Editor editor2, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(13);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(14);
        }
        return EditorActionUtil.getPreviousCaretStopOffset(editor2, caretStopPolicy, isCamel, false);
    }

    @ApiStatus.Internal
    public static int getNextCaretStopOffset(@NotNull Editor editor2, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel, boolean handleQuoted) {
        int newOffsetBeforeQuote;
        HighlighterIterator tokenIterator;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(15);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(16);
        }
        int maxOffset = EditorActionUtil.getNextLineStopOffset(editor2, caretStopPolicy.getLineStop());
        CaretStop wordStop = caretStopPolicy.getWordStop();
        if (wordStop.equals((Object)CaretStop.NONE)) {
            return maxOffset;
        }
        int offset = editor2.getCaretModel().getOffset();
        if (offset == maxOffset) {
            return maxOffset;
        }
        CharSequence text2 = editor2.getDocument().getCharsSequence();
        int newOffset = EditorActionUtil.getNextWordStopOffset(text2, wordStop, tokenIterator = EditorActionUtil.createHighlighterIteratorAtOffset(editor2, offset), offset, maxOffset, isCamel);
        if (newOffset < maxOffset && handleQuoted && !tokenIterator.atEnd() && EditorActionUtil.isTokenStart(tokenIterator, newOffset - 1) && EditorActionUtil.isQuotedToken(tokenIterator, text2) && EditorActionUtil.isTokenEnd(tokenIterator, (newOffsetBeforeQuote = EditorActionUtil.getNextWordStopOffset(text2, CaretStop.BOTH, tokenIterator, newOffset, maxOffset, isCamel)) + 1)) {
            return EditorActionUtil.getNextWordStopOffset(text2, wordStop, tokenIterator, newOffsetBeforeQuote, maxOffset, isCamel);
        }
        return newOffset;
    }

    @ApiStatus.Internal
    public static int getPreviousCaretStopOffset(@NotNull Editor editor2, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel, boolean handleQuoted) {
        int newOffsetAfterQuote;
        HighlighterIterator tokenIterator;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(17);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(18);
        }
        int minOffset = EditorActionUtil.getPreviousLineStopOffset(editor2, caretStopPolicy.getLineStop());
        CaretStop wordStop = caretStopPolicy.getWordStop();
        if (wordStop.equals((Object)CaretStop.NONE)) {
            return minOffset;
        }
        int offset = editor2.getCaretModel().getOffset();
        if (offset == minOffset) {
            return minOffset;
        }
        CharSequence text2 = editor2.getDocument().getCharsSequence();
        int newOffset = EditorActionUtil.getPreviousWordStopOffset(text2, wordStop, tokenIterator = EditorActionUtil.createHighlighterIteratorAtOffset(editor2, offset - 1), offset, minOffset, isCamel);
        if (newOffset > minOffset && handleQuoted && !tokenIterator.atEnd() && EditorActionUtil.isTokenEnd(tokenIterator, newOffset + 1) && EditorActionUtil.isQuotedToken(tokenIterator, text2) && EditorActionUtil.isTokenStart(tokenIterator, (newOffsetAfterQuote = EditorActionUtil.getPreviousWordStopOffset(text2, CaretStop.BOTH, tokenIterator, newOffset, minOffset, isCamel)) - 1)) {
            return EditorActionUtil.getPreviousWordStopOffset(text2, wordStop, tokenIterator, newOffsetAfterQuote, minOffset, isCamel);
        }
        return newOffset;
    }

    private static int getNextWordStopOffset(@NotNull CharSequence text2, @NotNull CaretStop wordStop, @NotNull HighlighterIterator tokenIterator, int offset, int maxOffset, boolean isCamel) {
        boolean isTokenBoundary;
        int newOffset;
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(19);
        }
        if (wordStop == null) {
            EditorActionUtil.$$$reportNull$$$0(20);
        }
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(21);
        }
        for (newOffset = offset + 1; newOffset < maxOffset && !EditorActionUtil.isWordStopOffset(text2, wordStop, newOffset, isCamel, isTokenBoundary = EditorActionUtil.advanceTokenOnBoundary(tokenIterator, text2, newOffset)); ++newOffset) {
        }
        return newOffset;
    }

    private static int getPreviousWordStopOffset(@NotNull CharSequence text2, @NotNull CaretStop wordStop, @NotNull HighlighterIterator tokenIterator, int offset, int minOffset, boolean isCamel) {
        boolean isTokenBoundary;
        int newOffset;
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(22);
        }
        if (wordStop == null) {
            EditorActionUtil.$$$reportNull$$$0(23);
        }
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(24);
        }
        for (newOffset = offset - 1; newOffset > minOffset && !EditorActionUtil.isWordStopOffset(text2, wordStop, newOffset, isCamel, isTokenBoundary = EditorActionUtil.retreatTokenOnBoundary(tokenIterator, text2, newOffset)); --newOffset) {
        }
        return newOffset;
    }

    private static boolean isWordStopOffset(@NotNull CharSequence text2, @NotNull CaretStop wordStop, int offset, boolean isCamel, boolean isLexemeBoundary) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(25);
        }
        if (wordStop == null) {
            EditorActionUtil.$$$reportNull$$$0(26);
        }
        if (wordStop.isAtStart() && wordStop.isAtEnd()) {
            return isLexemeBoundary || EditorActionUtil.isWordStart(text2, offset, isCamel) || EditorActionUtil.isWordEnd(text2, offset, isCamel);
        }
        if (wordStop.isAtStart()) {
            return isLexemeBoundary && !EditorActionUtil.isWordEnd(text2, offset, isCamel) || EditorActionUtil.isWordStart(text2, offset, isCamel);
        }
        if (wordStop.isAtEnd()) {
            return isLexemeBoundary && !EditorActionUtil.isWordStart(text2, offset, isCamel) || EditorActionUtil.isWordEnd(text2, offset, isCamel);
        }
        return false;
    }

    private static boolean advanceTokenOnBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text2, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(27);
        }
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(28);
        }
        if (tokenIterator.atEnd()) {
            return false;
        }
        if (EditorActionUtil.isTokenEnd(tokenIterator, offset)) {
            IElementType leftToken = tokenIterator.getTokenType();
            boolean wasQuotedToken = EditorActionUtil.isQuotedToken(tokenIterator, text2);
            tokenIterator.advance();
            if (wasQuotedToken) {
                return true;
            }
            if (tokenIterator.atEnd()) {
                return false;
            }
            return EditorActionUtil.isQuotedToken(tokenIterator, text2) || !EditorActionUtil.isBetweenWhitespaces(text2, offset) && EditorActionUtil.isLexemeBoundary(leftToken, tokenIterator.getTokenType());
        }
        return EditorActionUtil.isQuotedTokenInnardsBoundary(tokenIterator, text2, offset);
    }

    private static boolean retreatTokenOnBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text2, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(30);
        }
        if (tokenIterator.atEnd()) {
            return false;
        }
        if (EditorActionUtil.isTokenStart(tokenIterator, offset)) {
            IElementType rightToken = tokenIterator.getTokenType();
            boolean wasQuotedToken = EditorActionUtil.isQuotedToken(tokenIterator, text2);
            tokenIterator.retreat();
            if (wasQuotedToken) {
                return true;
            }
            if (tokenIterator.atEnd()) {
                return false;
            }
            return EditorActionUtil.isQuotedToken(tokenIterator, text2) || !EditorActionUtil.isBetweenWhitespaces(text2, offset) && EditorActionUtil.isLexemeBoundary(tokenIterator.getTokenType(), rightToken);
        }
        return EditorActionUtil.isQuotedTokenInnardsBoundary(tokenIterator, text2, offset);
    }

    private static boolean isQuotedTokenInnardsBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text2, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(31);
        }
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(32);
        }
        return (EditorActionUtil.isTokenStart(tokenIterator, offset - 1) || EditorActionUtil.isTokenEnd(tokenIterator, offset + 1)) && EditorActionUtil.isQuotedToken(tokenIterator, text2);
    }

    private static boolean isTokenStart(@NotNull HighlighterIterator tokenIterator, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(33);
        }
        return offset == tokenIterator.getStart();
    }

    private static boolean isTokenEnd(@NotNull HighlighterIterator tokenIterator, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(34);
        }
        return offset == tokenIterator.getEnd();
    }

    private static boolean isQuotedToken(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text2) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(35);
        }
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(36);
        }
        int startOffset = tokenIterator.getStart();
        int endOffset = tokenIterator.getEnd();
        if (endOffset - startOffset < 2) {
            return false;
        }
        char openingQuote = EditorActionUtil.getQuoteAt(text2, startOffset);
        char closingQuote = EditorActionUtil.getQuoteAt(text2, endOffset - 1);
        return openingQuote != '\u0000' && closingQuote == openingQuote;
    }

    private static char getQuoteAt(@NotNull CharSequence text2, int offset) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(37);
        }
        if (offset < 0 || offset >= text2.length()) {
            return '\u0000';
        }
        char ch = text2.charAt(offset);
        return ch == '\'' || ch == '\"' ? ch : (char)'\u0000';
    }

    @NotNull
    private static HighlighterIterator createHighlighterIteratorAtOffset(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(38);
        }
        HighlighterIterator highlighterIterator = editor2.getHighlighter().createIterator(offset);
        if (highlighterIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(39);
        }
        return highlighterIterator;
    }

    private static boolean isLexemeBoundary(@Nullable IElementType leftTokenType, @Nullable IElementType rightTokenType) {
        return leftTokenType != null && rightTokenType != null && ((WordBoundaryFilter)LanguageWordBoundaryFilter.getInstance().forLanguage(rightTokenType.getLanguage())).isWordBoundary(leftTokenType, rightTokenType);
    }

    @ApiStatus.Internal
    public static int getNextLineStopOffset(@NotNull Editor editor2, @NotNull CaretStop lineStop) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(40);
        }
        if (lineStop == null) {
            EditorActionUtil.$$$reportNull$$$0(41);
        }
        Document document2 = editor2.getDocument();
        CaretModel caretModel = editor2.getCaretModel();
        int lineNumber = caretModel.getLogicalPosition().line;
        boolean isAtLineEnd = caretModel.getOffset() == document2.getLineEndOffset(lineNumber);
        return EditorActionUtil.getNextLineStopOffset(document2, lineStop, lineNumber, isAtLineEnd);
    }

    private static int getNextLineStopOffset(@NotNull Document document2, @NotNull CaretStop lineStop, int lineNumber, boolean isAtLineEnd) {
        if (document2 == null) {
            EditorActionUtil.$$$reportNull$$$0(42);
        }
        if (lineStop == null) {
            EditorActionUtil.$$$reportNull$$$0(43);
        }
        if (lineNumber + 1 >= document2.getLineCount()) {
            return document2.getTextLength();
        }
        if (!isAtLineEnd) {
            return lineStop.isAtEnd() ? document2.getLineEndOffset(lineNumber) : (lineStop.isAtStart() ? document2.getLineStartOffset(lineNumber + 1) : document2.getTextLength());
        }
        return lineStop.isAtStart() ? document2.getLineStartOffset(lineNumber + 1) : (lineStop.isAtEnd() ? document2.getLineEndOffset(lineNumber + 1) : document2.getTextLength());
    }

    @ApiStatus.Internal
    public static int getPreviousLineStopOffset(@NotNull Editor editor2, @NotNull CaretStop lineStop) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(44);
        }
        if (lineStop == null) {
            EditorActionUtil.$$$reportNull$$$0(45);
        }
        Document document2 = editor2.getDocument();
        CaretModel caretModel = editor2.getCaretModel();
        int lineNumber = caretModel.getLogicalPosition().line;
        boolean isAtLineStart = caretModel.getOffset() == document2.getLineStartOffset(lineNumber);
        return EditorActionUtil.getPreviousLineStopOffset(document2, lineStop, lineNumber, isAtLineStart);
    }

    private static int getPreviousLineStopOffset(@NotNull Document document2, @NotNull CaretStop lineStop, int lineNumber, boolean isAtLineStart) {
        if (document2 == null) {
            EditorActionUtil.$$$reportNull$$$0(46);
        }
        if (lineStop == null) {
            EditorActionUtil.$$$reportNull$$$0(47);
        }
        if (lineNumber - 1 < 0) {
            return 0;
        }
        if (!isAtLineStart) {
            return lineStop.isAtStart() ? document2.getLineStartOffset(lineNumber) : (lineStop.isAtEnd() ? document2.getLineEndOffset(lineNumber - 1) : 0);
        }
        return lineStop.isAtEnd() ? document2.getLineEndOffset(lineNumber - 1) : (lineStop.isAtStart() ? document2.getLineStartOffset(lineNumber - 1) : 0);
    }

    public static boolean isWordOrLexemeStart(@NotNull Editor editor2, int offset, boolean isCamel) {
        CharSequence chars;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(48);
        }
        return EditorActionUtil.isWordStart(chars = editor2.getDocument().getCharsSequence(), offset, isCamel) || !EditorActionUtil.isWordEnd(chars, offset, isCamel) && EditorActionUtil.isLexemeBoundary(editor2, offset);
    }

    public static boolean isWordOrLexemeEnd(@NotNull Editor editor2, int offset, boolean isCamel) {
        CharSequence chars;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(49);
        }
        return EditorActionUtil.isWordEnd(chars = editor2.getDocument().getCharsSequence(), offset, isCamel) || !EditorActionUtil.isWordStart(chars, offset, isCamel) && EditorActionUtil.isLexemeBoundary(editor2, offset);
    }

    public static boolean isLexemeBoundary(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(50);
        }
        if (offset <= 0 || offset >= editor2.getDocument().getTextLength() || DocumentUtil.isInsideSurrogatePair((Document)editor2.getDocument(), (int)offset) || EditorActionUtil.isBetweenWhitespaces(editor2.getDocument().getCharsSequence(), offset)) {
            return false;
        }
        EditorHighlighter highlighter = editor2.getHighlighter();
        HighlighterIterator it = highlighter.createIterator(offset);
        return EditorActionUtil.retreatTokenOnBoundary(it, editor2.getDocument().getCharsSequence(), offset);
    }

    public static void moveCaretToLineStart(@NotNull Editor editor2, boolean isWithSelection) {
        int logLineToUse;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(51);
        }
        Document document2 = editor2.getDocument();
        SelectionModel selectionModel = editor2.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor2.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        EditorSettings editorSettings = editor2.getSettings();
        int logCaretLine = caretModel.getLogicalPosition().line;
        VisualPosition currentVisCaret = caretModel.getVisualPosition();
        VisualPosition caretLogLineStartVis = editor2.offsetToVisualPosition(document2.getLineStartOffset(logCaretLine));
        if (currentVisCaret.line > caretLogLineStartVis.line) {
            if (editorSettings.isSmartHome()) {
                EditorActionUtil.moveCaretToStartOfSoftWrappedLine(editor2, currentVisCaret);
            } else {
                caretModel.moveToVisualPosition(new VisualPosition(currentVisCaret.line, 0));
            }
            EditorActionUtil.setupSelection(editor2, isWithSelection, selectionStart, blockSelectionStart);
            EditorModificationUtil.scrollToCaret((Editor)editor2);
            return;
        }
        for (logLineToUse = logCaretLine - 1; logLineToUse >= 0 && editor2.offsetToVisualPosition((int)document2.getLineEndOffset((int)logLineToUse)).line == currentVisCaret.line; --logLineToUse) {
        }
        if (++logLineToUse >= document2.getLineCount() || !editorSettings.isSmartHome()) {
            editor2.getCaretModel().moveToLogicalPosition(new LogicalPosition(logLineToUse, 0));
        } else if (logLineToUse == logCaretLine) {
            int column;
            int line = currentVisCaret.line;
            if (currentVisCaret.column == 0) {
                column = EditorActionUtil.findSmartIndentColumn(editor2, currentVisCaret.line);
            } else {
                column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor2, currentVisCaret.line);
                if (column >= currentVisCaret.column) {
                    column = 0;
                }
            }
            caretModel.moveToVisualPosition(new VisualPosition(line, Math.max(column, 0)));
        } else {
            LogicalPosition logLineEndLog = editor2.offsetToLogicalPosition(document2.getLineEndOffset(logLineToUse));
            VisualPosition logLineEndVis = editor2.logicalToVisualPosition(logLineEndLog);
            int softWrapCount = EditorUtil.getSoftWrapCountAfterLineStart(editor2, logLineEndLog);
            if (softWrapCount > 0) {
                EditorActionUtil.moveCaretToStartOfSoftWrappedLine(editor2, logLineEndVis);
            } else {
                int firstNonSpaceColumnOnTheLine;
                int line = logLineEndVis.line;
                int column = 0;
                if (currentVisCaret.column > 0 && (firstNonSpaceColumnOnTheLine = Math.max(0, EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor2, currentVisCaret.line))) < currentVisCaret.column) {
                    column = firstNonSpaceColumnOnTheLine;
                }
                caretModel.moveToVisualPosition(new VisualPosition(line, column));
            }
        }
        EditorActionUtil.setupSelection(editor2, isWithSelection, selectionStart, blockSelectionStart);
        EditorModificationUtilEx.scrollToCaret((Editor)editor2);
    }

    private static void moveCaretToStartOfSoftWrappedLine(@NotNull Editor editor2, VisualPosition currentVisual) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(52);
        }
        CaretModel caretModel = editor2.getCaretModel();
        int startLineOffset = editor2.visualPositionToOffset(new VisualPosition(currentVisual.line, 0));
        SoftWrapModel softWrapModel = editor2.getSoftWrapModel();
        SoftWrap softWrap = softWrapModel.getSoftWrap(startLineOffset);
        if (softWrap == null) {
            int column;
            int columnToMove = column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor2, currentVisual.line);
            if (column < 0 || currentVisual.column <= column && currentVisual.column > 0) {
                columnToMove = 0;
            }
            caretModel.moveToVisualPosition(new VisualPosition(currentVisual.line, columnToMove));
            return;
        }
        if (currentVisual.column > softWrap.getIndentInColumns()) {
            caretModel.moveToOffset(softWrap.getStart());
        } else if (currentVisual.column > 0) {
            caretModel.moveToVisualPosition(new VisualPosition(currentVisual.line, 0));
        } else {
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor2, startLineOffset);
            int visualLine = editor2.offsetToVisualPosition((int)lineStartOffset).line;
            caretModel.moveToVisualPosition(new VisualPosition(visualLine, Math.max(0, EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor2, visualLine))));
        }
    }

    private static int findSmartIndentColumn(@NotNull Editor editor2, int visualLine) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(53);
        }
        for (int i2 = visualLine; i2 >= 0; --i2) {
            int column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor2, i2);
            if (column < 0) continue;
            return column;
        }
        return 0;
    }

    public static int findFirstNonSpaceColumnOnTheLine(@NotNull Editor editor2, int visualLineNumber) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(54);
        }
        int startOffset = editor2.visualPositionToOffset(new VisualPosition(visualLineNumber, 0));
        int endOffset = EditorUtil.getNotFoldedLineEndOffset(editor2, startOffset);
        int offset = EditorActionUtil.findFirstNonSpaceOffsetInRange(editor2.getDocument().getImmutableCharSequence(), startOffset, endOffset);
        if (offset == -1) {
            return -1;
        }
        VisualPosition targetPosition = editor2.offsetToVisualPosition(offset, true, false);
        return targetPosition.line == visualLineNumber ? targetPosition.column : -1;
    }

    public static int findFirstNonSpaceOffsetOnTheLine(@NotNull Document document2, int lineNumber) {
        if (document2 == null) {
            EditorActionUtil.$$$reportNull$$$0(55);
        }
        int lineStart = document2.getLineStartOffset(lineNumber);
        int lineEnd = document2.getLineEndOffset(lineNumber);
        int result2 = EditorActionUtil.findFirstNonSpaceOffsetInRange(document2.getCharsSequence(), lineStart, lineEnd);
        return result2 >= 0 ? result2 : lineEnd;
    }

    public static int findFirstNonSpaceOffsetInRange(@NotNull CharSequence text2, int start2, int end) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(56);
        }
        while (start2 < end) {
            char c = text2.charAt(start2);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                return start2;
            }
            ++start2;
        }
        return -1;
    }

    public static void moveCaretToLineEnd(@NotNull Editor editor2, boolean isWithSelection) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(57);
        }
        EditorActionUtil.moveCaretToLineEnd(editor2, isWithSelection, true);
    }

    public static void moveCaretToLineEnd(@NotNull Editor editor2, boolean isWithSelection, boolean ignoreTrailingWhitespace) {
        int offset;
        VisualPosition visualEndOfLineWithCaret;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(58);
        }
        Document document2 = editor2.getDocument();
        SelectionModel selectionModel = editor2.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor2.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        SoftWrapModel softWrapModel = editor2.getSoftWrapModel();
        int lineNumber = editor2.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document2.getLineCount()) {
            LogicalPosition pos = new LogicalPosition(lineNumber, 0);
            editor2.getCaretModel().moveToLogicalPosition(pos);
            EditorActionUtil.setupSelection(editor2, isWithSelection, selectionStart, blockSelectionStart);
            EditorModificationUtilEx.scrollToCaret((Editor)editor2);
            return;
        }
        VisualPosition currentVisualCaret = editor2.getCaretModel().getVisualPosition();
        if (currentVisualCaret.equals((Object)(visualEndOfLineWithCaret = new VisualPosition(currentVisualCaret.line, EditorUtil.getLastVisualLineColumnNumber(editor2, currentVisualCaret.line), true))) && (offset = editor2.visualPositionToOffset(visualEndOfLineWithCaret)) < editor2.getDocument().getTextLength()) {
            int logicalLineEndOffset = EditorUtil.getNotFoldedLineEndOffset(editor2, offset);
            visualEndOfLineWithCaret = editor2.offsetToVisualPosition(logicalLineEndOffset, true, false);
        }
        LogicalPosition logLineEnd = editor2.visualToLogicalPosition(visualEndOfLineWithCaret);
        int offset2 = editor2.logicalPositionToOffset(logLineEnd);
        lineNumber = logLineEnd.line;
        int newOffset = offset2;
        CharSequence text2 = document2.getCharsSequence();
        int i2 = newOffset - 1;
        while (i2 >= document2.getLineStartOffset(lineNumber)) {
            if (softWrapModel.getSoftWrap(i2) != null) {
                newOffset = offset2;
                break;
            }
            if (text2.charAt(i2) != ' ' && text2.charAt(i2) != '\t') break;
            newOffset = i2--;
        }
        if (newOffset == offset2 || newOffset == caretModel.getOffset() || !ignoreTrailingWhitespace) {
            caretModel.moveToVisualPosition(visualEndOfLineWithCaret);
        } else if (editor2 instanceof EditorImpl) {
            caretModel.moveToLogicalPosition(editor2.offsetToLogicalPosition(newOffset).leanForward(true));
        } else {
            caretModel.moveToOffset(newOffset);
        }
        EditorModificationUtilEx.scrollToCaret((Editor)editor2);
        EditorActionUtil.setupSelection(editor2, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretToNextWord(@NotNull Editor editor2, boolean isWithSelection, boolean camel) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(59);
        }
        EditorActionUtil.moveToNextCaretStop(editor2, EditorSettingsExternalizable.getInstance().getCaretStopOptions().getForwardPolicy(), isWithSelection, camel);
    }

    @ApiStatus.Internal
    public static void moveToNextCaretStop(@NotNull Editor editor2, @NotNull CaretStopPolicy caretStopPolicy, boolean isWithSelection, boolean isCamel) {
        int boundaryOffset;
        int newOffset;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(60);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(61);
        }
        Document document2 = editor2.getDocument();
        SelectionModel selectionModel = editor2.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor2.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        int offset = caretModel.getOffset();
        if (offset == document2.getTextLength()) {
            return;
        }
        FoldRegion currentFoldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(offset);
        if (currentFoldRegion != null) {
            newOffset = currentFoldRegion.getEndOffset();
        } else {
            newOffset = EditorActionUtil.getNextCaretStopOffset(editor2, caretStopPolicy, isCamel);
            if (newOffset == offset) {
                return;
            }
            FoldRegion foldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(newOffset);
            if (foldRegion != null) {
                newOffset = foldRegion.getStartOffset();
            }
        }
        if (editor2 instanceof EditorImpl && (boundaryOffset = ((EditorImpl)editor2).findNearestDirectionBoundary(offset, true)) >= 0) {
            newOffset = Math.min(boundaryOffset, newOffset);
        }
        caretModel.moveToOffset(newOffset);
        EditorModificationUtilEx.scrollToCaret((Editor)editor2);
        EditorActionUtil.setupSelection(editor2, isWithSelection, selectionStart, blockSelectionStart);
    }

    private static void setupSelection(@NotNull Editor editor2, boolean isWithSelection, int selectionStart, @NotNull LogicalPosition blockSelectionStart) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(62);
        }
        if (blockSelectionStart == null) {
            EditorActionUtil.$$$reportNull$$$0(63);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        CaretModel caretModel = editor2.getCaretModel();
        if (isWithSelection) {
            if (editor2.isColumnMode() && !caretModel.supportsMultipleCarets()) {
                selectionModel.setBlockSelection(blockSelectionStart, caretModel.getLogicalPosition());
            } else {
                selectionModel.setSelection(selectionStart, caretModel.getVisualPosition(), caretModel.getOffset());
            }
        } else {
            selectionModel.removeSelection();
        }
        EditorActionUtil.selectNonexpandableFold(editor2);
    }

    public static void selectNonexpandableFold(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(64);
        }
        CaretModel caretModel = editor2.getCaretModel();
        VisualPosition pos = caretModel.getVisualPosition();
        VisualPosition prevPos = (VisualPosition)editor2.getUserData(PREV_POS);
        if (prevPos != null) {
            int columnShift = pos.line == prevPos.line ? pos.column - prevPos.column : 0;
            int caret = caretModel.getOffset();
            FoldRegion collapsedUnderCaret = editor2.getFoldingModel().getCollapsedRegionAtOffset(caret);
            if (collapsedUnderCaret != null && collapsedUnderCaret.shouldNeverExpand() && Boolean.TRUE.equals(collapsedUnderCaret.getUserData(FoldingKeys.SELECT_REGION_ON_CARET_NEARBY))) {
                if (caret > collapsedUnderCaret.getStartOffset() && columnShift > 0) {
                    caretModel.moveToOffset(collapsedUnderCaret.getEndOffset());
                } else if (caret + 1 < collapsedUnderCaret.getEndOffset() && columnShift < 0) {
                    caretModel.moveToOffset(collapsedUnderCaret.getStartOffset());
                }
                editor2.getSelectionModel().setSelection(collapsedUnderCaret.getStartOffset(), collapsedUnderCaret.getEndOffset());
            }
        }
        editor2.putUserData(PREV_POS, (Object)pos);
    }

    public static void moveCaretToPreviousWord(@NotNull Editor editor2, boolean isWithSelection, boolean camel) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(65);
        }
        EditorActionUtil.moveToPreviousCaretStop(editor2, EditorSettingsExternalizable.getInstance().getCaretStopOptions().getBackwardPolicy(), isWithSelection, camel);
    }

    @ApiStatus.Internal
    public static void moveToPreviousCaretStop(@NotNull Editor editor2, @NotNull CaretStopPolicy caretStopPolicy, boolean isWithSelection, boolean isCamel) {
        int newOffset;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(66);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(67);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor2.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        int offset = editor2.getCaretModel().getOffset();
        if (offset == 0) {
            return;
        }
        FoldRegion currentFoldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
        if (currentFoldRegion != null) {
            newOffset = currentFoldRegion.getStartOffset();
        } else {
            newOffset = EditorActionUtil.getPreviousCaretStopOffset(editor2, caretStopPolicy, isCamel);
            if (newOffset == offset) {
                return;
            }
            FoldRegion foldRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(newOffset);
            if (foldRegion != null && newOffset > foldRegion.getStartOffset()) {
                newOffset = foldRegion.getEndOffset();
            }
        }
        if (editor2 instanceof EditorImpl) {
            int boundaryOffset = ((EditorImpl)editor2).findNearestDirectionBoundary(offset, false);
            if (boundaryOffset >= 0) {
                newOffset = Math.max(boundaryOffset, newOffset);
            }
            caretModel.moveToLogicalPosition(editor2.offsetToLogicalPosition(newOffset).leanForward(true));
        } else {
            editor2.getCaretModel().moveToOffset(newOffset);
        }
        EditorModificationUtilEx.scrollToCaret((Editor)editor2);
        EditorActionUtil.setupSelection(editor2, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageUp(@NotNull Editor editor2, boolean isWithSelection) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(68);
        }
        int lineHeight = editor2.getLineHeight();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor2);
        editor2.getScrollingModel().scrollVertically(EditorActionUtil.adjustYToVisualLineBase(editor2, visibleArea.y - visibleArea.height / lineHeight * lineHeight));
        int lineShift = EditorActionUtil.calcVisualLineIncrement(editor2, editor2.getCaretModel().getVisualPosition().line, -visibleArea.height);
        editor2.getCaretModel().moveCaretRelatively(0, lineShift, isWithSelection, editor2.isColumnMode(), true);
    }

    public static void moveCaretPageDown(@NotNull Editor editor2, boolean isWithSelection) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(69);
        }
        int lineHeight = editor2.getLineHeight();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor2);
        int allowedBottom = ((EditorEx)editor2).getContentSize().height - visibleArea.height;
        editor2.getScrollingModel().scrollVertically(Math.min(allowedBottom, EditorActionUtil.adjustYToVisualLineBase(editor2, visibleArea.y + visibleArea.height / lineHeight * lineHeight)));
        int lineShift = EditorActionUtil.calcVisualLineIncrement(editor2, editor2.getCaretModel().getVisualPosition().line, visibleArea.height);
        editor2.getCaretModel().moveCaretRelatively(0, lineShift, isWithSelection, editor2.isColumnMode(), true);
    }

    public static void moveCaretToTextStart(@NotNull Editor editor2, @Nullable Project project2) {
        IdeDocumentHistory instance2;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(70);
        }
        editor2.getCaretModel().removeSecondaryCarets();
        editor2.getCaretModel().moveToOffset(0);
        editor2.getSelectionModel().removeSelection();
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        scrollingModel.enableAnimation();
        if (project2 != null && (instance2 = IdeDocumentHistory.getInstance(project2)) != null) {
            instance2.includeCurrentCommandAsNavigation();
        }
    }

    public static void moveCaretToTextEnd(@NotNull Editor editor2, @Nullable Project project2) {
        IdeDocumentHistory instance2;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(71);
        }
        editor2.getCaretModel().removeSecondaryCarets();
        int offset = editor2.getDocument().getTextLength();
        if (editor2 instanceof EditorImpl) {
            editor2.getCaretModel().moveToLogicalPosition(editor2.offsetToLogicalPosition(offset).leanForward(true));
        } else {
            editor2.getCaretModel().moveToOffset(offset);
        }
        editor2.getSelectionModel().removeSelection();
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollToCaret(ScrollType.CENTER);
        scrollingModel.enableAnimation();
        if (project2 != null && (instance2 = IdeDocumentHistory.getInstance(project2)) != null) {
            instance2.includeCurrentCommandAsNavigation();
        }
    }

    private static int adjustYToVisualLineBase(@NotNull Editor editor2, int y) {
        int visualLineBaseY;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(72);
        }
        return y > (visualLineBaseY = editor2.visualLineToY(editor2.yToVisualLine(y))) && y < visualLineBaseY + editor2.getLineHeight() ? visualLineBaseY : y;
    }

    private static int calcVisualLineIncrement(@NotNull Editor editor2, int visualLine, int yIncrement) {
        int targetVisualLine;
        int targetVisualLineBase;
        int startY;
        int targetY;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(73);
        }
        if ((targetY = (startY = editor2.visualLineToY(visualLine) + (yIncrement > 0 ? editor2.getLineHeight() - 1 : 0)) + yIncrement) < (targetVisualLineBase = editor2.visualLineToY(targetVisualLine = editor2.yToVisualLine(targetY)))) {
            if (yIncrement < 0) {
                --targetVisualLine;
            }
        } else if (targetY >= targetVisualLineBase + editor2.getLineHeight() && yIncrement > 0) {
            ++targetVisualLine;
        }
        return targetVisualLine - visualLine;
    }

    public static void moveCaretPageTop(@NotNull Editor editor2, boolean isWithSelection) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(74);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor2.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor2);
        int lineNumber = editor2.yToVisualLine(visibleArea.y);
        if (visibleArea.y > editor2.visualLineToY(lineNumber) && visibleArea.y + visibleArea.height > editor2.visualLineToY(lineNumber + 1)) {
            ++lineNumber;
        }
        VisualPosition pos = new VisualPosition(lineNumber, editor2.getCaretModel().getVisualPosition().column);
        editor2.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor2, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageBottom(@NotNull Editor editor2, boolean isWithSelection) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(75);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor2.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor2);
        int maxY = visibleArea.y + visibleArea.height - editor2.getLineHeight();
        int lineNumber = editor2.yToVisualLine(maxY);
        if (lineNumber > 0 && maxY < editor2.visualLineToY(lineNumber) && visibleArea.y <= editor2.visualLineToY(lineNumber - 1)) {
            --lineNumber;
        }
        VisualPosition pos = new VisualPosition(lineNumber, editor2.getCaretModel().getVisualPosition().column);
        editor2.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor2, isWithSelection, selectionStart, blockSelectionStart);
    }

    @NotNull
    private static Rectangle getVisibleArea(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(76);
        }
        ScrollingModel model2 = editor2.getScrollingModel();
        Rectangle rectangle = EditorCoreUtil.isTrueSmoothScrollingEnabled() ? model2.getVisibleAreaOnScrollingFinished() : model2.getVisibleArea();
        if (rectangle == null) {
            EditorActionUtil.$$$reportNull$$$0(77);
        }
        return rectangle;
    }

    private static boolean isBetweenWhitespaces(@NotNull CharSequence text2, int offset) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(78);
        }
        return 0 < offset && offset < text2.length() && Character.isWhitespace(text2.charAt(offset - 1)) && Character.isWhitespace(text2.charAt(offset));
    }

    public static boolean isWordStart(@NotNull CharSequence text2, int offset, boolean isCamel) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(79);
        }
        return EditorActionUtil.isWordBoundary(text2, offset, isCamel, true);
    }

    public static boolean isWordEnd(@NotNull CharSequence text2, int offset, boolean isCamel) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(80);
        }
        return EditorActionUtil.isWordBoundary(text2, offset, isCamel, false);
    }

    public static boolean isWordBoundary(@NotNull CharSequence text2, int offset, boolean isCamel, boolean isStart) {
        char neighbor;
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(81);
        }
        if (offset < 0 || offset > text2.length()) {
            return false;
        }
        char prev = offset > 0 ? text2.charAt(offset - 1) : (char)'\u0000';
        char curr = offset < text2.length() ? text2.charAt(offset) : (char)'\u0000';
        char word = isStart ? curr : prev;
        char c = neighbor = isStart ? prev : curr;
        if (Character.isJavaIdentifierPart(word)) {
            if (!Character.isJavaIdentifierPart(neighbor)) {
                return true;
            }
            if (isCamel && EditorActionUtil.isHumpBound(text2, offset, isStart)) {
                return true;
            }
        }
        return EditorActionUtil.isPunctuation(word) && !EditorActionUtil.isPunctuation(neighbor);
    }

    public static boolean isHumpBound(@NotNull CharSequence text2, int offset, boolean isStart) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(82);
        }
        if (offset <= 0 || offset >= text2.length()) {
            return false;
        }
        char prev = text2.charAt(offset - 1);
        char curr = text2.charAt(offset);
        char next = offset + 1 < text2.length() ? text2.charAt(offset + 1) : (char)'\u0000';
        char hump = isStart ? curr : prev;
        char neighbor = isStart ? prev : curr;
        return EditorActionUtil.isLowerCaseOrDigit(prev) && Character.isUpperCase(curr) || neighbor == '_' && hump != '_' || neighbor == '$' && Character.isLetterOrDigit(hump) || Character.isUpperCase(prev) && Character.isUpperCase(curr) && Character.isLowerCase(next);
    }

    private static boolean isLowerCaseOrDigit(char c) {
        return Character.isLowerCase(c) || Character.isDigit(c);
    }

    private static boolean isPunctuation(char c) {
        return !Character.isJavaIdentifierPart(c) && !Character.isWhitespace(c);
    }

    public static void moveCaretToLineStartIgnoringSoftWraps(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(83);
        }
        editor2.getCaretModel().moveToLogicalPosition((LogicalPosition)EditorUtil.calcCaretLineRange((Editor)editor2).first);
    }

    public static void makePositionVisible(@NotNull Editor editor2, int offset) {
        FoldRegion region;
        if (editor2 == null) {
            EditorActionUtil.$$$reportNull$$$0(84);
        }
        FoldingModel foldingModel = editor2.getFoldingModel();
        while ((region = foldingModel.getCollapsedRegionAtOffset(offset)) != null && !region.shouldNeverExpand()) {
            foldingModel.runBatchFoldingOperation(() -> region.setExpanded(true));
        }
    }

    public static void moveCaret(@NotNull Caret caret, int offset, boolean withSelection) {
        if (caret == null) {
            EditorActionUtil.$$$reportNull$$$0(85);
        }
        if (withSelection) {
            caret.setSelection(caret.getLeadSelectionOffset(), offset);
        } else {
            caret.removeSelection();
        }
        caret.moveToOffset(offset);
        EditorModificationUtilEx.scrollToCaret((Editor)caret.getEditor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 39, 77 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 6: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 8: 
            case 10: 
            case 39: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/EditorActionUtil";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 61: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStopPolicy";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 36: 
            case 37: 
            case 56: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordStop";
                break;
            }
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenIterator";
                break;
            }
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStop";
                break;
            }
            case 42: 
            case 46: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockSelectionStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/EditorActionUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToWordEnd";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToWordStart";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighterIteratorAtOffset";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scrollRelatively";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretRelativelyAndScroll";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "indentLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseSmartTabs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectEntireLines";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToWordEnd";
                break;
            }
            case 8: 
            case 10: 
            case 39: 
            case 77: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToWordStart";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNextCaretStopOffset";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousCaretStopOffset";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNextWordStopOffset";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousWordStopOffset";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isWordStopOffset";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "advanceTokenOnBoundary";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "retreatTokenOnBoundary";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedTokenInnardsBoundary";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isTokenStart";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isTokenEnd";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedToken";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteAt";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighterIteratorAtOffset";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNextLineStopOffset";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousLineStopOffset";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isWordOrLexemeStart";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isWordOrLexemeEnd";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isLexemeBoundary";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineStart";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToStartOfSoftWrappedLine";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findSmartIndentColumn";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNonSpaceColumnOnTheLine";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNonSpaceOffsetOnTheLine";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNonSpaceOffsetInRange";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineEnd";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToNextWord";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "moveToNextCaretStop";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setupSelection";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "selectNonexpandableFold";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToPreviousWord";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "moveToPreviousCaretStop";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretPageUp";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretPageDown";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToTextStart";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToTextEnd";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "adjustYToVisualLineBase";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "calcVisualLineIncrement";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretPageTop";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretPageBottom";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleArea";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isBetweenWhitespaces";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isWordStart";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isWordEnd";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isWordBoundary";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isHumpBound";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineStartIgnoringSoftWraps";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "makePositionVisible";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "moveCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 39, 77 -> new IllegalStateException(string);
        };
    }
}

