/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.util.DocumentUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class GuardedBlocksIndex {
    private final int[] offsets;
    private final boolean[] guards;
    private final int length;

    GuardedBlocksIndex(int @NotNull [] offsets, boolean @NotNull [] guards, int length) {
        if (offsets == null) {
            GuardedBlocksIndex.$$$reportNull$$$0(0);
        }
        if (guards == null) {
            GuardedBlocksIndex.$$$reportNull$$$0(1);
        }
        assert (offsets.length == guards.length);
        assert (length <= offsets.length);
        this.offsets = offsets;
        this.guards = guards;
        this.length = length;
    }

    public int nearestLeft(int offset) {
        int i2 = this.indexOfNearestLeft(offset);
        if (i2 != -1) {
            return this.offsets[i2];
        }
        return -1;
    }

    public int nearestRight(int offset) {
        int i2 = this.indexOfNearestRight(offset);
        if (i2 != -1) {
            return this.offsets[i2];
        }
        return -1;
    }

    public boolean isGuarded(int offset) {
        int i2 = this.indexOfNearestLeft(offset);
        if (i2 != -1) {
            return this.guards[i2];
        }
        return false;
    }

    private int indexOfNearestLeft(int offset) {
        if (offset == -1) {
            return -1;
        }
        assert (offset >= 0);
        int i2 = Arrays.binarySearch(this.offsets, 0, this.length, offset);
        if (i2 < 0) {
            i2 = -(i2 + 2);
        }
        if (0 <= i2 && i2 < this.length) {
            return i2;
        }
        return -1;
    }

    private int indexOfNearestRight(int offset) {
        assert (offset >= 0);
        int i2 = Arrays.binarySearch(this.offsets, 0, this.length, offset);
        if (i2 < 0) {
            i2 = -(i2 + 1);
        }
        if (i2 < this.length) {
            return i2;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GuardedBlocksIndex)) {
            return false;
        }
        GuardedBlocksIndex index = (GuardedBlocksIndex)o;
        return this.toString().equals(index.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return IntStream.range(0, this.length).mapToObj(i2 -> this.offsets[i2] + (this.guards[i2] ? "+" : "-")).collect(Collectors.joining(")[", "[", ")"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "offsets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "guards";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/view/GuardedBlocksIndex";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record Offset(int value, boolean isStart) implements Comparable<Offset>
    {
        int push(int stack) {
            int result2;
            int n = result2 = this.isStart ? stack + 1 : stack - 1;
            assert (result2 >= 0);
            return result2;
        }

        @Override
        public int compareTo(@NotNull Offset o) {
            int compare;
            if (o == null) {
                Offset.$$$reportNull$$$0(0);
            }
            if ((compare = Integer.compare(this.value(), o.value())) != 0) {
                return compare;
            }
            if (this.isStart() == o.isStart()) {
                return 0;
            }
            return this.isStart() ? -1 : 1;
        }

        @Override
        @NotNull
        public String toString() {
            String s = this.isStart ? "start" : "end";
            String string = s + "[" + this.value + "]";
            if (string == null) {
                Offset.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/view/GuardedBlocksIndex$Offset";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/view/GuardedBlocksIndex$Offset";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static final class DocumentBuilder
    extends Builder {
        private final DocumentEx document;

        DocumentBuilder(@NotNull DocumentEx document2) {
            if (document2 == null) {
                DocumentBuilder.$$$reportNull$$$0(0);
            }
            this.document = document2;
        }

        @NotNull
        GuardedBlocksIndex build(int start2, int end) {
            GuardedBlocksIndex guardedBlocksIndex = this.build(start2, end, this.document.getGuardedBlocks());
            if (guardedBlocksIndex == null) {
                DocumentBuilder.$$$reportNull$$$0(1);
            }
            return guardedBlocksIndex;
        }

        @Override
        protected int alignOffset(int offset, boolean isStart) {
            if (DocumentUtil.isInsideSurrogatePair((Document)this.document, (int)offset)) {
                if (!isStart && offset + 1 < this.document.getTextLength()) {
                    return offset + 1;
                }
                return offset - 1;
            }
            return offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/view/GuardedBlocksIndex$DocumentBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/view/GuardedBlocksIndex$DocumentBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static sealed class Builder
    permits DocumentBuilder {
        @VisibleForTesting
        @NotNull
        public GuardedBlocksIndex build(int start2, int end, @NotNull List<RangeMarker> guardedBlocks) {
            if (guardedBlocks == null) {
                Builder.$$$reportNull$$$0(0);
            }
            assert (0 <= start2 && start2 <= end);
            List offsetList = guardedBlocks.stream().flatMap(r -> {
                int rangeStart = r.getStartOffset();
                int rangeEnd = r.getEndOffset();
                assert (rangeStart <= rangeEnd);
                if (start2 - 1 <= rangeEnd && rangeStart <= end + 1) {
                    Offset o1 = new Offset(this.alignOffset(rangeStart, true), true);
                    Offset o2 = new Offset(this.alignOffset(rangeEnd, false), false);
                    return Stream.of(o1, o2);
                }
                return Stream.empty();
            }).sorted().toList();
            int size2 = offsetList.size();
            assert (size2 % 2 == 0);
            int[] offsets = new int[size2];
            boolean[] guards = new boolean[size2];
            int i2 = 0;
            int stack = 0;
            for (int j = 0; j < size2; ++j) {
                Offset current = (Offset)offsetList.get(j);
                stack = current.push(stack);
                for (int k = j + 1; k < size2; ++k) {
                    Offset next = (Offset)offsetList.get(k);
                    if (current.value() != next.value()) break;
                    current = next;
                    stack = current.push(stack);
                    ++j;
                }
                offsets[i2] = current.value();
                guards[i2] = stack > 0;
                ++i2;
            }
            assert (stack == 0);
            assert (i2 == 0 || !guards[i2 - 1]);
            return new GuardedBlocksIndex(offsets, guards, i2);
        }

        protected int alignOffset(int offset, boolean isStart) {
            return offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guardedBlocks", "com/intellij/openapi/editor/impl/view/GuardedBlocksIndex$Builder", "build"));
        }
    }
}

